/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.taketask;

import java.util.List;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.taketask.SJctrAsyncTakeTaskStrategy;
import sanproject.sn2.controller.com.taketask.SJctrDelDRDTakeTaskStrategy;
import sanproject.sn2.controller.com.taketask.SJctrShrinkTakeTaskStrategy;
import sanproject.sn2.controller.com.taketask.SJctrSyncTakeTaskStrategy;
import sanproject.sn2.controller.com.taketask.SJctrTakeTaskStrategy;

public class SJctrTakeTask {
    private static final SJctrDelDRDTakeTaskStrategy delDRDStrategy = new SJctrDelDRDTakeTaskStrategy();
    private static final SJctrShrinkTakeTaskStrategy shrinkStrategy = new SJctrShrinkTakeTaskStrategy();
    private static final SJctrAsyncTakeTaskStrategy asyncStrategy = new SJctrAsyncTakeTaskStrategy();
    private static final SJctrSyncTakeTaskStrategy syncStrategy = new SJctrSyncTakeTaskStrategy();
    private final String mClassName = this.getClass().getSimpleName();

    public SJctrTask getTask(List<SJctrTask> queuingList) {
        SJctrTakeTaskStrategy strategy;
        SJctrTask retTask = null;
        if (queuingList == null) {
            return null;
        }
        SJctrTask task = this.getOldestSubmitTask(queuingList);
        if (task != null && (strategy = this.getStrategy(task)).isReadyTask(queuingList)) {
            retTask = task;
            SJctrLogUty.info(this.mClassName, "getTask", "return = " + retTask.getId());
        }
        return retTask;
    }

    private SJctrTask getOldestSubmitTask(List<SJctrTask> queuingList) {
        for (SJctrTask task : queuingList) {
            if (task.getStatus() != 1) continue;
            return task;
        }
        return null;
    }

    private SJctrTakeTaskStrategy getStrategy(SJctrTask task) {
        SJctrTakeTaskStrategy strategy = task.isAsync() ? (task.isShrink() ? shrinkStrategy : (task.isDelDRD() ? delDRDStrategy : asyncStrategy)) : syncStrategy;
        return strategy;
    }
}

