<?xml version="1.0"?>
<!-- 
WBEM Solutions CIM Schema Documentation 
Copyright 2006-2007, WBEM Solutions, Inc. All Rights Reserved.
Use subject to license terms.
This file can not be redistributed without written permission of WBEM Solutions, Inc.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:lxslt="http://xml.apache.org/xslt" xmlns:redirect="http://xml.apache.org/xalan/redirect" extension-element-prefixes="redirect">
	<xsl:param name="outputdir"/>
	<xsl:param name="indexfile"/>
	<xsl:param name="pCompany"/>
	<xsl:output method="html" indent="yes"/>
	<!-- KEY DEFINITIONS -->
	<xsl:key name="classes" match="CLASS" use="@NAME"/>
	<xsl:key name="classsuper" match="CLASS" use="@SUPERCLASS"/>
	<!-- VARIABLE DEFINITIONS -->
	<xsl:variable name="documents" select="document($indexfile)/CLASSES/CLASS"/>
	<xsl:template match="*"/>
	<xsl:template match="/|CIM|DECLARATION|DECLGROUP|VALUE.OBJECT">
		<xsl:apply-templates/>
	</xsl:template>
	<!-- INCLUDED MODULES -->
	<!-- Rules for CIM Class -->
	<xsl:template match="CLASS">
		<xsl:variable name="classname" select="@NAME"/>
		<xsl:variable name="parentname" select="@SUPERCLASS"/>
		<xsl:variable name="qualcount" select="count(.)"/>
		<xsl:variable name="outfile">
			<xsl:value-of select="$outputdir"/>//<xsl:value-of select="@NAME"/>.html</xsl:variable>
		<redirect:write file="{$outfile}">
			<head>
				<link rel="stylesheet" type="text/css" href="mof.css"/>
				<title><xsl:value-of select="$pCompany"/> Schema Documentation</title>
			</head>
			<html>
				<body bgcolor="White">
					<hr>
						<xsl:text> </xsl:text>
					</hr>
					<xsl:choose>
						<xsl:when test="@SUPERCLASS">
							<a name="{@NAME}"/>
							<H1>Class <xsl:value-of select="@NAME"/>
								<BR/>extends <a href="{@SUPERCLASS}.html">
									<xsl:value-of select="@SUPERCLASS"/>
								</a>
							</H1>
						</xsl:when>
						<xsl:otherwise>
							<H1>Class <xsl:value-of select="@NAME"/>
							</H1>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="child::QUALIFIER[attribute::NAME='Description'][position()=1]"/>
					<h3>
					Table of Contents<br/>
					<a href="#c_hierarchy">Hierarchy</a><br/>
					<a href="#c_subclasses">Direct Known Subclasses</a><br/>
					<a href="#c_qualifiers">Class Qualifiers</a><br/>
					<a href="#c_properties">Class Properties</a><br/>
					<a href="#c_methods">Class Methods</a><br/>
					</h3>
					<hr>
						<xsl:text> </xsl:text>
					</hr>
					<H2><a name="c_hierarchy">Class Hierarchy</a></H2>
					<!-- This works. -->
					<xsl:apply-templates select="." mode="hierarchy">
						<xsl:with-param name="bottomNode">true</xsl:with-param>
					</xsl:apply-templates>
					<H2><a name="c_subclasses">Direct Known Subclasses</a></H2>
					<xsl:for-each select="$documents">
						<xsl:sort select="@NAME"/>
						<xsl:choose>
							<xsl:when test="@SUPERCLASS=$classname">
								<a href="{@NAME}.html">
									<xsl:value-of select="@NAME"/>
								</a>
								<BR/>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
					<H2><a name="c_qualifiers">Class Qualifiers</a></H2>
					<TABLE BORDER="1" CELLPADDING="1" WIDTH="100%">
						<TR>
							<TH>Name</TH>
							<TH>Data Type</TH>
							<TH>Value</TH>
						</TR>
						<xsl:for-each select="QUALIFIER[not(NAME=preceding-sibling::QUALIFIER/NAME)]">
							<xsl:sort select="@NAME"/>
							<xsl:call-template name="QUAL_ROW"/>
						</xsl:for-each>
					</TABLE>
					<H2><a name="c_properties">Class Properties</a></H2>
					<xsl:if test="PROPERTY[@PROPAGATED='false'] or PROPERTY.ARRAY[@PROPAGATED='false']">
						<H3>Local Class Properties</H3>
						<TABLE WIDTH="100%" CELLPADDING="1" BORDER="1">
							<TR>
								<TH ROWSPAN="2">
									<B>Name</B>
								</TH>
								<TH ROWSPAN="2">
									<B>Data Type</B>
								</TH>
								<TH ROWSPAN="2">
									<B>Default Value</B>
								</TH>
								<TH COLSPAN="5">
									<B>Qualifiers</B>
								</TH>
							</TR>
							<TR>
								<TH>Name</TH>
								<TH>Data Type</TH>
								<TH>Value</TH>
							</TR>
							<xsl:for-each select="PROPERTY[@PROPAGATED='false']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="LOCAL_PROP_ROW">
									<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
								</xsl:call-template>
								<xsl:for-each select="QUALIFIER">
									<xsl:sort select="@NAME"/>
									<xsl:call-template name="QUAL_ROW"/>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="PROPERTY.ARRAY[@PROPAGATED='false']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="LOCAL_PROP_ROW_ARRAY">
									<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
								</xsl:call-template>
								<xsl:for-each select="QUALIFIER">
									<xsl:sort select="@NAME"/>
									<xsl:call-template name="QUAL_ROW"/>
								</xsl:for-each>
							</xsl:for-each>
						</TABLE>
					</xsl:if>
					<xsl:if test="PROPERTY.REFERENCE">
						<H3>Association References</H3>
						<TABLE BORDER="1" CELLPADDING="1" WIDTH="60%">
							<TR>
								<TH>Name</TH>
								<TH>Reference Class</TH>
							</TR>
							<xsl:for-each select="PROPERTY.REFERENCE[@PROPAGATED='false']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="ASSOC_PROP_ROW"/>
							</xsl:for-each>
						</TABLE>
					</xsl:if>
					<xsl:if test="PROPERTY.REFERENCE[@PROPAGATED='true']">
						<H3>Propagated Association References</H3>
						<TABLE BORDER="1" CELLPADDING="1" WIDTH="60%">
							<TR>
								<TH>Name</TH>
								<TH>Reference Class</TH>
							</TR>
							<xsl:for-each select="PROPERTY.REFERENCE[PROPAGATED]">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="ASSOC_PROP_ROW"/>
							</xsl:for-each>
						</TABLE>
					</xsl:if>
					<xsl:if test="PROPERTY[@PROPAGATED='true']">
						<H3>Inherited Properties</H3>
						<TABLE BORDER="1" CELLPADDING="1" WIDTH="60%">
							<TR>
								<TH>Name</TH>
								<TH>Data Type</TH>
							</TR>
							<xsl:for-each select="PROPERTY[@PROPAGATED='true']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="PROP_ROW"/>
							</xsl:for-each>
							<xsl:for-each select="PROPERTY.ARRAY[@PROPAGATED='true']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="PROP_ROW_ARRAY"/>
							</xsl:for-each>
						</TABLE>
					</xsl:if>
					<h2><a name="c_methods">Class Methods</a></h2>
					<xsl:if test="METHOD[not(@PROPAGATED)]">
						<H3>Local Class Methods</H3>
						<xsl:for-each select="METHOD[not(@PROPAGATED)]">
							<h4>
								<xsl:value-of select="@NAME"/> (<xsl:value-of select="@TYPE"/>)</h4>
							<h4>Method Qualifiers (<xsl:value-of select="@NAME"/>)</h4>
							<TABLE BORDER="1" CELLPADDING="1" WIDTH="100%">
								<TR>
									<TH>Name</TH>
									<TH>Data Type</TH>
									<TH>Value</TH>
								</TR>
								<xsl:for-each select="QUALIFIER[not(NAME=preceding-sibling::QUALIFIER/NAME)]">
									<xsl:sort select="@NAME"/>
									<xsl:call-template name="QUAL_ROW"/>
								</xsl:for-each>
							</TABLE>
									<h4>Method Parameters (<xsl:value-of select="@NAME"/>)</h4>
									<TABLE WIDTH="100%" CELLPADDING="1" BORDER="1">
										<TR>
											<TH ROWSPAN="2">
												<B>Name</B>
											</TH>
											<TH ROWSPAN="2">
												<B>Type</B>
											</TH>
											<TH COLSPAN="5">
												<B>Qualifiers</B>
											</TH>
										</TR>
										<TR>
											<TH>Name</TH>
											<TH>Data Type</TH>
											<TH>Value</TH>
										</TR>
										<xsl:for-each select="PARAMETER">
											<xsl:sort select="@NAME"/>
											<xsl:call-template name="LOCAL_PARAM_ROW">
												<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
											</xsl:call-template>
											<xsl:for-each select="QUALIFIER">
												<xsl:sort select="@NAME"/>
												<xsl:call-template name="QUAL_ROW"/>
											</xsl:for-each>
										</xsl:for-each>
										<xsl:for-each select="PARAMETER.ARRAY">
											<xsl:sort select="@NAME"/>
											<xsl:call-template name="LOCAL_PARAM_ROW_ARRAY">
												<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
											</xsl:call-template>
											<xsl:for-each select="QUALIFIER">
												<xsl:sort select="@NAME"/>
												<xsl:call-template name="QUAL_ROW"/>
											</xsl:for-each>
										</xsl:for-each>
										<xsl:for-each select="PARAMETER.REFARRAY">
											<xsl:sort select="@NAME"/>
											<xsl:call-template name="LOCAL_PARAM_ROW_REFARRAY">
												<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
											</xsl:call-template>
											<xsl:for-each select="QUALIFIER">
												<xsl:sort select="@NAME"/>
												<xsl:call-template name="QUAL_ROW"/>
											</xsl:for-each>
										</xsl:for-each>
										<xsl:for-each select="PARAMETER.REFERENCE">
											<xsl:sort select="@NAME"/>
											<xsl:call-template name="ASSOC_PARAM_ROW">
												<xsl:with-param name="count" select="count(child::QUALIFIER) + 1"/>
											</xsl:call-template>
											<xsl:for-each select="QUALIFIER">
												<xsl:sort select="@NAME"/>
												<xsl:call-template name="QUAL_ROW"/>
											</xsl:for-each>
										</xsl:for-each>
									</TABLE>
						</xsl:for-each>
					</xsl:if>
					<xsl:if test="METHOD[@PROPAGATED='true']">
						<H3>Inherited Class Methods</H3>
							<TABLE BORDER="1" CELLPADDING="1" WIDTH="60%">
							<TR>
								<TH>Name</TH>
								<TH>Return Type</TH>
							</TR>
							<xsl:for-each select="METHOD[@PROPAGATED='true']">
								<xsl:sort select="@NAME"/>
								<xsl:call-template name="PROP_ROW"/>
							</xsl:for-each>
						</TABLE>
					</xsl:if>
				</body>
			</html>
		</redirect:write>
		<!-- End of CLASS Template-->
	</xsl:template>
	<!-- Output Rows of Property Values-->
	<xsl:template name="PROP_ROW">
		<TR>
			<TH VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
			</TD>
			<!--no default values in MOFs. don't know how to determine default value. -->
			<!-- <TD VALIGN="TOP"><xsl:value-of select="child::VALUE|/descendant::VALUE"/></TD> -->
		</TR>
	</xsl:template>
	<xsl:template name="PROP_ROW_ARRAY">
		<TR>
			<TH VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
				<xsl:text>[]</xsl:text>
			</TD>
			<!--no default values in MOFs. don't know how to determine default value. -->
			<!-- <TD VALIGN="TOP"><xsl:value-of select="child::VALUE|/descendant::VALUE"/></TD> -->
		</TR>
	</xsl:template>
	<xsl:template name="LOCAL_PROP_ROW">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
			</TD>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:for-each select="child::VALUE">
						<xsl:value-of select="."/>
					</xsl:for-each>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="LOCAL_PARAM_ROW">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="LOCAL_PROP_ROW_ARRAY">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
				<xsl:text>[]</xsl:text>
			</TD>
				<TD ROWSPAN="{$count}" VALIGN="TOP">
					<xsl:for-each select="child::VALUE.ARRAY/child::VALUE">
						<xsl:value-of select="."/>
						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</TD>
		</TR>
	</xsl:template>
	<xsl:template name="LOCAL_PARAM_ROW_ARRAY">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
				<xsl:text>[]</xsl:text>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="LOCAL_PARAM_ROW_REFARRAY">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<a href="{@REFERENCECLASS}.html">
					<xsl:value-of select="@REFERENCECLASS"/>
				</a>
				<xsl:text>[]</xsl:text>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="ASSOC_PROP_ROW">
		<TR>
			<TH VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD VALIGN="TOP">
				<a href="{@REFERENCECLASS}.html">
					<xsl:value-of select="@REFERENCECLASS"/>
				</a>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="ASSOC_PARAM_ROW">
			<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				REF
				<a href="{@REFERENCECLASS}.html">
					<xsl:value-of select="@REFERENCECLASS"/></a>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="QUAL_ROW">
		<TR>
			<TD VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TD>
			<TD VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
			</TD>
			<xsl:if test="child::VALUE">
				<TD VALIGN="TOP">
					<xsl:value-of select="."/>
				</TD>
			</xsl:if>
			<xsl:if test="child::VALUE.ARRAY">
				<TD VALIGN="TOP">
					<xsl:for-each select="child::VALUE.ARRAY/child::VALUE">
						<xsl:value-of select="."/>
						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</TD>
			</xsl:if>
		</TR>
	</xsl:template>
	<xsl:template name="PARAMETER_ROW">
		<xsl:param name="count" select="count(child::QUALIFIER) + 1"/>
		<TR>
			<TH ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@NAME"/>
			</TH>
			<TD ROWSPAN="{$count}" VALIGN="TOP">
				<xsl:value-of select="@TYPE"/>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template match="CLASS" mode="hierarchy">
		<xsl:param name="bottomNode">false</xsl:param>
		<xsl:variable name="parentname" select="@SUPERCLASS"/>
		<xsl:for-each select="$documents">
			<!-- applies hierarchy template to the parent of the each class -->
			<xsl:choose>
				<xsl:when test="@NAME=$parentname">
					<xsl:apply-templates select="." mode="hierarchy"/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<!-- outputs details about the current class -->
		<xsl:choose>
			<xsl:when test="$bottomNode = 'false' ">
				<a href="{@NAME}.html">
					<xsl:value-of select="@NAME"/>
				</a>
				<br data="@NAME"/>
				<xsl:text> &#xa0;   &#xa0;|</xsl:text>
				<br/>
				<xsl:text> &#xa0;  &#xa0;+--</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<b>
					<xsl:value-of select="@NAME"/>
				</b>
				<br data="{@NAME} -- {@SUPERCLASS}"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="CLASS" mode="nohierarchy">
		<xsl:value-of select="@NAME"/>
		<xsl:text> is a top level class.</xsl:text>
	</xsl:template>
</xsl:stylesheet>
