/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.makexml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlMacro;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlOutput_HIE;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlOutput_HIJ;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlOutput_HPE;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlOutput_HPJ;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlFuncIdData;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlGrpData;
import sanproject.sn2msg.model.SN2MsgMdlMacro;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgCtrlMakexmlMain
implements SN2MsgMdlMacro,
SN2MsgCtrlMakexmlMacro {
    private String m_StrXmlPath = "";
    private ArrayList<SN2MsgMdlAllData> m_AlMsgList = null;

    public SN2MsgCtrlMakexmlMain(String strPath, ArrayList<SN2MsgMdlAllData> alMsg) throws SN2MsgCtrlException {
        if (strPath != null && alMsg != null) {
            if (!SN2MsgCtrlMakexmlMain.isValidPath(strPath)) {
                SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException();
                SN2MsgLogger.getLogger().severe("Parameter error(path):" + strPath);
                ctrlExp.setIErrorCode(4);
                throw ctrlExp;
            }
        } else {
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException();
            SN2MsgLogger.getLogger().severe("Parameter error(null parameter).");
            ctrlExp.setIErrorCode(3);
            throw ctrlExp;
        }
        this.m_StrXmlPath = strPath;
        this.m_AlMsgList = alMsg;
    }

    ArrayList<SN2MsgCtrlMakexmlFuncIdData> getFuncIdUnitData() {
        ArrayList<SN2MsgCtrlMakexmlFuncIdData> alRet = new ArrayList<SN2MsgCtrlMakexmlFuncIdData>();
        SN2MsgCtrlMakexmlFuncIdData funcIdData = null;
        int iCurrentFuncCode = -1;
        int iMsgCnt = 0;
        int iMsg = 0;
        while (iMsg < this.m_AlMsgList.size()) {
            SN2MsgMdlAllData tmpMsg = this.m_AlMsgList.get(iMsg);
            SN2MsgMdlMsgIdxData msgIdx = tmpMsg.getMsgIdx();
            String strMsgId = msgIdx.getStrMsgId();
            String[] strTmpId = strMsgId.split("/");
            if (3 == strTmpId.length) {
                int iFuncCode = Integer.parseInt(String.valueOf(strTmpId[0]) + strTmpId[1]);
                if (iCurrentFuncCode != iFuncCode) {
                    if (funcIdData != null) {
                        alRet.add(funcIdData);
                    }
                    iCurrentFuncCode = iFuncCode;
                    funcIdData = new SN2MsgCtrlMakexmlFuncIdData();
                    funcIdData.setStrFuncId(String.valueOf(strTmpId[0]) + strTmpId[1]);
                    funcIdData.addMsgList(tmpMsg);
                    ++iMsgCnt;
                } else if (funcIdData != null) {
                    funcIdData.addMsgList(tmpMsg);
                    ++iMsgCnt;
                } else {
                    SN2MsgLogger.getLogger().warning("Internal logic error:" + strMsgId);
                }
            } else {
                SN2MsgLogger.getLogger().warning("Invalid message ID:" + strMsgId);
            }
            ++iMsg;
        }
        if (funcIdData != null) {
            alRet.add(funcIdData);
        }
        SN2MsgLogger.getLogger().info("Processed number of messages:" + iMsgCnt);
        return alRet;
    }

    ArrayList<SN2MsgCtrlMakexmlGrpData> getUnitData(ArrayList<SN2MsgCtrlMakexmlFuncIdData> alFuncTmp) {
        ArrayList<SN2MsgCtrlMakexmlGrpData> alRet = new ArrayList<SN2MsgCtrlMakexmlGrpData>();
        int iCurrentCode = -1;
        SN2MsgCtrlMakexmlGrpData grpTmp = null;
        int iFunc = 0;
        while (iFunc < alFuncTmp.size()) {
            SN2MsgCtrlMakexmlFuncIdData funcTmp = alFuncTmp.get(iFunc);
            int iCode = Integer.parseInt(funcTmp.getStrFuncId()) / 1000;
            if (iCode != iCurrentCode) {
                if (grpTmp != null) {
                    alRet.add(grpTmp);
                }
                iCurrentCode = iCode;
                grpTmp = new SN2MsgCtrlMakexmlGrpData();
                grpTmp.setStrStartFuncId(funcTmp.getStrFuncId());
                grpTmp.addFuncIdList(funcTmp);
            } else if (grpTmp != null) {
                grpTmp.addFuncIdList(funcTmp);
            } else {
                SN2MsgLogger.getLogger().warning("Internal logic error:" + funcTmp.getStrFuncId());
            }
            ++iFunc;
        }
        if (grpTmp != null) {
            alRet.add(grpTmp);
        }
        return alRet;
    }

    ArrayList<SN2MsgCtrlMakexmlGrpData> getIndexList() throws SN2MsgCtrlException {
        ArrayList<SN2MsgCtrlMakexmlGrpData> alRet = new ArrayList();
        SN2MsgCtrlException ctrlExp = null;
        if (this.m_AlMsgList != null) {
            try {
                ArrayList<SN2MsgCtrlMakexmlFuncIdData> alFuncTmp = this.getFuncIdUnitData();
                alRet = this.getUnitData(alFuncTmp);
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.WARNING, "Internal error", jvExp);
                ctrlExp = new SN2MsgCtrlException("Internal error");
                ctrlExp.setIErrorCode(-1);
            }
        } else {
            ctrlExp = new SN2MsgCtrlException("Field data failed(m_AlMsgList)");
            ctrlExp.setIErrorCode(1);
            SN2MsgLogger.getLogger().warning("Field data failed(m_AlMsgList).");
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
        return alRet;
    }

    static boolean isValidPath(String strPath) {
        boolean bRet = true;
        try {
            if (strPath != null) {
                File tmpFile = new File(strPath);
                bRet = tmpFile.exists();
                if (!bRet) {
                    SN2MsgLogger.getLogger().warning("Invalid file path:" + strPath);
                }
            } else {
                SN2MsgLogger.getLogger().warning("Invalid file path(null).");
                bRet = false;
            }
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.WARNING, "Internal error", jvExp);
            bRet = false;
        }
        return bRet;
    }

    /*
     * Loose catch block
     */
    ArrayList<String[]> getUserGuideName() throws SN2MsgCtrlException {
        InputStreamReader flRd = null;
        SN2MsgCtrlException ctrlExp = null;
        int iRowCnt = 0;
        ArrayList<String[]> alRet = new ArrayList<String[]>();
        try {
            try {
                flRd = new FileReader("lib" + File.separator + "UserGuideName.csv");
                BufferedReader bufRd = new BufferedReader(flRd);
                String tmpBuf = "";
                while (tmpBuf != null) {
                    tmpBuf = bufRd.readLine();
                    if (tmpBuf == null) continue;
                    String[] strElm = tmpBuf.split("\t", 6);
                    if (6 != strElm.length) {
                        ctrlExp = new SN2MsgCtrlException();
                        ctrlExp.setIErrorCode(-1);
                        SN2MsgLogger.getLogger().warning("Invalid User Guide Name. Row=" + iRowCnt);
                        break;
                    }
                    alRet.add(strElm);
                    ++iRowCnt;
                }
            }
            catch (FileNotFoundException flnotExp) {
                flnotExp.printStackTrace();
                ctrlExp = new SN2MsgCtrlException();
                ctrlExp.setIErrorCode(-1);
                SN2MsgLogger.getLogger().log(Level.SEVERE, "FileNotFoundException", flnotExp);
                SN2MsgLogger.getLogger().severe("UserGuideName.csv is not exist.");
                try {
                    if (flRd != null) {
                        flRd.close();
                    }
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "Exception", jvExp);
                }
                if (ctrlExp != null) {
                    throw ctrlExp;
                }
            }
            catch (IOException ioExp) {
                ioExp.printStackTrace();
                ctrlExp = new SN2MsgCtrlException();
                ctrlExp.setIErrorCode(-1);
                SN2MsgLogger.getLogger().log(Level.SEVERE, "IOException", ioExp);
                SN2MsgLogger.getLogger().severe("UserGuideName.csv cannot access.");
                try {
                    if (flRd != null) {
                        flRd.close();
                    }
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "Exception", jvExp);
                }
                if (ctrlExp != null) {
                    throw ctrlExp;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                ctrlExp = new SN2MsgCtrlException();
                ctrlExp.setIErrorCode(-1);
                SN2MsgLogger.getLogger().log(Level.SEVERE, "Exception", jvExp);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (flRd != null) {
                        flRd.close();
                    }
                }
                catch (Exception jvExp2) {
                    jvExp2.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "Exception", jvExp2);
                }
                if (ctrlExp != null) {
                    throw ctrlExp;
                }
            }
        }
        finally {
            try {
                if (flRd != null) {
                    flRd.close();
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.SEVERE, "Exception", jvExp);
            }
            if (ctrlExp != null) {
                throw ctrlExp;
            }
        }
        return alRet;
    }

    public void makeXML() throws SN2MsgCtrlException {
        ArrayList<SN2MsgCtrlMakexmlGrpData> alGrp = this.getIndexList();
        ArrayList<String[]> alUgNameRow = this.getUserGuideName();
        SN2MsgCtrlMakexmlOutput_HIE outHie = new SN2MsgCtrlMakexmlOutput_HIE(this.m_StrXmlPath, alGrp, alUgNameRow);
        outHie.outputXML();
        SN2MsgCtrlMakexmlOutput_HPE outHpe = new SN2MsgCtrlMakexmlOutput_HPE(this.m_StrXmlPath, alGrp, alUgNameRow);
        outHpe.outputXML();
        SN2MsgCtrlMakexmlOutput_HIJ outHij = new SN2MsgCtrlMakexmlOutput_HIJ(this.m_StrXmlPath, alGrp, alUgNameRow);
        outHij.outputXML();
        SN2MsgCtrlMakexmlOutput_HPJ outHpj = new SN2MsgCtrlMakexmlOutput_HPJ(this.m_StrXmlPath, alGrp, alUgNameRow);
        outHpj.outputXML();
    }
}

