/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;

public class MachineCharacter {
    private static boolean isLeadByte(int charByte) {
        return 129 <= charByte && charByte <= 159 || 224 <= charByte && charByte <= 252;
    }

    private static boolean isTrailByte(int charByte) {
        return 64 <= charByte && charByte <= 252 && charByte != 127;
    }

    public static boolean hasMachineCharacters(String target) throws UnsupportedEncodingException {
        byte[] charArray = target.getBytes("MS932");
        int i = 0;
        while (i < charArray.length) {
            int charByte = charArray[i] & 0xFF;
            if (MachineCharacter.isLeadByte(charByte)) {
                if (++i >= charArray.length) {
                    return true;
                }
                int charByte2 = charArray[i] & 0xFF;
                if (!MachineCharacter.isTrailByte(charByte2)) {
                    return true;
                }
                int targetChar = charByte << 8 | charByte2;
                if (34624 <= targetChar && targetChar <= 34718) {
                    return true;
                }
                if (60736 <= targetChar && targetChar <= 61436) {
                    return true;
                }
                if (64064 <= targetChar && targetChar <= 64587) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

