/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataUtility;
import com.hitachi.sanproject.rmi.SanInterface;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.server.SanRemoteObject;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.rmi.server.managers.SanAuditLog;
import com.hitachi.sanproject.util.SanLogger;
import com.hitachi.sanproject.util.SanProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class SanAuditLogManager {
    protected static Logger logger;
    protected static SanRemoteObject robj;
    protected static HashMap<String, SanData> auditLogs;
    protected static SanProperties settingProperties;
    public static final String DIRECTORY_AUDITLOG = "define_auditlog";

    public void initialize() {
        logger = SanRmiServer.getLogger();
        robj = SanRmiServer.getRemoteObject();
        settingProperties = SanRmiServer.getSettingProperties();
        this.readAuditLogs();
        if (Boolean.valueOf(settingProperties.getProperty("com.hitachi.sanproject.define.debug")).booleanValue()) {
            this.readAuditLogs(new File(DIRECTORY_AUDITLOG));
        }
        SanAuditLog.initialize();
    }

    public void startThread(SanInterface sanInterface, SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException {
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        SanAuditLog sanAuditLog = new SanAuditLog(sanInterface, sanData, sanRequest, sanResponse, auditLogs.get(sanRequest2.id()));
        sanAuditLog.start();
    }

    public void readAuditLogs(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        HashMap<String, SanData> hashMap = new HashMap<String, SanData>();
        for (File file2 : fileArray) {
            String string = file2.getName();
            if (!file2.isFile() || !string.endsWith(".json")) continue;
            logger.info(String.format("data=%s", string));
            try {
                SanData sanData = SanDataUtility.readDataFromJSON((File)file2);
                hashMap.put(sanData.id(), sanData);
            }
            catch (SanDataException sanDataException) {
                logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            }
        }
        auditLogs = hashMap;
    }

    public HashMap<String, SanData> getAuditLogs() {
        return auditLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAuditLogs() {
        HashMap<String, SanData> hashMap = new HashMap<String, SanData>();
        JarEntry jarEntry = null;
        ZipFile zipFile = null;
        try {
            URL uRL = this.getClass().getClassLoader().getResource("define/define_auditlog/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            zipFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().contains(DIRECTORY_AUDITLOG) || !jarEntry.getName().endsWith(".json")) continue;
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jarEntry.getName());
                logger.info(jarEntry.getName());
                SanData sanData = SanDataUtility.readDataFromJSON((InputStream)inputStream, (String)jarEntry.getName());
                hashMap.put(sanData.id(), sanData);
            }
        }
        catch (SanDataException sanDataException) {
            logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
        }
        catch (IOException iOException) {
            logger.warning(SanLogger.getStackTrace((Throwable)iOException));
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                logger.warning(SanLogger.getStackTrace((Throwable)iOException));
            }
        }
        auditLogs = hashMap;
    }
}

