/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class AuthenticatedURL {
    int lifetime;
    protected AuthenticationBlock[] authBlocks = new AuthenticationBlock[0];

    protected final void sign(List spiList) throws ServiceLocationException {
        this.authBlocks = new AuthenticationBlock[spiList.size()];
        for (int k = 0; k < spiList.size(); ++k) {
            int timestamp = SLPUtils.getTimestamp();
            String spi = (String)spiList.get(k);
            byte[] data = this.getAuthData(spi, timestamp += this.lifetime);
            this.authBlocks[k] = new AuthenticationBlock(2, spi, timestamp, data, null);
        }
    }

    protected final boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            byte[] data = this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp());
            if (!this.authBlocks[i].verify(data)) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String spi, int timestamp) throws ServiceLocationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            byte[] temp = spi.getBytes();
            dos.writeShort(temp.length);
            dos.write(temp);
            temp = this.toString().getBytes();
            dos.writeShort(temp.length);
            dos.write(temp);
            dos.writeInt(timestamp);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(20, ioe.getMessage());
        }
    }

    protected void writeAuthBlock(DataOutputStream out) throws IOException {
        out.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(out);
        }
    }

    protected final int getAuthBlockLength() {
        int len = 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            len += this.authBlocks[i].getLength();
        }
        return len;
    }

    protected static final AuthenticationBlock[] parseAuthBlock(DataInputStream input) throws ServiceLocationException, IOException {
        return AuthenticationBlock.parse(input);
    }
}

