/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.file;

import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAuthorizeModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalLoginModule;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationDnsException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationGroupException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExGetGroupException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExTrialException;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;

public class SJbaseExternalTrial {
    private SJbaseExternalTrial() {
    }

    public static void externalLdapConnect(String name, String pass, SJbaseLdapConfiguration conf, boolean group) throws SJbaseExTrialException {
        HashMap<String, SJbaseLdapConfiguration> confmap = new HashMap<String, SJbaseLdapConfiguration>();
        confmap.put("PrimaryServer", conf);
        SJbaseExTrialException errObj = new SJbaseExTrialException();
        try {
            Properties data = SJbaseExternalFile.setLdapConfiguration(confmap, null, group);
            if (group) {
                SJbaseExternalAuthorizeModule clsExternal = new SJbaseExternalAuthorizeModule(data);
                clsExternal.login(name, pass);
            } else {
                SJbaseExternalLoginModule clsExternal = new SJbaseExternalLoginModule(data);
                clsExternal.login(name, pass);
            }
        }
        catch (SJbaseExAuthenticationException e) {
            errObj.setServerType("ldap");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(1);
                    break;
                }
                case 1: {
                    errObj.setErrCode(5);
                    break;
                }
                case 2: {
                    errObj.setErrCode(6);
                    break;
                }
                case 3: {
                    errObj.setErrCode(6);
                    break;
                }
                case 4: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExGetGroupException e) {
            errObj.setServerType("ldapgroup");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(6);
                    break;
                }
                case 1: {
                    errObj.setErrCode(5);
                    break;
                }
                case 2: {
                    errObj.setErrCode(6);
                    break;
                }
                case 4: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExCommunicationGroupException e) {
            errObj.setServerType("ldapgroup");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (SJbaseExCommunicationDnsException e) {
            errObj.setServerType("ldap");
            errObj.setErrCode(3);
            throw errObj;
        }
        catch (SJbaseExCommunicationException e) {
            errObj.setServerType("ldap");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (Exception e) {
            errObj.setServerType("ldap");
            errObj.setErrCode(9999);
            throw errObj;
        }
    }

    public static void externalRadiusConnect(String name, String pass, SJbaseRadiusConfiguration conf) throws SJbaseExTrialException {
        HashMap<String, SJbaseRadiusConfiguration> confmap = new HashMap<String, SJbaseRadiusConfiguration>();
        confmap.put("PrimaryServer", conf);
        SJbaseExTrialException errObj = new SJbaseExTrialException();
        try {
            Properties data = SJbaseExternalFile.setRadiusConfiguration(confmap, null, false);
            SJbaseExternalLoginModule clsExternal = new SJbaseExternalLoginModule(data);
            clsExternal.login(name, pass);
        }
        catch (SJbaseExAuthenticationException e) {
            errObj.setServerType("radius");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(1);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExCommunicationException e) {
            errObj.setServerType("radius");
            switch (e.getErrCode()) {
                case 1: {
                    errObj.setErrCode(2);
                    break;
                }
                case 2: {
                    errObj.setErrCode(2);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (Exception e) {
            errObj.setServerType("radius");
            errObj.setErrCode(9999);
            throw errObj;
        }
    }

    public static void externalRadiusConnect(String name, String pass, SJbaseRadiusConfiguration conf, SJbaseLdapGroupConfiguration gconf) throws SJbaseExTrialException {
        HashMap<String, SJbaseRadiusConfiguration> confmap = new HashMap<String, SJbaseRadiusConfiguration>();
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
        confmap.put("PrimaryServer", conf);
        gconfmap.put("PrimaryServer", gconf);
        SJbaseExTrialException errObj = new SJbaseExTrialException();
        try {
            Properties data = SJbaseExternalFile.setRadiusConfiguration(confmap, gconfmap, true);
            SJbaseExternalAuthorizeModule clsExternal = new SJbaseExternalAuthorizeModule(data);
            clsExternal.login(name, pass);
        }
        catch (SJbaseExAuthenticationException e) {
            errObj.setServerType("radius");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(1);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExGetGroupException e) {
            errObj.setServerType("ldapgroup");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(6);
                    break;
                }
                case 1: {
                    errObj.setErrCode(5);
                    break;
                }
                case 2: {
                    errObj.setErrCode(6);
                    break;
                }
                case 4: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExCommunicationGroupException e) {
            errObj.setServerType("ldapgroup");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (SJbaseExCommunicationException e) {
            errObj.setServerType("radius");
            switch (e.getErrCode()) {
                case 1: {
                    errObj.setErrCode(2);
                    break;
                }
                case 2: {
                    errObj.setErrCode(2);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (Exception e) {
            errObj.setServerType("radius");
            errObj.setErrCode(9999);
            throw errObj;
        }
    }

    public static void externalKerberosConnect(String name, String pass, SJbaseKerberosConfiguration conf) throws SJbaseExTrialException {
        HashMap<String, SJbaseKerberosConfiguration> confmap = new HashMap<String, SJbaseKerberosConfiguration>();
        confmap.put("PrimaryServer", conf);
        SJbaseExTrialException errObj = new SJbaseExTrialException();
        try {
            Properties data = SJbaseExternalFile.setKerberosConfiguration(confmap, null, false);
            SJbaseExternalLoginModule clsExternal = new SJbaseExternalLoginModule(data);
            clsExternal.login(name, pass);
        }
        catch (SJbaseExAuthenticationException e) {
            errObj.setServerType("kerberos");
            switch (e.getErrCode()) {
                case 6: 
                case 24: {
                    errObj.setErrCode(1);
                    break;
                }
                case 37: {
                    errObj.setErrCode(5);
                    break;
                }
                case 41: 
                case 68: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExCommunicationDnsException e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(3);
            throw errObj;
        }
        catch (SJbaseExCommunicationException e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (Exception e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(9999);
            throw errObj;
        }
    }

    public static void externalKerberosConnect(String name, String pass, SJbaseKerberosConfiguration conf, SJbaseLdapGroupConfiguration gconf) throws SJbaseExTrialException {
        HashMap<String, SJbaseKerberosConfiguration> confmap = new HashMap<String, SJbaseKerberosConfiguration>();
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
        confmap.put("PrimaryServer", conf);
        gconfmap.put("PrimaryServer", gconf);
        SJbaseExTrialException errObj = new SJbaseExTrialException();
        try {
            Properties data = SJbaseExternalFile.setKerberosConfiguration(confmap, gconfmap, true);
            SJbaseExternalAuthorizeModule clsExternal = new SJbaseExternalAuthorizeModule(data);
            clsExternal.login(name, pass);
        }
        catch (SJbaseExAuthenticationException e) {
            errObj.setServerType("kerberos");
            switch (e.getErrCode()) {
                case 6: 
                case 24: {
                    errObj.setErrCode(1);
                    break;
                }
                case 37: {
                    errObj.setErrCode(5);
                    break;
                }
                case 41: 
                case 68: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExGetGroupException e) {
            errObj.setServerType("ldapgroup");
            switch (e.getErrCode()) {
                case 0: {
                    errObj.setErrCode(6);
                    break;
                }
                case 1: {
                    errObj.setErrCode(5);
                    break;
                }
                case 2: {
                    errObj.setErrCode(6);
                    break;
                }
                case 4: {
                    errObj.setErrCode(4);
                    break;
                }
                default: {
                    errObj.setErrCode(9999);
                }
            }
            throw errObj;
        }
        catch (SJbaseExCommunicationGroupException e) {
            errObj.setServerType("ldapgroup");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (SJbaseExCommunicationDnsException e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(3);
            throw errObj;
        }
        catch (SJbaseExCommunicationException e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(2);
            throw errObj;
        }
        catch (Exception e) {
            errObj.setServerType("kerberos");
            errObj.setErrCode(9999);
            throw errObj;
        }
    }
}

