/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldap;

import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapBind;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapLoginModuleThread
extends Thread {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapLoginModuleThread";
    private SJbaseLdapConfiguration ldapConf;
    private String userId;
    private String password;
    private SJbaseExternalAccountInfo account;
    private Exception exception;

    public SJbaseLdapLoginModuleThread(SJbaseLdapConfiguration ldapConf, String userId, String password) {
        super(new ThreadGroup("LDAP-ThreadGroup"), "LDAP-Thread");
        this.ldapConf = ldapConf;
        this.userId = userId;
        this.password = password;
        this.account = null;
        this.exception = null;
    }

    @Override
    public void run() {
        String method = "run";
        logger.info(module, method, "", "start");
        try {
            this.account = new SJbaseLdapBind().execute(this.ldapConf, this.userId, this.password);
        }
        catch (Exception e) {
            this.exception = e;
        }
        logger.info(module, method, "", "end");
    }

    public SJbaseExternalAccountInfo getAuthenticationResult() throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "getAuthenticationResult";
        logger.info(module, method, "", "start");
        if (this.exception != null) {
            if (this.exception instanceof SJbaseExAuthenticationException) {
                logger.info(module, method, "", "", this.exception);
                throw (SJbaseExAuthenticationException)this.exception;
            }
            if (this.exception instanceof SJbaseExCommunicationException) {
                logger.info(module, method, "", "", this.exception);
                throw (SJbaseExCommunicationException)this.exception;
            }
        }
        logger.info(module, method, "", "end");
        return this.account;
    }
}

