/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadUtils {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusUtils";
    private static byte id = 0;
    public static final int CHAP_CHALLENGE_LENGTH = 16;
    private static long seed = System.currentTimeMillis();

    public static byte generateId() {
        String method = "generateId";
        logger.info(module, method, "", "start");
        logger.info(module, method, "", "end");
        byte by = id;
        id = (byte)(by + 1);
        return by;
    }

    public static byte[] generateAuthenticator() {
        String method = "generateAuthenticator";
        logger.info(module, method, "", "start");
        logger.info(module, method, "", "end");
        return SJbaseRadUtils.generateRandom16Bytes();
    }

    public static byte[] generateRandom16Bytes() {
        String method = "generateRandom16Bytes";
        logger.info(module, method, "", "start");
        Random rand = new Random(seed);
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(rand.nextLong());
        buf.putLong(rand.nextLong());
        seed = rand.nextLong();
        logger.info(module, method, "", "end");
        return buf.array();
    }

    public static byte[] createMD5(byte[] input) {
        String method = "createMD5";
        logger.info(module, method, "", "start");
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.info(module, method, "", "", e);
        }
        logger.info(module, method, "", "end");
        return md5.digest(input);
    }

    public static byte[] generateCHAPChallenge() {
        String method = "generateCHAPChallenge";
        logger.info(module, method, "", "start");
        logger.info(module, method, "", "end");
        return SJbaseRadUtils.generateRandom16Bytes();
    }
}

