/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusDictionary;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseUnsupportedAttributeException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusAttribute {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusAttribute";
    public static final int MAX_LENGTH = 255;
    public static final int MIN_LENGTH = 3;
    private String name;
    private int type;
    private int length;
    private byte[] value;

    protected SJbaseRadiusAttribute(int type, byte[] value) {
        this.name = SJbaseRadiusDictionary.getAttributeName(type);
        this.type = type;
        if (value.length > 253) {
            byte[] subValue = new byte[253];
            System.arraycopy(value, 0, subValue, 0, 253);
            this.value = subValue;
        } else {
            this.value = value;
        }
        this.length = this.value.length + 2;
    }

    public static SJbaseRadiusAttribute create(int type, byte[] value) {
        return new SJbaseRadiusAttribute(type, value);
    }

    public static SJbaseRadiusAttribute create(String name, String value) throws SJbaseUnsupportedAttributeException {
        byte[] valueBytes;
        String method = "create";
        logger.info(module, method, "", "start");
        byte type = SJbaseRadiusDictionary.getAttributeType(name);
        String attrType = SJbaseRadiusDictionary.getValueType(name);
        if (attrType.equalsIgnoreCase("String") || attrType.equalsIgnoreCase("Text")) {
            try {
                valueBytes = value.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.info(module, method, "", "", e);
                valueBytes = value.getBytes();
            }
        } else {
            if (attrType.equalsIgnoreCase("Inet4Address") || attrType.equalsIgnoreCase("Inet6Address")) {
                try {
                    valueBytes = InetAddress.getByName(value).getAddress();
                }
                catch (UnknownHostException e) {
                    logger.info(module, method, "", "the value of attribute is invalid", e);
                    throw new SJbaseUnsupportedAttributeException();
                }
            }
            if (attrType.equalsIgnoreCase("Value")) {
                ByteBuffer bytebuf = ByteBuffer.allocate(4);
                try {
                    bytebuf.putInt(new Integer(value));
                }
                catch (NumberFormatException e) {
                    logger.info(module, method, "", "the value of attribute is invalid", e);
                    throw new SJbaseUnsupportedAttributeException();
                }
                valueBytes = bytebuf.array();
            } else {
                logger.info(module, method, "check the attribute name", "unsupported attribute");
                throw new SJbaseUnsupportedAttributeException();
            }
        }
        logger.info(module, method, "", "end");
        return new SJbaseRadiusAttribute(type, valueBytes);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] toBytes() {
        byte[] attribute = new byte[this.length];
        attribute[0] = (byte)this.type;
        attribute[1] = (byte)this.length;
        System.arraycopy(this.value, 0, attribute, 2, this.value.length);
        return attribute;
    }
}

