/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.LogTask;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcLogTask
extends TimerTask
implements Comparator<File> {
    private final String LOG_FUNCTION = "LoggerUtility";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String LOG_START = "Start.";
    private final String LOG_END = "End.";
    private final String FILE_PAUSE_START = "<";
    private final String FILE_PAUSE_END = ">";
    private final String DIRECTORY_PATH = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("catalina.base"), "logs");
    private final String REGULAR_EXPRESSION_TOMCAT_LOG = "^(commons-daemon\\.|tomcat7-stdout\\.|tomcat7-stderr\\.|localhost_access_log\\.)([0-9]{8}|[0-9]{4}-[0-9]{2}-[0-9]{2})\\.log$";
    private final String REGULARE_XPRESSION_SERIAL_NUMBER = "((_)([0-9]+))?.zip$";
    private final String REGULARE_XPRESSION_ZIP_FILE = "^([0-9]{8})((_)([0-9]+))?.zip$";
    private final String REGULARE_XPRESSION_LINE_TOP = "^";
    private final Pattern PATTERN_LOG = Pattern.compile("^(commons-daemon\\.|tomcat7-stdout\\.|tomcat7-stderr\\.|localhost_access_log\\.)([0-9]{8}|[0-9]{4}-[0-9]{2}-[0-9]{2})\\.log$", 2);
    private final Pattern PATTERN_ZIP = Pattern.compile("^([0-9]{8})((_)([0-9]+))?.zip$", 2);
    private final String EXTENSION_ZIP = ".zip";
    private final String UNDER_SCORE = "_";
    private final String PATH_SEPARATOR = "." + File.separator;
    private final String DATE_FORMAT = "yyyyMMdd";
    private final int DATE_GROUP_NUMBER_LOG = 2;
    private final int DATE_GROUP_NUMBER_ZIP = 1;
    private final int SERIAL_NUMBER_GROUP = 4;
    private final int SN_LOG_KEEPCOUNT_DEFAULT = 30;
    private final int BUF_SIZE = 1024;
    private SJcLoggerInterface logger = SJcLogUty.getLogger("SN_System.log");
    private final String HISTORY_FILE = this.DIRECTORY_PATH + "TOMCAT_LOG.history";
    private final String ENCODE = "UTF-8";

    @Override
    public void run() {
        String Log_SubTitle = "run";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "run", "Start.");
        this.logTaskMain();
        this.logger.info("LoggerUtility", this.LOG_TITLE, "run", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTaskMain() {
        String Log_SubTitle = "logTaskMain";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "logTaskMain", "Start.");
        try {
            File file = new File(this.DIRECTORY_PATH);
            if (!file.isDirectory()) {
                this.logger.info("LoggerUtility", this.LOG_TITLE, "logTaskMain", "Tomcat log folder <logs> is not found");
                return;
            }
            this.archiveLogMain();
            this.deleteLogMain();
        }
        catch (Exception ex) {
            this.logger.error("LoggerUtility", this.LOG_TITLE, "logTaskMain", "Exception occured.", ex);
        }
        finally {
            this.logger.info("LoggerUtility", this.LOG_TITLE, "logTaskMain", "End.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveLogMain() {
        String Log_SubTitle = "archiveLogMain";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLogMain", "Start.");
        try {
            ArrayList<File> fileList = this.getFileList(this.DIRECTORY_PATH);
            if (fileList.isEmpty()) {
                this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLogMain", "File not exist in tomcat log folder");
                return;
            }
            HashMap<String, ArrayList<File>> objectOfArchiveMap = this.getObjectOfArchive(fileList);
            if (objectOfArchiveMap.isEmpty()) {
                this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLogMain", "Object of archive file not exist.");
                return;
            }
            this.archiveLog(objectOfArchiveMap);
        }
        finally {
            this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLogMain", "End.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLogMain() {
        String Log_SubTitle = "deleteLogMain";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteLogMain", "Start.");
        try {
            ArrayList<File> fList = this.getFileList(this.DIRECTORY_PATH);
            if (fList.isEmpty()) {
                this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteLogMain", "File not exist in tomcat log folder");
                return;
            }
            ArrayList<File> archiveFileList = this.getArchiveFileList(fList);
            if (archiveFileList.isEmpty()) {
                this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteLogMain", "archive file not exist.");
                return;
            }
            Collections.sort(archiveFileList, this);
            this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteLogMain", "archive file sort finish.");
            ArrayList<File> historyFileList = this.getHistoryFileList();
            archiveFileList = this.mergeArchiveList(historyFileList, archiveFileList);
            archiveFileList = this.deleteArchiveFile(archiveFileList);
            this.updateHistory(archiveFileList);
        }
        finally {
            this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteLogMain", "End.");
        }
    }

    private HashMap<String, ArrayList<File>> getObjectOfArchive(ArrayList<File> fileList) {
        String Log_SubTitle = "getObjectOfArchive";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getObjectOfArchive", "Start.");
        HashMap<String, ArrayList<File>> objectOfArchiveMap = new HashMap<String, ArrayList<File>>();
        Date nowDate = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
        String nowDateStr = simpleFormat.format(nowDate);
        for (File file : fileList) {
            String fileName = file.getName();
            Matcher matcherLog = this.PATTERN_LOG.matcher(fileName);
            if (!matcherLog.matches()) continue;
            String fileDateStr = matcherLog.group(2);
            if (0 <= (fileDateStr = fileDateStr.replaceAll("-", "")).compareTo(nowDateStr)) continue;
            ArrayList<Object> fList = null;
            fList = objectOfArchiveMap.containsKey(fileDateStr) ? objectOfArchiveMap.get(fileDateStr) : new ArrayList();
            fList.add(file);
            objectOfArchiveMap.put(fileDateStr, fList);
        }
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getObjectOfArchive", "End.");
        return objectOfArchiveMap;
    }

    private void archiveLog(HashMap<String, ArrayList<File>> objectOfArchiveMap) {
        String Log_SubTitle = "archiveLog";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLog", "Start.");
        Iterator<String> keyIterator = objectOfArchiveMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            try {
                String dateStr = keyIterator.next();
                ArrayList<File> fList = objectOfArchiveMap.get(dateStr);
                File archiveFile = this.getArchiveFileName(dateStr);
                ArrayList<File> deleteFileList = this.compress(archiveFile, fList);
                this.deleteObjectOfArchive(deleteFileList);
                this.addHistory(archiveFile);
            }
            catch (Exception ex) {
                this.logger.error("LoggerUtility", this.LOG_TITLE, "archiveLog", "Exception occured.", ex);
            }
        }
        this.logger.info("LoggerUtility", this.LOG_TITLE, "archiveLog", "End.");
    }

    private File getArchiveFileName(String dateStr) {
        String Log_SubTitle = "getArchiveFileName";
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getArchiveFileName", "Start.");
        File archiveFile = null;
        ArrayList<File> sameDateZipList = this.getSameDateZip(dateStr);
        if (sameDateZipList.size() == 0) {
            archiveFile = new File(this.DIRECTORY_PATH + SJcConst.sjc_PathSeparator + dateStr + ".zip");
        } else {
            String serialNumber = this.getSerialNumber(sameDateZipList);
            archiveFile = new File(this.DIRECTORY_PATH + SJcConst.sjc_PathSeparator + dateStr + "_" + serialNumber + ".zip");
        }
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getArchiveFileName", "End.return : " + archiveFile.getName());
        return archiveFile;
    }

    private ArrayList<File> getArchiveFileList(ArrayList<File> fList) {
        String Log_SubTitle = "getArchiveFileList";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getArchiveFileList", "Start.");
        ArrayList<File> archiveFileList = new ArrayList<File>();
        for (File file : fList) {
            Matcher matcherZip = this.PATTERN_ZIP.matcher(file.getName());
            if (!matcherZip.matches()) continue;
            archiveFileList.add(file);
        }
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getArchiveFileList", "End.");
        return archiveFileList;
    }

    private ArrayList<File> deleteArchiveFile(ArrayList<File> archiveFileList) {
        String Log_SubTitle = "deleteArchiveFile";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "Start.");
        int snLogKeepCount = SJcEnvUty.getProperty2int("SN_Log_KeepCount", 30);
        this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "snLogKeepCount : " + snLogKeepCount);
        if (snLogKeepCount < 0) {
            snLogKeepCount = 30;
        }
        int archiveFileCount = archiveFileList.size();
        int deleteCount = archiveFileCount - snLogKeepCount;
        ArrayList<File> archiveNewFileList = new ArrayList<File>(archiveFileList);
        for (int i = 0; i < deleteCount; ++i) {
            try {
                if (archiveFileList.get(i).delete()) {
                    this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "Archive file delete.<" + archiveFileList.get(i).getAbsolutePath() + ">");
                    archiveNewFileList.remove(archiveFileList.get(i));
                    continue;
                }
                this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "Archive file failed to delete.<" + archiveFileList.get(i).getAbsolutePath() + ">");
                continue;
            }
            catch (Exception ex) {
                this.logger.error("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "Exception occured.", ex);
            }
        }
        this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteArchiveFile", "End.");
        return archiveNewFileList;
    }

    private void deleteObjectOfArchive(ArrayList<File> deleteFileList) {
        String Log_SubTitle = "deleteObjectOfArchive";
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "deleteObjectOfArchive", "Start.");
        for (File file : deleteFileList) {
            try {
                if (file.delete()) {
                    this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteObjectOfArchive", "Original file delete.<" + file.getAbsolutePath() + ">");
                    continue;
                }
                this.logger.info("LoggerUtility", this.LOG_TITLE, "deleteObjectOfArchive", "Original file failed to delete.<" + file.getAbsolutePath() + ">");
            }
            catch (Exception ex) {
                this.logger.error("LoggerUtility", this.LOG_TITLE, "deleteObjectOfArchive", "Exception occured.<" + file.getAbsolutePath() + ">", ex);
            }
        }
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "deleteObjectOfArchive", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<File> compress(File archiveFile, ArrayList<File> files) throws IOException {
        String Log_SubTitle = "compress";
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "compress", "Start.");
        ZipOutputStream zos = null;
        byte[] buf = new byte[1024];
        ArrayList<File> deleteFileList = new ArrayList<File>();
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile)));
            for (File f : files) {
                this.logger.trace("LoggerUtility", this.LOG_TITLE, "compress", "archive start.<" + f.getAbsolutePath() + ">");
                InputStream is = null;
                try {
                    String fileNameZip = this.PATH_SEPARATOR + f.getName();
                    ZipEntry ze = new ZipEntry(fileNameZip);
                    zos.putNextEntry(ze);
                    is = new BufferedInputStream(new FileInputStream(f));
                    int len = 0;
                    while ((len = is.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                    zos.flush();
                    deleteFileList.add(f);
                    this.logger.info("LoggerUtility", this.LOG_TITLE, "compress", "zip archive succeeded.<" + f.getAbsolutePath() + ">");
                }
                catch (Exception ex) {
                    this.logger.error("LoggerUtility", this.LOG_TITLE, "compress", "Failed to zip archive.<" + f.getAbsolutePath() + ">", ex);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        this.logger.error("LoggerUtility", this.LOG_TITLE, "compress", "Failed to file close.<" + f.getAbsolutePath() + ">", ex);
                    }
                }
            }
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "compress", "End.");
        return deleteFileList;
    }

    private ArrayList<File> getFileList(String path) {
        String Log_SubTitle = "getFileList";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getFileList", "Start.");
        File[] files = new File(path).listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (!file.isFile()) continue;
            fileList.add(file);
        }
        this.logger.info("LoggerUtility", this.LOG_TITLE, "getFileList", "End.");
        return fileList;
    }

    private ArrayList<File> getSameDateZip(String dateStr) {
        String Log_SubTitle = "getSameDateZip";
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getSameDateZip", "Start.");
        ArrayList<File> sameDateZipList = new ArrayList<File>();
        ArrayList<File> fList = this.getFileList(this.DIRECTORY_PATH);
        String patternDynamStr = "^" + dateStr + "((_)([0-9]+))?.zip$";
        Pattern patternDynam = Pattern.compile(patternDynamStr, 2);
        for (File file : fList) {
            Matcher matcherZip = patternDynam.matcher(file.getName());
            if (!matcherZip.matches()) continue;
            sameDateZipList.add(file);
        }
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getSameDateZip", "End.");
        return sameDateZipList;
    }

    private String getSerialNumber(ArrayList<File> sameZipList) throws RuntimeException {
        String Log_SubTitle = "getSerialNumber";
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getSerialNumber", "Start.");
        int maxSerialNumber = 0;
        for (File file : sameZipList) {
            int serialNumber;
            String serialNumberStr;
            Matcher matcherZip = this.PATTERN_ZIP.matcher(file.getName());
            if (!matcherZip.matches() || (serialNumberStr = matcherZip.group(4)) == null || maxSerialNumber >= (serialNumber = Integer.parseInt(serialNumberStr))) continue;
            maxSerialNumber = serialNumber;
        }
        this.logger.trace("LoggerUtility", this.LOG_TITLE, "getSerialNumber", "End.");
        return String.valueOf(maxSerialNumber + 1);
    }

    @Override
    public int compare(File fileA, File fileB) {
        Matcher matcherA = this.PATTERN_ZIP.matcher(fileA.getName());
        Matcher matcherB = this.PATTERN_ZIP.matcher(fileB.getName());
        matcherA.matches();
        matcherB.matches();
        String dateA = matcherA.group(1);
        String dateB = matcherB.group(1);
        if (!dateA.equals(dateB)) {
            return dateA.compareTo(dateB);
        }
        String serialNumberStrA = matcherA.group(4);
        String serialNumberStrB = matcherB.group(4);
        if (serialNumberStrA == null) {
            return -1;
        }
        if (serialNumberStrB == null) {
            return 1;
        }
        int serialNumberA = Integer.parseInt(serialNumberStrA);
        int serialNumberB = Integer.parseInt(serialNumberStrB);
        return serialNumberA - serialNumberB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<File> getHistoryFileList() {
        String TITLE = "getHistoryFileList";
        ArrayList<File> historyList = new ArrayList<File>();
        File historyMngFile = new File(this.HISTORY_FILE);
        if (!historyMngFile.exists()) {
            return historyList;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(historyMngFile), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                File historyFile = new File(this.concatFile(line));
                if (historyFile.exists()) {
                    historyList.add(historyFile);
                    continue;
                }
                this.logger.warn("LoggerUtility", this.LOG_TITLE, "getHistoryFileList", "Archive File Not Found. File:" + historyFile.getName());
            }
        }
        catch (Exception ex) {
            this.logger.warn("LoggerUtility", this.LOG_TITLE, "getHistoryFileList", "read error.", ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {
                    this.logger.warn("LoggerUtility", this.LOG_TITLE, "getHistoryFileList", "close error.", ex);
                }
            }
        }
        return historyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistory(File historyFile) {
        String TITLE = "addHistory";
        File historyMngFile = new File(this.HISTORY_FILE);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(historyMngFile, true), "UTF-8"));
            bw.write(historyFile.getName());
            bw.newLine();
        }
        catch (Exception ex) {
            this.logger.warn("LoggerUtility", this.LOG_TITLE, "addHistory", "write error.", ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    this.logger.warn("LoggerUtility", this.LOG_TITLE, "addHistory", "close error.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(ArrayList<File> listNewHistory) {
        String TITLE = "updateHistory";
        File historyMngFile = new File(this.HISTORY_FILE);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(historyMngFile), "UTF-8"));
            for (File historyFile : listNewHistory) {
                bw.write(historyFile.getName());
                bw.newLine();
            }
        }
        catch (Exception ex) {
            this.logger.warn("LoggerUtility", this.LOG_TITLE, "updateHistory", "write error.", ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    this.logger.warn("LoggerUtility", this.LOG_TITLE, "updateHistory", "close error.", ex);
                }
            }
        }
    }

    private ArrayList<File> mergeArchiveList(ArrayList<File> historyList, ArrayList<File> archiveList) {
        ArrayList<File> mergeList = new ArrayList<File>();
        ArrayList<File> outSideList = new ArrayList<File>();
        for (File archiveFile : archiveList) {
            if (historyList.contains(archiveFile)) continue;
            outSideList.add(archiveFile);
        }
        mergeList.addAll(outSideList);
        mergeList.addAll(historyList);
        return mergeList;
    }

    private String concatFile(String file) {
        String result = this.DIRECTORY_PATH;
        if (!result.endsWith(SJcConst.sjc_PathSeparator)) {
            result = result + SJcConst.sjc_PathSeparator;
        }
        result = result + file;
        return result;
    }
}

