/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import java.util.HashMap;
import java.util.UUID;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLogElemCon;
import sanproject.sn2.com.utility.Logger.SJcAuditLogger;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLogElementContainerInterface;
import sanproject.sn2.com.utility.SJcSessionUty;

public class SJcAuditLoggerSN2
extends SJcAuditLogger {
    protected SJbaseUserSession userSession = null;
    private final String OPE_NAME_LOGIN = "Login";
    private final String OPE_NAME_LOGOUT = "Logout";
    private static final String LOG_FUNCTION = "SJcAuditLoggerSN2";
    private static final String LOG_TITLE = SJcAuditLoggerSN2.class.getSimpleName();
    private static final int ADT_EXD_RMIAP = 4;
    private static final int ADT_EXD_SVP = 5;
    private static final String ADD_INFO_LOGID_DEFAULT = "0";

    @Override
    public void init(SJbaseUserSession us) {
        String LOG_SUBTITLE = "init";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.  - us:" + us);
        this.userSession = us;
        this.glSessionId = this.userSession.getSessionID();
        if (this.glSessionId == null || this.glSessionId.trim().equals("")) {
            UUID uid = UUID.randomUUID();
            this.glSessionId = uid.toString().replace("-", "");
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.  ");
    }

    @Override
    public void login(SJcException ex) {
        String LOG_SUBTITLE = "login";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start. - ex:" + ex);
        SJcAuditLogElemCon aLogElem = new SJcAuditLogElemCon();
        aLogElem.setFunctionName("LOGIN");
        aLogElem.setOperationName("Login");
        aLogElem.setOperationParameter("");
        if (ex == null) {
            aLogElem.setOperationResult("Success");
            aLogElem.setOperationErrorCode(null);
        } else {
            aLogElem.setOperationResult("Error");
            aLogElem.setOperationErrorCode(ex.getMsg());
        }
        this.setAdditionalInfo(aLogElem);
        super.putLog(aLogElem);
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.  ");
    }

    @Override
    public void logout(SJcException ex) {
        String LOG_SUBTITLE = "logout";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start. - ex:" + ex);
        SJcAuditLogElemCon aLogElem = new SJcAuditLogElemCon();
        aLogElem.setFunctionName("LOGOUT");
        aLogElem.setOperationName("Logout");
        aLogElem.setOperationParameter("");
        if (ex == null) {
            aLogElem.setOperationResult("Success");
            aLogElem.setOperationErrorCode(null);
        } else {
            aLogElem.setOperationResult("Error");
            aLogElem.setOperationErrorCode(ex.getMsg());
        }
        this.setAdditionalInfo(aLogElem);
        super.putLog(aLogElem);
        this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.  ");
    }

    @Override
    public void putLog(SJcAuditLogElementContainerInterface ec) {
        this.setAdditionalInfo(ec);
        super.putLog(ec);
    }

    private void setAdditionalInfo(SJcAuditLogElementContainerInterface ec) {
        if (null != this.userSession) {
            HashMap<String, String> addinfo = ec.getAdditionalInfo();
            if (null == addinfo) {
                addinfo = new HashMap();
                ec.setAdditionalInfo(addinfo);
            }
            if (!addinfo.containsKey("SN2_AUDITLOG_ADD_USER")) {
                addinfo.put("SN2_AUDITLOG_ADD_USER", this.userSession.getUserName());
            }
            if (!addinfo.containsKey("SN2_AUDITLOG_ADD_HOST")) {
                addinfo.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(this.userSession));
            }
            if (addinfo.containsKey("SN2_AUDITLOG_ADD_LOGID")) {
                addinfo.remove("SN2_AUDITLOG_ADD_LOGID");
            }
            addinfo.put("SN2_AUDITLOG_ADD_LOGID", ADD_INFO_LOGID_DEFAULT);
            if (!addinfo.containsKey("SN2_AUDITLOG_ADD_EXTIF")) {
                if (this.userSession.getLoginType().equals("SVP")) {
                    addinfo.put("SN2_AUDITLOG_ADD_EXTIF", String.valueOf(5));
                } else {
                    addinfo.put("SN2_AUDITLOG_ADD_EXTIF", String.valueOf(4));
                }
            }
        }
    }
}

