/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.message;

import java.text.MessageFormat;
import java.util.HashMap;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.message.inf.SJcMessageProcessInterface;

public class SJcMessageProcess
implements SJcMessageProcessInterface {
    private HashMap messageList = new HashMap();
    private HashMap behaviorList = new HashMap();
    private HashMap iconIDList = new HashMap();
    private HashMap measuresMessageList = new HashMap();
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    @Override
    public synchronized HashMap getMessageList(String venderID, String langType) {
        HashMap listmapMessage;
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMessageList", "start");
        String messageKey = venderID + "/" + langType;
        if (this.messageList.containsKey(messageKey)) {
            listmapMessage = (HashMap)this.messageList.get(messageKey);
        } else {
            try {
                listmapMessage = (HashMap)SJcFileUty.loadSerialize(SJcConst.MESSAGE_DIRECTORY, this.getMessageFileName(venderID, langType));
                this.messageList.put(messageKey, listmapMessage);
            }
            catch (Exception e) {
                listmapMessage = new HashMap();
            }
            this.stdLogger.trace("Message", "SJcMessageProcess", "getMessageList", "end");
        }
        return listmapMessage;
    }

    private String getMessageFileName(String venderID, String langType) {
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMessageFileName", "start");
        MessageFormat format = new MessageFormat("Message_{0}_{1}.bin");
        Object[] parameters = new Object[]{venderID, langType};
        String fileName = format.format(parameters);
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMessageFileName", "end");
        return fileName;
    }

    @Override
    public synchronized HashMap getBehaviorList(String venderID, String langType) {
        HashMap listmapBehavior;
        this.stdLogger.trace("Message", "SJcMessageProcess", "getBehaviorList", "start");
        String behaviorKey = venderID + "/" + langType;
        if (this.behaviorList.containsKey(behaviorKey)) {
            listmapBehavior = (HashMap)this.behaviorList.get(behaviorKey);
        } else {
            try {
                listmapBehavior = (HashMap)SJcFileUty.loadSerialize(SJcConst.MESSAGE_DIRECTORY, this.getBehaviorFileName(venderID, langType));
                this.behaviorList.put(behaviorKey, listmapBehavior);
            }
            catch (Exception e) {
                this.stdLogger.error("Message", "SJcMessageProcess", "getBehaviorList", "catchException");
                listmapBehavior = new HashMap();
            }
            this.stdLogger.trace("Message", "SJcMessageProcess", "getBehaviorList", "end");
        }
        return listmapBehavior;
    }

    private String getBehaviorFileName(String venderID, String langType) {
        this.stdLogger.trace("Message", "SJcMessageProcess", "getBehaviorFileName", "start");
        MessageFormat format = new MessageFormat("Behavior_{0}_{1}.bin");
        Object[] parameters = new Object[]{venderID, langType};
        String fileName = format.format(parameters);
        this.stdLogger.trace("Message", "SJcMessageProcess", "getBehaviorFileName", "end");
        return fileName;
    }

    @Override
    public synchronized HashMap getIconIDList(String venderID, String langType) {
        HashMap listmapIconID;
        this.stdLogger.trace("Message", "SJcMessageProcess", "getIconIDList", "start");
        String iconIDKEY = venderID + "/" + langType;
        if (this.iconIDList.containsKey(iconIDKEY)) {
            listmapIconID = (HashMap)this.iconIDList.get(iconIDKEY);
        } else {
            try {
                listmapIconID = (HashMap)SJcFileUty.loadSerialize(SJcConst.MESSAGE_DIRECTORY, this.getIconIDFileName(venderID, langType));
                this.iconIDList.put(iconIDKEY, listmapIconID);
            }
            catch (Exception e) {
                this.stdLogger.error("Message", "SJcMessageProcess", "getIconIDList", "catchException");
                listmapIconID = new HashMap();
            }
            this.stdLogger.trace("Message", "SJcMessageProcess", "getIconIDList", "end");
        }
        return listmapIconID;
    }

    private String getIconIDFileName(String venderID, String langType) {
        this.stdLogger.trace("Message", "SJcMessageProcess", "getIconIDFileName", "start");
        MessageFormat format = new MessageFormat("IconID_{0}_{1}.bin");
        Object[] parameters = new Object[]{venderID, langType};
        String fileName = format.format(parameters);
        this.stdLogger.trace("Message", "SJcMessageProcess", "getIconIDFileName", "end");
        return fileName;
    }

    @Override
    public synchronized HashMap getMeasuresMessageList(String venderID, String langType) {
        HashMap listmapMeasuresMessage;
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMeasuresMessageList", "start");
        String measuresMessageKey = venderID + "/" + langType;
        if (this.measuresMessageList.containsKey(measuresMessageKey)) {
            listmapMeasuresMessage = (HashMap)this.measuresMessageList.get(measuresMessageKey);
        } else {
            try {
                listmapMeasuresMessage = (HashMap)SJcFileUty.loadSerialize(SJcConst.MESSAGE_DIRECTORY, this.getMeasuresMessageFileName(venderID, langType));
                this.measuresMessageList.put(measuresMessageKey, listmapMeasuresMessage);
            }
            catch (Exception e) {
                this.stdLogger.error("Message", "SJcMessageProcess", "getMeasuresMessageList", "catchException");
                listmapMeasuresMessage = new HashMap();
            }
            this.stdLogger.trace("Message", "SJcMessageProcess", "getMeasuresMessageList", "end");
        }
        return listmapMeasuresMessage;
    }

    private String getMeasuresMessageFileName(String venderID, String langType) {
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMeasuresMessageFileName", "start");
        MessageFormat format = new MessageFormat("Measures_{0}_{1}.bin");
        Object[] parameters = new Object[]{venderID, langType};
        String fileName = format.format(parameters);
        this.stdLogger.trace("Message", "SJcMessageProcess", "getMeasuresMessageFileName", "end");
        return fileName;
    }
}

