/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFErrorDetail;
import sanproject.serverux.dataimpl.MRCFErrorInf;
import sanproject.serverux.dataimpl.MRCFctgDetail;
import sanproject.serverux.dataimpl.MRCFctgInf;
import sanproject.serverux.dataimpl.MRCFgetPairRate;
import sanproject.serverux.dataimpl.MRCFgetPairRateDetail;
import sanproject.serverux.dataimpl.MRCFgetPairRate_IN;
import sanproject.serverux.dataimpl.MRCFgetPairRate_OUT;
import sanproject.serverux.dataimpl.MRCFgetTiPairInfo;
import sanproject.serverux.dataimpl.MRCFsetAtrbMain;
import sanproject.serverux.dataimpl.MRCFsetAttribute;
import sanproject.serverux.dataimpl.MRCFsetDelPair;
import sanproject.serverux.dataimpl.MRCFsetDelPairMain;
import sanproject.serverux.dataimpl.MRCFsetQSPairDetail;
import sanproject.serverux.dataimpl.MRCFsetQSPairInfo_OUT;
import sanproject.serverux.dataimpl.MRCFsetQSPairMain;
import sanproject.serverux.dataimpl.MRCFsetResPairMain;
import sanproject.serverux.dataimpl.MRCFsetResyncPair;
import sanproject.serverux.dataimpl.MRCFsetSplitPair;
import sanproject.serverux.dataimpl.MRCFsetSptPairMain;
import sanproject.serverux.dataimpl.MRCFsetSusPairMain;
import sanproject.serverux.dataimpl.MRCFsetSuspendPair;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrCapacityColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.replication.SJctrPVolCapacityColumnFromPairVolInfo;
import sanproject.sn2.controller.com.column.replication.SJctrSVolCapacityColumnFromPairVolInfo;
import sanproject.sn2.controller.com.column.thinimage.SJctrPVolCapacityColumnFromTiPvolInfo;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.replication.local.ssgrp.SJctrLocalReplicationSsGroupTopTableModel;
import sanproject.sn2.controller.topwindow.replication.local.tipvol.SJctrLocalReplicationTiPvolTopTableModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrCTGInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetPairRate;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetPvolSsCountInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetSnapshotGroupPairNum;
import sanproject.sn2.controller.wizard.replication.com.SJctrLReplicaOperationError;
import sanproject.sn2.controller.wizard.replication.com.SJctrLReplicaOperationErrorForRsvCtg;
import sanproject.sn2.controller.wizard.replication.com.SJctrLReplicaOperationErrorForRsvVol;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicaLdevInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateSnapshotDataInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate.SJctrViewPairSyncRateInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesSiInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationConsistencyGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationConsistencyGroupSummary;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.SJmoConsistencyGroupIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationConsistencyGroupInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationConsistencyGroupSummary;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationSummary;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationTiPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationConsistencyGroupInfoMgr;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.replication.local.manager.SJmoSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoLicenseDetail;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrReplicationUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public SJctrReplicationUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    private static List<?> getCache(SJctrDataController dc, Class<?> key) {
        if (dc instanceof SJctrWizardDataController) {
            return ((SJctrWizardDataController)dc).getCache(key);
        }
        return dc.getProxy().getCache(key);
    }

    public static SJmoLocalReplicationPairVolInfoMgr getSJmoLocalReplicationPairVolInfoMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationPairVolInfoMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoLocalReplicationPairVolInfoMgr", "Information of Local Replication pair List is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoLocalReplicationPairVolInfoMgr", "Size of Local Replication pair List size is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLocalReplicationPairVolInfoMgr retInfo = (SJmoLocalReplicationPairVolInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoLocalReplicationPairVolInfoMgr", "Information of Local Replication pairs is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static SJmoLocalReplicationConsistencyGroupSummary getSJmoLocalReplicationConsistencyGroupSummary(SJctrDataController dc) {
        List<?> retInfoList = SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationConsistencyGroupSummary.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupSummary", "Information of Local Replication CTG Summary List is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupSummary", "Size of Local Replication CTG Summary List size is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLocalReplicationConsistencyGroupSummary retInfo = (SJmoLocalReplicationConsistencyGroupSummary)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupSummary", "Information of Local Replication CTG Summary is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static SJmoLocalReplicationConsistencyGroupInfoMgr getSJmoLocalReplicationConsistencyGroupInfoMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationConsistencyGroupInfoMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupInfoMgr", "Information of Local Replication CTG List is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupInfoMgr", "Size of Local Replication CTG List size is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLocalReplicationConsistencyGroupInfoMgr retInfo = (SJmoLocalReplicationConsistencyGroupInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoLocalReplicationConsistencyGroupInfoMgr", "Information of Local Replication CTG is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfo;
    }

    public static List<SJmoLdevDetail> getSJmoLdevDetail(SJctrDataController dc) {
        List<SJmoLdevDetail> info = SJctrReplicationUtility.getCache(dc, SJmoGetLdevDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevDetail", "Information of LDEVs is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevNicknameInfo> getSJmoLdevNicknameInfo(SJctrDataController dc) {
        List<SJmoLdevNicknameInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetLdevNicknameInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevNicknameInfo", "Information of LDEV nickname is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPoolNameInfo> getSJmoPoolNameInfo(SJctrDataController dc) {
        List<SJmoPoolNameInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetPoolNameInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPoolNameInfo", "Information of pool name info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoClprInfo> getSJmoClprInfo(SJctrDataController dc) {
        List<SJmoClprInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetClprInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoClprInfo", "Information of CLPR info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevLuseInfo> getSJmoLdevLuseInfo(SJctrDataController dc) {
        List<SJmoLdevLuseInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetLdevLuseInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevLuseInfo", "Information of LUSE info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPoolDetail> getSJmoPoolDetail(SJctrDataController dc) {
        List<SJmoPoolDetail> info = SJctrReplicationUtility.getCache(dc, SJmoGetPoolDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPoolDetail", "Information of Pool info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoSnapshotSetInfoMgr> getSJmoSnapshotSetInfoMgr(SJctrDataController dc) {
        List<SJmoSnapshotSetInfoMgr> info = SJctrReplicationUtility.getCache(dc, SJmoGetSnapshotSetInfoMgr.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoSnapshotSetInfoMgr", "Information of Snapshot Set info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoRSGgetAllRsgs> getSJmoRSGgetAllRsgs(SJctrDataController dc) {
        List<SJmoRSGgetAllRsgs> allRsgs = SJctrReplicationUtility.getCache(dc, SJmoGetRSGgetAllRsgs.class);
        if (null == allRsgs) {
            dc.getLogUty().putlog("getSJmoRSGgetAllRsgs", "Information of all resource groups is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return allRsgs;
    }

    public static SJmoRSGgetAllRsgs checkSJmoRSGgetAllRsgsInfo(SJctrDataController dc, List<SJmoRSGgetAllRsgs> allRsgsList) {
        if (null == allRsgsList || 0 == allRsgsList.size()) {
            dc.getLogUty().putlog("checkSJmoRSGgetAllRsgsInfo", "Information of allRsgsList info is null or zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs allRsg = allRsgsList.get(0);
        if (null == allRsg) {
            dc.getLogUty().putlog("checkSJmoRSGgetAllRsgsInfo", "Information of allRsg info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return allRsg;
    }

    public static List<Object> getModelInfoNotUsedCache(SJctrDataController dc, SJmoGetKind_IF kind) {
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        wrapperSet.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        return dataMap.get(directWrapper);
    }

    public static List<SJmoLocalReplicationPairVolInfo> checkAndGetExistPairVolInfo(List<SJmoLocalReplicationPairVolInfo> checkList, SJmoLocalReplicationPairVolInfoMgr allPairVolInfo) throws SJcException {
        if (checkList == null || allPairVolInfo == null) {
            return new ArrayList<SJmoLocalReplicationPairVolInfo>(0);
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>(checkList.size());
        for (SJmoLdevIndex sJmoLdevIndex : checkList) {
            SJmoLocalReplicationPairVolInfo targetVol = allPairVolInfo.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (SJctrReplicationUtility.checkLocalPairVolPos(targetVol, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SVOL)) {
                if (null != targetVol.getPVolIndex()) {
                    retList.add(targetVol);
                    continue;
                }
                SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetExistPairVolInfo", "Information of Primary Volume Index is null.");
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetExistPairVolInfo", "Information of Pair Volume is not Secondary Volume.");
            SJctrError err = new SJctrError(209, 22, 106534);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> checkAndGetAllExistPairVolInfo(List<SJmoLocalReplicationPairVolInfo> checkList, SJmoLocalReplicationPairVolInfoMgr allPairVolInfo, SJmoTiSnapshotPairList sJmoTiSnapshotPairList, SJmoTiPvolStatus sJmoTiPvolStatus) {
        if (checkList == null || allPairVolInfo == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetAllExistPairVolInfo", "checkList is null or allPairVolInfo is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>(checkList.size());
        List<SJmoLocalReplicationPairVolInfo> noSvolPairInfoList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        for (SJmoLocalReplicationPairVolInfo selectedVol : checkList) {
            SJmoLocalReplicationPairVolInfo targetVol = allPairVolInfo.getLocalReplicationPairVolInfo(selectedVol);
            if (null != targetVol && SJctrReplicationUtility.checkLocalPairVolPos(targetVol, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SVOL)) {
                if (null != targetVol.getPVolIndex()) {
                    retList.add(targetVol);
                    continue;
                }
                SJctrLogUty.info("SJctrReplicationUtility", "checkAndGetAllExistPairVolInfo", "Information of Primary Volume Index is null.");
                continue;
            }
            noSvolPairInfoList.add(selectedVol);
        }
        ArrayList<SJmoTiPvolMu> targetTiPvolMuList = new ArrayList<SJmoTiPvolMu>();
        for (SJmoLocalReplicationPairVolInfo noSvolPair : noSvolPairInfoList) {
            SJmoLdevIndex pvol = noSvolPair.getPVolIndex();
            if (pvol == null || !noSvolPair.isVolPos(0x800000)) continue;
            short ldkc = pvol.getSLdkc();
            short cu = pvol.getSCu();
            short ldev = pvol.getSLdev();
            short mu = noSvolPair.getSMuNum();
            SJmoTiPvolMu pvolMu = SJctrTiReplicationUtility.createTiPVolMuInfo(ldkc, cu, ldev, mu);
            targetTiPvolMuList.add(pvolMu);
        }
        noSvolPairInfoList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromTiPvolMu(targetTiPvolMuList, sJmoTiSnapshotPairList, sJmoTiPvolStatus.getTiPvolInfo());
        retList.addAll(noSvolPairInfoList);
        if (retList.size() == 0) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetAllExistPairVolInfo", "Check list data is different from local pair list.");
            SJctrError err = new SJctrError(209, 22, 106534);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static void setCacheLReplicaDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc, short copyType) {
        needDataMap.put(SJmoGetLocalReplicationPairVolInfoMgr.class.getName(), SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationPairVolInfoMgr.class));
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrReplicationUtility.getSJmoLdevDetail(dc));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc));
        needDataMap.put(SJmoGetPoolNameInfo.class.getName(), SJctrReplicationUtility.getSJmoPoolNameInfo(dc));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrReplicationUtility.getSJmoClprInfo(dc));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevLuseInfo(dc));
        needDataMap.put(SJmoGetPoolDetail.class.getName(), SJctrReplicationUtility.getSJmoPoolDetail(dc));
        if (copyType == 3) {
            needDataMap.put(SJmoGetSnapshotSetInfoMgr.class.getName(), SJctrReplicationUtility.getSJmoSnapshotSetInfoMgr(dc));
        }
    }

    public static void chkCacheLReplicaDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoPoolNameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
        SJctrReplicationUtility.getSJmoPoolDetail(dc);
        SJctrReplicationUtility.getSJmoSnapshotSetInfoMgr(dc);
    }

    public static void setCacheLReplicaDetailDataForSuspend(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLocalReplicationPairVolInfoMgr.class.getName(), SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationPairVolInfoMgr.class));
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrReplicationUtility.getSJmoLdevDetail(dc));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrReplicationUtility.getSJmoClprInfo(dc));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevLuseInfo(dc));
        needDataMap.put(SJmoGetPoolDetail.class.getName(), SJctrReplicationUtility.getSJmoPoolDetail(dc));
    }

    public static void chkCacheLReplicaDetailDataForSuspend(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoLdevLuseInfo(dc);
        SJctrReplicationUtility.getSJmoPoolDetail(dc);
    }

    public static SJcException convLReplicaLogicalErr(SJcException err, int msgID) {
        SJcMessage msgObj = err.getMsg();
        if (msgObj.getModuleID().equals(Integer.toString(22)) && msgObj.getFunctionID().equals(Integer.toString(209)) && msgObj.getMsgID().equals(Integer.toString(107001))) {
            SJctrError errObj = new SJctrError(209, 22, msgID);
            err = errObj.createException();
        }
        return err;
    }

    public static List<SJctrReplicaLdevInfo> getReplicaLdevViewList(SJmoLocalReplicationPairVolInfoMgr localPairInfoMgr, SJmoTrueCopyPairVolInfoMgr tcPairInfoMgr, SJmoUniversalReplicatorPairVolInfoMgr urPairInfoMgr, SJmoHAPairVolInfoMgr haPairInfoMgr, SJmoTiPvolInfo[] tiPvolInfos, SJmoTiSnapshotPairList ssPairList, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList, SJctrSystemParamContainer systemParam) {
        ArrayList<SJctrReplicaLdevInfo> retList = new ArrayList<SJctrReplicaLdevInfo>();
        if (localPairInfoMgr == null || tcPairInfoMgr == null || urPairInfoMgr == null || haPairInfoMgr == null || rsgUty == null || ldevDetailList == null) {
            return retList;
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> tiPairInfo = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        for (SJmoTiPvolInfo pvolInfo : tiPvolInfos) {
            SJmoLocalReplicationPairVolInfo noSVolInfo = new SJmoLocalReplicationPairVolInfo(2);
            noSVolInfo.setIPairVolPos(0x400000);
            ArrayList<SJmoTiPvolInfo> pvols = new ArrayList<SJmoTiPvolInfo>();
            pvols.add(pvolInfo);
            noSVolInfo.setAlPVolIndex(pvols);
            noSVolInfo.setLdevIndex(pvolInfo.getSLdkc(), pvolInfo.getSCu(), pvolInfo.getSLdev());
            noSVolInfo.setPVolIndex(pvolInfo);
            tiPairInfo.add(noSVolInfo);
        }
        Collections.sort(tiPairInfo);
        List<SJmoLdevIndex> resourceLdevList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            if (Collections.binarySearch(resourceLdevList, ldevDetail) < 0) continue;
            SJmoLocalReplicationPairVolInfo localPairInfo = SJctrReplicationUtility.getLocalPairVolInfoForReplicaLdevs((SJmoLdevIndex)ldevDetail, localPairInfoMgr, ldevDetailList, systemParam);
            SJmoReplicationPairVolInfo tcPairInfo = tcPairInfoMgr.getTrueCopyPairVolInfo(ldevDetail);
            SJmoReplicationPairVolInfo urPairInfo = urPairInfoMgr.getPairVolInfo(ldevDetail);
            SJmoReplicationPairVolInfo haPairInfo = haPairInfoMgr.getHAPairVolInfo(ldevDetail);
            if (localPairInfo == null) {
                localPairInfo = SJctrReplicationUtility.getLocalPairVolInfoForReplicaLdevs((SJmoLdevIndex)ldevDetail, tiPairInfo, ldevDetailList, systemParam);
            }
            if (localPairInfo == null && tcPairInfo == null && urPairInfo == null && haPairInfo == null) continue;
            SJctrReplicaLdevInfo replicaLdevInfo = new SJctrReplicaLdevInfo(ldevDetail, localPairInfo, tcPairInfo, urPairInfo, haPairInfo);
            retList.add(replicaLdevInfo);
        }
        return retList;
    }

    private static SJmoLocalReplicationPairVolInfo getLocalPairVolInfoForReplicaLdevs(SJmoLdevIndex ldevIndex, SJmoLocalReplicationPairVolInfoMgr localPairInfoMgr, List<SJmoLdevDetail> ldevDetailList, SJctrSystemParamContainer systemParam) {
        SJmoLocalReplicationPairVolInfo ret = null;
        SJmoLocalReplicationPairVolInfo pairVolInfo = localPairInfoMgr.getLocalReplicationPairVolInfo(ldevIndex);
        if (pairVolInfo != null && SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_REPLICA_LDEV) && SJctrReplicationUtility.checkViewReplicationBothPairAndFiconVol(pairVolInfo, ldevDetailList, systemParam)) {
            ret = pairVolInfo;
        }
        return ret;
    }

    private static SJmoLocalReplicationPairVolInfo getLocalPairVolInfoForReplicaLdevs(SJmoLdevIndex ldevIndex, List<SJmoLocalReplicationPairVolInfo> pairInfoNoSvolList, List<SJmoLdevDetail> ldevDetailList, SJctrSystemParamContainer systemParam) {
        SJmoLdevIndex pvolInfo;
        SJmoLocalReplicationPairVolInfo noSvolPvolPairInfo = null;
        int index = Collections.binarySearch(pairInfoNoSvolList, ldevIndex);
        if (index > -1) {
            noSvolPvolPairInfo = pairInfoNoSvolList.get(index);
        }
        SJmoLocalReplicationPairVolInfo ret = null;
        if (noSvolPvolPairInfo != null && SJctrReplicationUtility.checkLocalPairVolPos(noSvolPvolPairInfo, SJctrReplicationDataMacro.BITMAPDATA_REPLICA_LDEV) && (pvolInfo = noSvolPvolPairInfo.getPVolIndex()) != null && SJctrReplicationUtility.checkViewPair(pvolInfo, ldevDetailList, systemParam.isLocalHost())) {
            ret = noSvolPvolPairInfo;
        }
        return ret;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getLocalPairVolViewList(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfoMgr == null || rsgUty == null || ldevDetailList == null) {
            return retList;
        }
        SJmoLocalReplicationPairVolInfo[] pairVolInfoArray = pairInfoMgr.getLocalReplicationPairVolInfoList();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoArray) {
            SJmoLdevIndex pvolIndex;
            if (null == pairVolInfo || !SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SVOL) || (SJctrTiReplicationUtility.isFloatingDevice(pairVolInfo) ? !SJctrReplicationUtility.checkLocalPairResource(pvolIndex = pairVolInfo.getPVolIndex(), resourceLdevs) || !SJctrReplicationUtility.checkViewPair(pvolIndex, ldevDetailList) : !SJctrReplicationUtility.checkLocalPairResourceEither(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewLocalPairBoth(pairVolInfo, ldevDetailList))) continue;
            retList.add(pairVolInfo);
        }
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getLocalPairVolViewSIPairsList(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList, SJctrSystemParamContainer systemParam) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfoMgr == null || rsgUty == null || ldevDetailList == null) {
            return retList;
        }
        SJmoLocalReplicationPairVolInfo[] pairVolInfoArray = pairInfoMgr.getLocalReplicationPairVolInfoList();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoArray) {
            if (null == pairVolInfo || !SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SI_SIMF_SVOL) || !SJctrReplicationUtility.checkLocalPairResourceEither(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewReplicationBothPairAndFiconVol(pairVolInfo, ldevDetailList, systemParam)) continue;
            retList.add(pairVolInfo);
        }
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getLocalPairVolViewSsPairsList(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfoMgr == null || rsgUty == null || ldevDetailList == null) {
            return retList;
        }
        SJmoLocalReplicationPairVolInfo[] pairVolInfoArray = pairInfoMgr.getLocalReplicationPairVolInfoList();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoArray) {
            if (null == pairVolInfo || !pairVolInfo.isVolPos(0x800000) || !pairVolInfo.isExSnapshotInfo(1) || !SJctrReplicationUtility.checkLocalPairResourceEither(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewLocalPairBoth(pairVolInfo, ldevDetailList)) continue;
            retList.add(pairVolInfo);
        }
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getLocalRsvVolViewList(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfoMgr == null || rsgUty == null || ldevDetailList == null) {
            return retList;
        }
        SJmoLocalReplicationPairVolInfo[] pairVolInfoArray = pairInfoMgr.getLocalReplicationPairVolInfoList();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoArray) {
            if (null == pairVolInfo || !SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_RSV_VOL) || SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SI_SIMF_SVOL) || !SJctrReplicationUtility.checkLocalPairResource(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewPair(pairVolInfo, ldevDetailList)) continue;
            retList.add(pairVolInfo);
        }
        return retList;
    }

    public static boolean checkLocalPairVolPos(SJmoLocalReplicationPairVolInfo pairVolInfo, int[] checkPosArray) {
        boolean ret = false;
        if (pairVolInfo != null) {
            for (int checkPos : checkPosArray) {
                if (!pairVolInfo.isVolPos(checkPos)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean checkLocalPairVolListStatus(List<SJmoLocalReplicationPairVolInfo> pairInfoList, int[] checkStatus) {
        boolean ret = false;
        if (pairInfoList != null) {
            for (SJmoLocalReplicationPairVolInfo pairInfo : pairInfoList) {
                if (!SJctrReplicationUtility.checkLocalPairVolStatus(pairInfo, checkStatus)) {
                    ret = false;
                    break;
                }
                ret = true;
            }
        }
        return ret;
    }

    public static boolean checkLocalPairVolStatus(SJmoLocalReplicationPairVolInfo pairVolInfo, int[] checkStatus) {
        boolean ret = false;
        if (checkStatus != null && 0 < checkStatus.length && pairVolInfo != null) {
            for (int status : checkStatus) {
                if (pairVolInfo.getSPairStatus() != status) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static int checkCopyTypeForLocalPairVolList(List<SJmoLocalReplicationPairVolInfo> pairList) {
        int copyType = -1;
        HashSet<Integer> selCopyType = new HashSet<Integer>();
        if (pairList != null) {
            for (SJmoLocalReplicationPairVolInfo pairInfo : pairList) {
                selCopyType.add(SJctrReplicationUtility.checkCopyTypeForLocalPairVol(pairInfo));
            }
        }
        if (selCopyType.size() == 1) {
            copyType = (Integer)selCopyType.toArray()[0];
        } else {
            if (selCopyType.size() == 0) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVolList", "Pair list data is invalid.");
                SJctrError err = new SJctrError(209, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVolList", "Copy type is mix.size = " + selCopyType.size());
        }
        return copyType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCopyTypeForLocalPairVol(SJmoLocalReplicationPairVolInfo pairInfo) {
        int copyType = -1;
        if (pairInfo != null) {
            if (pairInfo.isVolPos(8)) {
                return 1;
            }
            if (pairInfo.isVolPos(256)) {
                return 0;
            }
            if (pairInfo.isVolPos(0x800000)) {
                if (!pairInfo.isExSnapshotInfo(1)) return 2;
                return 3;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVol", "Copytype is invalid.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrLogUty.error("SJctrReplicationUtility", "checkCopyTypeForLocalPairVol", "Pair infomation is null.");
        SJctrError err = new SJctrError(209, 22, 107001);
        SJcException exp = err.createException();
        throw exp;
    }

    public static boolean checkLocalVolListResource(List<SJmoLocalReplicationPairVolInfo> pairInfoList, SJctrResourceGroupUtility rsgUty) {
        boolean ret = true;
        List<SJmoLdevIndex> enableResourceLdevList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        if (pairInfoList == null || rsgUty == null) {
            ret = false;
        } else {
            for (SJmoLocalReplicationPairVolInfo pairInfo : pairInfoList) {
                if (SJctrReplicationUtility.checkLocalPairResourceBoth(pairInfo, enableResourceLdevList)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean checkLocalVolListResourcePrimaryVol(List<SJmoLocalReplicationPairVolInfo> pairInfoList, SJctrResourceGroupUtility rsgUty) {
        boolean ret = true;
        List<SJmoLdevIndex> enableResourceLdevList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        if (pairInfoList == null || rsgUty == null) {
            ret = false;
        } else {
            for (SJmoLocalReplicationPairVolInfo pairInfo : pairInfoList) {
                if (SJctrReplicationUtility.checkLocalPairResourcePrimaryVol(pairInfo, enableResourceLdevList)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    private static boolean checkLocalPairResourceEither(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevIndex> resourceLdevs) {
        boolean ret = false;
        if (pairVolInfo != null && resourceLdevs != null) {
            if (SJctrReplicationUtility.checkLocalPairResource(pairVolInfo, resourceLdevs)) {
                ret = true;
            } else {
                SJmoLdevIndex pvolInfo = pairVolInfo.getPVolIndex();
                if (pvolInfo != null) {
                    ret = SJctrReplicationUtility.checkLocalPairResource(pvolInfo, resourceLdevs);
                }
            }
        }
        return ret;
    }

    private static boolean checkLocalPairResourceBoth(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevIndex> resourceLdevs) {
        SJmoLdevIndex pvolInfo;
        boolean ret = false;
        if (pairVolInfo != null && resourceLdevs != null && SJctrReplicationUtility.checkLocalPairResource(pairVolInfo, resourceLdevs) && (pvolInfo = pairVolInfo.getPVolIndex()) != null) {
            ret = SJctrReplicationUtility.checkLocalPairResource(pvolInfo, resourceLdevs);
        }
        return ret;
    }

    private static boolean checkLocalPairResourcePrimaryVol(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevIndex> resourceLdevs) {
        SJmoLdevIndex pvolInfo;
        boolean ret = false;
        if (pairVolInfo != null && resourceLdevs != null && (pvolInfo = pairVolInfo.getPVolIndex()) != null) {
            ret = SJctrReplicationUtility.checkLocalPairResource(pvolInfo, resourceLdevs);
        }
        return ret;
    }

    public static boolean checkLocalPairResource(SJmoLdevIndex ldevIndex, List<SJmoLdevIndex> resourceLdevs) {
        boolean ret = false;
        if (ldevIndex != null && resourceLdevs != null && 0 <= Collections.binarySearch(resourceLdevs, ldevIndex)) {
            ret = true;
        }
        return ret;
    }

    public static boolean checkPpLicenseForLocalPairVolList(SJctrUserController uc, int copyType) {
        boolean ret = true;
        SJctrLicenseContainer licenseCnt = uc.getAuthorizeContainer().getLisenceContainer();
        boolean siPPcheckResult = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HOMRCF);
        boolean simfPPcheckResult = licenseCnt.checkPP(SJctrLicenseContainer.PPID_HMRCF);
        boolean qsPPcheckResult = licenseCnt.checkPP(SJctrLicenseContainer.PPID_QS);
        boolean dssPPcheckResult = licenseCnt.checkPP(SJctrLicenseContainer.PPID_DSS);
        boolean hdpPPcheckResult = licenseCnt.checkPP(SJctrLicenseContainer.PPID_DP);
        if (copyType == 1) {
            if (!siPPcheckResult) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkPpLicenseForLocalPairVolList", "ShadowImage license not Install or Disable.");
                SJctrError err = new SJctrError(209, 22, 105442);
                SJcException exp = err.createException();
                throw exp;
            }
        } else if (copyType == 0) {
            if (!simfPPcheckResult) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkPpLicenseForLocalPairVolList", "ShadowImage for Mainframe license not Install or Disable.");
                SJctrError err = new SJctrError(209, 22, 105443);
                SJcException exp = err.createException();
                throw exp;
            }
        } else if (copyType == 2) {
            if (!siPPcheckResult || !qsPPcheckResult) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkPpLicenseForLocalPairVolList", "ShadowImage or COW Snapshot license not Install or Disable.");
                SJctrError err = new SJctrError(209, 22, 105444);
                SJcException exp = err.createException();
                throw exp;
            }
        } else if (!(copyType != 3 || hdpPPcheckResult && dssPPcheckResult)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkPpLicenseForLocalPairVolList", "Dynamic Provisioning or Thin Image license not Install or Disable.");
            SJctrError err = new SJctrError(209, 22, 105474);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private static boolean checkViewLocalPairBoth(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevDetail> ldevDetailList) {
        boolean ret = false;
        if (pairVolInfo != null && ldevDetailList != null && SJctrReplicationUtility.checkViewPair(pairVolInfo, ldevDetailList)) {
            ret = true;
            SJmoLdevIndex pvolInfo = pairVolInfo.getPVolIndex();
            if (pvolInfo != null) {
                ret = SJctrReplicationUtility.checkViewPair(pvolInfo, ldevDetailList);
            }
        }
        return ret;
    }

    public static boolean checkViewReplicationBothPairAndFiconVol(SJmoReplicationPairVolInfo pairVolInfo, List<SJmoLdevDetail> ldevDetailList, SJctrSystemParamContainer systemParam) {
        boolean ret = false;
        if (pairVolInfo != null && ldevDetailList != null && SJctrReplicationUtility.checkViewPair(pairVolInfo, ldevDetailList, systemParam.isLocalHost())) {
            ret = true;
            SJmoLdevIndex pvolInfo = pairVolInfo.getPVolIndex();
            if (pvolInfo != null) {
                ret = SJctrReplicationUtility.checkViewPair(pvolInfo, ldevDetailList, systemParam.isLocalHost());
            }
        }
        return ret;
    }

    private static boolean checkViewPair(SJmoLdevIndex ldevIndex, List<SJmoLdevDetail> ldevDetailList, boolean loginType) {
        boolean ret = true;
        if (ldevIndex == null || ldevDetailList == null) {
            ret = false;
        } else {
            int index = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (0 <= index) {
                SJmoLdevDetail checkVolDetail = ldevDetailList.get(index);
                if (checkVolDetail.getSLUSEEmlCount() == 0) {
                    ret = false;
                } else if (checkVolDetail.getbExternalMfVolume() && !loginType) {
                    ret = false;
                }
            } else {
                ret = false;
            }
        }
        return ret;
    }

    public static boolean checkViewPair(SJmoLdevIndex ldevIndex, List<SJmoLdevDetail> ldevDetailList) {
        return SJctrReplicationUtility.checkViewPair(ldevIndex, ldevDetailList, false);
    }

    private static boolean checkLocalPairVolClprDiff(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevDetail> ldevDetailList) {
        boolean ret = false;
        if (pairVolInfo == null || ldevDetailList == null) {
            return ret;
        }
        int index = Collections.binarySearch(ldevDetailList, pairVolInfo);
        if (0 <= index) {
            SJmoLdevDetail pvolDetail;
            SJmoLdevDetail svolDetail = ldevDetailList.get(index);
            SJmoLdevIndex pvolIndex = pairVolInfo.getPVolIndex();
            if (pvolIndex != null && 0 <= (index = Collections.binarySearch(ldevDetailList, pvolIndex)) && (pvolDetail = ldevDetailList.get(index)).getSCLPR() != svolDetail.getSCLPR()) {
                ret = true;
            }
        }
        return ret;
    }

    private static boolean checkLocalPairDpVolDiff(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoLdevDetail> ldevDetailList) {
        int pindex;
        boolean ret = false;
        if (pairVolInfo == null || ldevDetailList == null) {
            return ret;
        }
        Boolean bSDpvol = false;
        Boolean bPDpvol = false;
        SJmoLdevDetail svolDetail = null;
        int sindex = Collections.binarySearch(ldevDetailList, pairVolInfo);
        if (0 <= sindex) {
            svolDetail = ldevDetailList.get(sindex);
            bSDpvol = SJctrReplicationUtility.isDpVol(svolDetail);
        }
        SJmoLdevDetail pvolDetail = null;
        SJmoLdevIndex pvolIdx = pairVolInfo.getPVolIndex();
        if (pvolIdx != null && 0 <= (pindex = Collections.binarySearch(ldevDetailList, pvolIdx))) {
            pvolDetail = ldevDetailList.get(pindex);
            bPDpvol = SJctrReplicationUtility.isDpVol(pvolDetail);
        }
        if (!bSDpvol.equals(bPDpvol)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isDpVol(SJmoLdevDetail ldev) {
        boolean ret = false;
        if (null != ldev && ldev.getbVvol() && ldev.getbAouVvol()) {
            ret = true;
        }
        return ret;
    }

    public static List<SJmoLdevIndex> getEnableResourceLdevList(SJctrResourceGroupUtility rsgUty) {
        ArrayList<SJmoLdevIndex> enableLdevs = new ArrayList<SJmoLdevIndex>();
        if (rsgUty != null) {
            List<SJmoRSGgetRsg> enableRsgList = rsgUty.extractRsg();
            for (SJmoRSGgetRsg rsgInfo : enableRsgList) {
                enableLdevs.addAll(rsgInfo.getLdevs());
            }
            Collections.sort(enableLdevs);
        }
        return enableLdevs;
    }

    private static boolean isLocalPairVolSsShare(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoLocalReplicationPairVolInfoMgr pairVolInfoMgr) {
        boolean ret = false;
        if (null == pairVolInfo || null == pairVolInfoMgr) {
            return ret;
        }
        if (pairVolInfo.isVolPos(0x400000)) {
            ret = true;
        } else {
            SJmoLocalReplicationPairVolInfo pvolPairInfo;
            SJmoLdevIndex pvolIndex = pairVolInfo.getPVolIndex();
            if (null != pvolIndex && null != (pvolPairInfo = pairVolInfoMgr.getLocalReplicationPairVolInfo(pvolIndex)) && pvolPairInfo.isVolPos(0x400000)) {
                ret = true;
            }
        }
        return ret;
    }

    private static boolean isFcv2FcseSharePvol(SJmoLocalReplicationPairVolInfo pvolpair) {
        boolean ret = false;
        if (null != pvolpair && pvolpair.isVolPos(0x1000000)) {
            ret = true;
        }
        return ret;
    }

    public static void makeLocalPairCapacityUnit(SJctrTableDataModel table, List<? extends SJmoLocalReplicationPairVolInfo> basicDataList) {
        boolean isPvolCheck = false;
        boolean isSvolCheck = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String key : keySet) {
            SJctrColumn sJctrColumn = table.getColumnInfo(key);
            if (sJctrColumn instanceof SJctrPVolCapacityColumnFromPairVolInfo) {
                isPvolCheck = true;
            } else if (sJctrColumn instanceof SJctrSVolCapacityColumnFromPairVolInfo) {
                isSvolCheck = true;
            }
            if (!isPvolCheck || !isSvolCheck) continue;
            break;
        }
        if (isSvolCheck || isPvolCheck) {
            List<SJmoLdevDetail> ldevDetails = table.getBasicDataMap().get(SJmoGetLdevDetail.class);
            if (ldevDetails == null) {
                SJctrLogUty.info("SJctrReplicationUtility", "makeLocalPairCapacityUnit", "SJmoLdevDetail is null.");
                return;
            }
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoLocalReplicationPairVolInfo sJmoLocalReplicationPairVolInfo : basicDataList) {
                SJmoLdevIndex pvolIndex;
                if (isSvolCheck) {
                    SJctrReplicationUtility.checkLdevEmuType(table, sJmoLocalReplicationPairVolInfo, ldevDetails);
                }
                if (isPvolCheck && (pvolIndex = sJmoLocalReplicationPairVolInfo.getPVolIndex()) != null) {
                    SJctrReplicationUtility.checkLdevEmuType(table, pvolIndex, ldevDetails);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static void makeTiPairCapacityUnit(SJctrLocalReplicationTiPvolTopTableModel table, List<? extends SJmoTiPvolInfo> basicDataList) {
        boolean isPvolCheck = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String key : keySet) {
            SJctrColumn sJctrColumn = table.getColumnInfo(key);
            if (sJctrColumn instanceof SJctrPVolCapacityColumnFromTiPvolInfo) {
                isPvolCheck = true;
            }
            if (!isPvolCheck) continue;
            break;
        }
        if (isPvolCheck) {
            List<SJmoLdevDetail> ldevDetails = table.getBasicDataMap().get(SJmoGetLdevDetail.class);
            if (ldevDetails == null) {
                SJctrLogUty.info("SJctrReplicationUtility", "makeTiPairCapacityUnit", "SJmoLdevDetail is null.");
                return;
            }
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoTiPvolInfo sJmoTiPvolInfo : basicDataList) {
                SJctrReplicationUtility.checkLdevEmuType(table, sJmoTiPvolInfo, ldevDetails);
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static void checkLdevEmuType(SJctrTableDataModel table, SJmoLdevIndex targetVol, List<SJmoLdevDetail> ldevDetails) {
        int index = Collections.binarySearch(ldevDetails, targetVol);
        if (index >= 0) {
            SJmoLdevDetail ldevInfo = ldevDetails.get(index);
            if (SJctrLdevUtility.isOpenVolume(ldevInfo)) {
                table.setOpenVolumeFlg(true);
            } else if (SJctrLdevUtility.isMFVolume(ldevInfo)) {
                table.setMainframeVolumeFlg(true);
            }
        }
    }

    public static void makeLdevCapacityUnit(SJctrTableDataModel table, List<? extends SJmoLdevDetail> basicDataList) {
        boolean isOpenMfCheck = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String string : keySet) {
            SJctrColumn column = table.getColumnInfo(string);
            if (!(column instanceof SJctrCapacityColumnFromLdevDetail)) continue;
            isOpenMfCheck = true;
            break;
        }
        if (isOpenMfCheck) {
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoLdevDetail sJmoLdevDetail : basicDataList) {
                if (SJctrLdevUtility.isOpenVolume(sJmoLdevDetail)) {
                    table.setOpenVolumeFlg(true);
                } else if (SJctrLdevUtility.isMFVolume(sJmoLdevDetail)) {
                    table.setMainframeVolumeFlg(true);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static void checkLocalPairVolStatus(List<SJmoLocalReplicationPairVolInfo> pairlist, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus, int copytype) {
        if (null == pairlist || null == allpair) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatus", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJmoLocalReplicationPairVolInfo svolpair : pairlist) {
            SJmoLdevIndex pvolindex = svolpair.getPVolIndex();
            SJmoLocalReplicationPairVolInfo pvolinfo = allpair.getLocalReplicationPairVolInfo(pvolindex);
            if (null == pvolinfo) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatus", "Check list data is different from local pair.");
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrReplicationUtility.checkLocalPairVolStatusAll(svolpair, pvolinfo, allpair, checkStatus, copytype);
        }
    }

    public static int checkLocalPairVolStatusResync(List<SJmoLocalReplicationPairVolInfo> pairlist, SJmoLocalReplicationPairVolInfoMgr allpair, List<SJmoLdevDetail> ldevlist, int copytype) {
        return SJctrReplicationUtility.checkLocalPairVolStatusResync(pairlist, allpair, ldevlist, copytype, null);
    }

    public static int checkLocalPairVolStatusResync(List<SJmoLocalReplicationPairVolInfo> pairlist, SJmoLocalReplicationPairVolInfoMgr allpair, List<SJmoLdevDetail> ldevlist, int copytype, List<SJmoLocalReplicationPairVolInfo> tiPairVolInfoList) {
        int retComboResult = 0;
        boolean reverseflg = true;
        boolean quickResult = true;
        boolean clprResult = false;
        if (null == pairlist || null == allpair || null == ldevlist) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusResync", "Parameter info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap<Integer, ArrayList<Integer>> pvolIndexMap = null;
        SJmoLocalReplicationPairVolInfo[] allPairs = allpair.getLocalReplicationPairVolInfoList();
        for (SJmoLocalReplicationPairVolInfo svolpair : pairlist) {
            boolean pvolshareresult;
            boolean dpresult;
            boolean fcresult;
            SJmoLdevIndex pvolindex = svolpair.getPVolIndex();
            SJmoLocalReplicationPairVolInfo pvolinfo = allpair.getLocalReplicationPairVolInfo(pvolindex);
            if (tiPairVolInfoList != null && tiPairVolInfoList.size() != 0) {
                for (SJmoLocalReplicationPairVolInfo pvol : tiPairVolInfoList) {
                    if (pvol.getPVolIndex().getIndex() != svolpair.getPVolIndex().getIndex()) continue;
                    if (pvolinfo != null) {
                        short status = pvolinfo.getSPairStatus();
                        try {
                            pvol = (SJmoLocalReplicationPairVolInfo)pvol.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new SJctrError(209, 22, 107001).createException();
                        }
                        pvol.setSPairStatus(status);
                    }
                    pvolinfo = pvol;
                    break;
                }
            }
            if (null == pvolinfo) {
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusResync", "Check list data is different from local pair.");
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            if (svolpair.isVolPos(0x800000)) {
                SJmoLocalReplicationPairVolInfo svols;
                if (pvolIndexMap == null) {
                    pvolIndexMap = new HashMap<Integer, ArrayList<Integer>>();
                    for (int i = 0; i < allPairs.length; ++i) {
                        SJmoLdevIndex index;
                        SJmoLocalReplicationPairVolInfo info = allPairs[i];
                        if (info == null || (index = info.getPVolIndex()) == null) continue;
                        ArrayList<Integer> pvolList = (ArrayList<Integer>)pvolIndexMap.get(index.getIndex());
                        if (pvolList == null) {
                            pvolList = new ArrayList<Integer>();
                        }
                        pvolList.add(i);
                        pvolIndexMap.put(index.getIndex(), pvolList);
                    }
                }
                ArrayList<SJmoLocalReplicationPairVolInfo> targetTiPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                List tiPairIndexList = (List)pvolIndexMap.get(pvolinfo.getPVolIndex().getIndex());
                if (tiPairIndexList != null && !tiPairIndexList.isEmpty()) {
                    for (Integer integer : tiPairIndexList) {
                        targetTiPairList.add(allPairs[integer]);
                    }
                    ArrayList<SJmoLocalReplicationPairVolInfo> targetTiSvolList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                    targetTiSvolList.addAll(targetTiPairList);
                    pvolinfo.setAlSVolIndex(targetTiSvolList);
                }
                if ((svols = allpair.getLocalReplicationPairVolInfo(pvolinfo.getPVolIndex())) != null) {
                    targetTiPairList.add(svols);
                }
                for (SJmoLocalReplicationPairVolInfo checkPair : targetTiPairList) {
                    int pvolPairIndex = pvolinfo.getPVolIndex().getIndex();
                    SJmoLdevIndex checkPairPvolIndex = checkPair.getPVolIndex();
                    boolean isSiPvol = false;
                    if (checkPairPvolIndex != null) {
                        boolean bl = isSiPvol = pvolPairIndex == checkPairPvolIndex.getIndex();
                    }
                    if (!isSiPvol && pvolPairIndex != checkPair.getIndex()) continue;
                    int volPosFlag = 0x800000;
                    if (checkPair.isVolPos(4)) {
                        volPosFlag |= 4;
                    }
                    if (checkPair.isVolPos(8)) {
                        volPosFlag |= 8;
                    }
                    pvolinfo.setIPairVolPos(volPosFlag);
                }
            }
            boolean ficonPairFlag = SJctrReplicationUtility.isFiocnVolFromLdevIndex(pvolindex, ldevlist);
            if (ficonPairFlag |= SJctrReplicationUtility.isFiocnVolFromLdevIndex(svolpair, ldevlist)) {
                SJctrReplicationUtility.checkUnusualSuspendStatusOfFiconDm(svolpair);
                SJctrReplicationUtility.checkLocalPairVolStatusFiconDm(svolpair, pvolinfo, allpair, SJctrReplicationDataMacro.RESYNC_FICON_PAIR_STATUS_PASS, copytype);
            } else {
                SJctrReplicationUtility.checkLocalPairVolStatusAll(svolpair, pvolinfo, allpair, SJctrReplicationDataMacro.RESYNC_PAIR_STATUS_PASS, copytype);
            }
            if (reverseflg) {
                try {
                    SJctrReplicationUtility.checkLocalPairVolStatusAll(svolpair, pvolinfo, allpair, SJctrReplicationDataMacro.RESYNC_R_PAIR_STATUS_PASS, copytype);
                }
                catch (SJcException e) {
                    SJcMessage msgObj = e.getMsg();
                    if (msgObj.getModuleID().equals(Integer.toString(22)) && msgObj.getFunctionID().equals(Integer.toString(209)) && msgObj.getMsgID().equals(Integer.toString(107001))) {
                        throw e;
                    }
                    reverseflg = false;
                }
            }
            if (reverseflg && 0 == copytype && (fcresult = SJctrReplicationUtility.isFcv2FcseSharePvol(pvolinfo))) {
                reverseflg = false;
            }
            if (!reverseflg || !quickResult) continue;
            if ((0 == copytype || 1 == copytype) && (dpresult = SJctrReplicationUtility.checkLocalPairDpVolDiff(svolpair, ldevlist))) {
                quickResult = false;
            }
            if (quickResult && 1 == copytype && (pvolshareresult = SJctrReplicationUtility.isLocalPairVolSsShare(svolpair, allpair))) {
                quickResult = false;
            }
            if (!quickResult || clprResult || 0 != copytype && 1 != copytype) continue;
            clprResult = SJctrReplicationUtility.checkLocalPairVolClprDiff(svolpair, ldevlist);
        }
        if (!reverseflg) {
            retComboResult = 1;
        }
        if (!quickResult) {
            retComboResult |= 2;
        }
        if (clprResult) {
            retComboResult |= 4;
        }
        return retComboResult;
    }

    public static void checkLocalPairVolStatusAll(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus, int copytype) {
        if (null == svolpair || null == pvolpair || null == allpair) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusAll", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrReplicationUtility.checkLocalPairVolStatusFor1x1(svolpair, checkStatus, copytype);
        if (1 == copytype) {
            SJctrReplicationUtility.checkLocalPairVolStatusForCascadeL1Ss(svolpair, allpair, checkStatus);
            SJctrReplicationUtility.checkLocalPairVolStatusForCascadeL2(svolpair, pvolpair, checkStatus);
            SJctrReplicationUtility.checkLocalPairVolStatusForShareSvolsSiSs(svolpair, pvolpair, allpair, checkStatus);
        }
        if (0 == copytype) {
            SJctrReplicationUtility.checkLocalPairVolStatusForShareSvolsSimf(svolpair, pvolpair, allpair, checkStatus);
        }
        if (2 == copytype || 3 == copytype) {
            SJctrReplicationUtility.checkLocalPairVolStatusForSsCascadeSi(svolpair, pvolpair, checkStatus);
            SJctrReplicationUtility.checkLocalPairVolStatusForSsSharePvolSi(svolpair, pvolpair, allpair, checkStatus);
        }
    }

    protected static void checkLocalPairVolStatusFor1x1(SJmoLocalReplicationPairVolInfo svolpair, int[][] checkStatus, int copytype) {
        int[] chkPairStatus = null;
        if (0 == copytype || 1 == copytype) {
            chkPairStatus = checkStatus[0];
        } else if (2 == copytype || 3 == copytype) {
            chkPairStatus = checkStatus[1];
        } else {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusFor1x1", "Copy Type is invalid.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(svolpair, chkPairStatus);
        if (!bstatus) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusFor1x1", "Selected pair is invalid status. -svol:" + svolpair + " -status:" + svolpair.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106141);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static void checkLocalPairVolStatusForCascadeL1Ss(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus) {
        ArrayList<? extends SJmoLdevIndex> sVolList = svolpair.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
            boolean bstatus;
            SJmoLocalReplicationPairVolInfo existPairInfo = allpair.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (null == existPairInfo) continue;
            if (existPairInfo.isVolPos(8)) {
                bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[2]);
                if (bstatus) continue;
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForCascadeL1Ss", "Selected L2 pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
                SJctrError err = new SJctrError(209, 22, 106155);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!existPairInfo.isVolPos(0x800000) || (bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[6]))) continue;
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForCascadeL1Ss", "Selected ss pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106158);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static void checkLocalPairVolStatusForCascadeL2(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, int[][] checkStatus) {
        boolean bstatus;
        if (svolpair.isVolPos(8) && pvolpair.isVolPos(12) && !(bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(pvolpair, checkStatus[3]))) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForCascadeL2", "Selected pair is invalid status. -pvol:" + pvolpair + " -status:" + pvolpair.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106156);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static void checkLocalPairVolStatusForShareSvolsSiSs(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus) {
        ArrayList<? extends SJmoLdevIndex> sVolList = pvolpair.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
            boolean bstatus;
            SJmoLocalReplicationPairVolInfo existPairInfo = allpair.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (null == existPairInfo || 0 == existPairInfo.compareTo(svolpair)) continue;
            if (existPairInfo.isVolPos(8)) {
                bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[4]);
                if (bstatus) continue;
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForShareSvolsSiSs", "Selected si pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
                SJctrError err = new SJctrError(209, 22, 106157);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!existPairInfo.isVolPos(0x800000) || (bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[8]))) continue;
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForShareSvolsSiSs", "Selected ss pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106157);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static void checkLocalPairVolStatusForShareSvolsSimf(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus) {
        ArrayList<? extends SJmoLdevIndex> sVolList = pvolpair.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
            boolean bstatus;
            SJmoLocalReplicationPairVolInfo existPairInfo = allpair.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (null == existPairInfo || 0 == existPairInfo.compareTo(svolpair) || !existPairInfo.isVolPos(256) || (bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[5]))) continue;
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForShareSvolsSimf", "Selected pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106157);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    protected static void checkLocalPairVolStatusForSsCascadeSi(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, int[][] checkStatus) {
        boolean bstatus;
        if (svolpair.isVolPos(0x800000) && pvolpair.isVolPos(8) && !(bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(pvolpair, checkStatus[7]))) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForSsCascadeSi", "Selected pair is invalid status. -pvol:" + pvolpair + " -status:" + pvolpair.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 106158);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static void checkLocalPairVolStatusForSsSharePvolSi(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus) {
        if ((pvolpair.isVolPos(4) || pvolpair.isVolPos(8)) && svolpair.isVolPos(0x800000)) {
            ArrayList<? extends SJmoLdevIndex> sVolList = pvolpair.getAlSVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
                boolean bstatus;
                SJmoLocalReplicationPairVolInfo existPairInfo = allpair.getLocalReplicationPairVolInfo(sJmoLdevIndex);
                if (null == existPairInfo || 0 == existPairInfo.compareTo(svolpair) || !existPairInfo.isVolPos(8) || (bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[9]))) continue;
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForSsSharePvolSi", "Selected pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
                SJctrError err = new SJctrError(209, 22, 106157);
                SJcException exp = err.createException();
                throw exp;
            }
        }
    }

    private static void checkUnusualSuspendStatusOfFiconDm(SJmoLocalReplicationPairVolInfo svolpair) {
        if (null == svolpair) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkUnusualSuspendStatusOfFiconDm", "svolpair is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean suspendStatus = SJctrReplicationUtility.isUnusualSuspendStatusOfFiconPair(svolpair);
        if (suspendStatus) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkUnusualSuspendStatusOfFiconDm", "svolpair status is Suspend/SUSPER");
            SJctrError err = new SJctrError(209, 22, 106141);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static int checkConfigurationFiconVolFromLocalPairList(List<SJmoLocalReplicationPairVolInfo> pairVolInfoList, List<SJmoLdevDetail> ldevDetailList) {
        int ret = -1;
        int numOfFiconFromPairVol = 0;
        if (pairVolInfoList == null || ldevDetailList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkConfigurationFiconVolFromLocalPairList", "Parameter info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoList) {
            if (pairVolInfo.getPVolIndex() == null) continue;
            if (SJctrReplicationUtility.isFiocnVolFromLdevIndex(pairVolInfo.getPVolIndex(), ldevDetailList) || SJctrReplicationUtility.isFiocnVolFromLdevIndex(pairVolInfo, ldevDetailList)) {
                ++numOfFiconFromPairVol;
                continue;
            }
            if (numOfFiconFromPairVol <= 0) continue;
            break;
        }
        if (numOfFiconFromPairVol == pairVolInfoList.size()) {
            ret = 4;
        } else if (numOfFiconFromPairVol == 0) {
            ret = 0;
        }
        return ret;
    }

    public static boolean isFiocnVolFromLdevIndex(SJmoLdevIndex ldevIndex, List<SJmoLdevDetail> ldevDetailList) {
        SJmoLdevDetail checkVolDetail;
        boolean checkFiconVol = false;
        if (ldevIndex == null || ldevDetailList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "isFiocnVolFromLdevIndex", "Parameter info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int index = Collections.binarySearch(ldevDetailList, ldevIndex);
        if (0 <= index && (checkVolDetail = ldevDetailList.get(index)).getbExternalMfVolume()) {
            checkFiconVol = true;
        }
        return checkFiconVol;
    }

    public static int checkSimfPairMixFiconAndNormal(List<SJmoLocalReplicationPairVolInfo> simfPairList, List<SJmoLdevDetail> ldevDetailList) {
        if (simfPairList == null || ldevDetailList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSimfPairMixFiconAndNormal", "Parameter info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int checkSimfPairType = SJctrReplicationUtility.checkConfigurationFiconVolFromLocalPairList(simfPairList, ldevDetailList);
        if (checkSimfPairType == -1) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSimfPairMixFiconAndNormal", "Selected pairs include FICON DMVOL and NormalVOL.");
            SJctrError err = new SJctrError(209, 22, 205021);
            SJcException exp = err.createException();
            throw exp;
        }
        return checkSimfPairType;
    }

    public static int getErrFuncCode(int errorpart) {
        int funccode = errorpart / 100;
        return funccode;
    }

    public static int getErrModulePart(int errorpart) {
        int part = errorpart % 100;
        return part;
    }

    private String getDescriptionGuidKey(int maskCode, Object[][] codeDef) {
        String guidanceKey = "";
        for (Object[] obj : codeDef) {
            if (maskCode != (Integer)obj[0]) continue;
            guidanceKey = (String)obj[1];
            break;
        }
        return guidanceKey;
    }

    public String getDescriptionStringSi(int taskCode) {
        String ret = "?";
        int mask = taskCode & 0xFFF0;
        String guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_SI);
        if (guidanceKey.length() == 0) {
            mask = taskCode & 0xFFFF;
            guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_SI_SIMF_INIT);
        } else if ((guidanceKey.equals("COPY_START_RS") || guidanceKey.equals("COPY_END_RS")) && (taskCode & 0xFF0000) > 0) {
            guidanceKey = guidanceKey + "-R";
        }
        if (guidanceKey.length() != 0) {
            ret = this.guidanceHandle.getGuidance("REPLICATION", guidanceKey);
        }
        return ret;
    }

    public String getDescriptionStringSimf(int taskCode) {
        String ret = "?";
        int mask = taskCode & 0xFFF0;
        String guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_SIMF);
        if (guidanceKey.length() == 0) {
            mask = taskCode & 0xFFFF;
            guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_SI_SIMF_INIT);
        } else if ((guidanceKey.equals("RESYNC_START") || guidanceKey.equals("RESYNC_END")) && (taskCode & 0xFF0000) > 0) {
            guidanceKey = guidanceKey + "-R";
        }
        if (guidanceKey.length() != 0) {
            ret = this.guidanceHandle.getGuidance("REPLICATION", guidanceKey);
        }
        return ret;
    }

    public String getDescriptionStringSs(int taskCode) {
        String ret = "?";
        int mask = taskCode & 0xFFFF;
        String guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_SS);
        if (guidanceKey.length() != 0) {
            ret = this.guidanceHandle.getGuidance("REPLICATION", guidanceKey);
        }
        return ret;
    }

    public String getDescriptionNumberString(int taskCode) {
        int mask = taskCode & 0xFFFF;
        String taskNumber = SJctrComUtility.toHexString(mask, 4, true);
        return taskNumber;
    }

    public String getDescriptionStringFc(int taskCode) {
        String ret = "?";
        int mask = taskCode & 0xFFFF;
        String guidanceKey = this.getDescriptionGuidKey(mask, SJctrReplicationDataMacro.DESCRIPTION_DEF_FC);
        if (guidanceKey.length() != 0) {
            ret = this.guidanceHandle.getGuidance("REPLICATION", guidanceKey);
        }
        return ret;
    }

    public String getNumOfReplicaLdevsCountString(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJmoTrueCopyPairVolInfoMgr tcPairInfoMgr, SJmoUniversalReplicatorPairVolInfoMgr urPairInfoMgr, SJmoHAPairVolInfoMgr haPairInfoMgr, SJmoTiPvolInfo[] tiPvolInfos, SJmoTiSnapshotPairList ssPairList, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList, SJctrUserController uc) {
        String ret = "?";
        if (pairInfoMgr == null || tcPairInfoMgr == null || urPairInfoMgr == null || haPairInfoMgr == null || rsgUty == null || ldevDetailList == null || uc == null) {
            return ret;
        }
        int replicaLdevCount = 0;
        SJctrAuthorizeContainer Authorize = uc.getAuthorizeContainer();
        SJctrSystemParamContainer systemParam = Authorize.getSystemParamContainer();
        List<Object> tableDataList = new ArrayList();
        tableDataList = SJctrReplicationUtility.getReplicaLdevViewList(pairInfoMgr, tcPairInfoMgr, urPairInfoMgr, haPairInfoMgr, tiPvolInfos, ssPairList, rsgUty, ldevDetailList, systemParam);
        if (tableDataList != null) {
            replicaLdevCount = tableDataList.size();
            ret = Integer.toString(replicaLdevCount);
        }
        return ret;
    }

    public Map<String, String> getNumOfPairsCountString(SJmoLocalReplicationPairVolInfoMgr pairInfoMgr, SJctrResourceGroupUtility rsgUty, SJctrUserController uc, List<SJmoLdevDetail> ldevDetailList, SJmoTiSnapshotPairList tiPairs, SJmoTiPvolStatus tiPvolStatus) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (pairInfoMgr == null || rsgUty == null || uc == null || ldevDetailList == null) {
            retMap.put("COM_SI_PAIR_NUM", "?");
            retMap.put("COM_DSS_PAIR_NUM", "?");
            retMap.put("COM_COW_SNAP_PAIR_NUM", "?");
            retMap.put("COM_SI_MF_PAIR_NUM", "?");
            retMap.put("COM_TOTAL_PAIR_NUM", "?");
            retMap.put("COM_OPEN_RESERVE_VOL_NUM", "?");
            retMap.put("COM_MF_RESERVE_VOL_NUM", "?");
            retMap.put("COM_TOTAL_RESERVE_VOL_NUM", "?");
            retMap.put("COM_TOTAL_RESERVE_SVOL_NUM", "?");
            return retMap;
        }
        int siPrCount = 0;
        int dssPrCount = 0;
        int ssPrCount = 0;
        int simfPrCount = 0;
        int opRsvCount = 0;
        int mfRsvCount = 0;
        SJmoLocalReplicationPairVolInfo[] pairVolInfoArray = pairInfoMgr.getLocalReplicationPairVolInfoList();
        SJctrAuthorizeContainer Authorize = uc.getAuthorizeContainer();
        SJctrSystemParamContainer systemParam = Authorize.getSystemParamContainer();
        HashMap tiPvolMap = new HashMap();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairVolInfoArray) {
            if (null == pairVolInfo || !SJctrReplicationUtility.checkLocalPairResourceEither(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewReplicationBothPairAndFiconVol(pairVolInfo, ldevDetailList, systemParam)) continue;
            if (pairVolInfo.isVolPos(8)) {
                ++siPrCount;
                continue;
            }
            if (pairVolInfo.isVolPos(0x800000)) {
                if (pairVolInfo.isExSnapshotInfo(1)) continue;
                ++ssPrCount;
                continue;
            }
            if (pairVolInfo.isVolPos(256)) {
                ++simfPrCount;
                continue;
            }
            if (pairVolInfo.isVolPos(16)) {
                ++opRsvCount;
                continue;
            }
            if (!pairVolInfo.isVolPos(512)) continue;
            ++mfRsvCount;
        }
        SJmoTiPvolInfo[] tiRootVolInfos = tiPvolStatus.getTiPvolInfo();
        Map<Integer, List<SJmoLocalReplicationPairVolInfo>> rootPairMap = SJctrTiReplicationUtility.getMapRootVol_TiPairList(pairInfoMgr, tiRootVolInfos);
        for (SJmoTiPvolInfo rootVolInfo : tiRootVolInfos) {
            if (null == rootVolInfo) continue;
            boolean isRsgFlg = false;
            long snapshotDataCount = 0L;
            isRsgFlg = SJctrTiReplicationUtility.checkTiPairInfoTreePairsResource(rootVolInfo, rootPairMap, resourceLdevs);
            if (!isRsgFlg) continue;
            snapshotDataCount = rootVolInfo.getPairnum();
            dssPrCount = (int)((long)dssPrCount + snapshotDataCount);
        }
        retMap.put("COM_SI_PAIR_NUM", Integer.toString(siPrCount));
        retMap.put("COM_OPEN_RESERVE_VOL_NUM", Integer.toString(opRsvCount));
        retMap.put("COM_DSS_PAIR_NUM", Integer.toString(dssPrCount));
        retMap.put("COM_COW_SNAP_PAIR_NUM", Integer.toString(ssPrCount));
        retMap.put("COM_SI_MF_PAIR_NUM", Integer.toString(simfPrCount));
        retMap.put("COM_MF_RESERVE_VOL_NUM", Integer.toString(mfRsvCount));
        retMap.put("COM_TOTAL_PAIR_NUM", Integer.toString(siPrCount + dssPrCount + ssPrCount + simfPrCount));
        retMap.put("COM_TOTAL_RESERVE_VOL_NUM", Integer.toString(opRsvCount + mfRsvCount));
        retMap.put("COM_TOTAL_RESERVE_SVOL_NUM", Integer.toString(siPrCount + dssPrCount + ssPrCount + simfPrCount + opRsvCount + mfRsvCount));
        return retMap;
    }

    public static int[] getNumOfLocalPairsIntoCtgCount(int ctgLength, SJmoLocalReplicationPairVolInfo[] pairInfoList, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetailList) {
        int[] numOfPairs = new int[ctgLength];
        if (pairInfoList == null || rsgUty == null || ldevDetailList == null) {
            return numOfPairs;
        }
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairInfoList) {
            short ctgId;
            if (null == pairVolInfo || 0 > (ctgId = pairVolInfo.getSCtgId()) || ctgId >= ctgLength || !SJctrReplicationUtility.checkLocalPairResourceEither(pairVolInfo, resourceLdevs) || !SJctrReplicationUtility.checkViewLocalPairBoth(pairVolInfo, ldevDetailList)) continue;
            short s = ctgId;
            numOfPairs[s] = numOfPairs[s] + 1;
        }
        return numOfPairs;
    }

    public String getLicensedCapacityString(SJctrComUtility util, List<SJmoLicenseDetail> ppList, String ppKey) {
        SJctrCapacityUtility capaUty;
        String limitCapaStr;
        long usedCapa;
        String ret;
        block14: {
            block12: {
                block13: {
                    ret = "? / ?";
                    if (util == null || ppList == null || ppKey == null) {
                        return ret;
                    }
                    usedCapa = 0L;
                    limitCapaStr = "?";
                    capaUty = util.getCapacityUtility();
                    if (ppList.size() == 0) {
                        return ret;
                    }
                    SJmoLicenseDetail license = ppList.get(0);
                    ArrayList ppInfoList = license.getPpl1ppinfo();
                    SJmoPPKget1PPInfo ppInfo = new SJmoPPKget1PPInfo();
                    ppInfo.setStrPPID(ppKey);
                    int index = Collections.binarySearch(ppInfoList, ppInfo);
                    if (0 > index) break block12;
                    ppInfo = (SJmoPPKget1PPInfo)ppInfoList.get(index);
                    usedCapa = capaUty.valueOf(ppInfo.getIUsedCapa(), SJctrCapacityUtility.UNIT.GB);
                    int ppStatus = ppInfo.getIStatus();
                    if (ppStatus != 1 && ppStatus != 3) break block13;
                    int keyKind = ppInfo.getIKeyKind();
                    int limitCapa = ppInfo.getIPermitVol();
                    switch (keyKind) {
                        case 2: 
                        case 7: 
                        case 8: {
                            if (limitCapa == -1) {
                                limitCapaStr = this.guidanceHandle.getGuidance("UNLIMITED");
                                break;
                            }
                            if (limitCapa <= 0) break;
                            long licenseBlock = capaUty.valueOf((long)limitCapa, SJctrCapacityUtility.UNIT.TB);
                            limitCapaStr = capaUty.toUnitString(licenseBlock);
                            if (keyKind == 8) {
                                long lDiffCapa = ppInfo.getLPermDiffCapa();
                                if (lDiffCapa >= 0L) {
                                    limitCapaStr = limitCapaStr + " + ";
                                } else {
                                    lDiffCapa = Math.abs(lDiffCapa);
                                    limitCapaStr = limitCapaStr + " - ";
                                }
                                long lDiffCapaBlock = capaUty.valueOf(lDiffCapa, SJctrCapacityUtility.UNIT.GB);
                                limitCapaStr = limitCapaStr + capaUty.toUnitString(lDiffCapaBlock) + this.guidanceHandle.getGuidance("METER_UNIT");
                                break;
                            }
                            break block14;
                        }
                        case 1: 
                        case 3: {
                            if (limitCapa != -1 && limitCapa != 0 && limitCapa <= 0) break;
                            limitCapaStr = this.guidanceHandle.getGuidance("UNLIMITED");
                            break;
                        }
                        case 4: {
                            if (limitCapa != -1) break;
                            limitCapaStr = this.guidanceHandle.getGuidance("UNLIMITED");
                            break;
                        }
                    }
                    break block14;
                }
                limitCapaStr = "-";
                break block14;
            }
            limitCapaStr = "-";
        }
        if (usedCapa >= 0L && !limitCapaStr.equals("?")) {
            ret = capaUty.toUnitString(usedCapa) + " / " + limitCapaStr;
        }
        return ret;
    }

    public String getCopyPaceString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            short copyPace = pairVolInfo.getSCopyPace();
            if (pairVolInfo.isVolPos(8) || pairVolInfo.isVolPos(256)) {
                switch (copyPace) {
                    case 0: {
                        ret = this.guidanceHandle.getGuidance("MEDIUM_CP");
                        break;
                    }
                    case 1: {
                        ret = this.guidanceHandle.getGuidance("LOWER_CP");
                        break;
                    }
                    case 2: {
                        ret = this.guidanceHandle.getGuidance("FASTER_CP");
                        break;
                    }
                }
            } else if (pairVolInfo.isVolPos(0x800000)) {
                switch (copyPace) {
                    case 1: {
                        ret = this.guidanceHandle.getGuidance("LOWER_CP");
                        break;
                    }
                    case 2: {
                        ret = this.guidanceHandle.getGuidance("MEDIUM_CP");
                        break;
                    }
                    case 3: {
                        ret = this.guidanceHandle.getGuidance("FASTER_CP");
                        break;
                    }
                    case 0: {
                        ret = "-";
                        break;
                    }
                    case -1: {
                        ret = "-";
                        break;
                    }
                    default: {
                        SJctrLogUty.warn("SJctrReplicationUtility", "getCopyPaceString", "TI pair CopyPace is" + copyPace);
                        break;
                    }
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getCopyPaceStringByPairStatus(SJmoLocalReplicationPairVolInfo pairVolInfo, short status) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(8) || pairVolInfo.isVolPos(256)) {
                switch (status) {
                    case 16: 
                    case 64: 
                    case 72: 
                    case 96: 
                    case 104: {
                        ret = this.getCopyPaceString(pairVolInfo);
                        break;
                    }
                    default: {
                        ret = "-";
                        break;
                    }
                }
            } else {
                ret = pairVolInfo.isVolPos(0x800000) ? this.getCopyPaceString(pairVolInfo) : "-";
            }
        }
        return ret;
    }

    public String getCopyPaceStringByPairStatus(SJmoLocalReplicationPairVolInfo pairInfo, SJctrViewPairSyncRateInfo syncInfo) {
        String ret = "?";
        if (pairInfo != null && syncInfo != null) {
            if (pairInfo.isVolPos(8) || pairInfo.isVolPos(256)) {
                block0 : switch (syncInfo.getPairstatus()) {
                    case 16: 
                    case 64: 
                    case 72: 
                    case 96: 
                    case 104: {
                        short copyPace = syncInfo.getPairCopyPace();
                        switch (copyPace) {
                            case 0: {
                                ret = this.guidanceHandle.getGuidance("MEDIUM_CP");
                                break block0;
                            }
                            case 1: {
                                ret = this.guidanceHandle.getGuidance("LOWER_CP");
                                break block0;
                            }
                            case 2: {
                                ret = this.guidanceHandle.getGuidance("FASTER_CP");
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        ret = "-";
                        break;
                    }
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getCopyPaceStringByPairStatus(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = this.getCopyPaceStringByPairStatus(pairVolInfo, pairVolInfo.getSPairStatus());
        }
        return ret;
    }

    public String getCopyTypeString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoLocalReplicationPairVolInfo pvolInfo) {
        String ret = "?";
        if (pairVolInfo == null || pvolInfo == null) {
            return ret;
        }
        if (pairVolInfo.isVolPos(8)) {
            ret = !pvolInfo.isVolPos(12) ? this.guidanceHandle.getGuidance("SI_L1_COPY") : this.guidanceHandle.getGuidance("SI_L2_COPY");
        } else if (pairVolInfo.isVolPos(0x800000)) {
            ret = pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("DSS_COPY") : this.guidanceHandle.getGuidance("SS_COPY");
        } else if (pairVolInfo.isVolPos(256)) {
            ret = this.guidanceHandle.getGuidance("SI_MF_COPY");
        }
        return ret;
    }

    public String getCopyTypeSiL1String(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoLocalReplicationPairVolInfo pvolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(8) ? (pvolInfo != null && !pvolInfo.isVolPos(12) ? this.guidanceHandle.getGuidance("SECONDARY") : "-") : (pairVolInfo.isVolPos(4) ? this.guidanceHandle.getGuidance("PRIMARY") : "-");
        }
        return ret;
    }

    public String getCopyTypeSiL2String(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoLocalReplicationPairVolInfo pvolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(12) ? this.guidanceHandle.getGuidance("PRIMARY") : (pairVolInfo.isVolPos(8) ? (pvolInfo != null && pvolInfo.isVolPos(12) ? this.guidanceHandle.getGuidance("SECONDARY") : "-") : "-");
        }
        return ret;
    }

    public String getCopyTypeDssString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(0x400000) && pairVolInfo.isVolPos(0x800000) ? (pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("PRIMARY") + " / " + this.guidanceHandle.getGuidance("SECONDARY") : "-") : (pairVolInfo.isVolPos(0x800000) ? (pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("SECONDARY") : "-") : (pairVolInfo.isVolPos(0x400000) ? (pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("PRIMARY") : "-") : "-"));
        }
        return ret;
    }

    public String getCopyTypeSsString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(0x800000) ? (!pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("SECONDARY") : "-") : (pairVolInfo.isVolPos(0x400000) ? (!pairVolInfo.isExSnapshotInfo(1) ? this.guidanceHandle.getGuidance("PRIMARY") : "-") : "-");
        }
        return ret;
    }

    public String getCopyTypeSimfString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(256) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(128) ? this.guidanceHandle.getGuidance("PRIMARY") : "-");
        }
        return ret;
    }

    public String getCopyTypeFcv2String(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo == null) {
            return ret;
        }
        if (SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_FC)) {
            if (pairVolInfo.isFcStatus(0x10000000)) {
                if (pairVolInfo.isFcStatus(48)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_PS_BAR");
                } else if (pairVolInfo.isFcStatus(32)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_S_BAR");
                } else if (pairVolInfo.isFcStatus(16)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_P_BAR");
                } else {
                    return "-";
                }
                ret = pairVolInfo.isFcStatus(64) ? ret + this.guidanceHandle.getGuidance("FAILED2") : ret + this.guidanceHandle.getGuidance("NORMAL2");
            } else if (pairVolInfo.isFcStatus(0x100000)) {
                if (pairVolInfo.isFcStatus(3)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_PS_BAR");
                } else if (pairVolInfo.isFcStatus(2)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_S_BAR");
                } else if (pairVolInfo.isFcStatus(1)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_P_BAR");
                } else {
                    return "-";
                }
                ret = pairVolInfo.isFcStatus(196608) ? ret + this.guidanceHandle.getGuidance("FULL_FAILED") : (pairVolInfo.isFcStatus(65536) ? ret + this.guidanceHandle.getGuidance("FAILED2") : (pairVolInfo.isFcStatus(131072) ? ret + this.guidanceHandle.getGuidance("FULL") : ret + this.guidanceHandle.getGuidance("NORMAL2")));
            } else {
                ret = "-";
            }
        } else {
            ret = "-";
        }
        return ret;
    }

    public String getCopyTypeFcseString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo == null) {
            return ret;
        }
        if (SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_FC)) {
            if (pairVolInfo.isFcStatus(0x10000000)) {
                if (pairVolInfo.isFcStatus(768)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_PS_BAR");
                } else if (pairVolInfo.isFcStatus(512)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_S_BAR");
                } else if (pairVolInfo.isFcStatus(256)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_P_BAR");
                } else {
                    return "-";
                }
                ret = pairVolInfo.isFcStatus(3072) ? ret + this.guidanceHandle.getGuidance("FULL_FAILED") : (pairVolInfo.isFcStatus(1024) ? ret + this.guidanceHandle.getGuidance("FAILED2") : (pairVolInfo.isFcStatus(2048) ? ret + this.guidanceHandle.getGuidance("FULL") : ret + this.guidanceHandle.getGuidance("NORMAL2")));
            } else if (pairVolInfo.isFcStatus(0x200000)) {
                if (pairVolInfo.isFcStatus(3)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_PS_BAR");
                } else if (pairVolInfo.isFcStatus(2)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_S_BAR");
                } else if (pairVolInfo.isFcStatus(1)) {
                    ret = this.guidanceHandle.getGuidance("CPTYPE_P_BAR");
                } else {
                    return "-";
                }
                ret = pairVolInfo.isFcStatus(196608) ? ret + this.guidanceHandle.getGuidance("FULL_FAILED") : (pairVolInfo.isFcStatus(65536) ? ret + this.guidanceHandle.getGuidance("FAILED2") : (pairVolInfo.isFcStatus(131072) ? ret + this.guidanceHandle.getGuidance("FULL") : ret + this.guidanceHandle.getGuidance("NORMAL2")));
            } else {
                ret = "-";
            }
        } else {
            ret = "-";
        }
        return ret;
    }

    public String getCtgIdString(SJmoConsistencyGroupIndex ctgIndex) {
        String ret = "?";
        if (null != ctgIndex) {
            ret = this.getCtgIdString(ctgIndex.getICtgId());
        }
        return ret;
    }

    public String getCtgIdString(int ctgId) {
        String ret = "?";
        ret = ctgId == -1 ? "-" : SJctrComUtility.toHexString(ctgId, 3, true);
        return ret;
    }

    public String getCtgStatusString(SJmoLocalReplicationConsistencyGroupInfo ctgInfo) {
        String rtnstr = "?";
        if (null != ctgInfo) {
            if (ctgInfo.isCtgStatus((short)228)) {
                rtnstr = this.guidanceHandle.getGuidance("USED_BY_DSS_CTG");
            } else if (ctgInfo.isCtgStatus((short)240)) {
                rtnstr = this.guidanceHandle.getGuidance("USED_BY_QS_CTG");
            } else if (ctgInfo.isCtgStatus((short)224)) {
                rtnstr = this.guidanceHandle.getGuidance("USED_BY_SI_CTG");
            } else if (ctgInfo.isCtgStatus((short)200)) {
                rtnstr = this.guidanceHandle.getGuidance("USED_BY_SIMF_CTG_RM");
            } else if (ctgInfo.isCtgStatus((short)192)) {
                rtnstr = this.guidanceHandle.getGuidance("USED_BY_SIMF_CTG");
            } else if (ctgInfo.isCtgStatus((short)160)) {
                rtnstr = this.guidanceHandle.getGuidance("CHANGING_CTG");
            } else if (ctgInfo.isCtgStatus((short)128)) {
                rtnstr = this.guidanceHandle.getGuidance("MAINFRAME_RESERVED_CTG");
            } else if (ctgInfo.isCtgStatus((short)0)) {
                rtnstr = this.guidanceHandle.getGuidance("FREE_CTG");
            }
        }
        return rtnstr;
    }

    public String getCopyStatusString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoPoolDetail poolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            short status = pairVolInfo.getSPairStatus();
            ret = this.getCopyStatusString(status, pairVolInfo, poolInfo);
        }
        return ret;
    }

    public String getCopyStatusString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJctrViewPairSyncRateInfo syncRateInfo, SJmoPoolDetail poolInfo) {
        String ret = "?";
        if (pairVolInfo != null && syncRateInfo != null) {
            short status = (short)syncRateInfo.getPairstatus();
            ret = this.getCopyStatusString(status, pairVolInfo, poolInfo);
        }
        return ret;
    }

    private String getCopyStatusString(short status, SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoPoolDetail poolInfo) {
        String ret = "?";
        if (pairVolInfo == null) {
            return ret;
        }
        long lPoolStatus = 0L;
        boolean poolThreshold = false;
        if (pairVolInfo.isVolPos(8)) {
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL_PD");
                    break;
                }
                case 16: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY_PD");
                    break;
                }
                case 32: {
                    ret = this.guidanceHandle.getGuidance("ST_PAIR");
                    break;
                }
                case 48: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUS");
                    break;
                }
                case 64: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY_RS");
                    break;
                }
                case 72: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY_RS_R");
                    break;
                }
                case 80: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUE");
                    break;
                }
                case 96: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY_SP");
                    break;
                }
                case 104: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUS_SP");
                    break;
                }
            }
        } else if (pairVolInfo.isVolPos(256)) {
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SIMPLEX");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ST_DELETING");
                    break;
                }
                case 16: {
                    ret = this.guidanceHandle.getGuidance("ST_PENDING");
                    break;
                }
                case 32: {
                    ret = this.guidanceHandle.getGuidance("ST_DUPLEX");
                    break;
                }
                case 48: {
                    ret = this.guidanceHandle.getGuidance("ST_SPLIT");
                    break;
                }
                case 64: {
                    ret = this.guidanceHandle.getGuidance("ST_RESYNC");
                    break;
                }
                case 72: {
                    ret = this.guidanceHandle.getGuidance("ST_RESYNC_R");
                    break;
                }
                case 80: {
                    ret = this.getPairStatusForFiconPair(pairVolInfo);
                    break;
                }
                case 96: {
                    ret = this.guidanceHandle.getGuidance("ST_SP_PEND");
                    break;
                }
                case 104: {
                    ret = this.guidanceHandle.getGuidance("ST_V_SPLIT");
                    break;
                }
            }
        } else if (pairVolInfo.isVolPos(0x800000)) {
            if (poolInfo != null) {
                lPoolStatus = poolInfo.getPoolStatus();
            }
            if ((lPoolStatus & 0x80000000L) != 0L) {
                poolThreshold = true;
            }
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL");
                    break;
                }
                case 513: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL_PD");
                    break;
                }
                case 528: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY");
                    break;
                }
                case 544: {
                    if (poolThreshold) {
                        ret = this.guidanceHandle.getGuidance("ST_PFUL");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("ST_PAIR");
                    break;
                }
                case 560: {
                    if (poolThreshold) {
                        ret = this.guidanceHandle.getGuidance("ST_PFUS");
                        break;
                    }
                    if (pairVolInfo.isBClone()) {
                        ret = this.guidanceHandle.getGuidance("ST_PSUS_TI");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("ST_PSUS");
                    break;
                }
                case 584: {
                    ret = this.guidanceHandle.getGuidance("ST_RCPY");
                    break;
                }
                case 592: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUE");
                    break;
                }
            }
        }
        return ret;
    }

    private String getPairStatusForFiconPair(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo == null) {
            return ret;
        }
        short statusOpt = pairVolInfo.getSStatusOpt();
        if (statusOpt == 1) {
            ret = this.guidanceHandle.getGuidance("ST_SUSPEND_MIG");
        } else if (statusOpt == 0) {
            ret = this.guidanceHandle.getGuidance("ST_SUSPEND");
        }
        return ret;
    }

    public String getINumberOfPairsString(SJctrCTGInfo numOfPair) {
        String ret = "?";
        if (numOfPair != null && numOfPair.getINumberOfPairs() != -1) {
            ret = Integer.toString(numOfPair.getINumberOfPairs());
        }
        return ret;
    }

    public String getSvolModeString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo == null) {
            return ret;
        }
        if (pairVolInfo.isVolPos(8) || pairVolInfo.isVolPos(256)) {
            if (pairVolInfo.getSWriteHist() == 1) {
                ret = this.guidanceHandle.getGuidance("MODE_W");
            } else if (pairVolInfo.getSHideMode() == 1) {
                ret = this.guidanceHandle.getGuidance("MODE_N");
            } else if (pairVolInfo.isVolPos(256)) {
                short pairStatus = pairVolInfo.getSPairStatus();
                switch (pairStatus) {
                    case 48: 
                    case 96: 
                    case 104: {
                        if (pairVolInfo.getStatOpt() == 2) {
                            ret = this.guidanceHandle.getGuidance("MODE_PROTECT");
                            break;
                        }
                        ret = "-";
                        break;
                    }
                    default: {
                        ret = "-";
                        break;
                    }
                }
            } else {
                ret = "-";
            }
        } else if (pairVolInfo.isVolPos(0x800000)) {
            ret = pairVolInfo.getSWriteHist() == 1 ? this.guidanceHandle.getGuidance("MODE_W") : "-";
        }
        return ret;
    }

    public String getSnapshotDateString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(0x800000)) {
                Date snapshotDate = pairVolInfo.getSnapShotDate();
                if (snapshotDate != null) {
                    SimpleDateFormat formatter = (SimpleDateFormat)SJctrReplicationDataMacro.REPLICATION_DATE_FORMAT.clone();
                    formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    ret = formatter.format(snapshotDate);
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getMirrorUnitString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = SJctrReplicationUtility.isEnabledSMuNumForMirrorUnitColumn(pairVolInfo) ? Short.toString(pairVolInfo.getSMuNum()) : "-";
        }
        return ret;
    }

    public String getSplitTypeString(short splittype) {
        String rtnstr = "?";
        switch (splittype) {
            case 240: {
                rtnstr = this.guidanceHandle.getGuidance("QUICK_SPLIT");
                break;
            }
            case 0: {
                rtnstr = this.guidanceHandle.getGuidance("STEADY_SPLIT");
                break;
            }
            case -1: {
                rtnstr = this.guidanceHandle.getGuidance("MIGRATION");
                break;
            }
        }
        return rtnstr;
    }

    public String getResyncTypeString(short resynctype, short copytype) {
        String rtnstr = "?";
        if (0 == copytype || 1 == copytype) {
            switch (resynctype) {
                case 0: {
                    rtnstr = this.guidanceHandle.getGuidance("NORMAL_COPY_PR_SC");
                    break;
                }
                case 1: {
                    rtnstr = this.guidanceHandle.getGuidance("NORMAL_COPY_SC_PR");
                    break;
                }
                case 64: {
                    rtnstr = this.guidanceHandle.getGuidance("QUICK_RESYNC_PR_SC");
                    break;
                }
                case 129: {
                    rtnstr = this.guidanceHandle.getGuidance("QUICK_RESYNC_SC_PR");
                    break;
                }
                case -1: {
                    rtnstr = this.guidanceHandle.getGuidance("MIGRATION_PRIMARY_SECONDARY");
                    break;
                }
            }
        } else if (2 == copytype || 3 == copytype) {
            switch (resynctype) {
                case 3: {
                    rtnstr = this.guidanceHandle.getGuidance("NORMAL_COPY_PR_SC");
                    break;
                }
                case 4: {
                    rtnstr = this.guidanceHandle.getGuidance("NORMAL_COPY_SC_PR");
                    break;
                }
            }
        }
        return rtnstr;
    }

    public String getPoolNameIdString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoPoolNameInfo poolNameInfo) {
        String ret = "?";
        if (pairVolInfo != null && poolNameInfo != null) {
            ret = poolNameInfo.getStrName() + "(" + pairVolInfo.getISVolPoolId() + ")";
        }
        return ret;
    }

    public String getPvolProvisioningTypeString(SJctrViewHistoriesSiInfo histInfo) {
        String ret = "?";
        if (histInfo != null) {
            short sVolKind = histInfo.getSVolKind();
            ret = (sVolKind & 8) == 8 ? this.guidanceHandle.getGuidance("EXTERNAL_MF_VOL") : ((sVolKind & 0x20) == 32 ? this.guidanceHandle.getGuidance("EXTERNAL_VOL") : ((sVolKind & 0x80) == 128 ? this.guidanceHandle.getGuidance("AOU-VVOL") : this.guidanceHandle.getGuidance("BASIC_VOL")));
        }
        return ret;
    }

    public String getSvolProvisioningTypeString(SJctrViewHistoriesSiInfo histInfo, boolean isTIFlg) {
        String ret = "?";
        if (histInfo != null) {
            short sVolKind = histInfo.getSVolKind();
            ret = (sVolKind & 4) == 4 ? this.guidanceHandle.getGuidance("EXTERNAL_MF_VOL") : ((sVolKind & 0x10) == 16 ? this.guidanceHandle.getGuidance("EXTERNAL_VOL") : ((sVolKind & 0x40) == 64 ? this.guidanceHandle.getGuidance("AOU-VVOL") : (isTIFlg ? this.guidanceHandle.getGuidance("SS-VVOL") : this.guidanceHandle.getGuidance("BASIC_VOL"))));
        }
        return ret;
    }

    public String getSnapshotSetString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoSnapshotSetInfoMgr sssinfoMgr) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (pairVolInfo.isVolPos(0x800000)) {
                if (pairVolInfo.isExSnapshotInfo(1)) {
                    if (0 <= pairVolInfo.getISnapshotSetId()) {
                        SJmoSnapshotSetInfo sssinfo;
                        if (null != sssinfoMgr && null != (sssinfo = sssinfoMgr.getSnapshotSetInfo(pairVolInfo.getISnapshotSetId()))) {
                            ret = sssinfo.getStrSnapshotSetName();
                        }
                    } else {
                        ret = "";
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getCascadeString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(0x800000) ? (pairVolInfo.isBCascade() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getCascadeStringOnCreate(Object obj) {
        String ret = "?";
        if (obj != null) {
            if (obj instanceof SJctrCreateSnapshotDataInfo) {
                ret = ((SJctrCreateSnapshotDataInfo)obj).isBCascade() ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("DISABLE");
            } else if (obj instanceof SJctrCreateTIPairInfo) {
                ret = ((SJctrCreateTIPairInfo)obj).isBCascade() ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("DISABLE");
            }
        }
        return ret;
    }

    public String getCascadeStringOnAssignSvol(SJctrCreateTIPairInfo pairInfo) {
        String ret = "?";
        if (pairInfo != null) {
            ret = pairInfo.isBCascade() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String getCascadeStringFromTiPvolInfo(SJmoTiPvolInfo pvolInfo) {
        String ret = "?";
        if (pvolInfo != null) {
            ret = pvolInfo.getBCascade() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String getPairCloneTypeString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(0x800000) ? (pairVolInfo.isBCascade() && pairVolInfo.isBClone() ? this.guidanceHandle.getGuidance("CLONE") : this.guidanceHandle.getGuidance("PAIR_TYPE_SNAPSHOT")) : "-";
        }
        return ret;
    }

    public String getPairCloneTypeStringOnCreate(Object obj) {
        String ret = "?";
        if (obj != null) {
            if (obj instanceof SJctrCreateSnapshotDataInfo) {
                SJctrCreateSnapshotDataInfo ssData = (SJctrCreateSnapshotDataInfo)obj;
                ret = ssData.isBCascade() && ssData.isBClone() ? this.guidanceHandle.getGuidance("CLONE") : this.guidanceHandle.getGuidance("PAIR_TYPE_SNAPSHOT");
            } else if (obj instanceof SJctrCreateTIPairInfo) {
                SJctrCreateTIPairInfo createTiPair = (SJctrCreateTIPairInfo)obj;
                ret = createTiPair.isBCascade() && createTiPair.isBClone() ? this.guidanceHandle.getGuidance("CLONE") : this.guidanceHandle.getGuidance("PAIR_TYPE_SNAPSHOT");
            }
        }
        return ret;
    }

    public String getPairPositionString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(0x800000) && pairVolInfo.isVolPos(0x400000) ? this.guidanceHandle.getGuidance("PRIMARY") + " " + "/" + " " + this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(0x400000) ? this.guidanceHandle.getGuidance("PRIMARY") : (pairVolInfo.isVolPos(0x800000) ? this.guidanceHandle.getGuidance("SECONDARY") : "-"));
        }
        return ret;
    }

    public List<SJmoLocalReplicationPairVolInfo> getCascadeTiPairListFromLeafVol(SJmoLdevIndex rootLdev, SJmoLdevIndex pvol, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        ArrayList<SJmoLocalReplicationPairVolInfo> pairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(pvol);
        if (pairInfo != null) {
            pairList.add(pairInfo);
            SJmoLdevIndex highPvol = pairInfo.getPVolIndex();
            if (SJctrReplicationUtility.getLdevIndexKey(rootLdev) != SJctrReplicationUtility.getLdevIndexKey(highPvol)) {
                pairList.addAll(this.getCascadeTiPairListFromLeafVol(rootLdev, highPvol, pairMgr));
            }
        }
        return pairList;
    }

    public String getPairPositionPrimaryString() {
        return this.guidanceHandle.getGuidance("PRIMARY");
    }

    public String getPairPositionPrimarySecondayString() {
        return this.guidanceHandle.getGuidance("PRIMARY") + " " + "/" + " " + this.guidanceHandle.getGuidance("SECONDARY");
    }

    public String getPairTopologyIdStringForPairVolInfo(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        ArrayList<String> muNumList = new ArrayList<String>(maxDepth);
        if (pairInfo != null && pairMgr != null && ldevUtil != null) {
            if (pairInfo.isVolPos(0x800000)) {
                ret = this.getTiTopologyIDStringForPairInfo(pairInfo, muNumList, pairMgr, ldevUtil);
            } else {
                SJmoLdevIndex pVolIndex = pairInfo.getPVolIndex();
                SJmoLocalReplicationPairVolInfo pVolInfo = pairMgr.getLocalReplicationPairVolInfo(pVolIndex);
                ret = this.getTopologyId(pairInfo, pVolInfo, ldevUtil);
            }
        }
        return ret;
    }

    public String getPairTopologyIdStringForPairInfo(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        ArrayList<String> muNumList = new ArrayList<String>(maxDepth);
        if (pairInfo != null && pairMgr != null && ldevUtil != null) {
            ret = this.getTiTopologyIDStringForPairInfo(pairInfo, muNumList, pairMgr, ldevUtil);
        }
        return ret;
    }

    public String getPairTopologyIdStringForCreateTiPairInfo(SJctrCreateTIPairInfo createTiPairInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        ArrayList<String> muNumList = new ArrayList<String>(maxDepth);
        if (createTiPairInfo != null && pairMgr != null && ldevUtil != null) {
            SJmoLdevIndex createPVolIndex = createTiPairInfo.getPVolIndex();
            SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(createPVolIndex);
            muNumList.add(this.guidanceHandle.getGuidance("AUTO"));
            if (pairInfo != null) {
                if (pairInfo.isVolPos(0x800000) && !pairInfo.isBClone()) {
                    ret = this.getTiTopologyIDStringForPairInfo(pairInfo, muNumList, pairMgr, ldevUtil);
                } else {
                    SJmoLdevIndex rootLdev = createTiPairInfo.getPVolIndex();
                    ret = this.makeTiTopologyIDString(rootLdev, muNumList, ldevUtil);
                }
            } else {
                ret = "";
                SJmoLdevIndex pVolIndex = createTiPairInfo.getPVolIndex();
                ret = this.makeTiTopologyIDString(pVolIndex, muNumList, ldevUtil);
            }
        }
        return ret;
    }

    public String getPairTopologyIdStringForTiAssignSvol(SJctrCreateTIPairInfo createTiPairInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        ArrayList<String> muNumList = new ArrayList<String>(maxDepth);
        if (createTiPairInfo != null && pairMgr != null && ldevUtil != null) {
            ret = "";
            Short sMuNum = createTiPairInfo.getMuNum();
            muNumList.add(sMuNum.toString());
            SJmoLdevIndex pVolIndex = createTiPairInfo.getPVolIndex();
            SJmoLocalReplicationPairVolInfo pvolPairInfo = pairMgr.getLocalReplicationPairVolInfo(pVolIndex);
            ret = pvolPairInfo != null && pvolPairInfo.isVolPos(0x800000) && !pvolPairInfo.isBClone() ? this.getTiTopologyIDStringForPairInfo(pvolPairInfo, muNumList, pairMgr, ldevUtil) : this.makeTiTopologyIDString(pVolIndex, muNumList, ldevUtil);
        }
        return ret;
    }

    public String getPairTopologyIdStringForTiPairInfo(SJmoLocalReplicationTiPairVolInfo tiPairInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        ArrayList<String> muNumList = new ArrayList<String>(maxDepth);
        if (tiPairInfo != null && pairMgr != null && ldevUtil != null) {
            SJmoLdevIndex rootLdev = tiPairInfo.getRootLdev();
            Short sMuNum = tiPairInfo.getMu();
            muNumList.add(sMuNum.toString());
            SJmoLdevIndex pairVolIndex = tiPairInfo.getPVolIndex();
            ret = this.getTiTopologyIDStringForPairInfo(pairVolIndex, rootLdev, muNumList, pairMgr, ldevUtil);
        }
        return ret;
    }

    private String getTiTopologyIDStringForPairInfo(SJmoLocalReplicationPairVolInfo pairInfo, List<String> muNumList, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        SJmoLdevIndex rootLdev = pairInfo.getRootLdev();
        Short sMuNum = pairInfo.getSMuNum();
        muNumList.add(sMuNum.toString());
        SJmoLdevIndex pairVolIndex = pairInfo.getPVolIndex();
        ret = this.getTiTopologyIDStringForPairInfo(pairVolIndex, rootLdev, muNumList, pairMgr, ldevUtil);
        return ret;
    }

    private String getTiTopologyIDStringForPairInfo(SJmoLdevIndex pairVolIndex, SJmoLdevIndex rootLdev, List<String> muNumList, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        int maxDepth = SJctrReplicationDataMacro.MAX_NUM_TI_CASCADE_PAIR_DEPTH;
        if (rootLdev == null) {
            ret = this.makeTiTopologyIDString(pairVolIndex, muNumList, ldevUtil);
            return ret;
        }
        for (int depth = 0; depth < maxDepth && SJctrReplicationUtility.getLdevIndexKey(pairVolIndex) != SJctrReplicationUtility.getLdevIndexKey(rootLdev); ++depth) {
            SJmoLocalReplicationPairVolInfo pVolInfo = pairMgr.getLocalReplicationPairVolInfo(pairVolIndex);
            if (pVolInfo == null || !pVolInfo.isVolPos(0x800000)) {
                SJctrLogUty.warn("SJctrReplicationUtility", "getTiTopologyIDStringForPairInfo", "PairVolInfo is not TI S-VOL");
                return ret;
            }
            Short pairMuNum = pVolInfo.getSMuNum();
            muNumList.add(pairMuNum.toString());
            pairVolIndex = pVolInfo.getPVolIndex();
        }
        ret = this.makeTiTopologyIDString(rootLdev, muNumList, ldevUtil);
        return ret;
    }

    private String makeTiTopologyIDString(SJmoLdevIndex rootLdev, List<String> muNumList, SJctrLdevUtility ldevUtil) {
        StringBuffer retBuf = new StringBuffer();
        String ret = "?:?:?(?)";
        retBuf.append(ldevUtil.toLdevDisplay(rootLdev));
        retBuf.append("(");
        for (int muNum = 0; muNum < muNumList.size(); ++muNum) {
            String strMuNum = muNumList.get(muNumList.size() - 1 - muNum);
            if (!strMuNum.equals(this.guidanceHandle.getGuidance("AUTO"))) {
                retBuf.append(this.guidanceHandle.getGuidance("MU"));
            }
            retBuf.append(strMuNum);
            if (muNumList.size() - 1 == muNum) continue;
            retBuf.append("-");
        }
        retBuf.append(")");
        ret = retBuf.toString();
        return ret;
    }

    public static int getPairStatusIconId(SJmoLocalReplicationPairVolInfo pairInfo) {
        int icon = 16431;
        int status = -1;
        if (pairInfo == null) {
            return icon;
        }
        status = pairInfo.getSPairStatus();
        if (pairInfo.isVolPos(8) || pairInfo.isVolPos(256)) {
            switch (status) {
                case 0: 
                case 1: {
                    icon = 16409;
                    break;
                }
                case 16: 
                case 64: 
                case 72: 
                case 96: {
                    icon = 16406;
                    break;
                }
                case 32: {
                    icon = 16403;
                    break;
                }
                case 48: 
                case 104: {
                    icon = 16404;
                    break;
                }
                case 80: {
                    icon = 16405;
                    break;
                }
            }
        } else if (pairInfo.isVolPos(0x800000)) {
            switch (status) {
                case 0: 
                case 513: {
                    icon = 16409;
                    break;
                }
                case 528: 
                case 584: {
                    icon = 16406;
                    break;
                }
                case 544: {
                    icon = 16403;
                    break;
                }
                case 560: {
                    icon = 16404;
                    break;
                }
                case 592: {
                    icon = 16405;
                    break;
                }
            }
        }
        return icon;
    }

    public static MRCFsetSplitPair[] createSplitPairApplyDataForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList, int copytype) {
        MRCFsetSplitPair[] applyParamArr = new MRCFsetSplitPair[pairInfoList.size()];
        for (int i = 0; i < pairInfoList.size(); ++i) {
            SJmoLocalReplicationPairVolInfo rowInfo = pairInfoList.get(i);
            MRCFsetSplitPair applyParam = new MRCFsetSplitPair();
            SJmoLdevIndex pldev = rowInfo.getPVolIndex();
            applyParam.setPvolLdkc(pldev.getSLdkc());
            applyParam.setPvolCu(pldev.getSCu());
            applyParam.setPvolLdev(pldev.getSLdev());
            SJmoLocalReplicationPairVolInfo sldev = rowInfo;
            applyParam.setSvolLdkc(sldev.getSLdkc());
            applyParam.setSvolCu(sldev.getSCu());
            applyParam.setSvolLdev(sldev.getSLdev());
            if (1 == copytype) {
                applyParam.setMu(rowInfo.getSMuNum());
            }
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static MRCFsetSptPairMain createSplitPairApplyDataMainForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList, short copytype, short splittype, short copypace) {
        MRCFsetSplitPair[] applyage = null;
        if (null != pairInfoList && 0 < pairInfoList.size()) {
            applyage = SJctrReplicationUtility.createSplitPairApplyDataForSI(pairInfoList, copytype);
        }
        MRCFsetSptPairMain applyParam = new MRCFsetSptPairMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setKind(copytype);
            applyParam.setSplitPair(applyage);
            applyParam.setCopyPace(copypace);
            applyParam.setSplitType(splittype);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createSplitPairApplyDataMainForSI", "Copy Type = " + copytype + ", Number of Pair = " + applyage.length + ", Copy Pace = " + copypace + ", Split Type = " + splittype + ", Function Code = " + 1);
        }
        return applyParam;
    }

    public static MRCFsetResyncPair[] createResyncPairApplyDataForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList) {
        MRCFsetResyncPair[] applyParamArr = new MRCFsetResyncPair[pairInfoList.size()];
        for (int i = 0; i < pairInfoList.size(); ++i) {
            SJmoLocalReplicationPairVolInfo rowInfo = pairInfoList.get(i);
            MRCFsetResyncPair applyParam = new MRCFsetResyncPair();
            SJmoLdevIndex pldev = rowInfo.getPVolIndex();
            applyParam.setPvolLdkc(pldev.getSLdkc());
            applyParam.setPvolCu(pldev.getSCu());
            applyParam.setPvolLdev(pldev.getSLdev());
            SJmoLocalReplicationPairVolInfo sldev = rowInfo;
            applyParam.setSvolLdkc(sldev.getSLdkc());
            applyParam.setSvolCu(sldev.getSCu());
            applyParam.setSvolLdev(sldev.getSLdev());
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static MRCFsetResPairMain createResyncPairApplyDataMainForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList, short copytype, short resynctype, short copypace) {
        MRCFsetResyncPair[] applyage = null;
        if (null != pairInfoList && 0 < pairInfoList.size()) {
            applyage = SJctrReplicationUtility.createResyncPairApplyDataForSI(pairInfoList);
        }
        MRCFsetResPairMain applyParam = new MRCFsetResPairMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setKind(copytype);
            applyParam.setResyncPair(applyage);
            applyParam.setCopyPace(copypace);
            applyParam.setResyncType(resynctype);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createResyncPairApplyDataMainForSI", "Copy Type = " + copytype + ", Number of Pair = " + applyage.length + ", Copy Pace = " + copypace + ", Resync Type = " + resynctype + ", Function Code = " + 1);
        }
        return applyParam;
    }

    public static MRCFsetDelPairMain createDelPairApplyDataMainForSI(List<SJmoLocalReplicationPairVolInfo> delPairInfo, short copyType) {
        MRCFsetDelPair[] delPair = null;
        if (null != delPairInfo && 0 < delPairInfo.size()) {
            delPair = SJctrReplicationUtility.createDelPairApplyDataForSI(delPairInfo);
        }
        MRCFsetDelPairMain rtn = new MRCFsetDelPairMain();
        if (null != delPair && 0 < delPair.length) {
            rtn.setKind(copyType);
            rtn.setDeletePair(delPair);
            rtn.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createDelPairApplyDataMainForSI", "Copy Type = " + copyType + ", Number of Pair = " + delPair.length + ", Function Code = " + 1);
        }
        return rtn;
    }

    public static MRCFsetDelPair[] createDelPairApplyDataForSI(List<SJmoLocalReplicationPairVolInfo> delPairInfo) {
        MRCFsetDelPair[] rtn = new MRCFsetDelPair[delPairInfo.size()];
        for (int i = 0; i < delPairInfo.size(); ++i) {
            SJmoLocalReplicationPairVolInfo pairInfo = delPairInfo.get(i);
            MRCFsetDelPair applyParam = new MRCFsetDelPair();
            SJmoLdevIndex pLdev = pairInfo.getPVolIndex();
            applyParam.setPvolLdkc(pLdev.getSLdkc());
            applyParam.setPvolCu(pLdev.getSCu());
            applyParam.setPvolLdev(pLdev.getSLdev());
            SJmoLocalReplicationPairVolInfo sldev = pairInfo;
            applyParam.setSvolLdkc(sldev.getSLdkc());
            applyParam.setSvolCu(sldev.getSCu());
            applyParam.setSvolLdev(sldev.getSLdev());
            rtn[i] = applyParam;
        }
        return rtn;
    }

    public static MRCFsetSuspendPair[] createSuspendPairApplyDataForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList) {
        MRCFsetSuspendPair[] applyParamArr = new MRCFsetSuspendPair[pairInfoList.size()];
        for (int i = 0; i < pairInfoList.size(); ++i) {
            SJmoLocalReplicationPairVolInfo rowInfo = pairInfoList.get(i);
            MRCFsetSuspendPair applyParam = new MRCFsetSuspendPair();
            SJmoLdevIndex pldev = rowInfo.getPVolIndex();
            applyParam.setPvolLdkc(pldev.getSLdkc());
            applyParam.setPvolCu(pldev.getSCu());
            applyParam.setPvolLdev(pldev.getSLdev());
            SJmoLocalReplicationPairVolInfo sldev = rowInfo;
            applyParam.setSvolLdkc(sldev.getSLdkc());
            applyParam.setSvolCu(sldev.getSCu());
            applyParam.setSvolLdev(sldev.getSLdev());
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static MRCFsetSusPairMain createSuspendPairApplyDataMainForSI(List<SJmoLocalReplicationPairVolInfo> pairInfoList, short copytype) {
        MRCFsetSuspendPair[] applyage = null;
        if (null != pairInfoList && 0 < pairInfoList.size()) {
            applyage = SJctrReplicationUtility.createSuspendPairApplyDataForSI(pairInfoList);
        }
        MRCFsetSusPairMain applyParam = new MRCFsetSusPairMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setKind(copytype);
            applyParam.setSuspendPair(applyage);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createSuspendPairApplyDataMainForSI", "Copy Type = " + copytype + ", Number of Pair = " + applyage.length + ", Function Code = " + 1);
        }
        return applyParam;
    }

    public static List<Object> getOperateCopyApplyResult(Object resultObject, short copytype) {
        List<Object> result = null;
        if (0 == copytype || 1 == copytype) {
            result = SJctrReplicationUtility.setApplyResultForSISIMF(resultObject);
        } else if (2 == copytype || 3 == copytype) {
            result = SJctrReplicationUtility.setApplyResultForSnapshot(resultObject);
        } else {
            SJctrLogUty.error("SJctrReplicationUtility", "getOperateCopyApplyResult", "Copy type is invalid. Copy Type = " + copytype);
        }
        return result;
    }

    private static List<Object> setApplyResultForSISIMF(Object resultObject) {
        ArrayList<Object> ret = new ArrayList<Object>(2);
        ArrayList<SJctrLReplicaOperationError> resultData = null;
        int funcErc = 209;
        int moduleErc = 22;
        int delegateErc = 0;
        if (null == resultObject) {
            delegateErc = 107001;
        } else if (resultObject instanceof MRCFErrorInf) {
            MRCFErrorInf errinf = (MRCFErrorInf)resultObject;
            MRCFErrorDetail[] detailarr = errinf.getErrorDetail();
            if (null != detailarr) {
                resultData = new ArrayList<SJctrLReplicaOperationError>(detailarr.length);
                for (MRCFErrorDetail detail : detailarr) {
                    int detailesult;
                    if (null == detail || 0 == (detailesult = detail.getErrCode())) continue;
                    SJmoLdevIndex svol = new SJmoLdevIndex();
                    svol.setSLdkc(detail.getSvolLdkc());
                    svol.setSCu(detail.getSvolCu());
                    svol.setSLdev(detail.getSvolLdev());
                    SJctrLReplicaOperationError applyResult = new SJctrLReplicaOperationError(SJctrReplicationUtility.getErrFuncCode(detail.getIErrorDetect()), SJctrReplicationUtility.getErrModulePart(detail.getIErrorDetect()), detailesult, svol);
                    resultData.add(applyResult);
                }
                if (0 < resultData.size()) {
                    delegateErc = errinf.getRslt();
                    funcErc = SJctrReplicationUtility.getErrFuncCode(errinf.getIErrorPart());
                    moduleErc = SJctrReplicationUtility.getErrModulePart(errinf.getIErrorPart());
                }
            }
        } else {
            delegateErc = 107001;
            SJctrLogUty.error("SJctrReplicationUtility", "setApplyResultForSISIMF", "The parameter is not instance of MRCFErrorInf.");
        }
        SJctrError result = new SJctrError(funcErc, moduleErc, delegateErc);
        ret.add(resultData);
        ret.add(result);
        return ret;
    }

    private static List<Object> setApplyResultForSnapshot(Object resultObject) {
        ArrayList<Object> ret = new ArrayList<Object>(2);
        ArrayList<SJctrLReplicaOperationError> resultData = null;
        int funcErc = 209;
        int moduleErc = 22;
        int delegateErc = 0;
        if (null == resultObject) {
            delegateErc = 107001;
        } else if (resultObject instanceof MRCFsetQSPairInfo_OUT) {
            MRCFsetQSPairDetail[] detailarr;
            MRCFsetQSPairMain pairout = ((MRCFsetQSPairInfo_OUT)resultObject).getResult();
            if (null != pairout && null != (detailarr = pairout.getPairInf())) {
                resultData = new ArrayList<SJctrLReplicaOperationError>(detailarr.length);
                for (MRCFsetQSPairDetail detail : detailarr) {
                    int detailesult;
                    if (null == detail || 0 == (detailesult = detail.getIErrorCode())) continue;
                    RJiLDEVIndex rmiPvolLdevIndex = detail.getPVolIndex();
                    SJmoLdevIndex pvol = new SJmoLdevIndex();
                    pvol.setSLdkc(rmiPvolLdevIndex.getSLDKC());
                    pvol.setSCu(rmiPvolLdevIndex.getSCU());
                    pvol.setSLdev(rmiPvolLdevIndex.getSLDEV());
                    RJiLDEVIndex rmiSvolLdevIndex = detail.getSVolIndex();
                    SJmoLdevIndex svol = new SJmoLdevIndex();
                    svol.setSLdkc(rmiSvolLdevIndex.getSLDKC());
                    svol.setSCu(rmiSvolLdevIndex.getSCU());
                    svol.setSLdev(rmiSvolLdevIndex.getSLDEV());
                    SJctrLReplicaOperationError applyResult = new SJctrLReplicaOperationError(SJctrReplicationUtility.getErrFuncCode(detail.getIErrorDetect()), SJctrReplicationUtility.getErrModulePart(detail.getIErrorDetect()), detailesult, pvol, detail.getSMuNum(), svol);
                    resultData.add(applyResult);
                }
                if (0 < resultData.size()) {
                    delegateErc = pairout.getIResult();
                    funcErc = SJctrReplicationUtility.getErrFuncCode(pairout.getIErrorDetect());
                    moduleErc = SJctrReplicationUtility.getErrModulePart(pairout.getIErrorDetect());
                }
            }
        } else {
            delegateErc = 107001;
            SJctrLogUty.error("SJctrReplicationUtility", "setApplyResultForSnapshot", "The parameter is not instance of MRCFsetQSPairInfo_OUT.");
        }
        SJctrError result = new SJctrError(funcErc, moduleErc, delegateErc);
        ret.add(resultData);
        ret.add(result);
        return ret;
    }

    public static MRCFsetQSPairDetail[] createSnapshotApplyDataDetail(List<SJmoLocalReplicationPairVolInfo> pairInfoList, short kind, short cmdopt) {
        MRCFsetQSPairDetail[] applyParamArr = null;
        if (null != pairInfoList) {
            applyParamArr = new MRCFsetQSPairDetail[pairInfoList.size()];
            for (int i = 0; i < pairInfoList.size(); ++i) {
                SJmoLocalReplicationPairVolInfo rowInfo = pairInfoList.get(i);
                MRCFsetQSPairDetail applyParam = new MRCFsetQSPairDetail();
                applyParam.setSCmdKind(kind);
                applyParam.setSSnapshotKind((short)0);
                applyParam.setSCmdOpt(cmdopt);
                RJiLDEVIndex rmiPLdevIndex = new RJiLDEVIndex();
                rmiPLdevIndex.setLDEVIndex(rowInfo.getPVolIndex().getSLdkc(), rowInfo.getPVolIndex().getSCu(), rowInfo.getPVolIndex().getSLdev());
                applyParam.setPVolIndex(rmiPLdevIndex);
                RJiLDEVIndex rmiSLdevIndex = new RJiLDEVIndex();
                rmiSLdevIndex.setLDEVIndex(rowInfo.getSLdkc(), rowInfo.getSCu(), rowInfo.getSLdev());
                applyParam.setSVolIndex(rmiSLdevIndex);
                applyParam.setSMuNum(rowInfo.getSMuNum());
                applyParam.setSPoolId((short)rowInfo.getISVolPoolId());
                applyParamArr[i] = applyParam;
            }
        }
        return applyParamArr;
    }

    public static MRCFsetQSPairDetail[] createDynamicSnapshotApplyDataDetail(List<SJmoLocalReplicationPairVolInfo> pairInfoList, short kind, short cmdopt, short copypace) {
        MRCFsetQSPairDetail[] applyParamArr = null;
        if (null != pairInfoList) {
            applyParamArr = new MRCFsetQSPairDetail[pairInfoList.size()];
            for (int i = 0; i < pairInfoList.size(); ++i) {
                SJmoLocalReplicationPairVolInfo rowInfo = pairInfoList.get(i);
                MRCFsetQSPairDetail applyParam = new MRCFsetQSPairDetail();
                applyParam.setSCmdKind(kind);
                applyParam.setSPairKind((short)1);
                applyParam.setSSnapshotKind((short)1);
                if (SJctrTiReplicationUtility.isFloatingDevice(rowInfo)) {
                    applyParam.setSCmdOpt((short)1);
                } else {
                    applyParam.setSCmdOpt(cmdopt);
                }
                RJiLDEVIndex rmiPLdevIndex = new RJiLDEVIndex();
                rmiPLdevIndex.setLDEVIndex(rowInfo.getPVolIndex().getSLdkc(), rowInfo.getPVolIndex().getSCu(), rowInfo.getPVolIndex().getSLdev());
                applyParam.setPVolIndex(rmiPLdevIndex);
                if (!SJctrTiReplicationUtility.isFloatingDevice(rowInfo) || 0 == cmdopt || 2 == cmdopt) {
                    RJiLDEVIndex rmiSLdevIndex = new RJiLDEVIndex();
                    rmiSLdevIndex.setLDEVIndex(rowInfo.getSLdkc(), rowInfo.getSCu(), rowInfo.getSLdev());
                    applyParam.setSVolIndex(rmiSLdevIndex);
                }
                if (SJctrTiReplicationUtility.isFloatingDevice(rowInfo) || 0 == cmdopt || 1 == cmdopt) {
                    applyParam.setSMuNum(rowInfo.getSMuNum());
                }
                if (kind == 2 && rowInfo.isBCascade() && rowInfo.isBClone()) {
                    applyParam.setBCascade(true);
                    applyParam.setBClone(true);
                    applyParam.setSCopyPace(copypace);
                } else {
                    applyParam.setBCascade(false);
                    applyParam.setBClone(false);
                }
                applyParamArr[i] = applyParam;
            }
        }
        return applyParamArr;
    }

    public static MRCFsetQSPairMain createSnapshotApplyData(List<SJmoLocalReplicationPairVolInfo> pairInfoLis, short kind, short cmdopt, short copypace, short copytype) {
        MRCFsetQSPairDetail[] applyage = null;
        if (null != pairInfoLis && 0 < pairInfoLis.size()) {
            if (2 == copytype) {
                applyage = SJctrReplicationUtility.createSnapshotApplyDataDetail(pairInfoLis, kind, cmdopt);
            } else if (3 == copytype) {
                applyage = SJctrReplicationUtility.createDynamicSnapshotApplyDataDetail(pairInfoLis, kind, cmdopt, copypace);
            } else {
                SJctrLogUty.error("SJctrReplicationUtility", "createSnapshotApplyData", "Copy Type is invalid.");
            }
        }
        MRCFsetQSPairMain applyParam = new MRCFsetQSPairMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setIPairNum(applyage.length);
            applyParam.setPairInf(applyage);
            SJctrLogUty.info("SJctrReplicationUtility", "createSnapshotApplyData", "Command Kind = " + kind + ", Number of Pair = " + applyage.length + ", Command Option = " + cmdopt + ", Copy Type = " + copytype);
        }
        return applyParam;
    }

    public static MRCFgetPairRateDetail[] getPairSynchRateInfo(SJctrDataController dc, List<SJmoLocalReplicationPairVolInfo> pairList) {
        List<SJmoThroughRmiData> rmiData = SJctrReplicationUtility.getSyncRateModelDirect(dc, pairList);
        MRCFgetPairRate_OUT pairRateInfo = (MRCFgetPairRate_OUT)rmiData.get(0).getObjRmi();
        MRCFgetPairRate pairRate = pairRateInfo.getDataInf();
        MRCFgetPairRateDetail[] pairRateDetail = pairRate.getDetailInfo();
        return pairRateDetail;
    }

    private static List<SJmoThroughRmiData> getSyncRateModelDirect(SJctrDataController dc, List<SJmoLocalReplicationPairVolInfo> pairlist) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        MRCFgetPairRate paramPairRate = SJctrReplicationUtility.createParamPairRate(pairlist);
        MRCFgetPairRate_IN pairRate = new MRCFgetPairRate_IN(paramPairRate);
        SJctrGetMRCFgetPairRate kindPairSyncRate = new SJctrGetMRCFgetPairRate(pairRate);
        SJmoGetRange_IF rangePairSyncRate = null;
        ArrayList filterPairSyncRate = new ArrayList();
        SJmoGetDirect directPairSyncRate = new SJmoGetDirect(kindPairSyncRate, rangePairSyncRate, filterPairSyncRate);
        SJctrGetDirectWrapper wrapperPairSyncRate = new SJctrGetDirectWrapper(directPairSyncRate);
        wrapperPairSyncRate.setCacheMode(false);
        set.add(wrapperPairSyncRate);
        SJctrLogUty.info("SJctrReplicationUtility", "getSyncRateModelDirect", "Number of Pair = " + pairlist.size() + ", Kind Class = " + SJctrGetMRCFgetPairRate.class.getName());
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> syncRateData = map.get(wrapperPairSyncRate);
        return syncRateData;
    }

    private static MRCFgetPairRate createParamPairRate(List<SJmoLocalReplicationPairVolInfo> pairlist) {
        MRCFgetPairRate pairRate = new MRCFgetPairRate();
        if (null != pairlist && 0 < pairlist.size()) {
            pairRate.setPairNum(pairlist.size());
            MRCFgetPairRateDetail[] datailarr = new MRCFgetPairRateDetail[pairlist.size()];
            for (int i = 0; i < pairlist.size(); ++i) {
                SJmoLocalReplicationPairVolInfo pairinfo = pairlist.get(i);
                if (null == pairinfo) continue;
                MRCFgetPairRateDetail datail = new MRCFgetPairRateDetail();
                RJiLDEVIndex pVol = new RJiLDEVIndex();
                SJmoLdevIndex pVolIndx = pairinfo.getPVolIndex();
                pVol.setLDEVIndex(pVolIndx.getSLdkc(), pVolIndx.getSCu(), pVolIndx.getSLdev());
                RJiLDEVIndex sVol = new RJiLDEVIndex();
                sVol.setLDEVIndex(pairinfo.getSLdkc(), pairinfo.getSCu(), pairinfo.getSLdev());
                datail.setPVolIndex(pVol);
                datail.setSVolIndex(sVol);
                short copyType = (short)SJctrReplicationUtility.checkCopyTypeForLocalPairVol(pairinfo);
                if (3 == copyType) {
                    copyType = 2;
                }
                datail.setPairKind(copyType);
                datail.setMuNum(pairinfo.getSMuNum());
                datailarr[i] = datail;
            }
            pairRate.setDetailInfo(datailarr);
        }
        return pairRate;
    }

    public static MRCFsetAtrbMain createAddReserveVolumeApplyDataMain(List<SJmoLdevDetail> ldevInfoList, short sKind) {
        MRCFsetAttribute[] applyage = null;
        if (null != ldevInfoList && 0 < ldevInfoList.size()) {
            applyage = SJctrReplicationUtility.createMRCFsetAttribute(ldevInfoList);
        }
        MRCFsetAtrbMain applyParam = new MRCFsetAtrbMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setKind(sKind);
            applyParam.setChgVol(applyage);
            applyParam.setAtrb((short)128);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createAddReserveVolumeApplyDataMain", "Volume Type = " + sKind + ", Number of Ldev = " + applyage.length + ", Attribute = " + 128 + ", Function Code = " + 1);
        }
        return applyParam;
    }

    public static MRCFsetAtrbMain createRemovedReserveVolumeApplyDataMain(List<SJmoLdevDetail> ldevInfoList, short sKind) {
        MRCFsetAttribute[] applyage = null;
        if (null != ldevInfoList && 0 < ldevInfoList.size()) {
            applyage = SJctrReplicationUtility.createMRCFsetAttribute(ldevInfoList);
        }
        MRCFsetAtrbMain applyParam = new MRCFsetAtrbMain();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setKind(sKind);
            applyParam.setChgVol(applyage);
            applyParam.setAtrb((short)0);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createRemovedReserveVolumeApplyDataMain", "Volume Type = " + sKind + ", Number of Ldev = " + applyage.length + ", Attribute = " + 0 + ", Function Code = " + 1);
        }
        return applyParam;
    }

    public static MRCFsetAttribute[] createMRCFsetAttribute(List<SJmoLdevDetail> ldevInfoList) {
        MRCFsetAttribute[] applyParamArr = new MRCFsetAttribute[ldevInfoList.size()];
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            SJmoLdevDetail rowInfo = ldevInfoList.get(i);
            MRCFsetAttribute applyParam = new MRCFsetAttribute();
            applyParam.setVolLdkc(rowInfo.getSLdkc());
            applyParam.setVolCu(rowInfo.getSCu());
            applyParam.setVolLdev(rowInfo.getSLdev());
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static MRCFctgInf createOperateCtgApplyDataMain(List<SJctrCTGInfo> ctgInfoList, short attribute) {
        MRCFctgDetail[] applyage = null;
        if (null != ctgInfoList && 0 < ctgInfoList.size()) {
            applyage = SJctrReplicationUtility.createMRCFctgDetailArray(ctgInfoList, attribute);
        }
        MRCFctgInf applyParam = new MRCFctgInf();
        if (null != applyage && 0 < applyage.length) {
            applyParam.setCtgDetail(applyage);
            applyParam.setCtgNum((short)ctgInfoList.size());
            applyParam.setKind((short)0);
            applyParam.setSFunc((short)1);
            SJctrLogUty.info("SJctrReplicationUtility", "createOperateCtgApplyDataMain", "Number of CTG = " + ctgInfoList.size() + ", Kind = " + applyParam.sKind + ", Function Code = " + applyParam.sFunc + ", Attribute = " + attribute);
        }
        return applyParam;
    }

    private static MRCFctgDetail[] createMRCFctgDetailArray(List<SJctrCTGInfo> ctgInfoList, short attribute) {
        MRCFctgDetail[] applyParamArr = new MRCFctgDetail[ctgInfoList.size()];
        for (int i = 0; i < ctgInfoList.size(); ++i) {
            SJctrCTGInfo rowInfo = ctgInfoList.get(i);
            MRCFctgDetail applyParam = new MRCFctgDetail();
            applyParam.setCtgId((short)rowInfo.getICtgId());
            applyParam.setCtgAtrb(attribute);
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static void setCacheLReplicaDetailDataForAddRsvVols(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrReplicationUtility.getSJmoLdevDetail(dc));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrReplicationUtility.getSJmoLdevLuseInfo(dc));
    }

    public static List<SJmoLocalReplicationConsistencyGroupInfoMgr> getSJctrCTGInfo(SJctrDataController dc) {
        List<SJmoLocalReplicationConsistencyGroupInfoMgr> ctgDataList = SJctrReplicationUtility.getCache(dc, SJmoGetLocalReplicationConsistencyGroupInfoMgr.class);
        if (null == ctgDataList) {
            dc.getLogUty().putlog("getSJctrCTGInfo", "Information of CTGs is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ctgDataList;
    }

    public static List<Object> setApplyResultForRsvVol(Object resultObject) {
        ArrayList<Object> ret = new ArrayList<Object>(2);
        ArrayList<SJctrLReplicaOperationErrorForRsvVol> resultData = null;
        int funcErc = 209;
        int moduleErc = 22;
        int delegateErc = 0;
        if (null == resultObject) {
            delegateErc = 107001;
        } else if (resultObject instanceof MRCFErrorInf) {
            MRCFErrorInf errinf = (MRCFErrorInf)resultObject;
            MRCFErrorDetail[] detailarr = errinf.getErrorDetail();
            if (null != detailarr) {
                resultData = new ArrayList<SJctrLReplicaOperationErrorForRsvVol>(detailarr.length);
                for (MRCFErrorDetail detail : detailarr) {
                    int detailesult;
                    if (null == detail || 0 == (detailesult = detail.getErrCode())) continue;
                    SJmoLdevIndex svol = new SJmoLdevIndex();
                    svol.setSLdkc(detail.getSvolLdkc());
                    svol.setSCu(detail.getSvolCu());
                    svol.setSLdev(detail.getSvolLdev());
                    SJctrLReplicaOperationErrorForRsvVol applyResult = new SJctrLReplicaOperationErrorForRsvVol(SJctrReplicationUtility.getErrFuncCode(detail.getIErrorDetect()), SJctrReplicationUtility.getErrModulePart(detail.getIErrorDetect()), detailesult, svol);
                    resultData.add(applyResult);
                }
                if (0 < resultData.size()) {
                    delegateErc = errinf.getRslt();
                    funcErc = SJctrReplicationUtility.getErrFuncCode(errinf.getIErrorPart());
                    moduleErc = SJctrReplicationUtility.getErrModulePart(errinf.getIErrorPart());
                }
            }
        } else {
            delegateErc = 107001;
        }
        SJctrError result = new SJctrError(funcErc, moduleErc, delegateErc);
        ret.add(resultData);
        ret.add(result);
        return ret;
    }

    public static List<Object> setApplyResultForRsvCtg(Object resultObject) {
        ArrayList<Object> ret = new ArrayList<Object>(2);
        ArrayList<SJctrLReplicaOperationErrorForRsvCtg> resultData = null;
        int funcErc = 209;
        int moduleErc = 22;
        int delegateErc = 0;
        if (null == resultObject) {
            delegateErc = 107001;
        } else if (resultObject instanceof MRCFErrorInf) {
            MRCFErrorInf errinf = (MRCFErrorInf)resultObject;
            MRCFErrorDetail[] detailarr = errinf.getErrorDetail();
            if (null != detailarr) {
                resultData = new ArrayList<SJctrLReplicaOperationErrorForRsvCtg>(detailarr.length);
                for (MRCFErrorDetail detail : detailarr) {
                    int detailesult;
                    if (null == detail || 0 == (detailesult = detail.getErrCode())) continue;
                    SJmoConsistencyGroupIndex ctg = new SJmoConsistencyGroupIndex();
                    ctg.setICtgId(detail.Grp);
                    SJctrLReplicaOperationErrorForRsvCtg applyResult = new SJctrLReplicaOperationErrorForRsvCtg(SJctrReplicationUtility.getErrFuncCode(detail.getIErrorDetect()), SJctrReplicationUtility.getErrModulePart(detail.getIErrorDetect()), detailesult, ctg);
                    resultData.add(applyResult);
                }
                if (0 < resultData.size()) {
                    delegateErc = errinf.getRslt();
                    funcErc = SJctrReplicationUtility.getErrFuncCode(errinf.getIErrorPart());
                    moduleErc = SJctrReplicationUtility.getErrModulePart(errinf.getIErrorPart());
                }
            }
        } else {
            delegateErc = 107001;
        }
        SJctrError result = new SJctrError(funcErc, moduleErc, delegateErc);
        ret.add(resultData);
        ret.add(result);
        return ret;
    }

    public static List<SJctrCTGInfo> checkAndGetExistCtglInfo(List<SJctrCTGInfo> checkList, SJmoLocalReplicationConsistencyGroupInfoMgr allCtgInfo) throws SJcException {
        if (checkList == null || allCtgInfo == null) {
            return new ArrayList<SJctrCTGInfo>(0);
        }
        ArrayList<SJctrCTGInfo> retList = new ArrayList<SJctrCTGInfo>(checkList.size());
        for (SJctrCTGInfo selectedCtg : checkList) {
            SJmoLocalReplicationConsistencyGroupInfo targetCtg = allCtgInfo.getLocalReplicationCtgInfo(selectedCtg.getCtgInfo());
            if (null != targetCtg) {
                SJctrCTGInfo ctginfo = new SJctrCTGInfo(targetCtg);
                retList.add(ctginfo);
                continue;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetExistCtglInfo", "Check list data is different from local Ctg list.");
            SJctrError err = new SJctrError(209, 22, 106536);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static List<SJmoPortDetail> getSJmoPortDetail(SJctrDataController dc) {
        List<SJmoPortDetail> info = SJctrReplicationUtility.getCache(dc, SJmoGetPortDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortDetail", "Information of PORT info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevDetail> checkAndGetExistLdevlInfo(List<SJmoLdevDetail> checkList, List<SJmoLdevDetail> allLdevInfo) throws SJcException {
        if (checkList == null || allLdevInfo == null) {
            return new ArrayList<SJmoLdevDetail>(0);
        }
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(checkList.size());
        Collections.sort(allLdevInfo);
        for (SJmoLdevDetail selectedLdev : checkList) {
            int index = Collections.binarySearch(allLdevInfo, selectedLdev);
            if (index >= 0) {
                SJmoLdevDetail target = allLdevInfo.get(index);
                retList.add(target);
                continue;
            }
            SJctrLogUty.error("SJctrReplicationUtility", "checkAndGetExistLdevlInfo", "Check list data is different from local LDEV list.");
            SJctrError err = new SJctrError(209, 22, 106535);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static void setFinishChangeCheck(SJctrDataController dc, boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer;
        if (null != dc && null != (footer = (SJctrFooterDataModel)dc.getDataObjectModel("COM_FOOTER")) && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public String getOptStatusString(boolean flg) {
        String status = this.guidanceHandle.getGuidance("DISABLED");
        if (flg) {
            status = this.guidanceHandle.getGuidance("ENABLED");
        }
        return status;
    }

    public String getReserveVolString(SJmoLocalReplicationPairVolInfo pairInfo) {
        String rtn = "?";
        if (pairInfo != null) {
            rtn = pairInfo.isVolPos(16) || pairInfo.isVolPos(512) ? this.guidanceHandle.getGuidance("YES") : this.guidanceHandle.getGuidance("NO");
        }
        return rtn;
    }

    public String getDifferentialRateString(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(0x800000)) {
                short pairRate = pairVolInfo.getSPairRate();
                ret = Integer.toString(100 - pairRate);
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static List<SJmoLdevIndex> getFICONPortLUList(List<SJmoPortDetail> portDtlList, List<SJmoPortLunInfo> portLunList) {
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>(SJmoDataMacro_IF.MAX_LDEV_LDKC);
        for (SJmoPortDetail portDtl : portDtlList) {
            int target;
            if (portDtl.getByPortKindNo() != 3 || (target = Collections.binarySearch(portLunList, portDtl)) < 0) continue;
            SJmoPortLunInfo portLunInfo = portLunList.get(target);
            ArrayList portLunDtlList = portLunInfo.getAlPortLun();
            for (SJmoPortLunDetail portLunDtl : portLunDtlList) {
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setSLdkc(portLunDtl.getSLDKC());
                ldevIndex.setSCu(portLunDtl.getSCU());
                ldevIndex.setSLdev(portLunDtl.getSLDEV());
                retList.add(ldevIndex);
            }
        }
        Collections.sort(retList);
        return retList;
    }

    public static boolean chkReserved(SJmoLocalReplicationPairVolInfo pairVolInfo, SJmoLdevDetail ldevInf) {
        boolean rtn = false;
        if (pairVolInfo != null && !SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_SVOL) && SJctrReplicationUtility.checkLocalPairVolPos(pairVolInfo, SJctrReplicationDataMacro.BITMAPDATA_LOCALPAIR_RSV_VOL)) {
            rtn = true;
        }
        return rtn;
    }

    public static List<SJmoPortLunInfo> getSJmoPortLunInfo(SJctrDataController dc) {
        List<SJmoPortLunInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetPortLunInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("SJmoPortLunInfo", "Information of PORTLUN info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static Map<Integer, List<SJmoPortLunDetail>> createLDEVLUPathMap(List<SJmoPortLunInfo> portLunInfoList, List<SJmoLdevDetail> ldevDtlList) {
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        HashMap<Integer, List<SJmoPortLunDetail>> ldevLuPathMap = new HashMap<Integer, List<SJmoPortLunDetail>>(ldevDtlList.size());
        for (SJmoPortLunInfo portLunInfo : portLunInfoList) {
            ArrayList portLunDtlList = portLunInfo.getAlPortLun();
            for (SJmoPortLunDetail portLunDtl : portLunDtlList) {
                ldevIndex.setLdevIndex(portLunDtl.getSLDKC(), portLunDtl.getSCU(), portLunDtl.getSLDEV());
                int ldevIndexKey = ldevIndex.getIndex();
                ArrayList<SJmoPortLunDetail> portLunList = (ArrayList<SJmoPortLunDetail>)ldevLuPathMap.get(ldevIndexKey);
                if (portLunList == null) {
                    int index = Collections.binarySearch(ldevDtlList, ldevIndex);
                    if (index < 0) continue;
                    SJmoLdevDetail ldevDtl = ldevDtlList.get(index);
                    portLunList = new ArrayList<SJmoPortLunDetail>(ldevDtl.getILUPathNumber());
                }
                portLunList.add(portLunDtl);
                ldevLuPathMap.put(ldevIndexKey, (List<SJmoPortLunDetail>)portLunList);
            }
        }
        return ldevLuPathMap;
    }

    public static int getLdevIndexKey(SJmoLdevIndex ldevIndex) {
        return SJctrReplicationUtility.getLdevIndexKey(ldevIndex.getSLdkc(), ldevIndex.getSCu(), ldevIndex.getSLdev());
    }

    public static int getLdevIndexKey(SJmoPortLunDetail luPathDtl) {
        return SJctrReplicationUtility.getLdevIndexKey(luPathDtl.getSLDKC(), luPathDtl.getSCU(), luPathDtl.getSLDEV());
    }

    public static int getLdevIndexKey(short ldkc, short cu, short ldev) {
        return ldkc << 16 | cu << 8 | ldev;
    }

    public static SJmoPoolDetail getPoolDetalInfoFromPairVolInfo(SJmoLocalReplicationPairVolInfo pairVolInfo, List<SJmoPoolDetail> poolInfoList) {
        SJmoPoolDetail poolInfo = null;
        SJmoPoolIndex poolIndex = new SJmoPoolIndex();
        if (pairVolInfo != null && poolInfoList != null) {
            poolIndex.setPoolId(pairVolInfo.getISVolPoolId());
            int target = Collections.binarySearch(poolInfoList, poolIndex);
            if (0 <= target) {
                poolInfo = poolInfoList.get(target);
            }
        }
        return poolInfo;
    }

    public String getSyncrateString(SJmoLocalReplicationPairVolInfo pairVolInfo, SJctrViewPairSyncRateInfo syncRateInfo) {
        String ret = "?";
        if (syncRateInfo != null) {
            ret = this.isEffectiveStatusViewSyncRate(pairVolInfo, syncRateInfo.getPairstatus()) ? Short.toString(syncRateInfo.getPairrate()) : "-";
        }
        return ret;
    }

    public boolean isEffectiveStatusViewSyncRate(SJmoLocalReplicationPairVolInfo pairVolInfo, int status) {
        boolean ret;
        block2: {
            block3: {
                ret = false;
                if (pairVolInfo == null) break block2;
                if (!pairVolInfo.isVolPos(8) && !pairVolInfo.isVolPos(256)) break block3;
                for (int okStat : SJctrReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_SI_SIMF) {
                    if (okStat != status) continue;
                    ret = true;
                    break block2;
                }
                break block2;
            }
            if (!pairVolInfo.isVolPos(0x800000)) break block2;
            for (int okStat : SJctrReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_SS) {
                if (okStat != status) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean checkPoolVolListResource(List<SJmoLocalReplicationPairVolInfo> pairsList, SJctrResourceGroupUtility rsgUty, List<SJmoPoolVolDetail> poolVolDtlList) {
        boolean rtn = false;
        if (pairsList != null && rsgUty != null && poolVolDtlList != null) {
            HashSet<Integer> selectPoolIdList = SJctrReplicationUtility.getSelectPoolId(pairsList);
            for (int selectPoolId : selectPoolIdList) {
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(selectPoolId);
                int indexNo = Collections.binarySearch(poolVolDtlList, poolIndex);
                if (indexNo < 0) {
                    rtn = false;
                    break;
                }
                SJmoPoolVolDetail poolVolDtl = poolVolDtlList.get(indexNo);
                ArrayList poolVolInfoList = poolVolDtl.getAlPoolInfo();
                if (poolVolInfoList == null || poolVolInfoList.size() == 0) {
                    rtn = false;
                    break;
                }
                List<SJmoLdevIndex> extract = rsgUty.extractLdev(poolVolInfoList);
                if (extract.size() == 0) {
                    rtn = false;
                    break;
                }
                rtn = true;
            }
        }
        return rtn;
    }

    private static HashSet<Integer> getSelectPoolId(List<SJmoLocalReplicationPairVolInfo> selectedPairsList) {
        HashSet<Integer> poolIdlist = new HashSet<Integer>();
        for (SJmoLocalReplicationPairVolInfo pairInfo : selectedPairsList) {
            if (!pairInfo.isVolPos(0x800000)) continue;
            int poolId = pairInfo.getISVolPoolId();
            poolIdlist.add(poolId);
        }
        return poolIdlist;
    }

    public String getCtgSummaryString(String ctg_num) {
        String status = " " + this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + ctg_num + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
        return status;
    }

    public String getSsgSummaryString(String maxSsgNum) {
        String status = " " + this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + maxSsgNum + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
        return status;
    }

    public String getNumOfPairTblSummaryString(SJmoLocalReplicationSummary summaryInfo) {
        String numOfPairTbl = "?";
        if (null != summaryInfo) {
            int allPairTblNum = summaryInfo.getISiAllPairTblNum();
            int remPairTblNum = summaryInfo.getISiRemainderPairTblNum();
            int pairTblNum = allPairTblNum - remPairTblNum;
            numOfPairTbl = Integer.toString(pairTblNum) + " " + this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + Integer.toString(allPairTblNum) + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
        }
        return numOfPairTbl;
    }

    public String getNumOfPairTblTiSsFcSummaryString(SJmoLocalReplicationSummary summaryInfo) {
        String numOfPairTblTiSsFc = "?";
        if (null != summaryInfo) {
            int allPairTblNumTiSsFc = summaryInfo.getIAllPairTblNum();
            int remPairTblNumTiSsFc = summaryInfo.getIRemainderPairTblNum();
            int pairTblNumTiSsFc = allPairTblNumTiSsFc - remPairTblNumTiSsFc;
            numOfPairTblTiSsFc = Integer.toString(pairTblNumTiSsFc) + " " + this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + Integer.toString(allPairTblNumTiSsFc) + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
        }
        return numOfPairTblTiSsFc;
    }

    public String getNumOfDiffTblSummaryString(SJmoLocalReplicationSummary summaryInfo) {
        String numOfDiffTbl = "?";
        if (null != summaryInfo) {
            int allDiffTblNum = summaryInfo.getIAllDiffTblNum();
            int remDiffTblNum = summaryInfo.getIRemainderDiffTblNum();
            int diffTblNum = allDiffTblNum - remDiffTblNum;
            numOfDiffTbl = Integer.toString(diffTblNum) + " " + this.guidanceHandle.getGuidance("BRACKET_LEFT") + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + Integer.toString(allDiffTblNum) + this.guidanceHandle.getGuidance("BRACKET_RIGHT");
        }
        return numOfDiffTbl;
    }

    public static List<SJmoLdevStatusInfo> getSJmoLdevStatusInfo(SJctrDataController dc) {
        List<SJmoLdevStatusInfo> info = SJctrReplicationUtility.getCache(dc, SJmoGetLdevStatusInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevStatusInfo", "Information of SJmoLdevStatusInfo is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static boolean checkLdevStatus(SJmoLdevDetail ldevDetail, List<SJmoLdevStatusInfo> ldevStatusList) {
        byte byStatus;
        int index;
        boolean rtn = false;
        if (ldevDetail != null && ldevStatusList != null && (index = Collections.binarySearch(ldevStatusList, ldevDetail)) >= 0 && (byStatus = ldevStatusList.get(index).getLDEVStatus()) != 2 && byStatus != 12) {
            rtn = true;
        }
        return rtn;
    }

    public String getSsEstManageCapacity(List<SJmoPoolSummary> poolSummaryInfoList, SJctrCapacityUtility capaUtil) {
        SJmoPoolSummary poolSummaryInfo;
        String ssEstManageCapa = "?";
        long ssEstManageCapaBlock = -1L;
        if (null != poolSummaryInfoList && poolSummaryInfoList.size() != 0 && capaUtil != null && (poolSummaryInfo = poolSummaryInfoList.get(0)) != null) {
            long tiPairSysCapaEst = poolSummaryInfo.getLDSPairSysCapaEst();
            long tiVolCapa = poolSummaryInfo.getLDSVolCapa();
            long tiEstManageCapa = tiPairSysCapaEst - tiVolCapa;
            ssEstManageCapaBlock = capaUtil.valueOf(tiEstManageCapa, SJctrCapacityUtility.UNIT.MB);
            SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(ssEstManageCapaBlock);
            String capString = capaUtil.toString(ssEstManageCapaBlock, unit);
            String unitString = capaUtil.getUnitString(unit);
            ssEstManageCapa = capString + " " + unitString;
        }
        return ssEstManageCapa;
    }

    public boolean checkSsEstManageCapacity(List<SJmoPoolSummary> poolSummaryInfoList, SJctrCapacityUtility capaUtil) {
        SJmoPoolSummary poolSummaryInfo;
        boolean ssEstManageCapIconFlg = false;
        long ssEstManageCapaBlock = -1L;
        if (null != poolSummaryInfoList && poolSummaryInfoList.size() != 0 && capaUtil != null && (poolSummaryInfo = poolSummaryInfoList.get(0)) != null) {
            long tiVolCapa;
            long ssEstManageCapThreshold = SJctrReplicationUtility.getSnapShotEstManageCapThreshold(capaUtil);
            long tiPairSysCapaEst = poolSummaryInfo.getLDSPairSysCapaEst();
            long tiEstManageCapa = tiPairSysCapaEst - (tiVolCapa = poolSummaryInfo.getLDSVolCapa());
            ssEstManageCapaBlock = capaUtil.valueOf(tiEstManageCapa, SJctrCapacityUtility.UNIT.MB);
            if (ssEstManageCapaBlock < ssEstManageCapThreshold) {
                ssEstManageCapIconFlg = true;
            }
        }
        return ssEstManageCapIconFlg;
    }

    public static long getSnapShotEstManageCapThreshold(SJctrCapacityUtility capaUtil) {
        long ret = 0L;
        long threshold = 20L;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    threshold = 12L;
                    break;
                }
                case 40: {
                    threshold = 20L;
                    break;
                }
                case 60: {
                    threshold = 20L;
                    break;
                }
                default: {
                    SJctrLogUty.error("SJctrReplicationUtility", "getSnapShotEstManageCapThreshold", "iHMKind is Unkwon.");
                    break;
                }
            }
        } else {
            SJctrLogUty.error("SJctrReplicationUtility", "getSnapShotEstManageCapThreshold", "Other than HM800.");
        }
        ret = capaUtil.valueOf(threshold, SJctrCapacityUtility.UNIT.TB);
        return ret;
    }

    public String getTopologyId(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfo pVolInfo, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?(?)";
        if (pairInfo != null && pVolInfo != null) {
            ret = pVolInfo.getPVolIndex() == null || pairInfo.isVolPos(0x800000) ? ldevUtil.toLdevDisplay(pVolInfo) + "(" + this.guidanceHandle.getGuidance("MU") + this.getMirrorUnitString(pairInfo) + ")" : ldevUtil.toLdevDisplay(pVolInfo.getPVolIndex()) + "(" + this.guidanceHandle.getGuidance("MU") + this.getMirrorUnitString(pVolInfo) + "-" + this.guidanceHandle.getGuidance("MU") + this.getMirrorUnitString(pairInfo) + ")";
        }
        return ret;
    }

    public static long getTopologyNumber(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfo pVolInfo) {
        long ret = -1L;
        if (pairInfo != null && pVolInfo != null) {
            ret = pVolInfo.getPVolIndex() == null || pairInfo.isVolPos(0x800000) ? (long)pVolInfo.getSLdkc() * 0x10000000000L + (long)pVolInfo.getSCu() * 0x100000000L + (long)pVolInfo.getSLdev() * 0x1000000L + (long)pairInfo.getSMuNum() * 4096L : (long)pVolInfo.getPVolIndex().getSLdkc() * 0x10000000000L + (long)pVolInfo.getPVolIndex().getSCu() * 0x100000000L + (long)pVolInfo.getPVolIndex().getSLdev() * 0x1000000L + (long)pVolInfo.getSMuNum() * 4096L + (long)pairInfo.getSMuNum() + 1L;
        }
        return ret;
    }

    public static SJmoThroughRmiData getRmiObject(SJctrDataController dc, SJmoGetKind_IF kind) {
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        wrapperSet.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        List<?> rmiDataList = dataMap.get(directWrapper);
        if (null == rmiDataList) {
            SJctrLogUty.error("SJctrReplicationUtility", "getRmiObject", "RMI data list is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == rmiDataList.size()) {
            SJctrLogUty.error("SJctrReplicationUtility", "getRmiObject", "RMI data list size is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)rmiDataList.get(0);
        if (null == rmiData) {
            SJctrLogUty.error("SJctrReplicationUtility", "getRmiObject", "RMI data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return rmiData;
    }

    public static boolean isCtgStatusMFReserved(List<SJctrCTGInfo> ctgInfoList) {
        boolean mfReserved = true;
        if (ctgInfoList != null && ctgInfoList.size() != 0) {
            for (SJctrCTGInfo ctgInfo : ctgInfoList) {
                if (ctgInfo.isCtgStatus((short)128) && !ctgInfo.isCtgStatus((short)64) && !ctgInfo.isCtgStatus((short)32) && !ctgInfo.isCtgStatus((short)16) && !ctgInfo.isCtgStatus((short)8) && !ctgInfo.isCtgStatus((short)4)) continue;
                mfReserved = false;
                break;
            }
        } else {
            mfReserved = false;
        }
        return mfReserved;
    }

    public static boolean isEnabledSMuNumForMirrorUnitColumn(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        boolean ret = false;
        if (pairVolInfo != null && (pairVolInfo.isVolPos(8) || pairVolInfo.isVolPos(0x800000) || pairVolInfo.isVolPos(256))) {
            ret = true;
        }
        return ret;
    }

    public static void checkLocalPairVolStatusFiconDm(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus, int copytype) {
        if (null == svolpair || null == pvolpair || null == allpair) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusFiconDm", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrReplicationUtility.checkLocalPairVolStatusFor1x1(svolpair, checkStatus, copytype);
        SJctrReplicationUtility.checkLocalPairVolStatusForShareSvolsSimf(svolpair, pvolpair, allpair, checkStatus);
    }

    public static boolean isUnusualSuspendStatusOfFiconPairList(List<SJmoLocalReplicationPairVolInfo> selectedPairsList) {
        SJmoLocalReplicationPairVolInfo pairInfo;
        if (selectedPairsList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "isUnusualSuspendStatusOfFiconPairList", "selectedPairsList is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean ret = false;
        Iterator<SJmoLocalReplicationPairVolInfo> i$ = selectedPairsList.iterator();
        while (i$.hasNext() && !(ret = SJctrReplicationUtility.isUnusualSuspendStatusOfFiconPair(pairInfo = i$.next()))) {
        }
        return ret;
    }

    public static boolean isUnusualSuspendStatusOfFiconPair(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "isUnusualSuspendStatusOfFiconPair", "pairInfo is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean ret = false;
        if (80 == pairInfo.getSPairStatus() && 0 == pairInfo.getSStatusOpt()) {
            ret = true;
        }
        return ret;
    }

    public static short changeTIPairStatus(MRCFgetTiPairInfo tiPairInfo) {
        short ret = (short)tiPairInfo.getSts();
        return ret;
    }

    public static boolean isSupportedEncryption() {
        boolean ret = false;
        ret = SJctrDataController.isHM() ? true : true;
        return ret;
    }

    public static Set<Integer> getHaReserveLdevSet(List<SJmoHUVMVirtualLdev> vLdevList) {
        HashSet<Integer> ldevSet = new HashSet<Integer>(vLdevList.size());
        for (SJmoHUVMVirtualLdev vLdev : vLdevList) {
            short huvmAttr = vLdev.getSVAttrHuvm();
            if ((huvmAttr & Short.MIN_VALUE) != Short.MIN_VALUE || (huvmAttr & 0x2000) != 8192) continue;
            ldevSet.add(vLdev.getIndex());
        }
        return ldevSet;
    }

    public static void checkTiPairMaxCountForTIPrimaryVolumes(SJctrLocalReplicationTiPvolTopTableModel topTable) {
        if (topTable == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForTIPrimaryVolume", "parameter is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Map<Class<?>, List<?>> basicDataMap = topTable.getBasicDataMap();
        List<?> pairDataList = basicDataMap.get(SJctrGetPvolSsCountInfo.class);
        if (pairDataList == null || pairDataList.isEmpty()) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForTIPrimaryVolume", "Table cache data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Map pairCountMap = (Map)pairDataList.get(0);
        List<Object> selectedRows = topTable.getSelectedRowData();
        long pairCount = 0L;
        for (SJmoTiPvolInfo sJmoTiPvolInfo : selectedRows) {
            SJctrTiReplicationUtility.SJctrPvolPairCounts entryValue = (SJctrTiReplicationUtility.SJctrPvolPairCounts)pairCountMap.get(sJmoTiPvolInfo);
            if (entryValue == null) continue;
            pairCount += entryValue.getSnapshotDataCount();
        }
        if (32768L < pairCount) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForTIPrimaryVolume", "Ti pair is max defined.");
            SJctrError err = new SJctrError(209, 22, 205161);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
    }

    public static void checkTiPairMaxCountForSnapshotGroups(SJctrLocalReplicationSsGroupTopTableModel topTable) {
        if (topTable == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForSnapshotGroups", "parameter is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Map<Class<?>, List<?>> basicDataMap = topTable.getBasicDataMap();
        List<?> pairDataList = basicDataMap.get(SJctrGetSnapshotGroupPairNum.class);
        if (pairDataList == null || pairDataList.isEmpty()) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForSnapshotGroups", "Table cache data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Map pairCountMap = (Map)pairDataList.get(0);
        List<Object> selectedRows = topTable.getSelectedRowData();
        long pairCount = 0L;
        for (SJmoSnapshotSetInfo sJmoSnapshotSetInfo : selectedRows) {
            Integer entryValue = (Integer)pairCountMap.get(sJmoSnapshotSetInfo.getISnapshotSetId());
            if (entryValue == null) continue;
            pairCount += (long)entryValue.intValue();
        }
        if (32768L < pairCount) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkTiPairMaxCountForSnapshotGroups", "Ti pair is max defined.");
            SJctrError err = new SJctrError(209, 22, 205162);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
    }

    public SJctrCreateSnapshotDataInfo getCreateSnapshotDataInfo(SJmoLdevIndex ldevIndex, Map<Class<?>, List<?>> modelData) {
        List<SJctrCreateSnapshotDataInfo> ssDataInfoList;
        SJctrCreateSnapshotDataInfo ssDataInfo = null;
        if (ldevIndex != null && modelData != null && (ssDataInfoList = modelData.get(SJctrCreateSnapshotDataInfo.class)) != null) {
            ssDataInfo = this.getCreateSnapshotDataInfo(ssDataInfoList, ldevIndex);
        }
        return ssDataInfo;
    }

    public SJctrCreateSnapshotDataInfo getCreateSnapshotDataInfo(List<SJctrCreateSnapshotDataInfo> ssDataInfoList, SJmoLdevIndex ldevIndex) {
        SJctrCreateSnapshotDataInfo ssDataInfo = null;
        if (ssDataInfoList != null && ldevIndex != null) {
            for (SJctrCreateSnapshotDataInfo ssData : ssDataInfoList) {
                if (ssData.getIndex() != ldevIndex.getIndex()) continue;
                ssDataInfo = ssData;
                break;
            }
        }
        return ssDataInfo;
    }

    public String getLayerString(SJmoLdevIndex rootLdev, SJmoLdevIndex pVol, SJmoLocalReplicationPairVolInfoMgr pairInfoMgr) {
        String ret = "?";
        if (rootLdev != null && pVol != null && pairInfoMgr != null) {
            if (rootLdev.getIndex() != pVol.getIndex()) {
                List<Object> toRootVolPairList = new ArrayList();
                toRootVolPairList = this.getCascadeTiPairListFromLeafVol(rootLdev, pVol, pairInfoMgr);
                int pairLayer = toRootVolPairList.size() + 1;
                ret = Integer.toString(pairLayer);
            } else {
                ret = Integer.toString(1);
            }
        }
        return ret;
    }

    public static SJcException convLocalReplicationLogicErrorException(SJcException e, int errCode) {
        SJcException err = e;
        if (e != null) {
            SJcMessage msgObj = e.getMsg();
            if (!msgObj.getFunctionID().equals(Integer.toString(209))) {
                return err;
            }
            if (!msgObj.getModuleID().equals(Integer.toString(22))) {
                return err;
            }
            if (!msgObj.getMsgID().equals(Integer.toString(107001))) {
                return err;
            }
        }
        err = SJctrTiReplicationUtility.makeException(errCode);
        return err;
    }

    public static boolean isDPPool(SJmoPoolDetail PoolDetail) {
        boolean bRet = true;
        if (PoolDetail.getPoolKind() == 2) {
            if (!SJctrPoolUtility.isOpenPool(PoolDetail)) {
                return false;
            }
            if ((PoolDetail.getLPoolOptionFlag() & 0x20000000L) != 0L) {
                return false;
            }
            if ((PoolDetail.getITierControlInfo() & 0x80) != 0) {
                return false;
            }
        }
        return bRet;
    }
}

