/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrUserInfoDetailUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static WeakHashMap<String, WeakReference<String>> USER_ID = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_ACCOUNT = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_ACCOUNT_SET = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_ACCOUNT_ADT = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_AUTH_SERV = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_AUTH_SERV_ADT = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_TYPE = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> USER_HIDE_PASSWORD = new WeakHashMap();

    public SJctrUserInfoDetailUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String toUserIDDisplay(SJctrUserInfoDetail userInfoDetail) {
        String userID;
        String ret = "?";
        if (userInfoDetail != null && (userID = userInfoDetail.getUserName()) != null) {
            ret = userID;
        }
        return this.getCache(ret, USER_ID);
    }

    public String toUserAuthDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            if (userInfoDetail.getAuthPtn() == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "LOCAL");
            } else if (userInfoDetail.getAuthPtn() == SJcAccountConst.INT_AUTHPTN_EXTERNAL) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "EXTERNAL");
            }
        }
        return this.getCache(ret, USER_AUTH_SERV);
    }

    public String toUserAuthAdtDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            if (userInfoDetail.getAuthPtn() == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "ADT_LOCAL");
            } else if (userInfoDetail.getAuthPtn() == SJcAccountConst.INT_AUTHPTN_EXTERNAL) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "ADT_EXT");
            }
        }
        return this.getCache(ret, USER_AUTH_SERV_ADT);
    }

    public String toUserAccountDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            ret = userInfoDetail.getEnable() ? this.guidanceHandle.getGuidance("ACCOUNT", "ACTIVE") : this.guidanceHandle.getGuidance("ACCOUNT", "LOCKED");
        }
        return this.getCache(ret, USER_ACCOUNT);
    }

    public String toUserAccountSettingDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            ret = userInfoDetail.getEnable() ? this.guidanceHandle.getGuidance("ACCOUNT", "ACTIVATE") : this.guidanceHandle.getGuidance("ACCOUNT", "LOCK");
        }
        return this.getCache(ret, USER_ACCOUNT_SET);
    }

    public String toUserAccountAdtDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            ret = userInfoDetail.getEnable() ? this.guidanceHandle.getGuidance("ACCOUNT", "ADT_ACTIVE") : this.guidanceHandle.getGuidance("ACCOUNT", "ADT_LOCKED");
        }
        return this.getCache(ret, USER_ACCOUNT_ADT);
    }

    public String toUserTypeDisplay(SJctrUserInfoDetail userInfoDetail) {
        String ret = "?";
        if (userInfoDetail != null) {
            if (userInfoDetail.getType() == SJcAccountConst.INT_USERTYPE_BUILDIN) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "BUILT_IN");
            } else if (userInfoDetail.getType() == SJcAccountConst.INT_USERTYPE_USER) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "ADD_ON");
            }
        }
        return this.getCache(ret, USER_TYPE);
    }

    public String toLoginUserNumDisplay(SJctrUserInfoDetail userInfoDetail) {
        int iLoginUserNum;
        String ret = "?";
        if (userInfoDetail != null && (iLoginUserNum = userInfoDetail.getLoginUserNum()) >= 0) {
            ret = Integer.toString(iLoginUserNum);
        }
        return ret;
    }

    public String toHidePasswordDisplay(SJctrUserInfoDetail userInfoDetail) {
        String strPass;
        String ret = "?";
        if (userInfoDetail != null && (strPass = userInfoDetail.getPassword()) != null) {
            String chgStr = "*";
            ret = strPass.replaceAll(".", chgStr);
        }
        return this.getCache(ret, USER_HIDE_PASSWORD);
    }

    public String toUserGrpNumDisplay(SJctrUserInfoDetail userInfoDetail) {
        int iUserGrpNum;
        String ret = "?";
        if (userInfoDetail != null && (iUserGrpNum = userInfoDetail.getUserGrpNum()) >= 0) {
            ret = Integer.toString(iUserGrpNum);
        }
        return ret;
    }
}

