/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.SJctrGetColumnIconCellObject;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrPgCapExpantioRateColumnFromPoolLdevDetail
extends SJctrColumn
implements SJctrGetColumnIconCellObject.SJctrColumnGetIconIdIF {
    private int iconId = 12295;
    private Map<String, Integer> numMap = null;
    private Map<String, Integer> poolPGExpantionRateMap = null;
    private final int INVALID_VALUE = -1;

    public SJctrPgCapExpantioRateColumnFromPoolLdevDetail(String key) {
        super(key);
        this.setPartsId("PHYSICAL_PG_CAP_EXP_RATE");
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        if (this.poolPGExpantionRateMap == null) {
            int rowCount = this.getTable().getRowCount();
            this.poolPGExpantionRateMap = new HashMap<String, Integer>(rowCount);
        }
        SJctrPoolLdevDetail poolLdevDtl = (SJctrPoolLdevDetail)index;
        List<?> poolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        List<SJmoPoolVolDetail> poolVolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        List<SJmoLdevDetail> ldevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        List<SJmoPgDetail> pgDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        List<SJmoVdevDetail> vdevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> scPglList = basicData.get(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        int pgExpantionRate = -1;
        ArrayList<Integer> retList = new ArrayList<Integer>();
        int poolVolIconid = 12295;
        SJmoPoolDetail poolDtl = poolLdevDtl.getPoolDetail();
        SJmoLdevDetail ldevDtl = poolLdevDtl.getLdevDetail();
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(ldevDtl.getIFB4());
        pgIndex.setPG(ldevDtl.getIPG());
        String poolPgKey = this.getPoolPGKey(poolDtl, pgIndex);
        Integer getValue = this.poolPGExpantionRateMap.get(poolPgKey);
        if (getValue == null) {
            Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap = SJctrPoolUtility.makePGPoolVolMapOnPg(poolDtl, poolVolDtlList, ldevDtlList, pgDtlList, scPglList, pgIndex);
            if (pgPoolVolMap.isEmpty()) {
                this.setIconId(poolVolIconid);
                return Collections.emptyList();
            }
            SJmoPgDetail pgDtl = (SJmoPgDetail)pgPoolVolMap.keySet().toArray()[0];
            if (SJctrPoolUtility.checkNF2KPG(pgDtl)) {
                List<SJmoPoolVolInfo> pgPoolVolList = pgPoolVolMap.get(pgDtl);
                List<SJmoVdevDetail> scVdevDtlList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, scPglList);
                pgExpantionRate = SJctrPoolUtility.getPGExpantionRate(poolDtl, scVdevDtlList, pgPoolVolList);
            }
            this.poolPGExpantionRateMap.put(poolPgKey, pgExpantionRate);
        } else {
            pgExpantionRate = getValue;
        }
        if (0 < pgExpantionRate) {
            poolVolIconid = SJctrPoolUtility.getPGPoolCapExpantionRateIconId(poolDtl, pgExpantionRate);
        }
        this.setIconId(poolVolIconid);
        retList.add(pgExpantionRate);
        return retList;
    }

    private String getPoolPGKey(SJmoPoolIndex poolIndex, SJmoPgIndex pgIndex) {
        StringBuffer buf = new StringBuffer();
        buf.append(poolIndex.toString());
        buf.append(pgIndex.toString());
        return buf.toString();
    }

    @Override
    public String toDispString(List<?> dataList) {
        if (this.numMap == null) {
            int rowCount = this.getTable().getRowCount();
            this.numMap = new HashMap<String, Integer>(rowCount);
        }
        String ret = "?";
        if (!dataList.isEmpty()) {
            int pgExpantionRate = (Integer)dataList.get(0);
            if (pgExpantionRate < 0) {
                ret = "-";
            } else {
                SJctrComUtility comUtil = this.getTable().getComUtility();
                ret = SJctrComUtility.toDecString(pgExpantionRate);
            }
            this.numMap.put(ret, pgExpantionRate);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = -2L;
        String strNum = this.getString(dat);
        Integer value = this.numMap.get(strNum);
        if (value != null) {
            ret = value.intValue();
        }
        return ret;
    }

    @Override
    public void setIconId(int iconId) {
        this.iconId = iconId;
    }

    @Override
    public int getIconId() {
        return this.iconId;
    }
}

