/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolTotalFMCCapacityColumnFromPoolDetail
extends SJctrCapacityColumn {
    public SJctrPoolTotalFMCCapacityColumnFromPoolDetail(String key) {
        super(key);
        this.setPartsId("TOTAL");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetPoolDetail.class);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && !dataList.isEmpty()) {
            Object objPoolDTL = dataList.get(0);
            if (objPoolDTL != null && objPoolDTL instanceof SJmoPoolDetail) {
                SJmoPoolDetail poolDTL = (SJmoPoolDetail)objPoolDTL;
                String strClmUnit = this.getUnitSelect();
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                strRtn = poolUtl.toPoolFMCTotalCapacityDisplay(poolDTL, strClmUnit, comUtl);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "objPoolDTL = " + objPoolDTL);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList = " + dataList);
        }
        return strRtn;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = this.getPageNumber(dat);
        if (ret >= 0L) {
            SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            int iEmulation = poolDetail.getEmulationType();
            iEmulation = poolUtl.changeEmulationType(iEmulation);
            long lPoolPageSize = poolDetail.getPageSize();
            long lPoolCapa = ret * lPoolPageSize;
            ret = capaUtil.valueOf(lPoolCapa, SJctrCapacityUtility.UNIT.KB, iEmulation);
        }
        return ret;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        if (poolDetail == null) {
            return -2L;
        }
        if (0L == poolDetail.getLPoolFmcActualPages()) {
            return SJctrPoolUtility.HAIFUN_NUM;
        }
        int iEmulation = poolDetail.getEmulationType();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        if (iEmulation == 0 && clmUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
            return SJctrPoolUtility.HAIFUN_NUM;
        }
        return poolDetail.getLPoolFmcLogicalPages();
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long ret = this.getNumber(dat);
        if (ret >= 0L) {
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
            int iEmulation = poolDetail.getEmulationType();
            iEmulation = poolUtl.changeEmulationType(iEmulation);
            ret = capaUtil.toCylValue(ret, iEmulation);
        }
        return ret;
    }
}

