/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrUuidColumnFromLdevDetail;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;

public class SJctrUuidColumnFromPortLunTableKey
extends SJctrUuidColumnFromLdevDetail {
    private SJmoHostGroupInfo hostGroupInfo = null;

    public SJctrUuidColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.setLabel(util.getGuidance("UUID"));
        super.initGuidance(util);
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoLdevUuidInfo> list = new ArrayList<SJmoLdevUuidInfo>();
        SJmoLdevUuidInfo ldevUuidInfo = null;
        SJctrPortLunTableKey ptLunInfo = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail ptLunDeteil = ptLunInfo.getPortLunDetail();
        List<?> ldevUuidInfoList = modelData.get(SJmoLdevUuidInfo.class);
        Collections.sort(ldevUuidInfoList);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setLdevIndex(ptLunDeteil.getSLDKC(), ptLunDeteil.getSCU(), ptLunDeteil.getSLDEV());
        int devIndex = Collections.binarySearch(ldevUuidInfoList, ldevIndex);
        if (devIndex >= 0) {
            ldevUuidInfo = (SJmoLdevUuidInfo)ldevUuidInfoList.get(devIndex);
            list.add(ldevUuidInfo);
        }
        List<?> ldevHgList = modelData.get(SJmoHostGroupInfo.class);
        this.hostGroupInfo = (SJmoHostGroupInfo)ldevHgList.get(0);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        if (dataList.size() == 0) {
            return util.toUuidDisplay(null);
        }
        SJmoLdevUuidInfo uuidInfo = (SJmoLdevUuidInfo)dataList.get(0);
        if (uuidInfo != null && !util.isOpenVMSBit(uuidInfo, this.hostGroupInfo) && !uuidInfo.getStrUuid().equals("")) {
            return "-";
        }
        return util.toUuidDisplay(uuidInfo);
    }
}

