/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrVVolCapacityUsedRatioColumnFromLdevDetailColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrVVolCapacityUsedRatioColumnFromPortLunTableKey
extends SJctrVVolCapacityUsedRatioColumnFromLdevDetailColumn {
    private Map<Object, Object> modelDataMap = null;

    public SJctrVVolCapacityUsedRatioColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        int ldevDetailIndex;
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>();
        SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail portLuDetail = tableKey.getPortLunDetail();
        List<?> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setSLdkc(portLuDetail.getSLDKC());
        ldevIndex.setSCu(portLuDetail.getSCU());
        ldevIndex.setSLdev(portLuDetail.getSLDEV());
        if (this.modelDataMap == null) {
            this.modelDataMap = new HashMap<Object, Object>(this.getTable().getRowCount());
        }
        if ((ldevDetailIndex = Collections.binarySearch(ldevDetailList, ldevIndex)) >= 0) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevDetailIndex);
            if (ldevDetail.getbAouVvol()) {
                List<?> dpvolList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
                int dpVolDetailIndex = Collections.binarySearch(dpvolList, ldevDetail);
                if (dpVolDetailIndex >= 0) {
                    SJmoHDPRelation hdpRelData = (SJmoHDPRelation)dpvolList.get(dpVolDetailIndex);
                    retList.add(hdpRelData);
                    this.modelDataMap.put(index, hdpRelData);
                }
            } else {
                retList.add(ldevDetail);
                this.modelDataMap.put(index, ldevDetail);
            }
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && dataList.size() != 0) {
            Object toDispData = dataList.get(0);
            if (toDispData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)toDispData;
                String strUnit = this.getTable().getUnitMenu();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                strRtn = this.getTable().getComUtility().getPoolUtility().toLUNVVolUsedCapacityRatioDisplay(hdpRelData, strUnit, comUtil);
            } else if (toDispData instanceof SJmoLdevDetail) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lUsedPages = 0L;
        long lUsedCap = 0L;
        long lTotalCap = 0L;
        long lRatio = -2L;
        int iLdevEmu = 0;
        SJctrComUtility comUtil = this.getTable().getComUtility();
        SJctrPoolUtility poolUtil = comUtil.getPoolUtility();
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                String strUnit = this.getTable().getUnitMenu();
                SJctrCapacityUtility.UNIT selCapaUnit = SJctrCapacityUtility.UNIT.valueOf(strUnit);
                iLdevEmu = poolUtil.changeEmulationType(hdpRelData.getIEmulationType());
                if (selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                    lUsedCap = hdpRelData.getLUsedpage() + hdpRelData.getLReservedPage();
                    lTotalCap = poolUtil.getPages(iLdevEmu, hdpRelData.getLTotalCapaLBA(), comUtil);
                } else {
                    lUsedPages = hdpRelData.getLUsedpage() + hdpRelData.getLReservedPage();
                    lUsedCap = lUsedPages * hdpRelData.getLPageCapa();
                    lTotalCap = hdpRelData.getLDPVolCapa();
                }
                if (lUsedCap >= 0L && lTotalCap > 0L && (lRatio = poolUtil.getNumRatio(lUsedCap, lTotalCap)) < 0L) {
                    lRatio = -2L;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRatio = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRatio;
    }
}

