/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrVlanIdColumnFromPortDetail
extends SJctrColumn {
    public SJctrVlanIdColumnFromPortDetail(String key) {
        super(key);
        this.setPartsId("VLAN_NAME");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPortDetail portInfo = (SJmoPortDetail)this.getPrimaryKeyObject(dat);
        if (SJctrPortUtility.isIscsiPort(portInfo) && portInfo.getBAvailableVlanTagging()) {
            return portInfo.getIVlanId();
        }
        return -1L;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortDetail portInfo = (SJmoPortDetail)dataList.get(0);
        if (SJctrPortUtility.isIscsiPort(portInfo) && portInfo.getBAvailableVlanTagging()) {
            if (portInfo.getIVPortMode() == 1) {
                return SJctrPortUtility.STR_HYPHEN;
            }
            return String.valueOf(portInfo.getIVlanId());
        }
        return SJctrPortUtility.STR_HYPHEN;
    }
}

