/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrRemoteLunIdColumnFromUrPairVolInfo
extends SJctrColumn {
    private boolean bDecDisplay = false;

    public SJctrRemoteLunIdColumnFromUrPairVolInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LUN_ID"));
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrRemoteReplicationUtility.isLunDec(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String format = "^([0-9A-Fa-f]{1,4})$";
        if (this.bDecDisplay) {
            format = "^\\d{1,19}$";
        }
        return format;
    }

    @Override
    public long getNumber(Map<String, Object> dat) {
        SJmoUniversalReplicatorPairVolInfo tblData = (SJmoUniversalReplicatorPairVolInfo)this.getPrimaryKeyObject(dat);
        long number = -1L;
        if (tblData != null && SJctrRemoteReplicationUtility.isOpen(tblData)) {
            if (SJctrRemoteReplicationUtility.isPvol(tblData)) {
                number = tblData.getPVolLuPath().getLuPath().getILUN();
            } else if (SJctrRemoteReplicationUtility.isSvol(tblData)) {
                number = tblData.getSVolLuPath().getLuPath().getILUN();
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getNumber", "Pair position is invalid.");
            }
        }
        return number;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoUniversalReplicatorPairVolInfo pairInfo = (SJmoUniversalReplicatorPairVolInfo)dataList.get(0);
        SJctrRemoteReplicationUtility replicaUty = this.getTable().getComUtility().getRemoteReplicationUtility();
        return replicaUty.getUrLunIdString(pairInfo, this.bDecDisplay);
    }
}

