/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSVolItNameColumnFromPairVolInfo
extends SJctrColumn {
    Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap;

    public SJctrSVolItNameColumnFromPairVolInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("ISCSI_TARGET_NAME"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortIscsiTargetInfo.class);
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJmoIscsiTargetInfo> retList = new ArrayList<SJmoIscsiTargetInfo>();
        SJmoLocalReplicationPairVolInfo pairVolInfo = (SJmoLocalReplicationPairVolInfo)index;
        if (pairVolInfo.isVolPos(256)) {
            return retList;
        }
        SJmoLdevIndex pairVol = this.getTargetVolume(pairVolInfo);
        this.ldevLUPathInfoMap = (Map)basicData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        List<SJmoPortLunDetail> portLunDtlList = this.ldevLUPathInfoMap.get(SJctrReplicationUtility.getLdevIndexKey(pairVol));
        if (portLunDtlList != null && portLunDtlList.size() > 0) {
            SJmoPortLunDetail portLunDtl = portLunDtlList.get(0);
            List<?> portDetailList = basicData.get(SJmoGetPortDetail.class);
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portLunDtl);
            if (portDetail != null) {
                if (SJctrRsgUtility.isIscsiPort(portDetail)) {
                    SJmoIscsiTargetInfo iscsiInfo = null;
                    List<?> portIscsiList = basicData.get(SJmoGetPortIscsiTargetInfo.class);
                    SJmoPortIscsiTargetInfo portIscsiInfo = (SJmoPortIscsiTargetInfo)SJctrRsgUtility.getPortInfoByPortIndex(portIscsiList, portLunDtl);
                    if (portIscsiInfo != null) {
                        ArrayList<SJmoIscsiTargetInfo> iscsiList = portIscsiInfo.getAlPortIscsiTarget();
                        for (SJmoIscsiTargetInfo iscsiData : iscsiList) {
                            if (iscsiData.getSIscsiTarget() != portLunDtl.getSHostGroup()) continue;
                            iscsiInfo = iscsiData;
                            break;
                        }
                        retList.add(iscsiInfo);
                    } else {
                        retList.add(null);
                    }
                } else if (!SJctrRsgUtility.isFibrePort(portDetail)) {
                    retList.add(null);
                }
            } else {
                retList.add(null);
            }
        } else {
            SJmoIscsiTargetInfo iscsiInfo = new SJmoIscsiTargetInfo();
            iscsiInfo.setStrIscsiTargetName("");
            retList.add(iscsiInfo);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList.size() == 0) {
            ret = "-";
        } else {
            Object rowData = dataList.get(0);
            if (rowData != null && rowData instanceof SJmoIscsiTargetInfo) {
                ret = SJctrIscsiUtility.getIscsiTargetNameString((SJmoIscsiTargetInfo)rowData);
            }
        }
        return ret;
    }

    protected SJmoLdevIndex getTargetVolume(SJmoLocalReplicationPairVolInfo volData) {
        return volData;
    }
}

