/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;

public class SJctrVirtualPortIDColumnFromReplicaRcuPathInfo
extends SJctrColumn {
    protected Map<String, Integer> stVPortIDMap = null;

    public SJctrVirtualPortIDColumnFromReplicaRcuPathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("VIRTUAL_PORT_ID"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        if (this.stVPortIDMap == null) {
            this.stVPortIDMap = new HashMap<String, Integer>();
        }
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>();
        SJmoRemoteReplicationRCUPathInfo rcuPathInfo = (SJmoRemoteReplicationRCUPathInfo)index;
        List<?> portDtlList = modelData.get(SJmoGetPortDetail.class);
        int localPortIndex = Collections.binarySearch(portDtlList, rcuPathInfo);
        SJmoPortDetail portDtl = null;
        if (localPortIndex >= 0) {
            portDtl = (SJmoPortDetail)portDtlList.get(localPortIndex);
        }
        retList.add(portDtl);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        int iVPortID = -1;
        SJmoPortDetail portDtl = (SJmoPortDetail)dataList.get(0);
        if (portDtl != null) {
            if (portDtl.getIVPortMode() == 1) {
                ret = "0";
                iVPortID = 0;
            } else {
                ret = "-";
            }
        }
        this.stVPortIDMap.put(ret, iVPortID);
        return ret;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int iVPortID = -1;
        String strNum = this.getString(dat);
        if (this.stVPortIDMap.containsKey(strNum)) {
            iVPortID = this.stVPortIDMap.get(strNum);
        }
        return this.stVPortIDMap.get(strNum).intValue();
    }
}

