/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.thinimage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationTiPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSVolEncryptionColumnFromTiPairInfo
extends SJctrColumn {
    public SJctrSVolEncryptionColumnFromTiPairInfo(String key) {
        super(key);
        this.setSupportColumn(SJctrReplicationUtility.isSupportedEncryption());
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("ENCRYPTION"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        SJmoLocalReplicationTiPairVolInfo info = (SJmoLocalReplicationTiPairVolInfo)index;
        SJmoLdevIndex svolIndex = info.getsVolIndex();
        ArrayList<SJmoLdevDetail> needList = new ArrayList<SJmoLdevDetail>();
        if (svolIndex != null) {
            short ldkc = svolIndex.getSLdkc();
            short cu = svolIndex.getSCu();
            short ldev = svolIndex.getSLdev();
            if (ldkc == -1 && cu == -1 && ldev == -1) {
                needList = null;
            } else {
                List<?> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
                int ldevDetailTargetIndex = Collections.binarySearch(ldevDetailList, svolIndex);
                if (0 <= ldevDetailTargetIndex) {
                    SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevDetailTargetIndex);
                    needList.add(ldevDetail);
                }
            }
        }
        return needList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList == null) {
            ret = "";
        } else if (!dataList.isEmpty()) {
            Object object = dataList.get(0);
            SJmoLdevDetail info = (SJmoLdevDetail)object;
            SJctrComUtility utility = this.getTable().getComUtility();
            SJctrLdevUtility util = utility.getLdevUtility();
            ret = util.toEncryptionDisplay(info);
        }
        return ret;
    }
}

