/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;

public class SJctrParityGroupIDColumnFromExdVolumeInfo
extends SJctrColumn {
    public SJctrParityGroupIDColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("AG_ID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)dataList.get(0);
        int fb4 = volumeInfo.getRmiExdVolumeInfo().getIFB4();
        int pg = volumeInfo.getRmiExdVolumeInfo().getIPG();
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        return util.toArrayGroupDisplay(fb4, pg);
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                SJmoExdVolumeInfo vol1 = (SJmoExdVolumeInfo)o1;
                SJmoExdVolumeInfo vol2 = (SJmoExdVolumeInfo)o2;
                EXDExternalVolume extVol1 = vol1.getRmiExdVolumeInfo();
                EXDExternalVolume extVol2 = vol2.getRmiExdVolumeInfo();
                return extVol1.compareTo(extVol2);
            }
        };
    }
}

