/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDVolumeStatus;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.column.uvm.SJctrStatusColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdStatusInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdStatusInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdStatusInfoMgr;

public class SJctrVolStatusColumnFromExdVolumeInfo
extends SJctrStatusColumn {
    public SJctrVolStatusColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("STATUS");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExdStatusInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Number> list = new ArrayList<Number>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        int extVolumeId = volumeInfo.getRmiExdVolumeInfo().getExternalVolumeID();
        SJmoExdStatusInfoMgr exdStatusMgr = (SJmoExdStatusInfoMgr)modelData.get(SJmoGetExdStatusInfoMgr.class).get(0);
        SJmoExdStatusInfo exdStatusInfo = exdStatusMgr.getExdStatusInfo(extVolumeId);
        EXDVolumeStatus volStatus = exdStatusInfo.getRmiExdStatusInfo().getVolumeStatus();
        int status = volStatus.getStatus();
        byte destageprogress = volStatus.getDestageProgress();
        list.add(status);
        list.add(destageprogress);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        Integer status = (Integer)dataList.get(0);
        Byte progress = (Byte)dataList.get(1);
        SJctrExtUtility util = this.getTable().getComUtility().getExtUtility();
        String strStatus = util.getStatusDisplay(status, progress.byteValue());
        return strStatus;
    }
}

