/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.comparator.uvm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;

public class SJctrExdPhysicalPathPortWWNComparator
implements Comparator<Object> {
    private SJmoExdTargetPortInfoMgr targetPortMgr = null;
    private HashMap<SJmoExdPhysicalPathInfo, String> pathWWNMap = null;

    public SJctrExdPhysicalPathPortWWNComparator(SJmoExdTargetPortInfoMgr targetPortMgr) {
        this.targetPortMgr = targetPortMgr;
        ArrayList targetPortList = targetPortMgr.getAlExdTargetPortInfo();
        this.pathWWNMap = new HashMap(targetPortList.size());
    }

    @Override
    public int compare(Object o1, Object o2) {
        int portId2;
        int ret = 0;
        SJmoExdPhysicalPathInfo pathInfo1 = (SJmoExdPhysicalPathInfo)o1;
        SJmoExdPhysicalPathInfo pathInfo2 = (SJmoExdPhysicalPathInfo)o2;
        int portId1 = pathInfo1.getRmiExdPhysicalPathInfo().referInitiatorPortId();
        ret = portId1 - (portId2 = pathInfo2.getRmiExdPhysicalPathInfo().referInitiatorPortId());
        if (ret == 0) {
            String wwn1 = this.getWWN(pathInfo1);
            String wwn2 = this.getWWN(pathInfo2);
            ret = wwn1.compareTo(wwn2);
        }
        return ret;
    }

    private String getWWN(SJmoExdPhysicalPathInfo physicalPathInfo) {
        String ret = "";
        String wwn = this.pathWWNMap.get(physicalPathInfo);
        if (wwn == null) {
            int targetPortId = physicalPathInfo.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPortInfo = this.targetPortMgr.getExdTargetPortInfo(targetPortId);
            if (targetPortInfo != null) {
                ret = targetPortInfo.getRmiExdTargetPortInfo().getDispTargetPortAddress();
            }
            this.pathWWNMap.put(physicalPathInfo, ret);
        } else {
            ret = wwn;
        }
        return ret;
    }
}

