/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.rsg.rsgs;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.account.rsg.rsgs.SJctrRsgIdSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrRsgSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_COM_PG_NUM = "COM_PG_NUM";
    public static final String KEY_COM_LDEV_NUM = "COM_LDEV_NUM";
    public static final String KEY_COM_PT_NUM = "COM_PT_NUM";
    public static final String KEY_COM_HG_NUM = "COM_HG_NUM";
    public static final String KEY_COM_ISCSI_NUM = "COM_ISCSI_TARGETS_NUM";
    public static final String KEY_COM_V_STORAGE_SYSTEM = "COM_V_STORAGE_SYSTEM";

    @Override
    public void makeDataObject() {
        List<SJmoHUVMVirtualDkc> vDkcList;
        List<SJmoPortDetail> portDetailList;
        List<SJmoLdevLuseInfo> luseList;
        List<SJmoPgScatteredInfo> pgStList;
        List<?> allRsgsList = this.getBasicDataMap().get(SJmoGetRSGgetAllRsgs.class);
        SJmoRSGgetAllRsgs allRsgs = null;
        if (null == allRsgsList) {
            this.logUty.putlog("getBasicDataList", "Information of SJmoRSGgetAllRsgs is null.");
        } else if (0 == allRsgsList.size()) {
            this.logUty.putlog("getBasicDataList", "Size of SJmoRSGgetAllRsgs data list is zero.");
        } else {
            allRsgs = (SJmoRSGgetAllRsgs)allRsgsList.get(0);
            if (null == allRsgs) {
                this.logUty.putlog("getBasicDataList", "Information of SJmoRSGgetRsg is null.");
            }
        }
        SJmoRSGInfo rsgInfo = ((SJctrRsgIdSelectDC)this.getDataController()).getRsgInfo();
        SJmoRSGgetRsg rscs = null;
        if (allRsgs != null) {
            rscs = SJctrRsgUtility.getRsgInfoByRsgId(rsgInfo.getRsgId(), allRsgs.getRsgs());
        }
        if (null == (pgStList = this.getBasicDataMap().get(SJmoGetPgScatteredInfo.class))) {
            pgStList = new ArrayList();
        }
        if (null == (luseList = this.getBasicDataMap().get(SJmoGetLdevLuseInfo.class))) {
            luseList = new ArrayList();
        }
        if (null == (portDetailList = this.getBasicDataMap().get(SJmoGetPortDetail.class))) {
            portDetailList = new ArrayList();
        }
        if (null == (vDkcList = this.getBasicDataMap().get(SJmoGetHUVMVirtualDkc.class))) {
            vDkcList = new ArrayList();
        }
        Object summaryData = this.getManageData();
        String rsgPgCount = this.getComUtility().getRsgUtility().getNumOfPgs(rscs, pgStList);
        ((SJctrDataObject)summaryData).setData(KEY_COM_PG_NUM, rsgPgCount);
        String rsgLdevCount = this.getComUtility().getRsgUtility().getNumOfLdevs(rscs, luseList);
        ((SJctrDataObject)summaryData).setData(KEY_COM_LDEV_NUM, rsgLdevCount);
        String rsgPtCount = this.getComUtility().getRsgUtility().getNumOfPorts(rscs);
        ((SJctrDataObject)summaryData).setData(KEY_COM_PT_NUM, rsgPtCount);
        String rsgHgCount = this.getComUtility().getRsgUtility().getNumOfHostGroups(rscs, portDetailList);
        ((SJctrDataObject)summaryData).setData(KEY_COM_HG_NUM, rsgHgCount);
        String rsgIscsiCount = this.getComUtility().getRsgUtility().getNumOfIscsiTargets(rscs, portDetailList);
        ((SJctrDataObject)summaryData).setData(KEY_COM_ISCSI_NUM, rsgIscsiCount);
        String rsgDkc = this.getComUtility().getRsgUtility().getModelSerialNumberStringFromRsgInfo(rsgInfo, vDkcList);
        ((SJctrDataObject)summaryData).setData(KEY_COM_V_STORAGE_SYSTEM, rsgDkc);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgScatteredInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }
}

