/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.alert.com;

import sanproject.serverux.dataimpl.DISKgetErrorLogInfoEx;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrAlertUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static final int STATUS_BIT_SHIFT = 4;
    private static final int STATUS_COMPLETED = 1;
    private static final int ERRORLEVEL_MASK = 15;
    private static final int REF_CODE_BEGIN_INDEX = 0;
    private static final int REF_CODE_END_INDEX = 4;
    private static final int MASK_INDEX_DEFAULT = 1;
    private static final int MASK_INDEX_END = 2;
    private static final String MASK_KEY_X = "X";
    private static final String[] SIM_LOCATION_TARGET_CODE = new String[]{"602FFE", "602FFF", "623FFE"};
    private static final int SIM_LOCATION_SPLIT_NUM = 3;
    private static final String SIM_LOCATION_SPLIT_STR = "%";
    private static final String DECIMAL_FORMAT = "d";
    private static final String HEX_FORMAT = "x";
    private static final String STRING_FORMAT = "s";
    public static final int SIM_ERROR_LEVEL_ACUTE = 2;
    public static final int SIM_ERROR_LEVEL_SERIOUS = 3;
    public static final int SIM_ERROR_LEVEL_MODERATE = 4;
    public static final int SIM_ERROR_LEVEL_SERVICE = 5;
    public static final String HEX_HEADER = "0x";
    private static final String LEFT_KAKKO = "(";
    private static final String RIGHT_KAKKO = ")";
    private static final String HALF_SPACE = " ";
    private static final String STR_DEFAULT = "";
    public static final int INT_DEFAULT = 0;
    public static final String STR_SLASH = "/";
    private static final String STR_HYPHEN = "-";
    private static final int LOCATION_SPILT_ONE = 0;
    private static final int LOCATION_SPILT_TWO = 1;
    private static final int LOCATION_SPILT_THREE = 2;
    private static final int NUM_HEXADECIMAL = 16;
    private static final int MAX_BIT = 32;
    private static final int CALC_BIT_ONE = 1;
    private static final int LOCATION_DRIVE_LENGTH = 2;
    private int HIGH_BIT_START = 5;
    private int HIGH_BIT_END = 11;
    private int LOW_BIT_START = 0;
    private int LOW_BIT_END = 4;
    private static final int HM_HIGH_BIT_START = 6;
    private static final int HM_HIGH_BIT_END = 11;
    private static final int HM_LOW_BIT_START = 0;
    private static final int HM_LOW_BIT_END = 5;
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final int LIST_SIZE_EMPTY = 0;
    public static final int ERROR_SECTION = 0;
    public static final int ERROR_DETAIL = 1;
    public static final int LOCATION = 2;

    public SJctrAlertUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
        this.changeMacro();
    }

    private void changeMacro() {
        if (SJctrControllerManager.isHM()) {
            this.HIGH_BIT_START = 6;
            this.HIGH_BIT_END = 11;
            this.LOW_BIT_START = 0;
            this.LOW_BIT_END = 5;
        }
    }

    public boolean isCompleted(DISKgetErrorLogInfoEx errorInfo) {
        boolean result = false;
        int iCompFlg = errorInfo.nEventLevel >>> 4;
        if (iCompFlg == 1) {
            result = true;
        }
        return result;
    }

    public String toDispStatus(DISKgetErrorLogInfoEx errorInfo) {
        String result = null;
        result = this.isCompleted(errorInfo) ? this.guidanceHandle.getGuidance("SIM_COMPLETED") : this.guidanceHandle.getGuidance("SIM_UNCOMPLETED");
        return result;
    }

    public int getErrorLevel(DISKgetErrorLogInfoEx errorInfo) {
        return errorInfo.nEventLevel & 0xF;
    }

    public String toDispErrorLevel(DISKgetErrorLogInfoEx errorInfo) {
        String result = null;
        int errorLevelMask = this.getErrorLevel(errorInfo);
        switch (errorLevelMask) {
            case 2: {
                result = this.guidanceHandle.getGuidance("ACUTE");
                break;
            }
            case 3: {
                result = this.guidanceHandle.getGuidance("SERIOUS");
                break;
            }
            case 4: {
                result = this.guidanceHandle.getGuidance("MODERATE");
                break;
            }
            case 5: {
                result = this.guidanceHandle.getGuidance("SERVICE");
                break;
            }
            default: {
                result = this.guidanceHandle.getGuidance("UNKNOWN") + LEFT_KAKKO + HEX_HEADER + errorLevelMask + RIGHT_KAKKO;
                SJctrLogUty.warn(SJctrAlertUtility.class.getSimpleName(), "toDispErrorLevel", "ErrorLevel : " + errorLevelMask);
            }
        }
        return result;
    }

    public String toDispDate(DISKgetErrorLogInfoEx errorInfo) {
        return errorInfo.strEventListDate + HALF_SPACE + errorInfo.strEventListTime;
    }

    public String toDispErrorCode(DISKgetErrorLogInfoEx errorInfo) {
        return errorInfo.strEventListREFCODE;
    }

    public static int getErrorLevelIcon(DISKgetErrorLogInfoEx errorInfo) {
        int iconID = 0;
        int errorLevelMask = errorInfo.nEventLevel & 0xF;
        switch (errorLevelMask) {
            case 2: {
                iconID = 12293;
                break;
            }
            case 3: {
                iconID = 12292;
                break;
            }
            case 4: {
                iconID = 12291;
                break;
            }
            case 5: {
                iconID = 12290;
                break;
            }
            default: {
                iconID = 12294;
                SJctrLogUty.warn(SJctrAlertUtility.class.getSimpleName(), "getErrorLevelIcon", "ErrorLevel : " + errorLevelMask);
            }
        }
        return iconID;
    }

    public String[] getDetail(DISKgetErrorLogInfoEx errorInfo) {
        String detailGuidance;
        String refCode = errorInfo.strEventListREFCODE;
        String refCodeKey = refCode.substring(0, 4);
        String simSectionKey = this.guidanceHandle.getGuidance("ALERT", "DEV_HEA_SIM_SECTION");
        String simDetailKey = this.guidanceHandle.getGuidance("ALERT", "DEV_HEA_SIM_DETAIL");
        String simLocationKey = this.guidanceHandle.getGuidance("ALERT", "DEV_HEA_SIM_LOCATION");
        simSectionKey = simSectionKey + refCodeKey;
        simDetailKey = simDetailKey + refCodeKey;
        simLocationKey = simLocationKey + refCodeKey;
        String sectionGuidance = this.guidanceHandle.getGuidance("ALERT", simSectionKey);
        if (sectionGuidance.equals("N/A") && (sectionGuidance = this.maskGuidanceKey(simSectionKey)).equals("N/A")) {
            sectionGuidance = this.guidanceHandle.getGuidance("ALERT", "DEV_HEA_LBL_NOERRORSECTION");
        }
        if ((detailGuidance = this.guidanceHandle.getGuidance("ALERT", simDetailKey)).equals("N/A") && (simDetailKey = this.getMaskGuidanceKey(simDetailKey)).length() == 0) {
            simDetailKey = "DEV_HEA_LBL_NOERRORDETAIL";
        }
        simDetailKey = "ALERT/" + simDetailKey;
        String locationGuidance = this.guidanceHandle.getGuidance("ALERT", simLocationKey);
        if (locationGuidance.equals("N/A") && (locationGuidance = this.maskGuidanceKey(simLocationKey)).equals("N/A")) {
            locationGuidance = STR_HYPHEN;
        }
        if (!locationGuidance.equals(STR_HYPHEN)) {
            locationGuidance = this.getLocation(locationGuidance, refCode);
        }
        String[] resultList = new String[]{sectionGuidance, simDetailKey, locationGuidance};
        return resultList;
    }

    public String maskGuidanceKey(String guidanceKey) {
        String resultGuidance = STR_DEFAULT;
        String strMaskX = STR_DEFAULT;
        for (int index = 1; index <= 2; ++index) {
            strMaskX = strMaskX.concat(MASK_KEY_X);
            String maskKey = guidanceKey.substring(0, guidanceKey.length() - index);
            resultGuidance = this.guidanceHandle.getGuidance("ALERT", maskKey = maskKey.concat(strMaskX));
            if (!resultGuidance.equals("N/A")) break;
        }
        return resultGuidance;
    }

    public String getMaskGuidanceKey(String guidanceKey) {
        String resultGuidance = STR_DEFAULT;
        String strMaskX = STR_DEFAULT;
        String maskKey = STR_DEFAULT;
        for (int index = 1; index <= 2; ++index) {
            strMaskX = strMaskX.concat(MASK_KEY_X);
            maskKey = guidanceKey.substring(0, guidanceKey.length() - index);
            resultGuidance = this.guidanceHandle.getGuidance("ALERT", maskKey = maskKey.concat(strMaskX));
            if (!resultGuidance.equals("N/A")) break;
        }
        if (resultGuidance.equals("N/A")) {
            maskKey = STR_DEFAULT;
        }
        return maskKey;
    }

    public String getLocation(String locationGuidance, String refCode) {
        String result = STR_DEFAULT;
        for (String target : SIM_LOCATION_TARGET_CODE) {
            if (!refCode.equals(target)) continue;
            result = STR_HYPHEN;
            return result;
        }
        String[] locationSpilt = locationGuidance.split(SIM_LOCATION_SPLIT_STR, 3);
        result = result.concat(locationSpilt[0]);
        String locationFormat = locationSpilt[1];
        String locationDispData = STR_DEFAULT;
        if (locationFormat.equals(DECIMAL_FORMAT)) {
            try {
                int refCodeSpilt = Integer.parseInt(locationSpilt[2]);
                int subStringStart = refCode.length() - refCodeSpilt;
                int subStringEnd = refCode.length();
                locationDispData = refCode.substring(subStringStart, subStringEnd);
                int decimalData = Integer.parseInt(locationDispData, 16);
                result = result.concat(String.valueOf(decimalData));
            }
            catch (NumberFormatException e) {
                SJctrLogUty.warn(SJctrAlertUtility.class.getSimpleName(), "getLocation", "Location Pool ID : " + e);
                result = "?";
            }
        } else if (locationFormat.equals(HEX_FORMAT)) {
            try {
                int refCodeSpilt = Integer.parseInt(locationSpilt[2]);
                int subStringStart = refCode.length() - refCodeSpilt;
                int subStringEnd = refCode.length();
                locationDispData = refCode.substring(subStringStart, subStringEnd);
                int code = Integer.parseInt(locationDispData, 16);
                int highBit = this.cutBit(code, this.HIGH_BIT_START, this.HIGH_BIT_END);
                int lowBit = this.cutBit(code, this.LOW_BIT_START, this.LOW_BIT_END);
                String hexData = SJctrComUtility.toHexString(highBit, 2, true);
                hexData = hexData + STR_SLASH;
                hexData = hexData + SJctrComUtility.toHexString(lowBit, 2, true);
                result = result.concat(hexData);
            }
            catch (NumberFormatException e) {
                SJctrLogUty.warn(SJctrAlertUtility.class.getSimpleName(), "getLocation", "Location Drive Nmber : " + e);
                result = "?";
            }
        } else if (locationFormat.equals(STRING_FORMAT)) {
            result = result.concat(locationSpilt[2]);
        }
        return result;
    }

    public int cutBit(int target, int begin, int end) {
        int letBitNum = 32 - (end + 1);
        int rightBitNum = begin;
        target <<= letBitNum;
        return target >>>= letBitNum + rightBitNum;
    }
}

