/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDirectLauncher;
import sanproject.sn2.controller.com.SJctrTabDataController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.controller.com.model.node.SJctrTreeNodeData;
import sanproject.sn2.controller.topwindow.base.SJctrChildViewModel;
import sanproject.sn2.controller.topwindow.base.SJctrNodePath;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.topwindow.base.SJctrViewHistoryModel;

public class SJctrAccordionTreeModel
extends SJctrNewTreeDataModel {
    private static final int MSG_NODE_NOTHING = 106079;
    private boolean activeAccordion = false;
    private boolean moveEventFlg;
    private Map<Class<?>, SJctrNodeData> classToNodeDataMap = new HashMap();

    public SJctrAccordionTreeModel() {
        this(10);
    }

    public SJctrAccordionTreeModel(int size) {
        super(size);
        this.setRestoreFlg(true);
        this.initListener();
    }

    @Override
    public void clearModelData() {
        this.removeAllItems();
        this.getLogicalPathToNodeDataMap().clear();
        this.setActiveAccordion(false);
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        if (this.isMoveEventFlg()) {
            controlData.remove("COM_SELECTED");
            super.setOwnControlData(controlData);
            this.setMoveEventFlg(false);
        } else {
            super.setOwnControlData(controlData);
        }
        if (!this.isActiveAccordion()) {
            return;
        }
        if (this.getSelection() != null) {
            return;
        }
        ArrayList<HashMap<String, Object>> listData = ((SJctrNestedListDataObject)this.getManageData()).listData();
        if (listData == null || listData.size() == 0) {
            return;
        }
        HashMap<String, Object> item = listData.get(0);
        String name = SJctrNewTreeDataModel.Item.getName(item);
        this.setSelection(name);
    }

    protected boolean isActiveAccordion() {
        return this.activeAccordion;
    }

    protected void setActiveAccordion(boolean flg) {
        this.activeAccordion = flg;
    }

    protected void updateCrumbTrail() {
        this.fireMessageEvent(SJctrTopWindowDC.TOP_MSG.MOVE_CRUMB, this);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrTopWindowDC.TOP_MSG.MOVE_CRUMB, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAccordionTreeModel.this.selectedAccordionTree(event.getNofifyObject());
            }
        });
        this.addItemExpandListener(new SJctrItemExpandListener(){

            @Override
            public void treeCollapsed(SJctrItemExpandEvent<String> event) {
                SJctrAccordionTreeModel.this.treeCollapsedNodeData(event);
            }

            @Override
            public void treeExpanded(SJctrItemExpandEvent<String> event) {
                SJctrAccordionTreeModel.this.treeExpandedNodeData(event);
            }
        });
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAccordionTreeModel.this.updateCrumbTrail();
                }
            }
        });
    }

    protected void treeCollapsedNodeData(SJctrItemExpandEvent<String> event) {
        String key = (String)event.getChangeObject();
        SJctrNodeData nodeData = this.getNodePathToNodeDataMap().get(key);
        List<SJctrNodeData> childeList = this.getNodeDataChilde(nodeData);
        for (SJctrNodeData childeNodeData : childeList) {
            SJctrItemExpandListener expandListener = ((SJctrTreeNodeData)childeNodeData).getExpandListener();
            if (expandListener == null) continue;
            SJctrItemExpandEvent<String> childeEvent = new SJctrItemExpandEvent<String>((SJctrDataObjectModel<SJctrDataObject>)event.getSource(), (String)event.getChangeObject(), event.isExpand());
            childeEvent.setParameter(childeNodeData.getLogicalPath());
            expandListener.treeCollapsed(childeEvent);
        }
    }

    protected void treeExpandedNodeData(SJctrItemExpandEvent<String> event) {
        String key = (String)event.getChangeObject();
        SJctrNodeData nodeData = this.getNodePathToNodeDataMap().get(key);
        List<SJctrNodeData> childeList = this.getNodeDataChilde(nodeData);
        for (SJctrNodeData childeNodeData : childeList) {
            SJctrItemExpandListener expandListener = ((SJctrTreeNodeData)childeNodeData).getExpandListener();
            if (expandListener == null) continue;
            SJctrItemExpandEvent<String> childeEvent = new SJctrItemExpandEvent<String>((SJctrDataObjectModel<SJctrDataObject>)event.getSource(), (String)event.getChangeObject(), event.isExpand());
            childeEvent.setParameter(childeNodeData.getLogicalPath());
            expandListener.treeExpanded(childeEvent);
        }
    }

    private void selectedAccordionTree(Object accordionTree) {
        boolean flg = accordionTree.equals(this);
        this.setActiveAccordion(flg);
        if (!flg) {
            this.clearSelection();
        }
        this.setDirty();
    }

    public SJctrNodePath getTreePath(Class<? extends SJctrDataController> dc, Object ... args) {
        SJctrNodeData data = this.getClassToNodeDataMap().get(dc);
        return this.getTreePath(data, dc, args);
    }

    private SJctrNodePath getTreePath(SJctrNodeData data, Class<? extends SJctrDataController> dc, Object ... args) {
        SJctrNodePath retValue = new SJctrNodePath();
        if (data != null) {
            String nodePath = data.getNodePath(args);
            retValue.setNodePath(nodePath);
            retValue.setDc(dc);
            retValue.setParam(args);
        }
        return retValue;
    }

    public void moveDisplay(SJctrNodePath nodePath) {
        String path = nodePath.getNodePath();
        this.refreshSelection(path);
        Class<? extends SJctrDataController> cls = nodePath.getDc();
        this.setTabDefaultSelect(cls);
    }

    @Override
    protected void setAction(SJctrNestedListDataObject nestedList) {
        ArrayList<HashMap<String, Object>> setList = nestedList.setRow();
        for (HashMap<String, Object> item : setList) {
            String name = SJctrNewTreeDataModel.Item.getName(item);
            if (name == null) continue;
            if (SJctrNewTreeDataModel.Item.containsSelect(item)) {
                if (SJctrNewTreeDataModel.Item.isSelect(item)) {
                    this.refreshSelection(name);
                } else {
                    this.clearSelection(name);
                }
            }
            if (!SJctrNewTreeDataModel.Item.containsExpand(item)) continue;
            this.setExpandedState(name, SJctrNewTreeDataModel.Item.isExpand(item));
        }
    }

    private void refreshSelection(String name) {
        if (name == null || name.isEmpty()) {
            this.getLogUty().putlog("refreshSelection", "name = " + name, 40000);
            return;
        }
        SJctrDataController dc = this.getDataController();
        SJctrTopWindowDC topDc = dc.getTopWindow();
        boolean retry = topDc.getRetryMoveDisplay();
        if (!retry) {
            boolean changeLicense = dc.getOwner().updateLicenseInfo();
            boolean updateTopWindow = topDc.isUpdateFlg();
            if (changeLicense || updateTopWindow) {
                topDc.updateAccordionTree();
            }
        }
        this.clearSelection();
        this.nodeLabelRefresh();
        this.nodeRefresh(name);
        boolean restorePath = this.setSelectionToRoot(name);
        if (this.getSelection() == null) {
            if (retry) {
                SJctrViewHistoryModel viewHistory = (SJctrViewHistoryModel)dc.getDataObjectModel("COM_HISTORY");
                boolean skipflg = viewHistory.getAddHistorySkip();
                if (skipflg) {
                    viewHistory.setAddHistorySkip(false);
                    viewHistory.removeCurrentHistory();
                    viewHistory.delDuplicateViewHistory();
                }
            } else if (!retry) {
                topDc.setRetryMoveDisplay(true);
                topDc.moveFirstDisplay();
                topDc.setRetryMoveDisplay(false);
            }
        }
        SJctrRelatedDispDataObject related = dc.getUpdateDisp();
        dc.addUpdateDisp(related);
        if (!restorePath && !retry) {
            SJcMessage msg = new SJcMessage(Integer.toString(201), Integer.toString(22), Integer.toString(106079));
            SJctrRelatedDispDataObject msgRelated = dc.createMsgDialog(msg);
            dc.addUpdateDisp(msgRelated);
        }
    }

    public void updateAccordionTree() {
        boolean act = this.isActiveAccordion();
        this.clearModelData();
        this.getLogicalPathToNodeDataMap().clear();
        this.initLogicalNode();
        this.initNode();
        this.setActiveAccordion(act);
    }

    private void nodeLabelRefresh() {
        Map<String, SJctrNodeData> nodeMap = this.getNodePathToNodeDataMap();
        for (Map.Entry<String, SJctrNodeData> entry : nodeMap.entrySet()) {
            String name = entry.getKey();
            SJctrNodeData nodeData = entry.getValue();
            if (nodeData == null || name == null) {
                this.getLogUty().putlog("nodeLabelRefresh", "nodeData = " + nodeData + ", name = " + name, 40000);
                continue;
            }
            if (nodeData.isVariable() || !nodeData.isVariableLabel()) continue;
            HashMap<String, Object> item = this.getItem(name);
            String newLabel = nodeData.createLabel(new Object[0]);
            SJctrNewTreeDataModel.Item.setLabel(item, newLabel);
        }
    }

    private void nodeRefresh(String path) {
        List<String> expandedList = this.getExpandedList();
        if (expandedList.contains(path)) {
            this.collapsePath(path);
        } else {
            int endIndex = path.lastIndexOf("\t");
            if (endIndex >= 0) {
                String parentPath = path.substring(0, endIndex);
                this.collapsePath(parentPath);
                this.setExpandedState(parentPath, true);
            }
        }
        for (String expandPath : expandedList) {
            this.setExpandedState(expandPath, true);
        }
    }

    private void setTabDefaultSelect(Class cls) {
        if (cls == null) {
            return;
        }
        SJctrTopWindowDC topwindow = this.getDataController().getTopWindow();
        SJctrChildViewModel child = (SJctrChildViewModel)topwindow.getDataObjectModel("COM_CHILD");
        SJctrDataController moveDC = topwindow.getOwner().getDataController(child.getMoveDisp());
        if (!(moveDC instanceof SJctrTabDataController)) {
            return;
        }
        ((SJctrTabDataController)moveDC).setDefaultDCClass(cls);
    }

    public boolean moveDisplay(Class<? extends SJctrDataController> dcClass) {
        SJctrNodeData nodeData = this.getClassToNodeDataMap().get(dcClass);
        if (nodeData == null) {
            return false;
        }
        String treePath = nodeData.getNodePath(new Object[0]);
        boolean result = this.setSelection(treePath);
        SJctrNodeData parentNode = nodeData.getParentNode();
        if (parentNode != null) {
            String parentNodePath = parentNode.getNodePath(new Object[0]);
            this.setExpandedState(parentNodePath, true);
        }
        return result;
    }

    public Map<Class<?>, SJctrNodeData> getClassToNodeDataMap() {
        return this.classToNodeDataMap;
    }

    @Override
    public void addNodeData(SJctrNodeData nodeData) {
        super.addNodeData(nodeData);
        for (Class<?> cls : ((SJctrTreeNodeData)nodeData).getDCList()) {
            this.getClassToNodeDataMap().put(cls, nodeData);
        }
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        SJctrNestedListDataObject data = (SJctrNestedListDataObject)this.getManageData();
        data.setData("COM_EXPANDED", this.activeAccordion);
        return super.getDataObject(inputObject);
    }

    public void setMoveEventFlg(boolean moveEventFlg) {
        this.moveEventFlg = moveEventFlg;
    }

    public boolean isMoveEventFlg() {
        return this.moveEventFlg;
    }

    @Override
    protected boolean setSelectionName(String name) {
        boolean ret = super.setSelectionName(name);
        if (!ret) {
            return ret;
        }
        SJctrDataController dc = this.getDataController();
        SJctrViewHistoryModel viewHistory = (SJctrViewHistoryModel)dc.getDataObjectModel("COM_HISTORY");
        boolean skipflg = viewHistory.getAddHistorySkip();
        if (skipflg) {
            viewHistory.setAddHistorySkip(false);
            viewHistory.replaceViewHistory(name);
            viewHistory.delDuplicateViewHistory();
        } else {
            viewHistory.addViewHistory(name);
        }
        viewHistory.setDirtyAll();
        return ret;
    }

    public void refreshSelectionforViewHistory(String name) {
        this.refreshSelection(name);
    }

    @Override
    protected void makeDataObject() {
        this.initLogicalNode();
        this.initNode();
    }

    public List<Object> getDisplayParam(SJctrDirectLauncher dl) {
        return null;
    }
}

