/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.gumLaunch.SJctrGumLaunchUty;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrLaunchMenuModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrLaunchDC
extends SJctrDataController {
    public static final int DISPLAY_ID_BROWS = 0x3000007;
    public static final String KEY_URL = "COM_URL";
    public static final String KEY_XML = "COM_XML";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String COM_LAUNCH = "COM_LAUNCH";
    private static final String CLIENT_MPC = "MAINTENANCE";
    private static final String CLIENT_MAPP = "MANAGEMENT";

    public SJctrLaunchDC() throws SJcException {
        super(0x3000007);
        this.initListener();
    }

    public void initDataObjectModel(SJctrLaunchMenuModel lmm, Map<String, Object> mMenu) {
        this.logUty.putlog("initDataObjectModel", "Brawser Execute Start");
        SJctrDataObject mgd = this.getManageData();
        if (mMenu.containsKey("GGI_PARAMETER")) {
            mgd.setData(KEY_URL, this.getGGIAuthUrl(mMenu));
        } else {
            if (lmm.sendXML(mMenu)) {
                mgd.setData(KEY_XML, lmm.getLaunch_XML());
            } else {
                mgd.setData(KEY_XML, "");
            }
            mgd.setData(KEY_URL, lmm.getLaunch_URL());
        }
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
        this.logUty.putlog("initDataObjectModel", "Brawser Execute End");
    }

    String getGGIAuthUrl(Map<String, Object> mMenu) throws SJcException {
        SJctrUserController uc = this.getOwner();
        SJbaseUserSessionInterfaceInternal usint = (SJbaseUserSessionInterfaceInternal)uc.getUserSession();
        String userName = usint.getUserName();
        if (userName == null) {
            this.getLogUty().putlog("getGGIAuthUrl", "[Logic Error]userID is Empty", null, 40000);
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        String password = usint.getPassword();
        if (password == null) {
            this.getLogUty().putlog("getGGIAuthUrl", "[Logic Error]password is Empty", null, 40000);
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        String ggiURL = SJctrGumLaunchUty.getGGIAuthUrl(userName, password, mMenu);
        return ggiURL;
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.CLOSE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLaunchDC.this.logUty.putlog("SJctrLaunchDC", "PUSH_CLOSE");
                SJctrUserController uc = SJctrLaunchDC.this.getOwner();
                SJctrRelatedDispDataObject relateDisp = uc.removeRelatedDispData(SJctrLaunchDC.this.getuId());
                SJctrLaunchDC.this.addUpdateDisp(relateDisp);
            }
        });
    }

    public void setUpdateDisp() {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject related = uc.removeRelatedDispData(this.getuId());
        this.addUpdateDisp(related);
    }

    public static void launchGGI(SJctrItemSelectEvent<?> event, String dispId, int ctrlId, String tabIndex, Map<String, Object> paramMap) {
        SJctrDataController dc = event.getSource().getDataController();
        dc.getLogUty().putlog("launchGGI", "event=" + event.toString() + ": DISP_ID=" + dispId);
        HashMap<String, Object> node = new HashMap<String, Object>();
        SJctrLaunchMenuModel launch = new SJctrLaunchMenuModel();
        SJctrUserController uc = dc.getOwner();
        SJctrSystemParamContainer spc = uc.getAuthorizeContainer().getSystemParamContainer();
        String client = CLIENT_MAPP;
        if (spc.isLocalHost()) {
            client = CLIENT_MPC;
        }
        Map<String, Object> ggiParam = SJctrGumLaunchUty.createParamMap(dispId, tabIndex, client);
        int hsc_auth = SJcSessionUty.getSsoOption(uc.getUserSession()) + 2;
        ggiParam.put("authType", hsc_auth);
        if (paramMap != null) {
            ggiParam.putAll(paramMap);
        }
        node.put("GGI_PARAMETER", ggiParam);
        node.put("GGI_CTRL_ID", ctrlId);
        SJctrRelatedDispDataObject related = uc.createRelatedDispData(SJctrLaunchDC.class);
        SJctrLaunchDC launchDc = (SJctrLaunchDC)uc.getDataController(related);
        launchDc.initDataObjectModel(launch, node);
        dc.addUpdateDisp(related);
    }
}

