/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrLockStartTimeColumnFromResourceLockTableKey
extends SJctrColumn {
    public static final String LOCK_START_TIME = "LOCK_START_TIME";
    private static final String BAR = "-";
    private static SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public SJctrLockStartTimeColumnFromResourceLockTableKey(String key) {
        super(key);
        this.setPartsId(LOCK_START_TIME);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance(LOCK_START_TIME));
    }

    @Override
    public int getFilterType() {
        return 8;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJctrResourceLockTableKey> list = new ArrayList<SJctrResourceLockTableKey>();
        list.add((SJctrResourceLockTableKey)index);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> datalist) {
        SJctrResourceLockTableKey tabledata = (SJctrResourceLockTableKey)datalist.get(0);
        BASEgetDkcLockList systemLockInfo = tabledata.getSystemLockInfo();
        BASEgetDkcLockList lockInfo = systemLockInfo != null ? systemLockInfo : tabledata.getLockInfo();
        if (lockInfo == null) {
            return BAR;
        }
        Date dateLock = lockInfo.getLockTime();
        String strLockStart = simpleDate.format(dateLock);
        return strLockStart;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long retValue = 0L;
        try {
            String dateStr;
            SJctrResourceLockTableKey info = (SJctrResourceLockTableKey)this.getPrimaryKeyObject(dat);
            BASEgetDkcLockList systemLockInfo = info.getSystemLockInfo();
            BASEgetDkcLockList lockInfo = systemLockInfo != null ? systemLockInfo : info.getLockInfo();
            if (lockInfo == null) {
                dateStr = "";
            } else {
                Date dateLock = lockInfo.getLockTime();
                dateStr = simpleDate.format(dateLock);
            }
            if (dateStr.length() > 0) {
                Date date = simpleDate.parse(dateStr);
                retValue = date.getTime();
            }
        }
        catch (ParseException e) {
            this.getTable().getLogUty().putlog("getNumber", "DateFormat: yyyy/mm/dd hh:mm:ss", e, 30000);
        }
        return retValue;
    }
}

