/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.base.SJctrLockStartTimeColumnFromResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrLockSystemColumnFromResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrLockUserColumnFromResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrOperationLockStatus;
import sanproject.sn2.controller.topwindow.base.SJctrResourceGroupNameColumnFromResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockDC;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrStatusColumnFromResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrVssModelSNoLdevColumnFromResourceLockTableKey;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrResourceLockTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_RSGNAME = "COM_COL_RSGNAME";
    public static final String KEY_COL_STATUS = "COM_COL_STATUS";
    public static final String KEY_COL_LOCK_USER = "COM_COL_LOCK_USER";
    public static final String KEY_COL_SYSTEM = "COM_COL_SYSTEM";
    public static final String KEY_COL_LOCK_STR_TIME = "COM_COL_LOCK_STR_TIME";
    public static final String KEY_COL_VSS = "COM_COL_VSS_MDL_SN";
    private static final int MSG_FUNCTION_BASE = 1;
    private static final int MSG_MODULE_CONTROLLER = 22;
    private static final int MSG_GET_RESOURCE_LOCK_INFO_ERR = 107021;
    private static Comparator<SJctrResourceLockTableKey> comparator = new Comparator<SJctrResourceLockTableKey>(){

        @Override
        public int compare(SJctrResourceLockTableKey o1, SJctrResourceLockTableKey o2) {
            String s1 = o1.getRsgName();
            String s2 = o2.getRsgName();
            int ret = s1.compareTo(s2);
            return o1.getRsgName().compareTo(o2.getRsgName());
        }
    };

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        return super.getDataObject(inputObject);
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        SJctrOperationLockStatus operationLockStatus;
        List<?> ret = super.getBasicDataList(cls);
        SJctrDataController dc = this.getDataController();
        SJctrUserController uc = dc.getOwner();
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null) {
            ret = new ArrayList(0);
            return ret;
        }
        SJmoGetAgent agent = dc.getOwner().getModelAgent();
        SanRequest request = agent.newRequest("SANreadOperationLockStatus");
        SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(request);
        SJmoGetDirect direct = new SJmoGetDirect(kind, null, null);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SanResponse responseData = (SanResponse)dc.getModelData(wrapper).get(0);
        try {
            SanObject errorInfo = responseData.getObj("ErrorInfo");
            int errorCode = errorInfo.getInt("ErrorCode");
            if (errorCode != 0) {
                int[] msgId = errorInfo.getIntArray("MessageId");
                this.getLogUty().putlog("getBasicDataList", "SanResponse ErrorCode:" + errorCode + " MessageId:" + msgId[0] + "," + msgId[1]);
                SJctrError err = new SJctrError(1, 22, 107021);
                SJcException exp = err.createException();
                throw exp;
            }
            operationLockStatus = new SJctrOperationLockStatus(responseData);
        }
        catch (SanDataException sanEx) {
            this.getLogUty().putlog("getBasicDataList", "SanDataException msg=" + sanEx.getMessage());
            SJctrError err = new SJctrError(1, 22, 107021);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> vDkcDetailList = dc.getModelData(SJmoGetHUVMVirtualDkc.class);
        SJmoRSGgetAllRsgs rsgData = (SJmoRSGgetAllRsgs)rsgDetailList.get(0);
        ((SJctrResourceLockDC)dc).setRsgData(rsgData);
        ((SJctrResourceLockDC)dc).setOperationLockStatus(operationLockStatus);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgData);
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        ret = new ArrayList(rsgList.size());
        BASEgetDkcLockList svpLock = operationLockStatus.getSVPLockInfo();
        BASEgetDkcLockList systemLock = operationLockStatus.getSystemLockInfo();
        BASEgetDkcLockList[] dkcLockList = operationLockStatus.getResourceLockInfo();
        for (SJmoRSGgetRsg rsg : rsgList) {
            int id = rsg.getRsgInfo().getRsgId();
            BASEgetDkcLockList lock = null;
            for (BASEgetDkcLockList dkcLock : dkcLockList) {
                if (id != dkcLock.getIResourceId()) continue;
                lock = dkcLock;
                break;
            }
            SJmoHUVMVirtualDkc vDkcInfo = null;
            SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
            SJmoHUVMvboxIndex vIndex = rsgInfo.getVboxIndex();
            int vBoxIndex = Collections.binarySearch(vDkcDetailList, vIndex);
            if (vBoxIndex >= 0) {
                vDkcInfo = (SJmoHUVMVirtualDkc)vDkcDetailList.get(vBoxIndex);
            }
            SJctrResourceLockTableKey data = new SJctrResourceLockTableKey(rsg, svpLock, systemLock, lock, vDkcInfo);
            ((ArrayList)ret).add(data);
        }
        if (ret != null && ret.size() > 0) {
            Collections.sort((ArrayList)ret, comparator);
        }
        ((ArrayList)ret).trimToSize();
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrResourceGroupNameColumnFromResourceLockTableKey(KEY_COL_RSGNAME));
        this.addColumn(new SJctrStatusColumnFromResourceLockTableKey(KEY_COL_STATUS));
        this.addColumn(new SJctrLockUserColumnFromResourceLockTableKey(KEY_COL_LOCK_USER));
        SJctrLockSystemColumnFromResourceLockTableKey systemColumn = new SJctrLockSystemColumnFromResourceLockTableKey(KEY_COL_SYSTEM);
        systemColumn.setSupportColumn(false);
        this.addColumn(systemColumn);
        this.addColumn(new SJctrLockStartTimeColumnFromResourceLockTableKey(KEY_COL_LOCK_STR_TIME));
        this.addColumn(new SJctrVssModelSNoLdevColumnFromResourceLockTableKey(KEY_COL_VSS));
    }
}

