/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.exstorage.system.pathgroup.volume;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.column.uvm.SJctrStatusIcon;
import sanproject.sn2.controller.com.column.uvm.SJctrVolumeStatus;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.exstorage.system.pathgroup.SJctrExsSystemPathGrpSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdStatusInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdStatusInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdStatusInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrExsPathGrpVolumeSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_EXT_STATUS = "COM_EXT_STATUS";
    public static final String KEY_EXT_VMS = "COM_EXT_VMS";
    public static final String KEY_EXT_VOL_NUM = "COM_EXT_VOL_NUM";
    public static final String KEY_EXT_VOL_CAP = "COM_EXT_VOL_CAP";
    public static final String KEY_EXT_PATH_NUM = "COM_EXT_PATH_NUM";
    private SJmoExdSubsystemInfo subsystem = null;
    private SJmoExdProfileInfo profile = null;
    private SJmoExdPathGroupInfo pathGrpInfo = null;
    private SJmoExdVolumeInfoOnPathGroup exdVolInfoOnPathGrp = null;
    private List<SJmoExdVolumeInfo> usableExdVolInfoList = null;
    private SJmoExdStatusInfoMgr exdStatusMgr = null;
    private SJctrResourceGroupUtility rsgUtil = null;

    @Override
    public void makeDataObject() {
        SJctrDataController dc = this.getDataController();
        SJctrComUtility comUtil = dc.getOwner().getComUtility();
        SJctrExtUtility extUtil = comUtil.getExtUtility();
        if (dc instanceof SJctrExsSystemPathGrpSelectDC) {
            SJmoModelData_Base mgr;
            SJctrExsSystemPathGrpSelectDC selectDC = (SJctrExsSystemPathGrpSelectDC)dc;
            int subsystemID = selectDC.getSelectSystem();
            int pathGroupID = selectDC.getSelectPathGroup();
            List<SJmoGetKind_IF> list = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (list != null && list.size() != 0) {
                SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)((Object)list.get(0));
                this.rsgUtil = new SJctrResourceGroupUtility(this.getDataController().getOwner(), rsgInfo);
            }
            if ((list = this.getBasicDataList(SJmoGetExdSubsystemInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdSubsystemInfoMgr)((Object)list.get(0));
                this.subsystem = ((SJmoExdSubsystemInfoMgr)mgr).getExdSubsystemInfo(subsystemID);
            }
            if ((list = this.getBasicDataList(SJmoGetExdProfileInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdProfileInfoMgr)((Object)list.get(0));
                if (this.subsystem != null) {
                    this.profile = ((SJmoExdProfileInfoMgr)mgr).getExdProfileInfo(this.subsystem.getRmiExdSubsystemInfo().referProfileId());
                }
            }
            if ((list = this.getBasicDataList(SJmoGetExdPathGroupInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdPathGroupInfoMgr)((Object)list.get(0));
                this.pathGrpInfo = ((SJmoExdPathGroupInfoMgr)mgr).getExdPathGroupInfo(pathGroupID);
            }
            if ((list = this.getBasicDataList(SJmoGetExdVolumeInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdVolumeInfoMgr)((Object)list.get(0));
                this.exdVolInfoOnPathGrp = ((SJmoExdVolumeInfoMgr)mgr).getExdVolumeInfoOnPathGroup(pathGroupID);
                ArrayList exdVolList = this.exdVolInfoOnPathGrp.getAlExdVolumeInfo();
                this.usableExdVolInfoList = extUtil.getUsableExdVolInfo(this.rsgUtil, exdVolList);
            }
            list = this.getBasicDataList(SJmoGetExdStatusInfoMgr.class);
            this.exdStatusMgr = (SJmoExdStatusInfoMgr)((Object)list.get(0));
        }
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetExdSubsystemInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdStatusInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        SJctrDataObject status = this.getStatus();
        String subsystemName = this.getSubsystemName();
        String strNumOfExtPath = this.getExternalPathNum();
        int numOfExtVol = this.getExternalVolNum();
        String extVolCap = this.getExternalVolCapacity();
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_EXT_STATUS, status);
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VMS, subsystemName);
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PATH_NUM, strNumOfExtPath);
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_NUM, SJctrComUtility.toDecString(numOfExtVol));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_CAP, extVolCap);
    }

    private SJctrDataObject getStatus() {
        String label = "?";
        int icon = 12292;
        if (this.exdVolInfoOnPathGrp != null) {
            ArrayList volList = this.exdVolInfoOnPathGrp.getAlExdVolumeInfo();
            SJctrVolumeStatus volumeStatus = new SJctrVolumeStatus();
            ArrayList<SJmoExdStatusInfo> statusList = new ArrayList<SJmoExdStatusInfo>(volList.size());
            for (SJmoExdVolumeInfo volInfo : volList) {
                int vpgId = volInfo.getRmiExdVolumeInfo().getExternalVolumeID();
                SJmoExdStatusInfo statusInfo = this.exdStatusMgr.getExdStatusInfo(vpgId);
                statusList.add(statusInfo);
            }
            if (statusList.size() != 0) {
                int principalStatus = volumeStatus.getPrincipalStatus(statusList);
                SJctrExtUtility util = this.getComUtility().getExtUtility();
                label = util.getStatusDisplay(principalStatus);
                icon = SJctrStatusIcon.getVolumeStatusIconId(principalStatus);
            }
        }
        SJctrDataObject status = new SJctrDataObject();
        status.setData("label", label);
        if (!label.equals("?")) {
            status.setData("COM_ICON", icon);
        }
        return status;
    }

    private String getSubsystemName() {
        SJctrExtUtility util = this.getComUtility().getExtUtility();
        return util.toSubSystemName(this.subsystem, this.profile);
    }

    private String getExternalPathNum() {
        StringBuffer buf = new StringBuffer();
        int num = 0;
        if (this.pathGrpInfo != null) {
            SJctrComUtility comUtil = this.getComUtility();
            SJctrExtUtility extUtil = comUtil.getExtUtility();
            num = extUtil.getExternalPathNum(this.pathGrpInfo);
            buf.append(SJctrComUtility.toDecString(num));
            buf.append(comUtil.getStrMaxAllowed(8));
        }
        return buf.toString();
    }

    private int getExternalVolNum() {
        int num = 0;
        num = this.usableExdVolInfoList.size();
        return num;
    }

    private String getExternalVolCapacity() {
        long capa = 0L;
        for (SJmoExdVolumeInfo usableExdVol : this.usableExdVolInfoList) {
            capa += usableExdVol.getRmiExdVolumeInfo().getExternalDeviceInfo().getVolumeSize();
        }
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        return util.toUnitString(capa);
    }
}

