/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.information.hardwares;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetCacheOnDemand;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoCacheOnDemand;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrInformationHardwaresSummaryModel
extends SJctrSimpleDataModel {
    public static final String EDIT_SPACE = " ";
    public static final String KEY_SUBSYSTEMTYPE = "COM_SUBSYSTEMTYPE";
    public static final String KEY_SERIALNUMBER = "COM_SERIALNUM";
    public static final String KEY_IP = "COM_IP";
    public static final String KEY_CONTACT = "COM_CONTACT";
    public static final String KEY_LOCATION = "COM_LOCATION";
    public static final String KEY_NAME = "COM_NAME";
    public static final String KEY_MAIN = "COM_MAIN";
    public static final String KEY_SVP = "COM_SVP";
    public static final String KEY_RMI = "COM_RMI";
    public static final String KEY_TOTALCACHE = "COM_TOTALCACHE";
    public static final String KEY_IPV4_CTL1 = "COM_IPV4_CTL1";
    public static final String KEY_IPV4_CTL2 = "COM_IPV4_CTL2";
    public static final String KEY_IPV6_CTL1 = "COM_IPV6_CTL1";
    public static final String KEY_IPV6_CTL2 = "COM_IPV6_CTL2";
    public static final double lMaxCapa = 1024.0;
    public static final long lUnitCapa = 1024L;
    public static String sMB = "MB";
    public static String sGB = "GB";
    public static String sTB = "TB";
    public static String sHai = "-";
    public static String sPar = "%";
    public static String sEdit = " ";
    public String sDKCsysName = "-";
    public String sProductName = "-";
    public String sSNAddString = "-";
    public String sIPAddress = "-";
    public String sDKCsysContact = "-";
    public String sDKCsysLocation = "-";
    public String sMainVersion = "-";
    public String sMibVersion = "-";
    public String sProgVersion = "-";
    public String sCacheSize = "0";
    public String sIPv4AddressCtl1 = "-";
    public String sIPv4AddressCtl2 = "-";
    public String sIPv6AddressCtl1 = "-";
    public String sIPv6AddressCtl2 = "-";
    private SJctrCapacityUtility capaUtil;

    @Override
    public void makeDataObject() {
        List<SJmoGetSubsystemInfo> infoSummary = this.getBasicDataList(SJmoGetSubsystemInfo.class);
        List<SJmoGetCacheOnDemand> baseSummary = this.getBasicDataList(SJmoGetCacheOnDemand.class);
        this.makeHardwarsSummary(infoSummary, baseSummary);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetSubsystemInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetCacheOnDemand();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    public void makeHardwarsSummary(List<?> infoSummary, List<?> baseSummary) {
        SJctrComUtility comUtil = this.getDataController().getOwner().getComUtility();
        this.capaUtil = comUtil.getCapacityUtility();
        if (infoSummary.size() > 0 && baseSummary.size() > 0) {
            SJmoSubsystemInfo lInformation = (SJmoSubsystemInfo)infoSummary.get(0);
            SJmoCacheOnDemand lCacheCapacity = (SJmoCacheOnDemand)baseSummary.get(0);
            this.sDKCsysName = lInformation.getDKCsysName();
            SJctrUserController uc = this.getDataController().getOwner();
            this.sProductName = uc.getProductName();
            this.sSNAddString = lInformation.getDKCSNAddString();
            String IPv4Ctl1 = SJcEnvUty.getGum1v4Address();
            this.sIPv4AddressCtl1 = IPv4Ctl1.equals("") ? "-" : IPv4Ctl1;
            String IPv4Ctl2 = SJcEnvUty.getGum2v4Address();
            this.sIPv4AddressCtl2 = IPv4Ctl2.equals("") ? "-" : IPv4Ctl2;
            String IPv6Ctl1 = SJcEnvUty.getGum1v6Address();
            this.sIPv6AddressCtl1 = IPv6Ctl1.equals("") ? "-" : IPv6Ctl1;
            String IPv6Ctl2 = SJcEnvUty.getGum2v6Address();
            this.sIPv6AddressCtl2 = IPv6Ctl2.equals("") ? "-" : IPv6Ctl2;
            this.sDKCsysContact = lInformation.getDKCsysContact();
            this.sDKCsysLocation = lInformation.getDKCsysLocation();
            this.sMainVersion = lInformation.getDKCMainVersion();
            this.sMibVersion = lInformation.getDKCMibVersion();
            this.sProgVersion = lInformation.getServProgVersion();
            this.sCacheSize = this.convertCapacity(lCacheCapacity.getPresentCacheSize());
            this.getLogUty().putlog("Hardwars", "Subsystem Name = " + this.sDKCsysName);
            this.getLogUty().putlog("Hardwars", "Subsystem Type = " + this.sProductName);
            this.getLogUty().putlog("Hardwars", "Serial Number = " + this.sSNAddString);
            this.getLogUty().putlog("Hardwars", "IPv4 Address = " + this.sIPv4AddressCtl1 + "," + this.sIPv4AddressCtl2);
            this.getLogUty().putlog("Hardwars", "IPv6 Address = " + this.sIPv6AddressCtl1 + "," + this.sIPv6AddressCtl2);
            this.getLogUty().putlog("Hardwars", "Contact = " + this.sDKCsysContact);
            this.getLogUty().putlog("Hardwars", "Location = " + this.sDKCsysLocation);
            this.getLogUty().putlog("Hardwars", "Main Version = " + this.sMainVersion);
            this.getLogUty().putlog("Hardwars", "SVP Version = " + this.sMibVersion);
            this.getLogUty().putlog("Hardwars", "RMI Server = " + this.sProgVersion);
            this.getLogUty().putlog("Hardwars", "Cache Size = " + lCacheCapacity.getPresentCacheSize());
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_NAME, this.sDKCsysName);
        ((SJctrDataObject)summaryData).setData(KEY_SUBSYSTEMTYPE, this.sProductName);
        ((SJctrDataObject)summaryData).setData(KEY_SERIALNUMBER, this.sSNAddString);
        ((SJctrDataObject)summaryData).setData(KEY_IPV4_CTL1, this.sIPv4AddressCtl1);
        ((SJctrDataObject)summaryData).setData(KEY_IPV4_CTL2, this.sIPv4AddressCtl2);
        ((SJctrDataObject)summaryData).setData(KEY_IPV6_CTL1, this.sIPv6AddressCtl1);
        ((SJctrDataObject)summaryData).setData(KEY_IPV6_CTL2, this.sIPv6AddressCtl2);
        ((SJctrDataObject)summaryData).setData(KEY_CONTACT, this.sDKCsysContact);
        ((SJctrDataObject)summaryData).setData(KEY_LOCATION, this.sDKCsysLocation);
        ((SJctrDataObject)summaryData).setData(KEY_MAIN, this.sMainVersion);
        ((SJctrDataObject)summaryData).setData(KEY_SVP, this.sMibVersion);
        ((SJctrDataObject)summaryData).setData(KEY_RMI, this.sProgVersion);
        ((SJctrDataObject)summaryData).setData(KEY_TOTALCACHE, this.sCacheSize);
    }

    public static String getSystemName(SJmoSubsystemInfo info) {
        String retValue = info.getDKCsysName();
        if (retValue == null || retValue.length() == 0) {
            retValue = SJctrUserController.strStogageSystemType;
        }
        return retValue;
    }

    @Deprecated
    public static String getProductName() {
        SJmoDataChange mochg = SJmoModelMgr.getModelMgr().getDataChange();
        String sProductName = mochg.ChangeProductName(null);
        return sProductName;
    }

    String convertCapacity(long lPara) {
        String ret = "?";
        if (lPara == 0L) {
            return "-";
        }
        if (this.capaUtil != null && lPara > 0L) {
            long block = this.capaUtil.valueOf(lPara, SJctrCapacityUtility.UNIT.KB);
            ret = this.capaUtil.toUnitString(block);
        }
        return ret;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        sMB = util.getGuidance("COMMON", "MB");
        sGB = util.getGuidance("COMMON", "GB");
        sTB = util.getGuidance("COMMON", "TB");
        sHai = util.getGuidance("COMMON", "BAR");
        sPar = util.getGuidance("COMMON", "PERCENT");
        sEdit = util.getGuidance("COMMON", "EDIT_SUBSYSTEM");
        super.initGuidance(util);
    }

    public String getSDKCsysName() {
        return this.sDKCsysName;
    }

    public String getSProductName() {
        return this.sProductName;
    }

    public String getSSNAddString() {
        return this.sSNAddString;
    }

    public String getSIPAddress() {
        return this.sIPAddress;
    }

    public String getSDKCsysContact() {
        return this.sDKCsysContact;
    }

    public String getSDKCsysLocation() {
        return this.sDKCsysLocation;
    }

    public String getSMainVersion() {
        return this.sMainVersion;
    }

    public String getSMibVersion() {
        return this.sMibVersion;
    }

    public String getSProgVersion() {
        return this.sProgVersion;
    }

    public String getSCacheSize() {
        return this.sCacheSize;
    }
}

