/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.host;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.port.SJctrPortSummaryModel;
import sanproject.sn2.controller.topwindow.port.host.SJctrHostActionMenuModel;
import sanproject.sn2.controller.topwindow.port.host.SJctrPortHostTableModel;
import sanproject.sn2.controller.wizard.lunm.addtohostgroups.SJctrAddtoHGSubWizard;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrEditHostSelectData;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrEditHostSubWizard;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrEditHostIscsiSelectData;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrEditHostIscsiSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.hostproperties.SJctrHostPropertiesDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removehosts.SJctrRemoveHostsSubWizard;
import sanproject.sn2.controller.wizard.lunm.removehosts.SJctrRemoveHostsSelectData;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrHostDC
extends SJctrDataController {
    public static final int DISP_ID = 1797;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_SELECTED_HOSTS = "COM_SELECTED_HOSTS";

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrPortSummaryModel());
        SJctrPortHostTableModel tableModel = new SJctrPortHostTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrHostActionMenuModel());
    }

    public SJctrHostDC() throws SJcException {
        super(1797);
        this.initDataModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_ADDTOHOSTGROUPS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostDC.this.makeAddtoHostGroups(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_REMOVEHOSTS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostDC.this.makeRemoveHosts(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_REMOVEHOSTS_ISCSI, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostDC.this.makeRemoveIscsiHosts(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_VIEWPROPERTIES_ISCSI, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostDC.this.makeViewHostProperties(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_EDITHOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostDC.this.makeEditHost(event, dstModel);
            }
        });
    }

    private void makeAddtoHostGroups(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeAddtoHostGroups", "not selected");
            return;
        }
        ArrayList<SJmoWwn> selecteList = new ArrayList<SJmoWwn>(selectedRowList.size());
        for (Object selectRow : selectedRowList) {
            SJctrPortHostGroupWwnTableKey tableKey = (SJctrPortHostGroupWwnTableKey)selectRow;
            if (!tableKey.isFibre()) {
                this.getLogUty().putlog("makeAddtoHostGroups", "selected iSCSI Port");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoWwn wwn = tableKey.getWwnInfo();
            selecteList.add(wwn);
        }
        HashMap param = new HashMap();
        param.put(SJmoWwn.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAddtoHGSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeRemoveHosts(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeRemoveHosts", "not selected");
            return;
        }
        ArrayList<SJctrRemoveHostsSelectData> selecteList = new ArrayList<SJctrRemoveHostsSelectData>(1);
        SJctrRemoveHostsSelectData selectData = new SJctrRemoveHostsSelectData();
        ArrayList<SJmoPortHostGroupInfo> portHGList = new ArrayList<SJmoPortHostGroupInfo>(selectedRowList.size());
        for (Object selectRow : selectedRowList) {
            SJctrPortHostGroupWwnTableKey tableKey = (SJctrPortHostGroupWwnTableKey)selectRow;
            if (!tableKey.isFibre()) {
                this.getLogUty().putlog("makeRemoveHosts", "selected iSCSI Port");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoPortHostGroupInfo tblPortHG = tableKey.getPortHostGroupInfo();
            SJmoHostGroupInfo tblHG = tableKey.getHostGroupInfo();
            SJmoWwn tblWwn = tableKey.getWwnInfo();
            ArrayList<SJmoWwn> wwnList = new ArrayList<SJmoWwn>(1);
            SJmoWwn wwnInfo = new SJmoWwn();
            wwnInfo.setByWWN(tblWwn.getByWWN());
            wwnInfo.setIDataMode(tblWwn.getIDataMode());
            wwnInfo.setStrWWNNickName(tblWwn.getStrWWNNickName());
            wwnList.add(wwnInfo);
            ArrayList<SJmoHostGroupInfo> hgList = new ArrayList<SJmoHostGroupInfo>(1);
            SJmoHostGroupInfo hgInfo = new SJmoHostGroupInfo();
            hgInfo.setBtOption(tblHG.getBtOption());
            hgInfo.setByHostMode(tblHG.getByHostMode());
            hgInfo.setIDataMode(tblHG.getIDataMode());
            hgInfo.setSHostGroup(tblHG.getSHostGroup());
            hgInfo.setStrHostgroupNickName(tblHG.getStrHostgroupNickName());
            hgInfo.setStrHostModeDisplayName(tblHG.getStrHostModeDisplayName());
            hgInfo.setAlHostGroupWwn(wwnList);
            hgList.add(hgInfo);
            SJmoPortHostGroupInfo portHGInfo = new SJmoPortHostGroupInfo();
            portHGInfo.setSPort(tblPortHG.getSPort());
            portHGInfo.setIDataMode(tblPortHG.getIDataMode());
            portHGInfo.setAlPortHostGroup(hgList);
            portHGList.add(portHGInfo);
        }
        selectData.setData(portHGList);
        selecteList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrRemoveHostsSelectData.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(sanproject.sn2.controller.wizard.lunm.removehosts.SJctrRemoveHostsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeRemoveIscsiHosts(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeRemoveIscsiHosts", "not selected");
            return;
        }
        ArrayList<SJmoIscsiName> iscsiNameList = new ArrayList<SJmoIscsiName>(selectedRowList.size());
        for (Object selectRow : selectedRowList) {
            SJctrPortHostGroupWwnTableKey tableKey = (SJctrPortHostGroupWwnTableKey)selectRow;
            if (tableKey.isFibre()) {
                this.getLogUty().putlog("makeRemoveIscsiHosts", "selected Fibre Port");
                SJctrError err = new SJctrError(10, 22, 206518);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoIscsiName itName = tableKey.getIscsiNameInfo();
            iscsiNameList.add(itName);
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_HOSTS", iscsiNameList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrRemoveHostsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeViewHostProperties(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeViewHostProperties", "not selected");
            return;
        }
        ArrayList<SJmoIscsiName> paramList = new ArrayList<SJmoIscsiName>(selectedRowList.size());
        for (Object selectRow : selectedRowList) {
            SJctrPortHostGroupWwnTableKey tableKey = (SJctrPortHostGroupWwnTableKey)selectRow;
            if (tableKey.isFibre()) {
                this.getLogUty().putlog("makeViewHostProperties", "selected Fibre Port");
                SJctrError err = new SJctrError(10, 22, 206518);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoIscsiName itInfo = tableKey.getIscsiNameInfo();
            try {
                paramList.add((SJmoIscsiName)itInfo.clone());
            }
            catch (CloneNotSupportedException e) {}
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_HOSTS", paramList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrHostPropertiesDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    private void makeEditHost(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeCreateAltPaths", "not selected");
            return;
        }
        ArrayList<SJctrEditHostSelectData> selecteList = new ArrayList<SJctrEditHostSelectData>(1);
        SJctrEditHostSelectData selectData = new SJctrEditHostSelectData();
        SJctrPortHostGroupWwnTableKey tableKey = (SJctrPortHostGroupWwnTableKey)selectedRowList.get(0);
        if (!tableKey.isFibre()) {
            this.makeEditHostIscsi(tableKey);
            return;
        }
        SJmoPortHostGroupInfo tblPortHG = tableKey.getPortHostGroupInfo();
        SJmoHostGroupInfo tblHG = tableKey.getHostGroupInfo();
        SJmoWwn tblWwn = tableKey.getWwnInfo();
        ArrayList<SJmoWwn> wwnList = new ArrayList<SJmoWwn>(1);
        SJmoWwn wwnInfo = new SJmoWwn();
        wwnInfo.setByWWN(tblWwn.getByWWN());
        wwnInfo.setIDataMode(tblWwn.getIDataMode());
        wwnInfo.setStrWWNNickName(tblWwn.getStrWWNNickName());
        wwnList.add(wwnInfo);
        ArrayList<SJmoHostGroupInfo> hgList = new ArrayList<SJmoHostGroupInfo>(1);
        SJmoHostGroupInfo hgInfo = new SJmoHostGroupInfo();
        hgInfo.setBtOption(tblHG.getBtOption());
        hgInfo.setByHostMode(tblHG.getByHostMode());
        hgInfo.setIDataMode(tblHG.getIDataMode());
        hgInfo.setSHostGroup(tblHG.getSHostGroup());
        hgInfo.setStrHostgroupNickName(tblHG.getStrHostgroupNickName());
        hgInfo.setStrHostModeDisplayName(tblHG.getStrHostModeDisplayName());
        hgInfo.setAlHostGroupWwn(wwnList);
        hgList.add(hgInfo);
        SJmoPortHostGroupInfo portHGInfo = new SJmoPortHostGroupInfo();
        portHGInfo.setSPort(tblPortHG.getSPort());
        portHGInfo.setIDataMode(tblPortHG.getIDataMode());
        portHGInfo.setAlPortHostGroup(hgList);
        selectData.setData(portHGInfo);
        selecteList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrEditHostSelectData.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditHostSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditHostIscsi(SJctrPortHostGroupWwnTableKey tableKey) {
        ArrayList<SJctrEditHostIscsiSelectData> selecteList = new ArrayList<SJctrEditHostIscsiSelectData>(1);
        SJctrEditHostIscsiSelectData selectData = new SJctrEditHostIscsiSelectData();
        SJmoPortIscsiTargetInfo tblPortIT = tableKey.getPortIscsiTargetInfo();
        SJmoIscsiTargetInfo tblIT = tableKey.getIscsiTargetInfo();
        SJmoIscsiName tblIscsiName = tableKey.getIscsiNameInfo();
        ArrayList<SJmoIscsiName> iscsiNameList = new ArrayList<SJmoIscsiName>(1);
        SJmoIscsiName iscsiNameInfo = new SJmoIscsiName();
        iscsiNameInfo.setStrIscsiName(tblIscsiName.getStrIscsiName());
        iscsiNameInfo.setIDataMode(tblIscsiName.getIDataMode());
        iscsiNameInfo.setStrIscsiNickName(tblIscsiName.getStrIscsiNickName());
        iscsiNameList.add(iscsiNameInfo);
        ArrayList<SJmoIscsiTargetInfo> itList = new ArrayList<SJmoIscsiTargetInfo>(1);
        SJmoIscsiTargetInfo itInfo = new SJmoIscsiTargetInfo();
        itInfo.setBtOption(tblIT.getBtOption());
        itInfo.setIHostMode(tblIT.getIHostMode());
        itInfo.setIDataMode(tblIT.getIDataMode());
        itInfo.setSIscsiTarget(tblIT.getSIscsiTarget());
        itInfo.setStrIscsiTargetName(tblIT.getStrIscsiTargetName());
        itInfo.setIHostMode(tblIT.getIHostMode());
        itInfo.setAlIscsiName(iscsiNameList);
        itList.add(itInfo);
        SJmoPortIscsiTargetInfo portITInfo = new SJmoPortIscsiTargetInfo();
        portITInfo.setSPort(tblPortIT.getSPort());
        portITInfo.setIDataMode(tblPortIT.getIDataMode());
        portITInfo.setAlPortIscsiTarget(itList);
        selectData.setData(portITInfo);
        selecteList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrEditHostIscsiSelectData.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditHostIscsiSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    public static enum HG_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_ADDTOHOSTGROUPS,
        MAKE_REMOVEHOSTS,
        MAKE_EDITHOST,
        MAKE_REMOVEHOSTS_ISCSI,
        MAKE_VIEWPROPERTIES_ISCSI;

    }
}

