/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.hostgroup;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrHostGroupNameComparator;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrItemExpandListenerHG
implements SJctrItemExpandListener {
    private static final SJctrHostGroupNameComparator hgComp = new SJctrHostGroupNameComparator();

    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String name = (String)event.getChangeObject();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        String parentNodePath = name + "\t";
        HashSet<String> keySet = new HashSet<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keySet) {
            if (!childeNodePath.startsWith(parentNodePath)) continue;
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String name = (String)event.getChangeObject();
        SJctrNodeData nodeData = dataModel.getNodePathToNodeDataMap().get(name);
        Object[] args = nodeData.getNodePathToArgsMap().get(name);
        SJmoPortDetail ptDetail = (SJmoPortDetail)args[0];
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        List<?> ptHgInfoList = nodeData.getDataModel().getDataController().getModelData(SJmoGetPortHostGroupInfo.class);
        if (ptHgInfoList == null) {
            return;
        }
        int portIndex = Collections.binarySearch(ptHgInfoList, (Object)ptDetail);
        if (portIndex < 0) {
            return;
        }
        SJmoPortHostGroupInfo ptHgInfo = (SJmoPortHostGroupInfo)ptHgInfoList.get(portIndex);
        List<?> pAttrInfoList = nodeData.getDataModel().getDataController().getModelData(SJmoGetPortAttributeInfo.class);
        if (pAttrInfoList == null) {
            return;
        }
        int search = Collections.binarySearch(pAttrInfoList, (Object)ptHgInfo);
        if (search < 0) {
            return;
        }
        SJmoPortAttributeInfo pAttrInfo = (SJmoPortAttributeInfo)pAttrInfoList.get(search);
        if (pAttrInfo.getByPortKind() == 5) {
            SJmoHostGroupInfo defHgInfo = (SJmoHostGroupInfo)ptHgInfo.getAlPortHostGroup().get(0);
            Object[] defHGNode = new Object[]{ptDetail, defHgInfo};
            dataModel.addItem(childeNodeData, defHGNode);
            return;
        }
        SJctrDataController dc = dataModel.getDataController();
        SJctrUserController uc = dc.getOwner();
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null) {
            return;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        ArrayList hgList = ptHgInfo.getAlPortHostGroup();
        if (hgList == null) {
            return;
        }
        hgList = new ArrayList(ptHgInfo.getAlPortHostGroup());
        Collections.sort(hgList, (Comparator)hgComp);
        for (SJmoHostGroupInfo hgInfo : hgList) {
            hgIndex.setSPort(hgInfo.getSPort());
            hgIndex.setSHostGroup(hgInfo.getSHostGroup());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) continue;
            Object[] childeArgs = new Object[]{ptDetail, hgInfo};
            dataModel.addItem(childeNodeData, childeArgs);
        }
    }
}

