/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.iscsi.port;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrItemExpandListenerIscsiPort
implements SJctrItemExpandListener {
    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String name = (String)event.getChangeObject();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        String parentNodePath = name + "\t";
        HashSet<String> keySet = new HashSet<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keySet) {
            if (!childeNodePath.startsWith(parentNodePath)) continue;
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        List<?> ptDtailList = dataModel.getDataController().getModelData(SJmoGetPortDetail.class);
        if (null == ptDtailList) {
            return;
        }
        SJctrDataController dc = dataModel.getDataController();
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (null == rsgDetailList || rsgDetailList.size() == 0) {
            return;
        }
        SJmoRSGgetAllRsgs rsgDetail = (SJmoRSGgetAllRsgs)rsgDetailList.get(0);
        if (null == rsgDetail) {
            return;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), rsgDetail);
        List<SJmoHostGroupIndex> enableHgList = SJctrIscsiUtility.getEnableResourceHgList(rsgUtil);
        for (SJmoPortDetail ptDetail : ptDtailList) {
            Object[] args;
            HashMap<String, Object> item;
            int index;
            int rsgId;
            boolean rsgFlg;
            if (!SJctrIscsiUtility.isIscsiPort(ptDetail) || !(rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId = rsgUtil.getRsgId(ptDetail), rsgUtil)) && (index = Collections.binarySearch(enableHgList, ptDetail.getSPort(), new Comparator(){

                public int compare(Object o1, Object o2) {
                    SJmoHostGroupIndex hgIndex = (SJmoHostGroupIndex)o1;
                    short portId = (Short)o2;
                    return hgIndex.getSPort() - portId;
                }
            })) < 0 || dataModel.addItem(item = dataModel.createItem(childeNodeData, args = new Object[]{ptDetail}), childeNodeData, args)) continue;
            String name = SJctrNewTreeDataModel.Item.getName(item);
            dataModel.getNodePathToNodeDataMap().put(name, childeNodeData);
            childeNodeData.getNodePathToArgsMap().put(name, args);
        }
    }
}

