/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.port;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrItemExpandListenerPort
implements SJctrItemExpandListener {
    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        ArrayList<String> keyList = new ArrayList<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keyList) {
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        List<?> ptDtailList = dataModel.getDataController().getModelData(SJmoGetPortDetail.class);
        if (ptDtailList == null) {
            return;
        }
        SJctrDataController dc = dataModel.getDataController();
        SJctrUserController uc = dc.getOwner();
        List<?> ptHgInfoList = dc.getModelData(SJmoGetPortHostGroupInfo.class);
        if (ptHgInfoList == null) {
            return;
        }
        List<?> ptItInfoList = dc.getModelData(SJmoGetPortIscsiTargetInfo.class);
        if (ptItInfoList == null) {
            return;
        }
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null) {
            return;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (SJmoPortDetail ptDetail : ptDtailList) {
            Object[] args;
            HashMap<String, Object> item;
            int rsgId;
            boolean rsgFlg;
            short hgindex;
            short sPort;
            SJmoPortIndex ptHgInfo;
            int portIndex;
            boolean fibre = SJctrPortUtility.isSupportPortType(ptDetail);
            boolean iscsi = SJctrPortUtility.isIscsiPort(ptDetail);
            boolean rsgHgFlg = false;
            if (fibre) {
                portIndex = Collections.binarySearch(ptHgInfoList, (Object)ptDetail);
                if (portIndex < 0) continue;
                ptHgInfo = (SJmoPortHostGroupInfo)ptHgInfoList.get(portIndex);
                sPort = ptHgInfo.getSPort();
                for (hgindex = 0; hgindex < SJctrPortUtility.PORT_HOSTGROUP_MAX; hgindex = (short)(hgindex + 1)) {
                    hgIndex.setSPort(sPort);
                    hgIndex.setSHostGroup(hgindex);
                    rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                    if (!rsgHgFlg) {
                        continue;
                    }
                    break;
                }
            } else {
                if (!iscsi || (portIndex = Collections.binarySearch(ptItInfoList, (Object)ptDetail)) < 0) continue;
                ptHgInfo = (SJmoPortIscsiTargetInfo)ptItInfoList.get(portIndex);
                sPort = ptHgInfo.getSPort();
                for (hgindex = 0; hgindex < SJctrPortUtility.PORT_ISCSITARGET_MAX; hgindex = (short)(hgindex + 1)) {
                    hgIndex.setSPort(sPort);
                    hgIndex.setSHostGroup(hgindex);
                    rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                    if (!rsgHgFlg) {
                        continue;
                    }
                    break;
                }
            }
            if (!rsgHgFlg && !(rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId = rsgUtil.getRsgId(ptDetail), rsgUtil)) || !dataModel.addItem(item = dataModel.createItem(childeNodeData, args = new Object[]{ptDetail}), childeNodeData, args)) continue;
            String nodeName = SJctrNewTreeDataModel.Item.getName(item);
            SJctrNewTreeDataModel.Item.setList(dataModel.getItem(nodeName), new ArrayList<HashMap<String, Object>>());
        }
    }
}

