/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.port;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLaunchDispItem;
import sanproject.sn2.controller.com.SJctrLaunchInterface;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.port.SJctrPortSummaryModel;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortActionMenuModel;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortTableModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsSelectData;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsSubWizard;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.SJctrEditIscsiPortsSubWizard;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrEditT10PIModeSubWizard;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrPortDC
extends SJctrDataController
implements SJctrLaunchInterface {
    public static final int DISP_ID = 1793;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    private static final String STR_DISP_ID = "V7-1";

    private void initDataObjectModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrPortSummaryModel());
        SJctrPortTableModel tableModel = new SJctrPortTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrPortActionMenuModel());
    }

    public SJctrPortDC() throws SJcException {
        super(1793);
        this.initDataObjectModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(PORT_NOTIFY_STATE.MAKE_EDITPORT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrPortDC.this.makeEditPort(event, dstModel);
            }
        });
        this.addMessageEventListener(PORT_NOTIFY_STATE.MAKR_EDITT10PI, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrPortDC.this.makeEditT10PI(event, dstModel);
            }
        });
    }

    private void makeEditPort(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditPort", "not selected");
            return;
        }
        Boolean fibreFlg = false;
        Boolean iscsiFlg = false;
        ArrayList<SJctrEditPortsSelectData> selecteList = new ArrayList<SJctrEditPortsSelectData>(1);
        ArrayList<SJmoPortIndex> portIndexList = new ArrayList<SJmoPortIndex>(selectedRowList.size());
        SJctrEditPortsSelectData selectData = new SJctrEditPortsSelectData();
        for (Object selectRow : selectedRowList) {
            SJmoPortDetail portDtl = (SJmoPortDetail)selectRow;
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(portDtl.getSPort());
            portIndexList.add(portIndex);
            if (SJctrPortUtility.isIscsiPort(portDtl)) {
                iscsiFlg = true;
            } else {
                fibreFlg = true;
            }
            if (!fibreFlg.booleanValue() || !iscsiFlg.booleanValue()) continue;
            this.getLogUty().putlog("makeEditPort", "both Fibre and iSCSI were selected");
            SJctrError err = new SJctrError(10, 22, 206519);
            SJcException exp = err.createException();
            throw exp;
        }
        selectData.setData(portIndexList);
        selecteList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrEditPortsSelectData.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = fibreFlg != false ? this.createWizard(SJctrEditPortsSubWizard.class, param) : this.createWizard(SJctrEditIscsiPortsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditT10PI(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.isEmpty()) {
            this.getLogUty().putlog("makeEditT10PI", "not selected");
            return;
        }
        SJctrEditT10PIModeSubWizard.makeEditT10PIModeWizard(this, selectedRowList);
    }

    @Override
    public SJctrLaunchDispItem getSelectionItem() {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        int selectListSize = selectedRowList.size();
        if (selectListSize == 0) {
            SJctrLaunchDispItem dispSelItem = new SJctrLaunchDispItem(STR_DISP_ID, 1);
            dispSelItem.addSelItem(null, null);
            return dispSelItem;
        }
        ArrayList<String> portlist = new ArrayList<String>();
        for (Object selectRow : selectedRowList) {
            SJmoPortDetail portDtl = (SJmoPortDetail)selectRow;
            String itemName = portDtl.getStrPortDisplayName();
            portlist.add(itemName);
        }
        Collections.sort(portlist);
        SJctrLaunchDispItem dispSelItem = new SJctrLaunchDispItem(STR_DISP_ID, selectListSize);
        for (String selectRow : portlist) {
            dispSelItem.addSelItem("Port", selectRow);
        }
        return dispSelItem;
    }

    public static enum PORT_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_EDITPORT,
        MAKR_EDITT10PI;

    }
}

