/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.port;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrPortDetailSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_WWN = "COM_WWN";
    public static final String KEY_LUNS_NUM = "COM_LUNS_NUM";
    public static final String KEY_HT_NUM = "COM_HT_NUM";
    public static final String KEY_HG_NUM = "COM_HG_NUM";
    public static final String KEY_CHNL_SPEED = "COM_CHNL_SPEED";
    public static final String KEY_PT_ATTR = "COM_PT_ATTR";
    public static final String KEY_PT_SECU = "COM_PT_SECU";
    public static final String KEY_FIBREADDR = "COM_FIBREADDR";
    public static final String KEY_FCSWITCH = "COM_FCSWITCH";
    public static final String KEY_CONNECT = "COM_CONNECT";
    public static final String KEY_T10PI_MODE = "COM_T10PI_MODE";
    public static final String KEY_SFP_SPEED = "COM_SFP_SPEED";

    @Override
    public void makeDataObject() {
        ArrayList<SJmoPortIndex> summryList = new ArrayList<SJmoPortIndex>();
        List<SJmoGetPortHostGroupInfo> portHostGroupInfoList = this.getBasicDataList(SJmoGetPortHostGroupInfo.class);
        List<SJmoGetPortDetail> portdetailList = this.getBasicDataList(SJmoGetPortDetail.class);
        List<SJmoGetPortLunInfo> portLunInfoList = this.getBasicDataList(SJmoGetPortLunInfo.class);
        List<SJmoGetPortAttributeInfo> portAttributeInfoList = this.getBasicDataList(SJmoGetPortAttributeInfo.class);
        summryList.add(this.getPortHostGroupSummry(portHostGroupInfoList));
        summryList.add(this.getPortDetailSummry(portdetailList));
        summryList.add(this.getPortLunInfoSummry(portLunInfoList));
        summryList.add(this.getPortAttributeInfoSummry(portAttributeInfoList));
        this.makeSummary(summryList);
    }

    public SJmoPortHostGroupInfo getPortHostGroupSummry(List<SJmoPortHostGroupInfo> portHostGroupInfoList) {
        SJmoPortHostGroupInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrPortSelectDC) {
            SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
            short selectPort = ptSelDc.getSelectPort();
            for (SJmoPortHostGroupInfo ptHgInfo : portHostGroupInfoList) {
                if (ptHgInfo.getSPort() != selectPort) continue;
                ret = ptHgInfo;
                break;
            }
        }
        return ret;
    }

    public SJmoPortDetail getPortDetailSummry(List<SJmoPortDetail> portDetailList) {
        SJmoPortDetail ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrPortSelectDC) {
            SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
            short selectPort = ptSelDc.getSelectPort();
            for (SJmoPortDetail ptDetail : portDetailList) {
                if (ptDetail.getSPort() != selectPort) continue;
                ret = ptDetail;
                break;
            }
        }
        return ret;
    }

    public SJmoPortLunInfo getPortLunInfoSummry(List<SJmoPortLunInfo> portLunInfoList) {
        SJmoPortLunInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrPortSelectDC) {
            SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
            short selectPort = ptSelDc.getSelectPort();
            for (SJmoPortLunInfo ptLunInfo : portLunInfoList) {
                if (ptLunInfo.getSPort() != selectPort) continue;
                ret = ptLunInfo;
                break;
            }
        }
        return ret;
    }

    public SJmoPortAttributeInfo getPortAttributeInfoSummry(List<SJmoPortAttributeInfo> portAttributeInfoList) {
        SJmoPortAttributeInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrPortSelectDC) {
            SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
            short selectPort = ptSelDc.getSelectPort();
            for (SJmoPortAttributeInfo ptAttributeInfo : portAttributeInfoList) {
                if (ptAttributeInfo.getSPort() != selectPort) continue;
                ret = ptAttributeInfo;
                break;
            }
        }
        return ret;
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetPortHostGroupInfo hgInfo_kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF hgInfo_range = null;
        ArrayList hgInfo_filterList = new ArrayList();
        SJmoGetDirect hgInfo_direct = new SJmoGetDirect(hgInfo_kind, hgInfo_range, hgInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(hgInfo_direct));
        SJmoGetPortDetail ptDetail_kind = new SJmoGetPortDetail();
        SJmoGetRange_IF ptDetail_range = null;
        ArrayList ptDetail_filterList = new ArrayList();
        SJmoGetDirect ptDetail_direct = new SJmoGetDirect(ptDetail_kind, ptDetail_range, ptDetail_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ptDetail_direct));
        SJmoGetPortLunInfo ptLunInfo_kind = new SJmoGetPortLunInfo();
        SJmoGetRange_IF ptLunInfo__range = null;
        ArrayList ptLunInfo__filterList = new ArrayList();
        SJmoGetDirect ptLunInfo_direct = new SJmoGetDirect(ptLunInfo_kind, ptLunInfo__range, ptLunInfo__filterList);
        this.directList.add(new SJctrGetDirectWrapper(ptLunInfo_direct));
        SJmoGetPortAttributeInfo ptAttribute_kind = new SJmoGetPortAttributeInfo();
        SJmoGetRange_IF ptAttribute_range = null;
        ArrayList ptAttribute_filterList = new ArrayList();
        SJmoGetDirect ptAttribute_direct = new SJmoGetDirect(ptAttribute_kind, ptAttribute_range, ptAttribute_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ptAttribute_direct));
    }

    protected void makeSummary(List<?> summryList) {
        String hg_num;
        String ht_num;
        String lun_num;
        SJmoPortHostGroupInfo ptHgInfo = (SJmoPortHostGroupInfo)summryList.get(0);
        SJmoPortDetail ptDetail = (SJmoPortDetail)summryList.get(1);
        SJmoPortLunInfo ptLunInfo = (SJmoPortLunInfo)summryList.get(2);
        SJmoPortAttributeInfo ptAttributeInfo = (SJmoPortAttributeInfo)summryList.get(3);
        String pt_wwn = this.getPortWWN(ptDetail);
        if (ptAttributeInfo.getByPortKind() == 5) {
            lun_num = SJctrPortUtility.STR_HYPHEN;
            ht_num = SJctrPortUtility.STR_HYPHEN;
            hg_num = SJctrComUtility.toDecString(1);
        } else if (ptAttributeInfo.getByPortKind() == 6) {
            lun_num = SJctrPortUtility.STR_HYPHEN;
            ht_num = SJctrPortUtility.STR_HYPHEN;
            hg_num = SJctrComUtility.toDecString(0);
        } else {
            lun_num = this.getLunNum(ptLunInfo);
            ht_num = this.getHostNum(ptHgInfo);
            hg_num = this.getHostGroupNum(ptHgInfo);
        }
        String chnl_speed = this.getChannelSpeed(ptDetail);
        String pt_attr = this.getPortAttribute(ptAttributeInfo);
        String pt_secu = this.getPortSecurity(ptDetail);
        String pt_fibreaddr = this.getFibreAddress(ptDetail);
        String pt_fcswitch = this.getFCSwitch(ptDetail);
        String pt_connection = this.getConnection(ptDetail);
        String pt_t10pimode = this.getT10PiMode(ptDetail);
        String sfp_speed = this.getSfpSpeed(ptDetail);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_WWN, pt_wwn);
        ((SJctrDataObject)summaryData).setData(KEY_LUNS_NUM, lun_num);
        ((SJctrDataObject)summaryData).setData(KEY_HT_NUM, ht_num);
        ((SJctrDataObject)summaryData).setData(KEY_HG_NUM, hg_num);
        ((SJctrDataObject)summaryData).setData(KEY_CHNL_SPEED, chnl_speed);
        ((SJctrDataObject)summaryData).setData(KEY_PT_ATTR, pt_attr);
        ((SJctrDataObject)summaryData).setData(KEY_PT_SECU, pt_secu);
        ((SJctrDataObject)summaryData).setData(KEY_FIBREADDR, pt_fibreaddr);
        ((SJctrDataObject)summaryData).setData(KEY_FCSWITCH, pt_fcswitch);
        ((SJctrDataObject)summaryData).setData(KEY_CONNECT, pt_connection);
        ((SJctrDataObject)summaryData).setData(KEY_T10PI_MODE, pt_t10pimode);
        ((SJctrDataObject)summaryData).setData(KEY_SFP_SPEED, sfp_speed);
    }

    private String getPortWWN(SJmoPortDetail ptDetail) {
        String wwn = "";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            wwn = portutil.toWWNDisplay(ptDetail);
        }
        return wwn;
    }

    private String getLunNum(SJmoPortLunInfo ptLunInfo) {
        StringBuffer buf = new StringBuffer();
        int num = 0;
        if (ptLunInfo != null) {
            num = ptLunInfo.getAlPortLun().size();
        }
        buf.append(SJctrComUtility.toDecString(num));
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrComUtility util = uc.getComUtility();
        buf.append(util.getStrMaxAllowed(SJctrPortUtility.PORT_LUN_MAX));
        return buf.toString();
    }

    private String getHostNum(SJmoPortHostGroupInfo ptHgInfo) {
        StringBuffer buf = new StringBuffer();
        int num = 0;
        if (ptHgInfo != null) {
            ArrayList hgInfoList = ptHgInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                num += hgInfo.getAlHostGroupWwn().size();
            }
        }
        buf.append(SJctrComUtility.toDecString(num));
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrComUtility util = uc.getComUtility();
        buf.append(util.getStrMaxAllowed(SJctrPortUtility.PORT_WWN_MAX));
        return buf.toString();
    }

    private String getHostGroupNum(SJmoPortHostGroupInfo ptHgInfo) {
        StringBuffer buf = new StringBuffer();
        int num = 0;
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrComUtility util = uc.getComUtility();
        int maxNum = 0;
        if (ptHgInfo != null) {
            boolean rsgFlg;
            SJctrDataController dc = this.getDataController();
            List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
            if (rsgDetailList == null) {
                return buf.toString();
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            for (SJmoHostGroupInfo hgInfo : ptHgInfo.getAlPortHostGroup()) {
                hgIndex.setSPort(hgInfo.getSPort());
                hgIndex.setSHostGroup(hgInfo.getSHostGroup());
                rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) continue;
                ++num;
            }
            short sPort = ptHgInfo.getSPort();
            for (short index = 0; index < SJctrPortUtility.PORT_HOSTGROUP_MAX; index = (short)(index + 1)) {
                hgIndex.setSPort(sPort);
                hgIndex.setSHostGroup(index);
                rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) continue;
                ++maxNum;
            }
            buf.append(SJctrComUtility.toDecString(num));
            buf.append(util.getStrMaxAllowed(maxNum));
        }
        return buf.toString();
    }

    private String getChannelSpeed(SJmoPortDetail ptDetail) {
        String speed = "";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            speed = portutil.toChannelSpeedDisplay(ptDetail);
        }
        return speed;
    }

    private String getPortAttribute(SJmoPortAttributeInfo ptAttributeInfo) {
        String attr = "";
        if (ptAttributeInfo != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            attr = portutil.toPortAttributeDisplay(ptAttributeInfo);
        }
        return attr;
    }

    private String getPortSecurity(SJmoPortDetail ptDetail) {
        String secu = "";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            secu = portutil.toPortSecuritySwitchDisplay(ptDetail);
        }
        return secu;
    }

    private String getFibreAddress(SJmoPortDetail ptDetail) {
        String fibreAddr = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            fibreAddr = portutil.toFibreAddressDisplay(ptDetail);
        }
        return fibreAddr;
    }

    private String getFCSwitch(SJmoPortDetail ptDetail) {
        String fcSwitch = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            fcSwitch = portutil.toFCSwitchDisplay(ptDetail);
        }
        return fcSwitch;
    }

    private String getConnection(SJmoPortDetail ptDetail) {
        String connection = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            connection = portutil.toConnectionDisplay(ptDetail);
        }
        return connection;
    }

    private String getT10PiMode(SJmoPortDetail ptDetail) {
        String t10PiMode = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            t10PiMode = portutil.toT10PIModeDisplay(ptDetail);
        }
        return t10PiMode;
    }

    private String getSfpSpeed(SJmoPortDetail ptDetail) {
        String sfpSpeed = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            sfpSpeed = portutil.toSFPDataTransferRateDisplay(ptDetail);
        }
        return sfpSpeed;
    }
}

