/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.tasks.status;

import java.util.List;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.tasks.com.SJctrTaskUtility;
import sanproject.sn2.controller.topwindow.tasks.status.SJctrTasksStatusDC;

public class SJctrTasksStatusMessageModel
extends SJctrSimpleDataModel {
    public static final String KEY_MESSAGE = "COM_MESSAGE";
    public static final String KEY_ACTION_NAME = "COM_ACTION_NAME";
    public static final String KEY_STATUS_TYPE = "COM_STATUS_TYPE";
    public static final String KEY_FUNCTION_CODE = "COM_FUNCTION_CODE";
    public static final String KEY_MODULE_CODE = "COM_MODULE_CODE";
    public static final String KEY_ERROR_CODE = "COM_ERROR_CODE";
    public static final String KEY_MSG = "COM_MSG";

    public SJctrTasksStatusMessageModel(SJctrTask mTaskInfo, SJctrError sError, SJctrComUtility com) {
        this.setmakeDataObject(mTaskInfo, sError, com);
    }

    @Override
    public void makeDataObject() {
    }

    public void setmakeDataObject(SJctrTask svTask, SJctrError sError, SJctrComUtility com) {
        int st = 0;
        String sFunction = "202";
        String sModule = "22";
        String sErrorCode = "";
        String[] sMsgArgument = null;
        String[] sMsgMeansureArgument = null;
        SJctrTaskUtility taskutil = new SJctrTaskUtility(com);
        String sActionName = taskutil.getTaskName(svTask.getActionGuidance(), 0, svTask.getType());
        switch (svTask.getStatus()) {
            case 1: {
                st = 0;
                break;
            }
            case 2: {
                st = 6;
                break;
            }
            case 256: 
            case 257: {
                st = 1;
                break;
            }
            case 258: {
                st = 7;
                break;
            }
            case 512: {
                int behavior = svTask.getGeneralBehavior();
                if (SJctrTask.checkBehavior(behavior, 4)) {
                    st = 9;
                    break;
                }
                st = 2;
                break;
            }
            case 513: {
                List<String> actionList = svTask.getActionType();
                if (actionList != null) {
                    List<Boolean> actionError = svTask.hasDetailActionResult();
                    List<SJctrGuidance> guidList = svTask.getActionGuidance();
                    if (actionError != null) {
                        for (int ii = 0; ii < actionError.size(); ++ii) {
                            if (!actionError.get(ii).booleanValue()) continue;
                            sActionName = taskutil.getTaskName(guidList, ii, actionList.get(ii));
                        }
                    }
                }
                boolean unexecute = svTask.containsUnExecuteApply();
                st = this.chkDefError(sError) ? (unexecute ? 11 : 4) : (unexecute ? 10 : 3);
                sFunction = SJctrComUtility.toDecString(sError.getFunc());
                sModule = SJctrComUtility.toDecString(sError.getModule());
                sErrorCode = SJctrComUtility.toDecString(sError.getError());
                sMsgArgument = sError.getMsgArgument();
                sMsgMeansureArgument = sError.getMeansureArgument();
                break;
            }
            case 514: {
                st = 5;
                sFunction = SJctrComUtility.toDecString(sError.getFunc());
                sModule = SJctrComUtility.toDecString(sError.getModule());
                sErrorCode = SJctrComUtility.toDecString(sError.getError());
                sMsgArgument = sError.getMsgArgument();
                sMsgMeansureArgument = sError.getMeansureArgument();
                break;
            }
        }
        String sStatus = SJctrComUtility.toDecString(st);
        Object messge = this.getManageData();
        ((SJctrDataObject)messge).setData(KEY_ACTION_NAME, sActionName);
        ((SJctrDataObject)messge).setData(KEY_STATUS_TYPE, sStatus);
        SJcMessage msg = new SJcMessage(sFunction, sModule, sErrorCode, sMsgArgument, sMsgMeansureArgument);
        ((SJctrDataObject)messge).setData(KEY_MSG, msg);
    }

    private boolean chkDefError(SJctrError destError) {
        if (SJctrTasksStatusDC.DEF_ERROR.getFunc() != destError.getFunc()) {
            return false;
        }
        if (SJctrTasksStatusDC.DEF_ERROR.getModule() != destError.getModule()) {
            return false;
        }
        return SJctrTasksStatusDC.DEF_ERROR.getError() == destError.getError();
    }
}

