/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.changepwd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrUserInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdAC;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogUty;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public class SJctrChangePwdSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "CHANGE_PASSWORD";
    private static final Class<?> CONFIRM_DC = SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_CONFIRM_DC;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        boolean[] encrypt;
        String strLogTitle = this.getClass().getSimpleName();
        String strLogSubTitle = "constructConfirmData";
        SJctrLogUty logUty = wizard.getLogUty();
        logUty.setTitle(strLogTitle);
        Class[] otherUserParamClass = new Class[]{String.class, String.class};
        Class[] myUserParamClass = new Class[]{String.class, String.class, String.class};
        logUty.putlog(strLogSubTitle, "start");
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrChangePwdAC ac = new SJctrChangePwdAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(wizard.getClass());
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> param = dc.getProxy().getCache(SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_DATA);
        if (param == null || param.isEmpty()) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        Object obj = param.get(0);
        if (obj == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_DATA.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!(obj instanceof SJctrChangePwdData)) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrChangePwdData changePwdData = (SJctrChangePwdData)obj;
        SJctrUserInfoDetail beforeUserInfoDetail = changePwdData.getBeforeUserInfoDetail();
        SJctrUserInfoDetail afterUserInfoDetail = changePwdData.getAfterUserInfoDetail();
        if (beforeUserInfoDetail == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data ((Before)" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (afterUserInfoDetail == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data ((After)" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        Object[] params = null;
        Class<SJcUserInfoUty> cls = SJcUserInfoUty.class;
        ArrayList<Map<String, Object>> applyData = new ArrayList<Map<String, Object>>();
        if (changePwdData.isTargetUser()) {
            paramList.add(beforeUserInfoDetail.getUserName());
            paramList.add(SJcSecureUty.encryptStrToStr(beforeUserInfoDetail.getPassword()));
            paramList.add(SJcSecureUty.encryptStrToStr(afterUserInfoDetail.getPassword()));
            params = paramList.toArray(new Object[0]);
            encrypt = new boolean[]{false, true, true};
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY_METHOD_NAME", "setPasswordWithCheck");
            map.put("KEY_PARAM_CLASS", myUserParamClass);
            map.put("KEY_OBJECT", cls);
            map.put("KEY_PARAM", params);
            map.put("KEY_ENCRYPT", encrypt);
            applyData.add(map);
        } else {
            paramList.add(beforeUserInfoDetail.getUserName());
            paramList.add(SJcSecureUty.encryptStrToStr(afterUserInfoDetail.getPassword()));
            params = paramList.toArray(new Object[0]);
            encrypt = new boolean[]{false, true};
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY_METHOD_NAME", "setPassword");
            map.put("KEY_PARAM_CLASS", otherUserParamClass);
            map.put("KEY_OBJECT", cls);
            map.put("KEY_PARAM", params);
            map.put("KEY_ENCRYPT", encrypt);
            applyData.add(map);
        }
        ac.setApplyList(applyData);
        SJctrAccAdtLogData adtLogData = this.makeAdtLogData(logUty, (SJbaseUserSession)wizard.getOwner().getUserSession(), wizard.getOwner().getComUtility(), changePwdData);
        ac.setAdtLogData(adtLogData);
        wizard.addConfirmData(ac, related);
        logUty.putlog(strLogSubTitle, "end");
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_DC};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    private SJctrAccAdtLogData makeAdtLogData(SJctrLogUty logUty, SJbaseUserSession userSession, SJctrComUtility comUty, SJctrChangePwdData changePwdData) {
        String strLogSubTitle = "makeAdtLogData";
        SJctrAccAdtLogData adtLogData = new SJctrAccAdtLogData();
        try {
            adtLogData = SJctrAccAdtLogUty.makeAccAdtLogData(logUty, userSession, comUty.getGuidance("ACCOUNT", "ADT_CHANGE_PASSWORD"));
            adtLogData.setDetailList(this.makeAdtDetailList(comUty, changePwdData));
            if (!adtLogData.getDetailList().isEmpty()) {
                adtLogData.setStrFooter(comUty.getGuidance("ACCOUNT", "ADT_USER_NUM"));
            }
            adtLogData.setStrNormalEnd(comUty.getGuidance("ADT_NORMAL_END"));
            adtLogData.setStrError(comUty.getGuidance("ADT_ERROR"));
        }
        catch (Exception e) {
            if (logUty != null) {
                logUty.putlog(strLogSubTitle, "[Logic Error]makeAdtLogData() is failed.", e, 40000);
            }
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        return adtLogData;
    }

    private List<SJctrAuditLogData> makeAdtDetailList(SJctrComUtility util, SJctrChangePwdData changePwdData) {
        ArrayList<SJctrAuditLogData> detailList = new ArrayList<SJctrAuditLogData>();
        SJctrUserInfoDetailUtility userInfoDetailUty = util.getUserInfoDetailUtility();
        ArrayList<String> partsIDList = new ArrayList<String>();
        partsIDList.add("ADT_USER_ID");
        partsIDList.add("ADT_RESULT");
        SJctrUserInfoDetail[] userInfo_array = new SJctrUserInfoDetail[]{changePwdData.getAfterUserInfoDetail()};
        for (int i = 0; i < userInfo_array.length; ++i) {
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(partsIDList);
            adtData.setScrID(new ArrayList<String>(0));
            adtData.setTitle("ADT_USER_ID", util.getGuidance("ACCOUNT", "ADT_USER_ID"));
            adtData.setValue("ADT_USER_ID", userInfoDetailUty.toUserIDDisplay(userInfo_array[i]));
            adtData.setTitle("ADT_RESULT", util.getGuidance("ADT_RESULT"));
            adtData.setValue("ADT_RESULT", util.getGuidance("ADT_NORMAL_END"));
            detailList.add(adtData);
        }
        return detailList;
    }
}

