/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.properties.radius;

import java.util.HashMap;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;

public class SJctrRadiusPropertiesSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_AUTH_PROT = "COM_AUTH_PROT";
    public static final String KEY_PRI_HOST_NAME = "COM_PRI_HOST_NAME";
    public static final String KEY_SECRET_KEY = "COM_SECRET_KEY";
    public static final String KEY_NAS_ADDR = "COM_NAS_ADDR";
    public static final String KEY_PRI_PORT_NUM = "COM_PRI_PORT_NUM";
    public static final String KEY_TOV = "COM_TOV";
    public static final String KEY_RET_NUM = "COM_RET_NUM";
    public static final String KEY_SEC_HOST_NAME = "COM_SEC_HOST_NAME";
    public static final String KEY_SEC_PORT_NUM = "COM_SEC_PORT_NUM";
    public static final String KEY_EXT_AUTH_PROT = "COM_EXT_AUTH__PROT";
    public static final String KEY_DNS_LOOKUP = "COM_DNS_LOOKUP";
    public static final String KEY_EXT_PRI_HOST_NAME = "COM_EXT_PRI_HOST_NAME";
    public static final String KEY_EXT_PRI_PORT_NUM = "COM_EXT_PRI_PORT_NUM";
    public static final String KEY_EXT_DOMAIN_NAME = "COM_DOMAIN_NAME";
    public static final String KEY_BASE_DN = "COM_BASE_DN";
    public static final String KEY_SEARCH_DN = "COM_SEARCH_DN";
    public static final String KEY_PASSWORD = "COM_PASSWORD";
    public static final String KEY_EXT_TOV = "COM_EXT_TOV";
    public static final String KEY_EXT_RET_INTERVAL = "COM_EXT_RET_INTERVAL";
    public static final String KEY_EXT_RET_NUM = "COM_EXT_RET_NUM";
    SJctrExtAuthServerUtility extAuthServerUtility = null;

    @Override
    public void makeDataObject() {
        SJctrExtAuthServerInfo info = null;
        SJbaseExternalFile config = new SJbaseExternalFile();
        HashMap<String, SJbaseConfiguration> config_map = null;
        HashMap<String, SJbaseGroupConfiguration> config_group_map = null;
        SJbaseRadiusConfiguration config_data = null;
        String type = config.getType();
        if (SJctrExtAuthServerUtility.isServerTypeRadius(type)) {
            config_map = config.getConfiguration(type);
            config_group_map = config.getGroupConfiguration(type);
            if (config_map == null) {
                info = new SJctrExtAuthServerInfo();
            } else {
                config_data = (SJbaseRadiusConfiguration)config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                if (config_data == null) {
                    info = new SJctrExtAuthServerInfo();
                } else {
                    info = new SJctrExtAuthServerInfo();
                    info.setServerType(type);
                    SJbaseConfiguration pri_conf = null;
                    SJbaseConfiguration sec_conf = null;
                    if (config_map != null) {
                        pri_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                        sec_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                    }
                    info.setConfiguration(pri_conf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    info.setConfiguration(sec_conf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                    SJbaseGroupConfiguration pri_gconf = null;
                    SJbaseGroupConfiguration sec_gconf = null;
                    if (config_group_map != null) {
                        pri_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                        sec_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                    }
                    info.setGroupConfiguration(pri_gconf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    info.setGroupConfiguration(sec_gconf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
            }
        }
        this.makeSummary(info);
    }

    protected void makeSummary(SJctrExtAuthServerInfo info) {
        SJctrUserController uc = this.getDataController().getOwner();
        this.extAuthServerUtility = uc.getComUtility().getExtAuthServerUtility();
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_AUTH_PROT, this.getProtocol(info));
        ((SJctrDataObject)summaryData).setData(KEY_PRI_HOST_NAME, this.getPrimaryHostName(info));
        ((SJctrDataObject)summaryData).setData(KEY_SECRET_KEY, this.getSecret(info));
        ((SJctrDataObject)summaryData).setData(KEY_NAS_ADDR, this.getNASAddress(info));
        ((SJctrDataObject)summaryData).setData(KEY_PRI_PORT_NUM, this.getPrimaryPortNumber(info));
        ((SJctrDataObject)summaryData).setData(KEY_TOV, this.getTimeout(info));
        ((SJctrDataObject)summaryData).setData(KEY_RET_NUM, this.getNumOfRetries(info));
        ((SJctrDataObject)summaryData).setData(KEY_SEC_HOST_NAME, this.getSecondaryHostName(info));
        ((SJctrDataObject)summaryData).setData(KEY_SEC_PORT_NUM, this.getSecondaryPortNumber(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_AUTH_PROT, this.getExtProtocol(info));
        ((SJctrDataObject)summaryData).setData(KEY_DNS_LOOKUP, this.getExtDnsLookup(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PRI_HOST_NAME, this.getExtPrimaryHostName(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PRI_PORT_NUM, this.getExtPrimaryPortNumber(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_DOMAIN_NAME, this.getExtDomainName(info));
        ((SJctrDataObject)summaryData).setData(KEY_BASE_DN, this.getExtBaseDN(info));
        ((SJctrDataObject)summaryData).setData(KEY_SEARCH_DN, this.getExtSearchDN(info));
        ((SJctrDataObject)summaryData).setData(KEY_PASSWORD, this.getExtPassword(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_TOV, this.getExtTimeout(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_RET_INTERVAL, this.getExtRetryInterval(info));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_RET_NUM, this.getExtNumOfRetries(info));
        if (info == null) {
            // empty if block
        }
    }

    private String getProtocol(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getRadiusProtocolDisplay(info);
        }
        return ret;
    }

    private String getPrimaryHostName(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getPrimaryHostNameDisplay(info);
        }
        return ret;
    }

    private String getSecret(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getSecretDisplay(info);
        }
        return ret;
    }

    private String getNASAddress(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getNASAddressDisplay(info);
        }
        return ret;
    }

    private String getPrimaryPortNumber(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getPrimaryPortNumberDisplay(info);
        }
        return ret;
    }

    private String getTimeout(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            String sec;
            ret = sec = this.extAuthServerUtility.getTimeoutDisplay(info);
            if (SJctrExtAuthServerUtility.isAppendStr(sec)) {
                ret = this.extAuthServerUtility.toAppendSecUnit(sec);
            }
        }
        return ret;
    }

    private String getNumOfRetries(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getNumOfRetriesDisplay(info);
        }
        return ret;
    }

    private String getSecondaryHostName(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getSecondaryHostNameDisplay(info);
        }
        return ret;
    }

    private String getSecondaryPortNumber(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getSecondaryPortNumberDisplay(info);
        }
        return ret;
    }

    private String getExtProtocol(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtLdapProtocolDisplay(info);
        }
        return ret;
    }

    private String getExtDnsLookup(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtDNSLookupDisplay(info);
        }
        return ret;
    }

    private String getExtPrimaryHostName(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtPrimaryHostNameDisplay(info);
        }
        return ret;
    }

    private String getExtPrimaryPortNumber(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtPrimaryPortNumberDisplay(info);
        }
        return ret;
    }

    private String getExtDomainName(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtDomainNameDisplay(info);
        }
        return ret;
    }

    private String getExtBaseDN(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtBaseDNDisplay(info);
        }
        return ret;
    }

    private String getExtSearchDN(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtUsersSearchDNDisplay(info);
        }
        return ret;
    }

    private String getExtPassword(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtPasswordDisplay(info);
        }
        return ret;
    }

    private String getExtTimeout(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            String sec;
            ret = sec = this.extAuthServerUtility.getExtTimeoutDispay(info);
            if (SJctrExtAuthServerUtility.isAppendStr(sec)) {
                ret = this.extAuthServerUtility.toAppendSecUnit(sec);
            }
        }
        return ret;
    }

    private String getExtRetryInterval(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            String sec;
            ret = sec = this.extAuthServerUtility.getExtRetryIntervalDispay(info);
            if (SJctrExtAuthServerUtility.isAppendStr(sec)) {
                ret = this.extAuthServerUtility.toAppendSecUnit(sec);
            }
        }
        return ret;
    }

    private String getExtNumOfRetries(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = this.extAuthServerUtility.getExtNumOfRetriesDisplay(info);
        }
        return ret;
    }
}

