/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupradius;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlFreeFormElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;

public class SJctrSetupServerRadiusAuditLog
implements Serializable {
    static final String FUNCTION_NAME = "ADT_FC_ACOUNT";
    static final int NUMBER_OF_SERVERS = 1;
    public static String[][] KeyTable_BasicInfo = new String[][]{{"COMMON", "ADT_SETUP_SERVER"}, {"COMMON", "RADIUS"}, {"COMMON", "ADT_NUM_OF_SERVERS"}};
    public static String[][] KeyTable_DtlInfo_Auth = new String[][]{{"COMMON", "AUTHENTICATION_PROTOCOL"}, {"COMMON", "PRIMARY_HOSTNAME"}, {"COMMON", "NAS_ADDRESS"}, {"COMMON", "PRIMARY_PORT_NUM"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_TIMES"}, {"AUTH", "SECOND_SERVER_AUTH"}, {"COMMON", "SECONDARY_HOSTNAME"}, {"COMMON", "SECONDARY_PORT_NUM"}};
    public static String[][] KeyTable_DtlInfo_AuthGroup = new String[][]{{"COMMON", "EXT_AUTHORIZATION"}, {"COMMON", "CERTIFICATION_FILE_NAME"}, {"COMMON", "AUTHENTICATION_PROTOCOL"}, {"COMMON", "DNS_LOOKUP"}, {"COMMON", "HOST_NAME"}, {"AUTH", "PORT_NUMBER"}, {"COMMON", "DOMAIN_NAME"}, {"COMMON", "BASE_DN"}, {"COMMON", "SEARCH_DN"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}};
    private static final int INDEX_DISPID = 0;
    private static final int INDEX_PARTSID = 1;
    private Map<String, String> TitleEnGuideMap = null;
    private Map<String, String> DataEnGuideMap = null;
    HashMap<String, String> addition = null;
    private String headAuth = "";
    private List<String> detailAuth = new ArrayList<String>();
    private String headAuthGroup = "";
    private List<String> detailAuthGroup = new ArrayList<String>();
    private String footer = "";

    SJctrSetupServerRadiusAuditLog() {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleEnGuideMap = new HashMap<String, String>();
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_BasicInfo));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Auth));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_AuthGroup));
        this.DataEnGuideMap = new HashMap<String, String>();
        this.DataEnGuideMap.putAll(guidance.getGuidance(SJctrExtAuthServerUtility.AdtGuideKeyTable));
        this.addition = new HashMap();
    }

    public void setAdditionData(SJbaseUserSession userSession) {
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    SJcAuditLogCtrlFreeFormElemCon createElemCon() {
        SJcAuditLogCtrlFreeFormElemCon elemCon = new SJcAuditLogCtrlFreeFormElemCon();
        elemCon.setFunctionName(FUNCTION_NAME);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_SETUP_SERVER");
        String opeName = this.TitleEnGuideMap.get(key);
        elemCon.setOperationName(opeName);
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "RADIUS");
        String opeParam = this.TitleEnGuideMap.get(key);
        elemCon.setOperationParameter(opeParam);
        elemCon.setAdditionalInfo(this.addition);
        elemCon.setHeadHier1st(this.headAuth);
        elemCon.setDetailHier1st(this.detailAuth);
        elemCon.setHeadHier2nd(this.headAuthGroup);
        elemCon.setDetailHier2nd(this.detailAuthGroup);
        elemCon.setFooter(this.footer);
        return elemCon;
    }

    public void setPrintData(SJctrExtAuthServerInfo info) {
        String data;
        String authorize;
        String key;
        String key2;
        SJbaseRadiusConfiguration config = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseRadiusConfiguration config_sec = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        SJbaseLdapGroupConfiguration gconfig = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_Auth.length; ++index) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_Auth[index][0], KeyTable_DtlInfo_Auth[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key2));
            if (index == KeyTable_DtlInfo_Auth.length - 1) break;
            buffer.append(",");
        }
        this.headAuth = "{" + buffer.toString() + "}" + "=" + "\n";
        buffer = new StringBuffer();
        buffer.append("{");
        String protocol = "";
        if (SJctrExtAuthServerUtility.isPapProtocol(config.getProtocol())) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("AUTH", "PAP");
            protocol = this.DataEnGuideMap.get(key2);
        } else {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("AUTH", "CHAP");
            protocol = this.DataEnGuideMap.get(key2);
        }
        buffer.append(protocol + ",");
        buffer.append(config.getHost() + ",");
        buffer.append("\n");
        String data2 = buffer.toString();
        this.detailAuth.add(data2);
        buffer = new StringBuffer();
        String attribute = "";
        Map<String, String> attributes = config.getAttributes();
        if (SJctrExtAuthServerUtility.isIdentifier(attributes)) {
            attribute = attributes.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IDENTIFIER);
        } else if (SJctrExtAuthServerUtility.isIPv4(attributes)) {
            attribute = attributes.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv4);
        } else if (SJctrExtAuthServerUtility.isIPv6(attributes)) {
            attribute = attributes.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv6);
        }
        buffer.append(attribute + ",");
        String port = String.valueOf(config.getPort());
        buffer.append(port + ",");
        String timeout = String.valueOf(config.getTimeout());
        buffer.append(timeout + ",");
        String retries = String.valueOf(config.getRetryTimes());
        buffer.append(retries + ",");
        String secondary = "";
        String sechost = "";
        String secport = "";
        if (config_sec != null) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            secondary = this.DataEnGuideMap.get(key);
            sechost = config_sec.getHost();
            secport = String.valueOf(config_sec.getPort());
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            secondary = this.DataEnGuideMap.get(key);
        }
        buffer.append(secondary + ",");
        buffer.append(sechost + ",");
        buffer.append(secport);
        buffer.append("}\n");
        String data3 = buffer.toString();
        this.detailAuth.add(data3);
        buffer = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_AuthGroup.length; ++index) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_AuthGroup[index][0], KeyTable_DtlInfo_AuthGroup[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key2));
            if (index == KeyTable_DtlInfo_AuthGroup.length - 1) break;
            buffer.append(",");
        }
        this.headAuthGroup = "{" + buffer.toString() + "}" + "=" + "\n";
        if (gconfig == null) {
            buffer = new StringBuffer();
            buffer.append("{");
            String key3 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            authorize = this.DataEnGuideMap.get(key3);
            buffer.append(authorize + ",");
            buffer.append(",,,,,,,,,,");
            buffer.append("}");
            data = buffer.toString();
            this.detailAuthGroup.add(data);
        } else {
            String key4;
            buffer = new StringBuffer();
            buffer.append("{");
            String key5 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            authorize = this.DataEnGuideMap.get(key5);
            buffer.append(authorize + ",");
            buffer.append(info.getCertifyFileName() + ",");
            protocol = "";
            if (SJctrExtAuthServerUtility.isLdapsProtocol(gconfig.getProtocol())) {
                key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LDAPS");
                protocol = this.DataEnGuideMap.get(key2);
            } else if (SJctrExtAuthServerUtility.isStarttlsProtocol(gconfig.getProtocol())) {
                key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "STARTTLS");
                protocol = this.DataEnGuideMap.get(key2);
            }
            buffer.append(protocol + ",");
            String dns = "";
            if (SJctrExtAuthServerUtility.isInvalidStr(gconfig.getDnsLookup())) {
                key4 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
                dns = this.DataEnGuideMap.get(key4);
            } else {
                key4 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
                dns = this.DataEnGuideMap.get(key4);
            }
            buffer.append(dns + ",");
            buffer.append("\n");
            data = buffer.toString();
            this.detailAuthGroup.add(data);
            buffer = new StringBuffer();
            String host = "";
            String port2 = "";
            if (!SJctrExtAuthServerUtility.isInvalidStr(gconfig.getDnsLookup())) {
                host = gconfig.getHost();
                port2 = String.valueOf(gconfig.getPort());
            }
            buffer.append(host + ",");
            buffer.append(port2 + ",");
            buffer.append(gconfig.getDomainName() + ",");
            buffer.append("\n");
            data = buffer.toString();
            this.detailAuthGroup.add(data);
            SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
            StringBuffer buffer2 = new StringBuffer();
            String baseDN = validUtil.replaceStr(gconfig.getSearchDN(), SJctrValidatorUtility.Comma, " ");
            buffer2.append(baseDN + ",");
            String searchDN = validUtil.replaceStr(gconfig.getSearchUserDN(), SJctrValidatorUtility.Comma, " ");
            buffer2.append(searchDN + ",");
            timeout = String.valueOf(gconfig.getTimeout());
            buffer2.append(timeout + ",");
            String interval = String.valueOf(gconfig.getRetryInterval());
            buffer2.append(interval + ",");
            String retries2 = String.valueOf(gconfig.getRetryTimes());
            buffer2.append(retries2);
            buffer2.append("}");
            String data4 = buffer2.toString();
            this.detailAuthGroup.add(data4);
        }
        String key6 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_NUM_OF_SERVERS");
        this.footer = this.TitleEnGuideMap.get(key6) + "=" + 1;
    }
}

