/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.creatersgs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrRsgHGNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrRsgITAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgsRscTableModel;
import sanproject.sn2.controller.wizard.account.rsg.creatersgs.SJctrCreateRsgsConfirmData;
import sanproject.sn2.controller.wizard.account.rsg.rsgproperties.SJctrRsgPropertiesDialogDC;
import sanproject.sn2.controller.wizard.account.rsg.selectresources.SJctrRsgSelectHostGroupsDC;
import sanproject.sn2.controller.wizard.account.rsg.selectresources.SJctrRsgSelectIscsiTargetsDC;
import sanproject.sn2.controller.wizard.account.rsg.selectresources.SJctrRsgSelectLdevsDC;
import sanproject.sn2.controller.wizard.account.rsg.selectresources.SJctrRsgSelectParityGroupsDC;
import sanproject.sn2.controller.wizard.account.rsg.selectresources.SJctrRsgSelectPortsDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevJnlGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrCreateRsgsDC
extends SJctrWizardDataController {
    protected static final int DISP_ID = 0x1001171;
    protected static final String DISP_TITLE = "CREATE_RES_GRPS";
    protected static final String KEY_INPUT_RSG_NAME = "COM_INPUT_RSG_NAME";
    protected static final String KEY_TABLE_SEL_RSG = "COM_TABLE_SEL_RSG";
    protected static final String KEY_ADD = "COM_ADD";
    protected static final String KEY_DETAIL = "COM_DETAIL";
    protected static final String KEY_REMOVE = "COM_REMOVE";
    protected static final String KEY_SEL_RESOURCE_EXIT_DISP_ID = "COM_SEL_RESOURCE_EXIT_DISP_ID";
    protected static final String KEY_TABLE_AVAIL_PGS = "COM_TABLE_AVAIL_PGS";
    protected static final String KEY_TABLE_SEL_PGS = "COM_TABLE_SEL_PGS";
    protected static final String KEY_SEL_PGS = "COM_SEL_PGS";
    protected static final String KEY_PG_SELECTION_INF = "COM_PG_SELECTION_INF";
    protected static final String KEY_TABLE_AVAIL_LDEVS = "COM_TABLE_AVAIL_LDEVS";
    protected static final String KEY_TABLE_SEL_LDEVS = "COM_TABLE_SEL_LDEVS";
    protected static final String KEY_SEL_LDEVS = "COM_SEL_LDEVS";
    protected static final String KEY_LDEV_SELECTION_INF = "COM_LDEV_SELECTION_INF";
    protected static final String KEY_TABLE_AVAIL_PTS = "COM_TABLE_AVAIL_PTS";
    protected static final String KEY_TABLE_SEL_PTS = "COM_TABLE_SEL_PTS";
    protected static final String KEY_SEL_PTS = "COM_SEL_PTS";
    protected static final String KEY_PT_SELECTION_INF = "COM_PT_SELECTION_INF";
    protected static final String KEY_TABLE_AVAIL_HGS = "COM_TABLE_AVAIL_HGS";
    protected static final String KEY_TABLE_SEL_HGS = "COM_TABLE_SEL_HGS";
    protected static final String KEY_SEL_HGS = "COM_SEL_HGS";
    protected static final String KEY_HG_SELECTION_INF = "COM_HG_SELECTION_INF";
    protected static final String KEY_TABLE_AVAIL_ISCSIS = "COM_TABLE_AVAIL_ISCSIS";
    protected static final String KEY_TABLE_SEL_ISCSIS = "COM_TABLE_SEL_ISCSIS";
    protected static final String KEY_SEL_ISCSIS = "COM_SEL_ISCSIS";
    protected static final String KEY_ISCSI_SELECTION_INF = "COM_ISCSI_SELECTION_INF";

    public SJctrCreateRsgsDC() throws SJcException {
        super(0x1001171);
        this.initDataModel();
        this.initListener();
    }

    public SJctrCreateRsgsDC(int dispId) throws SJcException {
        super(dispId);
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetVdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgScatteredInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgEncryptionInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHDPRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevJnlGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotVvolRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    protected void initDataModel() {
        SJctrTextBoxDataModel rsgNameTextBox = new SJctrTextBoxDataModel();
        rsgNameTextBox.setValue("");
        rsgNameTextBox.setVisible(true);
        this.addDataObjectModel(KEY_INPUT_RSG_NAME, rsgNameTextBox);
        this.initSelectionDataModel();
        SJctrRsgsRscTableModel selRsgsTable = new SJctrRsgsRscTableModel();
        selRsgsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_RSG, selRsgsTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_DETAIL);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    protected void initSelectionDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAIL_PGS, new SJctrRsgPgsTableModel());
        SJctrRsgPgsTableModel selPgsTable = new SJctrRsgPgsTableModel();
        selPgsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PGS, selPgsTable);
        SJctrButtonDataModel selPgsButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SEL_PGS, selPgsButton);
        selPgsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_SEL_PGS);
            }
        });
        this.addDataObjectModel(KEY_TABLE_AVAIL_LDEVS, new SJctrRsgLdevsTableModel());
        SJctrRsgLdevsTableModel selLdevsTable = new SJctrRsgLdevsTableModel();
        selLdevsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_LDEVS, selLdevsTable);
        SJctrButtonDataModel selLdevsButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SEL_LDEVS, selLdevsButton);
        selLdevsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_SEL_LDEVS);
            }
        });
        this.addDataObjectModel(KEY_TABLE_AVAIL_PTS, new SJctrRsgPortsTableModel());
        SJctrRsgPortsTableModel selPortsTable = new SJctrRsgPortsTableModel();
        selPortsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PTS, selPortsTable);
        SJctrButtonDataModel selPortsButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SEL_PTS, selPortsButton);
        selPortsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_SEL_PTS);
            }
        });
        this.addDataObjectModel(KEY_TABLE_AVAIL_HGS, new SJctrRsgHostGroupsTableModel());
        SJctrRsgHostGroupsTableModel selHgsTable = new SJctrRsgHostGroupsTableModel();
        selHgsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_HGS, selHgsTable);
        SJctrButtonDataModel selHgsButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SEL_HGS, selHgsButton);
        selHgsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_SEL_HGS);
            }
        });
        this.addDataObjectModel(KEY_TABLE_AVAIL_ISCSIS, new SJctrRsgIscsiTargetsTableModel());
        SJctrRsgIscsiTargetsTableModel selIscsisTable = new SJctrRsgIscsiTargetsTableModel();
        selIscsisTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSIS, selIscsisTable);
        SJctrButtonDataModel selIscsisButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SEL_ISCSIS, selIscsisButton);
        selIscsisButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateRsgsDC.this.fireMessageEvent(CREATE_RSGS_MSG.SELECT_SEL_ISCSIS);
            }
        });
    }

    protected void initListener() {
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_SEL_PGS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.selectPgsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_SEL_LDEVS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.selectLdevsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_SEL_PTS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.selectPortsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_SEL_HGS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.selectHgsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_SEL_ISCSIS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.selectIscsisAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.addRsgAction(event, dstModel);
                SJctrCreateRsgsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.makeDetailAction(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_RSGS_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.removeRsgsAction(event, dstModel);
                SJctrCreateRsgsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateRsgsDC.this.exitSelectResources(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            if (SJctrRsgUtility.isMaxCountOfRsgs(rsgInfoList)) {
                this.getLogUty().putlog("checkConstructData", "Resource Group is maximum-number-defined and cannot already create.");
                SJctrError err = new SJctrError(207, 22, 105285);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoRSGgetRsg rsg0Info = SJctrRsgUtility.getRsgInfoByRsgId(0, rsgInfoList);
            if (null == rsg0Info) {
                this.getLogUty().putlog("checkConstructData", "Information of RSG0 is null.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            HashSet<Integer> assignRsgIds = new HashSet<Integer>();
            Map<String, SJctrUserGrpInfoDetail> usrGroupList = SJctrRsgUtility.getUserGroupsInfo(this.getLogUty());
            if (null == usrGroupList) {
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            Collection<SJctrUserGrpInfoDetail> usrGroupCol = usrGroupList.values();
            for (SJctrUserGrpInfoDetail usrGroupInfo : usrGroupCol) {
                int[] rsgIds;
                if (usrGroupInfo.getAllRsrcGroup()) continue;
                for (int rsgId : rsgIds = usrGroupInfo.getRsrcGroupID()) {
                    assignRsgIds.add(rsgId);
                }
            }
            Iterator<SJctrUserGrpInfoDetail> i$ = assignRsgIds.iterator();
            while (i$.hasNext()) {
                int rsgIdInfo = (Integer)((Object)i$.next());
                SJmoRSGgetRsg allRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(rsgIdInfo, rsgInfoList);
                if (allRsgInfo != null) continue;
                this.getLogUty().putlog("checkConstructData", "The unmounted resource group assigned to the user group.");
                SJctrError err = new SJctrError(207, 22, 105315);
                SJcException exp = err.createException();
                throw exp;
            }
            this.setAvailableTableData(rsg0Info, rsgInfoList);
            SJctrTextBoxDataModel rsgNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_INPUT_RSG_NAME);
            rsgNameTextBox.setLabel(this.getComUtility().getGuidance("DISP_RES_GRP_NAME_MAX_CHAR"));
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    protected void setAvailableTableData(SJmoRSGgetRsg rsg0Info, List<SJmoRSGgetRsg> rsgInfoList) {
        ArrayList<SJmoPgIndex> pgIndexList = rsg0Info.getVdevs();
        ArrayList pgDetailList = (ArrayList)SJctrRsgUtility.getSJmoPgDetail(this);
        ArrayList vdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoVdevDetail(this);
        ArrayList pdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoPdevDetail(this);
        ArrayList pgStList = (ArrayList)SJctrRsgUtility.getSJmoPgScatteredInfo(this);
        ArrayList pgEncList = (ArrayList)SJctrRsgUtility.getSJmoPgEncryptionInfo(this);
        ArrayList ldevDetailList = (ArrayList)SJctrRsgUtility.getSJmoLdevDetail(this);
        ArrayList ldevStatusList = (ArrayList)SJctrRsgUtility.getSJmoLdevStatusInfo(this);
        ArrayList luseList = (ArrayList)SJctrRsgUtility.getSJmoLdevLuseInfo(this);
        List<SJctrRsgPgInfo> pgTableList = SJctrRsgUtility.createRsgPgInfoList(pgIndexList, pgDetailList, vdevDetailList, pdevDetailList, pgStList, pgEncList, ldevDetailList, ldevStatusList, luseList);
        SJctrRsgPgsTableModel rsgPgsTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        rsgPgsTable.setBasicDataList(pgTableList);
        ArrayList<SJmoLdevIndex> ldevIndexList = rsg0Info.getLdevs();
        List<SJctrRsgLdevInfo> ldevTableList = SJctrRsgUtility.createRsgLdevInfoList(ldevIndexList, ldevDetailList);
        SJctrRsgLdevsTableModel rsgLdevsTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        rsgLdevsTable.setBasicDataList(ldevTableList);
        ArrayList<SJmoPortIndex> portIndexList = rsg0Info.getPorts();
        ArrayList portDetailList = (ArrayList)SJctrRsgUtility.getSJmoPortDetail(this);
        List<SJctrRsgPortInfo> portTableList = SJctrRsgUtility.createRsgPortInfoList(portIndexList, portDetailList);
        SJctrRsgPortsTableModel rsgPortTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PTS);
        rsgPortTable.setBasicDataList(portTableList);
        ArrayList<SJmoHostGroupIndex> hgIndexList = rsg0Info.getHostGrps();
        ArrayList hgInfoList = (ArrayList)SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
        List<SJctrRsgHostGroupInfo> hgTableList = SJctrRsgUtility.createRsgHgInfoList(hgIndexList, portDetailList, hgInfoList);
        SJctrRsgHostGroupsTableModel rsgHgTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_HGS);
        rsgHgTable.setBasicDataList(hgTableList);
        List<SJmoPortIscsiTargetInfo> iscsiInfoList = SJctrRsgUtility.getSJmoPortIscsiTargetInfo(this);
        List<SJctrRsgIscsiTargetInfo> iscsiTableList = SJctrRsgUtility.createRsgIscsiInfoList(hgIndexList, portDetailList, iscsiInfoList);
        SJctrRsgIscsiTargetsTableModel rsgIscsiTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_ISCSIS);
        rsgIscsiTable.setBasicDataList(iscsiTableList);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrCreateRsgsConfirmData confirmData = new SJctrCreateRsgsConfirmData();
            SJctrRsgsRscTableModel selectedRsgTable = (SJctrRsgsRscTableModel)this.getDataObjectModel(KEY_TABLE_SEL_RSG);
            List<Object> selectedList = selectedRsgTable.getAllRowData();
            confirmData.setCreateRsgsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrCreateRsgsConfirmData> confirmDataList = new ArrayList<SJctrCreateRsgsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrCreateRsgsConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107003);
        }
        return true;
    }

    protected void selectPgsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        ArrayList<List<Object>> pgSelectionInfo = new ArrayList<List<Object>>();
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        if (0 == availableTable.getRowCount() + selectedTable.getRowCount()) {
            this.getLogUty().putlog("selectPgsAction", "The resource which can be added does not exist.");
            SJctrError err = new SJctrError(207, 22, 105289);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> availableList = availableTable.getAllRowData();
        pgSelectionInfo.add(availableList);
        List<Object> selectedList = selectedTable.getAllRowData();
        pgSelectionInfo.add(selectedList);
        HashMap param = new HashMap();
        param.put(KEY_PG_SELECTION_INF, pgSelectionInfo);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgSelectParityGroupsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void selectLdevsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        if (0 == availableTable.getRowCount() + selectedTable.getRowCount()) {
            this.getLogUty().putlog("selectLdevsAction", "The resource which can be added does not exist.");
            SJctrError err = new SJctrError(207, 22, 205062);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> availableList = availableTable.getAllRowData();
        selectionInfo.add(availableList);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        HashMap param = new HashMap();
        param.put(KEY_LDEV_SELECTION_INF, selectionInfo);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgSelectLdevsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void selectPortsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgPortsTableModel availableTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PTS);
        SJctrRsgPortsTableModel selectedTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PTS);
        if (0 == availableTable.getRowCount() + selectedTable.getRowCount()) {
            this.getLogUty().putlog("selectPortsAction", "The resource which can be added does not exist.");
            SJctrError err = new SJctrError(207, 22, 105289);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> availableList = availableTable.getAllRowData();
        selectionInfo.add(availableList);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        HashMap param = new HashMap();
        param.put(KEY_PT_SELECTION_INF, selectionInfo);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgSelectPortsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void selectHgsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgHostGroupsTableModel availableTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_HGS);
        SJctrRsgHostGroupsTableModel selectedTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_HGS);
        if (0 == availableTable.getRowCount() + selectedTable.getRowCount()) {
            this.getLogUty().putlog("selectHgsAction", "The resource which can be added does not exist.");
            SJctrError err = new SJctrError(207, 22, 205062);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> availableList = availableTable.getAllRowData();
        Collections.sort(availableList, new SJctrRsgHGNameComparator());
        selectionInfo.add(availableList);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        HashMap param = new HashMap();
        param.put(KEY_HG_SELECTION_INF, selectionInfo);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgSelectHostGroupsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void selectIscsisAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgIscsiTargetsTableModel availableTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_ISCSIS);
        SJctrRsgIscsiTargetsTableModel selectedTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSIS);
        if (0 == availableTable.getRowCount() + selectedTable.getRowCount()) {
            this.getLogUty().putlog("selectIscsisAction", "The resource which can be added does not exist.");
            SJctrError err = new SJctrError(207, 22, 105289);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> availableList = availableTable.getAllRowData();
        Collections.sort(availableList, new SJctrRsgITAliasComparator());
        selectionInfo.add(availableList);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        HashMap param = new HashMap();
        param.put(KEY_ISCSI_SELECTION_INF, selectionInfo);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgSelectIscsiTargetsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void makeDetailAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgsRscTableModel selectedRsgTable = (SJctrRsgsRscTableModel)this.getDataObjectModel(KEY_TABLE_SEL_RSG);
        List<Object> selectrsgList = selectedRsgTable.getSelectedRowData();
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), selectrsgList);
        SJctrRsgUtility.setCacheCreateEditRscDetailData(param, this);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgPropertiesDialogDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    protected void addRsgAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrTextBoxDataModel rsgNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_INPUT_RSG_NAME);
            String rsgName = rsgNameTextBox.getValue();
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            SJctrRsgsRscTableModel selectedRsgTable = (SJctrRsgsRscTableModel)this.getDataObjectModel(KEY_TABLE_SEL_RSG);
            List<Object> selectedList = selectedRsgTable.getAllRowData();
            if (SJctrRsgUtility.isMaxCountOfRsgs(rsgInfoList, selectedList)) {
                this.getLogUty().putlog("addRsgAction", "Resource Group is maximum-number-defined and cannot already create.");
                SJctrError err = new SJctrError(207, 22, 105286);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isInvalidRsgName(rsgName)) {
                this.getLogUty().putlog("addRsgAction", "Resource group name is invalid.");
                SJctrError err = new SJctrError(207, 22, 105283);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isDuplicateRsgName(rsgName, rsgInfoList, selectedList)) {
                this.getLogUty().putlog("addRsgAction", "Resource group name is duplicating.");
                SJctrError err = new SJctrError(207, 22, 105284);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrRsgPgsTableModel rsgPgsTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
            rsgPgsTable.selectAll();
            List<Object> selectedPgsList = rsgPgsTable.removeSelectedRowData();
            SJctrRsgLdevsTableModel rsgLdevsTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
            rsgLdevsTable.selectAll();
            List<Object> selectedLdevsList = rsgLdevsTable.removeSelectedRowData();
            SJctrRsgPortsTableModel rsgPortsTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PTS);
            rsgPortsTable.selectAll();
            List<Object> selectedPortsList = rsgPortsTable.removeSelectedRowData();
            SJctrRsgHostGroupsTableModel rsgHgsTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_HGS);
            rsgHgsTable.selectAll();
            List<Object> selectedHgsList = rsgHgsTable.removeSelectedRowData();
            SJctrRsgIscsiTargetsTableModel rsgIscsisTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSIS);
            rsgIscsisTable.selectAll();
            List<Object> selectedIscsisList = rsgIscsisTable.removeSelectedRowData();
            ArrayList<SJmoHostGroupIndex> selectedHgIscsiList = new ArrayList<SJmoHostGroupIndex>(selectedHgsList.size() + selectedIscsisList.size());
            selectedHgIscsiList.addAll((ArrayList)selectedHgsList);
            selectedHgIscsiList.addAll((ArrayList)selectedIscsisList);
            SJmoRSGInfo addRsgNameId = new SJmoRSGInfo();
            addRsgNameId.setRsgId(-1);
            addRsgNameId.setRsgName(rsgName);
            SJmoHUVMvboxIndex vboxIndex = new SJmoHUVMvboxIndex();
            vboxIndex.setIVboxId(0);
            addRsgNameId.setVboxIndex(vboxIndex);
            SJmoRSGgetRsg addRsgInfo = new SJmoRSGgetRsg();
            addRsgInfo.setRsgInfo(addRsgNameId);
            Collections.sort((ArrayList)selectedPgsList);
            Collections.sort((ArrayList)selectedLdevsList);
            Collections.sort((ArrayList)selectedPortsList);
            Collections.sort(selectedHgIscsiList);
            addRsgInfo.setVdevs((ArrayList)selectedPgsList);
            addRsgInfo.setLdevs((ArrayList)selectedLdevsList);
            addRsgInfo.setPorts((ArrayList)selectedPortsList);
            addRsgInfo.setHostGrps(selectedHgIscsiList);
            ArrayList<SJctrRsgInfo> addTableList = new ArrayList<SJctrRsgInfo>();
            addTableList.add(new SJctrRsgInfo(addRsgInfo));
            selectedRsgTable.addRowData(addTableList, 0);
            List<Object> selectingList = selectedRsgTable.getFilterData(addTableList);
            selectedRsgTable.setRowSelectionList(selectingList);
            selectedRsgTable.setCurrentPage(Integer.toString(1));
            selectedRsgTable.setVScrollReset(true);
            selectedRsgTable.setSortColumn(null, Boolean.TRUE);
            this.updateFooter();
            selectedRsgTable.setDirty();
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107004);
        }
    }

    protected void removeRsgsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgPgsTableModel availablePgTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        SJctrRsgLdevsTableModel availableLdevTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        SJctrRsgPortsTableModel availablePortTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PTS);
        SJctrRsgHostGroupsTableModel availableHgTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_HGS);
        SJctrRsgIscsiTargetsTableModel availableIscsiTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_ISCSIS);
        SJctrRsgsRscTableModel selectedRsgTable = (SJctrRsgsRscTableModel)this.getDataObjectModel(KEY_TABLE_SEL_RSG);
        List<Object> removeList = selectedRsgTable.removeSelectedRowData();
        for (SJctrRsgInfo sJctrRsgInfo : removeList) {
            availablePgTable.addRowData(sJctrRsgInfo.getRsgInfo().getVdevs(), 0);
            availableLdevTable.addRowData(sJctrRsgInfo.getRsgInfo().getLdevs(), 0);
            availablePortTable.addRowData(sJctrRsgInfo.getRsgInfo().getPorts(), 0);
            ArrayList<SJmoHostGroupIndex> hgIscsiList = sJctrRsgInfo.getRsgInfo().getHostGrps();
            ArrayList<SJctrRsgHostGroupInfo> hgList = new ArrayList<SJctrRsgHostGroupInfo>();
            ArrayList<SJctrRsgIscsiTargetInfo> iscsiList = new ArrayList<SJctrRsgIscsiTargetInfo>();
            for (SJmoHostGroupIndex hgIscsiIndex : hgIscsiList) {
                if (hgIscsiIndex instanceof SJctrRsgHostGroupInfo) {
                    hgList.add((SJctrRsgHostGroupInfo)hgIscsiIndex);
                    continue;
                }
                if (!(hgIscsiIndex instanceof SJctrRsgIscsiTargetInfo)) continue;
                iscsiList.add((SJctrRsgIscsiTargetInfo)hgIscsiIndex);
            }
            availableHgTable.addRowData(hgList, 0);
            availableIscsiTable.addRowData(iscsiList, 0);
        }
        this.updateFooter();
        availablePgTable.setDirty();
        availableLdevTable.setDirty();
        availablePortTable.setDirty();
        availableHgTable.setDirty();
        availableIscsiTable.setDirty();
        selectedRsgTable.setDirty();
    }

    protected void exitSelectResources(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectDispIdInfo = (List)param.get(KEY_SEL_RESOURCE_EXIT_DISP_ID);
        if (selectDispIdInfo == null) {
            return;
        }
        int dispId = (Integer)selectDispIdInfo.get(0);
        switch (dispId) {
            case 33595461: {
                this.exitSelectPgs(event, dstModel);
                break;
            }
            case 33595462: {
                this.exitSelectLdevs(event, dstModel);
                break;
            }
            case 33595463: {
                this.exitSelectPorts(event, dstModel);
                break;
            }
            case 33595464: {
                this.exitSelectHgs(event, dstModel);
                break;
            }
            case 33595528: {
                this.exitSelectIscsis(event, dstModel);
                break;
            }
        }
    }

    protected void exitSelectPgs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectionInfo = (List)param.get(KEY_PG_SELECTION_INF);
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        List availableTableList = (List)selectionInfo.get(0);
        availableTable.setBasicDataList(availableTableList);
        availableTable.doRefresh();
        List selectedTableList = (List)selectionInfo.get(1);
        selectedTable.setBasicDataList(selectedTableList);
        selectedTable.doRefresh();
        availableTable.setDirty();
        selectedTable.setDirty();
    }

    protected void exitSelectLdevs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectionInfo = (List)param.get(KEY_LDEV_SELECTION_INF);
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        List availableTableList = (List)selectionInfo.get(0);
        availableTable.setBasicDataList(availableTableList);
        availableTable.doRefresh();
        List selectedTableList = (List)selectionInfo.get(1);
        selectedTable.setBasicDataList(selectedTableList);
        selectedTable.doRefresh();
        availableTable.setDirty();
        selectedTable.setDirty();
    }

    protected void exitSelectPorts(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectionInfo = (List)param.get(KEY_PT_SELECTION_INF);
        SJctrRsgPortsTableModel availableTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PTS);
        SJctrRsgPortsTableModel selectedTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PTS);
        List availableTableList = (List)selectionInfo.get(0);
        availableTable.setBasicDataList(availableTableList);
        availableTable.doRefresh();
        List selectedTableList = (List)selectionInfo.get(1);
        selectedTable.setBasicDataList(selectedTableList);
        selectedTable.doRefresh();
        availableTable.setDirty();
        selectedTable.setDirty();
    }

    protected void exitSelectHgs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectionInfo = (List)param.get(KEY_HG_SELECTION_INF);
        SJctrRsgHostGroupsTableModel availableTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_HGS);
        SJctrRsgHostGroupsTableModel selectedTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_HGS);
        List availableTableList = (List)selectionInfo.get(0);
        availableTable.setBasicDataList(availableTableList);
        availableTable.doRefresh();
        List selectedTableList = (List)selectionInfo.get(1);
        selectedTable.setBasicDataList(selectedTableList);
        selectedTable.doRefresh();
        availableTable.setDirty();
        selectedTable.setDirty();
    }

    protected void exitSelectIscsis(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectionInfo = (List)param.get(KEY_ISCSI_SELECTION_INF);
        SJctrRsgIscsiTargetsTableModel availableTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_ISCSIS);
        SJctrRsgIscsiTargetsTableModel selectedTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSIS);
        List availableTableList = (List)selectionInfo.get(0);
        availableTable.setBasicDataList(availableTableList);
        availableTable.doRefresh();
        List selectedTableList = (List)selectionInfo.get(1);
        selectedTable.setBasicDataList(selectedTableList);
        selectedTable.doRefresh();
        availableTable.setDirty();
        selectedTable.setDirty();
    }

    protected void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public static enum CREATE_RSGS_MSG implements SJctrNotifyState
    {
        SELECT_SEL_PGS,
        SELECT_SEL_LDEVS,
        SELECT_SEL_PTS,
        SELECT_SEL_HGS,
        SELECT_SEL_ISCSIS,
        SELECT_ADD,
        SELECT_DETAIL,
        SELECT_REMOVE;

    }
}

