/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.removeresources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrRsgHGNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrRsgITAliasComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.removeresources.SJctrRemoveResourcesConfirmData;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrRemoveResourcesConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16822391;
    private static final String KEY_TABLE_SELECTED_RSG = "COM_TABLE_SELECTED_RSG";
    private static final String KEY_TABLE_SEL_PGS = "COM_TABLE_SEL_PGS";
    private static final String KEY_TABLE_SEL_LDEVS = "COM_TABLE_SEL_LDEVS";
    private static final String KEY_TABLE_SEL_PTS = "COM_TABLE_SEL_PTS";
    private static final String KEY_TABLE_SEL_HGS = "COM_TABLE_SEL_HGS";
    private static final String KEY_TABLE_SEL_ISCSIS = "COM_TABLE_SEL_ISCSIS";

    public SJctrRemoveResourcesConfirmDC() throws SJcException {
        super(16822391);
        this.initDataModel();
    }

    protected void initDataModel() {
        SJctrRsgsTableModel confirmTable = new SJctrRsgsTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED_RSG, confirmTable);
        SJctrRsgPgsTableModel removePgsRscTable = new SJctrRsgPgsTableModel();
        removePgsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PGS, removePgsRscTable);
        SJctrRsgLdevsTableModel removeLdevsRscTable = new SJctrRsgLdevsTableModel();
        removeLdevsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_LDEVS, removeLdevsRscTable);
        SJctrRsgPortsTableModel removePortsRscTable = new SJctrRsgPortsTableModel();
        removePortsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PTS, removePortsRscTable);
        SJctrRsgHostGroupsTableModel removeHgsRscTable = new SJctrRsgHostGroupsTableModel();
        removeHgsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_HGS, removeHgsRscTable);
        SJctrRsgIscsiTargetsTableModel removeIscsisRscTable = new SJctrRsgIscsiTargetsTableModel();
        removeIscsisRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSIS, removeIscsisRscTable);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrRemoveResourcesConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrRemoveResourcesConfirmData.class);
        if (confirmDataList == null) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (confirmDataList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrRemoveResourcesConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrRemoveResourcesConfirmData.class);
        SJctrRemoveResourcesConfirmData confirmData = (SJctrRemoveResourcesConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        SJctrRsgUtility.setOldTaskNothingData(this);
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrRemoveResourcesConfirmData confirmData = (SJctrRemoveResourcesConfirmData)this.getProxy().getCache(SJctrRemoveResourcesConfirmData.class).get(0);
            SJctrRsgsTableModel confirmTable = (SJctrRsgsTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED_RSG);
            confirmTable.setBasicDataList(confirmData.getRemoveRscsInfo());
            SJmoRSGgetRsg rsgInfo = confirmData.getRemoveRscsInfo().get(0).getRsgInfo();
            ArrayList<SJmoPgIndex> pgIndexList = rsgInfo.getVdevs();
            ArrayList pgDetailList = (ArrayList)SJctrRsgUtility.getSJmoPgDetail(this);
            ArrayList vdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoVdevDetail(this);
            ArrayList pdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoPdevDetail(this);
            ArrayList pgStList = (ArrayList)SJctrRsgUtility.getSJmoPgScatteredInfo(this);
            ArrayList pgEncList = (ArrayList)SJctrRsgUtility.getSJmoPgEncryptionInfo(this);
            ArrayList ldevDetailList = (ArrayList)SJctrRsgUtility.getSJmoLdevDetail(this);
            ArrayList ldevStatusList = (ArrayList)SJctrRsgUtility.getSJmoLdevStatusInfo(this);
            ArrayList luseList = (ArrayList)SJctrRsgUtility.getSJmoLdevLuseInfo(this);
            List<SJctrRsgPgInfo> pgTableList = SJctrRsgUtility.createRsgPgInfoList(pgIndexList, pgDetailList, vdevDetailList, pdevDetailList, pgStList, pgEncList, ldevDetailList, ldevStatusList, luseList);
            SJctrRsgPgsTableModel removePgsRscTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
            SJctrRsgUtility.makePgCapacityUnit(removePgsRscTable, pgTableList);
            removePgsRscTable.setBasicDataList(pgTableList);
            ArrayList<SJmoLdevIndex> ldevIndexList = rsgInfo.getLdevs();
            List<SJctrRsgLdevInfo> ldevTableList = SJctrRsgUtility.createRsgLdevInfoList(ldevIndexList, ldevDetailList);
            SJctrRsgLdevsTableModel removeLdevsRscTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
            SJctrRsgUtility.makeLdevCapacityUnit(removeLdevsRscTable, ldevTableList);
            removeLdevsRscTable.setBasicDataList(ldevTableList);
            ArrayList<SJmoPortIndex> portIndexList = rsgInfo.getPorts();
            ArrayList portDetailList = (ArrayList)SJctrRsgUtility.getSJmoPortDetail(this);
            List<SJctrRsgPortInfo> portTableList = SJctrRsgUtility.createRsgPortInfoList(portIndexList, portDetailList);
            SJctrRsgPortsTableModel removePortsRscTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PTS);
            removePortsRscTable.setBasicDataList(portTableList);
            ArrayList<SJmoHostGroupIndex> hgIndexList = rsgInfo.getHostGrps();
            ArrayList hgInfoList = (ArrayList)SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
            List<SJctrRsgHostGroupInfo> hgTableList = SJctrRsgUtility.createRsgHgInfoList(hgIndexList, portDetailList, hgInfoList);
            Collections.sort(hgTableList, new SJctrRsgHGNameComparator());
            SJctrRsgHostGroupsTableModel removeHgsRscTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_HGS);
            removeHgsRscTable.setBasicDataList(hgTableList);
            List<SJmoPortIscsiTargetInfo> iscsiInfoList = SJctrRsgUtility.getSJmoPortIscsiTargetInfo(this);
            List<SJctrRsgIscsiTargetInfo> iscsiTableList = SJctrRsgUtility.createRsgIscsiInfoList(hgIndexList, portDetailList, iscsiInfoList);
            Collections.sort(iscsiTableList, new SJctrRsgITAliasComparator());
            SJctrRsgIscsiTargetsTableModel removeIscsisRscTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSIS);
            removeIscsisRscTable.setBasicDataList(iscsiTableList);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrRemoveResourcesConfirmData.class);
        retMap.put(SJctrRemoveResourcesConfirmData.class.getName(), confirmDataList);
        return retMap;
    }
}

