/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.selectresources;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgsTableModel;

public class SJctrRsgSelectParityGroupsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595461;
    private static final String DISP_TITLE = "SEL_PG";
    private static final String KEY_TABLE_AVAIL_PGS = "COM_TABLE_AVAIL_PGS";
    private static final String KEY_TABLE_SEL_PGS = "COM_TABLE_SEL_PGS";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_PG_SELECTION_INF = "COM_PG_SELECTION_INF";
    private static final String KEY_SEL_RESOURCE_EXIT_DISP_ID = "COM_SEL_RESOURCE_EXIT_DISP_ID";

    public SJctrRsgSelectParityGroupsDC() throws SJcException {
        super(33595461);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrRsgPgsTableModel availableTable = new SJctrRsgPgsTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAIL_PGS, availableTable);
        SJctrRsgPgsTableModel selectedTable = new SJctrRsgPgsTableModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PGS, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRsgSelectParityGroupsDC.this.fireMessageEvent(SELECT_PGS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRsgSelectParityGroupsDC.this.fireMessageEvent(SELECT_PGS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_PGS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgSelectParityGroupsDC.this.addAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SELECT_PGS_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgSelectParityGroupsDC.this.removeAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        List<?> selectionInfo = this.getCache(KEY_PG_SELECTION_INF);
        List availableTableList = (List)selectionInfo.get(0);
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        availableTable.setBasicDataList(availableTableList);
        List selectedTableList = (List)selectionInfo.get(1);
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        selectedTable.setBasicDataList(selectedTableList);
        ArrayList makeUnitList = new ArrayList(availableTableList.size() + selectedTableList.size());
        makeUnitList.addAll(availableTableList);
        makeUnitList.addAll(selectedTableList);
        SJctrRsgUtility.makePgCapacityUnit(availableTable, makeUnitList);
        SJctrRsgUtility.makePgCapacityUnit(selectedTable, makeUnitList);
        return true;
    }

    private void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        List<Object> addData = availableTable.removeSelectedRowData();
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        selectedTable.addRowData(addData, 0);
        List<Object> selectingList = selectedTable.getFilterData(addData);
        selectedTable.setRowSelectionList(selectingList);
        selectedTable.setCurrentPage(Integer.toString(1));
        selectedTable.setVScrollReset(true);
        selectedTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        List<Object> removeData = selectedTable.removeSelectedRowData();
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        availableTable.addRowData(removeData, 0);
        List<Object> selectingList = availableTable.getFilterData(removeData);
        availableTable.setRowSelectionList(selectingList);
        availableTable.setCurrentPage(Integer.toString(1));
        availableTable.setVScrollReset(true);
        availableTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    @Override
    public boolean checkEndData() {
        ArrayList<Integer> dispIdInfo = new ArrayList<Integer>();
        dispIdInfo.add(33595461);
        this.putCache(KEY_SEL_RESOURCE_EXIT_DISP_ID, dispIdInfo);
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgPgsTableModel availableTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_PGS);
        List<Object> availableList = availableTable.getAllRowData();
        selectionInfo.add(availableList);
        SJctrRsgPgsTableModel selectedTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        this.putCache(KEY_PG_SELECTION_INF, selectionInfo);
        return true;
    }

    public static enum SELECT_PGS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

