/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.com;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sanproject.common.Robj_interface_DKCgetSystemOption;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoDriveBoxInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilInnerPg;

public class SJctrParityGroupUtility {
    public static final int INTERNAL_ERROR_CODE = 207009;
    public static final int FUNC_ID_PG = 213;
    public static final int MODURE_ID_CONTROLLER = 22;
    public static final int ERR_INPUTINVALID_CPG = 205097;
    public static final int ERR_INSUFFICIENT_PGID_CPG = 206170;
    public static final int ERR_INSUFFICIENT_PDEV_CPG = 206171;
    public static final int ERR_MIXTURE_RAIDLEVEL_CPG = 206172;
    public static final int ERR_MIXTURE_DRIVETYPE_CPG = 206173;
    public static final int ERR_MIXTURE_ENCRYPTION_CPG = 206174;
    public static final int ERR_MIXTURE_VIRTUALIZATIONMODE_CPG = 206286;
    public static final int ERR_MIXTURE_COPYBACKMODE_CPG = 206175;
    public static final int ERR_INVALID_NUMBER_OF_PGS_CPG = 205098;
    public static final int ERR_INVALID_RAIDLEVEL_CPG = 205100;
    public static final int ERR_SEL_ROW = 206195;
    public static final int CONFIRM_CONTINUE_CONCATENATION = 209022;
    public static final int ERR_INPUTINVALID_CHANGESETTING = 205099;
    public static final int ERR_INSUFFICIENT_PGID_CHANGESETTING = 206176;
    public static final int ERR_ENC_VIRTMODE_ENABLE_CS = 205210;
    public static final int ERR_HDD_STATUS_ASD = 206177;
    public static final int ERR_OVER_MAX_NUM_ASD = 206178;
    public static final int ERR_DRIVE_KIND_ASD = 206193;
    public static final int ERR_UNSUPPORTED_MODEL = 206194;
    public static final int ERR_EXTERNAL_CBM = 205130;
    public static final int ERR_AUTHORITY_DPG = 206182;
    public static final int ERR_LANPASS_DPG = 206183;
    public static final int ERR_POOLVOL_DPG = 206184;
    public static final int ERR_JOURNAL_DPG = 206185;
    public static final int ERR_QUORUMDISK_DPG = 206186;
    public static final int ERR_LDEVSECURITY_DPG = 206187;
    public static final int ERR_REMOTECOMMANDDEVICE_DPG = 206188;
    public static final int ERR_EXTERNALVOL_DPG = 206189;
    public static final int ERR_ODM_DPG = 206190;
    public static final int ERR_LDEVAUTHORITY_DPG = 206191;
    public static final int ERR_EXTERNAL_DPG = 205131;
    public static final int ERR_NOT_EXIST_PG = 205155;
    public static final int ERROR_SYSRSG_LDEVPG = 205178;
    public static final int RMI_VALUE_ENC_ENABLED = 1;
    public static final int RMI_VALUE_ENC_DISABLED = 0;
    public static int RMI_VALUE_COPYBACK_ENABLED = 1;
    public static int RMI_VALUE_COPYBACK_DISABLED = 2;
    public static final int WAR_POOL_USED = 205197;
    public static final int VM_NOT_SEL = -1;
    public static final int VM_VALUE_ENABLED = 1;
    public static final int VM_VALUE_DISABLED = 2;
    public static final String COM_VIRTUALIZATION = "COM_VIRTUALIZATION";
    public static final String COM_VIRTUALIZATION_CHECKBOX = "COM_VIRTUALIZATION_CHECKBOX";
    public static final String COM_ENABLE = "COM_ENABLE";
    public static final String COM_DISABLE = "COM_DISABLE";
    public static final int RMI_VALUE_HDD_STATUS_NORMAL = 0;
    public static final int EMULATION_TYPE_OPEN_V = 625;
    public static final int INT_1_2D2D = 8194;
    public static final int INT_5_2D1P = 8201;
    public static final int INT_5_3D1P = 8197;
    public static final int INT_5_4D1P = 8202;
    public static final int INT_5_5D1P = 8203;
    public static final int INT_5_6D1P = 8196;
    public static final int INT_5_7D1P = 8198;
    public static final int INT_5_8D1P = 8204;
    public static final int INT_6_4D2P = 8205;
    public static final int INT_6_6D2P = 8199;
    public static final int INT_6_8D2P = 8206;
    public static final int INT_6_10D2P = 8207;
    public static final int INT_6_12D2P = 8208;
    public static final int INT_6_14D2P = 8200;
    public static final int DATA_DRIVE_NUM_2 = 2;
    public static final int DATA_DRIVE_NUM_3 = 3;
    public static final int DATA_DRIVE_NUM_4 = 4;
    public static final int DATA_DRIVE_NUM_5 = 5;
    public static final int DATA_DRIVE_NUM_6 = 6;
    public static final int DATA_DRIVE_NUM_7 = 7;
    public static final int DATA_DRIVE_NUM_8 = 8;
    public static final int DATA_DRIVE_NUM_10 = 10;
    public static final int DATA_DRIVE_NUM_12 = 12;
    public static final int DATA_DRIVE_NUM_14 = 14;
    public static final int REQUIRED_PDEV_NUM_3 = 3;
    public static final int REQUIRED_PDEV_NUM_4 = 4;
    public static final int REQUIRED_PDEV_NUM_5 = 5;
    public static final int REQUIRED_PDEV_NUM_6 = 6;
    public static final int REQUIRED_PDEV_NUM_7 = 7;
    public static final int REQUIRED_PDEV_NUM_8 = 8;
    public static final int REQUIRED_PDEV_NUM_9 = 9;
    public static final int REQUIRED_PDEV_NUM_10 = 10;
    public static final int REQUIRED_PDEV_NUM_12 = 12;
    public static final int REQUIRED_PDEV_NUM_14 = 14;
    public static final int REQUIRED_PDEV_NUM_16 = 16;
    public static final int SUPPORT_CONCATENATE_0 = 0;
    public static final int SUPPORT_CONCATENATE_1 = 1;
    public static final int SUPPORT_CONCATENATE_2 = 2;
    public static final boolean RAID_SUPPORT_TRUE = true;
    public static final boolean RAID_SUPPORT_FALSE = false;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DBS = 2;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DBL = 1;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DB60 = 7;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DBF = 4;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DBF2_A = 8;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DBF2_B = 9;
    public static final int RMI_VALUE_DRIVE_BOX_TYPE_DB60S = 12;
    public static final Map<Integer, String> RMI_VALUE_DRIVE_BOX_TYPE = new LinkedHashMap<Integer, String>();

    public static SJcException createPgException(int errorCode) {
        SJctrError error = SJctrParityGroupUtility.createPgError(errorCode);
        SJcException exception = error.createException();
        throw exception;
    }

    public static SJctrError createPgError(int errorCode) {
        SJctrError error = new SJctrError(213, 22, errorCode);
        return error;
    }

    public static SJctrError createPgInternalError() {
        return SJctrParityGroupUtility.createPgError(207009);
    }

    public static SJcException createPgInternalException() {
        SJcException exp = SJctrParityGroupUtility.createPgException(207009);
        throw exp;
    }

    public static int toInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String join(String delimiter, List<?> args) {
        return SJctrParityGroupUtility.join(delimiter, args.toArray(new Object[args.size()]));
    }

    public static String join(String delimiter, Object ... args) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                builder.append(delimiter);
            }
            builder.append(arg);
            isFirst = false;
        }
        return builder.toString();
    }

    public static <V> List<V> getModifiableCache(SJctrWizardDataController dc, String key) {
        List<?> list = dc.getCache(key);
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList(list);
    }

    public static <V, K extends SJmoGetKind_IF> List<V> getCache(SJctrWizardDataController dc, Class<K> key) {
        List<?> list = dc.getCache(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static SJmoPgDetail findPg(List<SJmoPgDetail> pgs, int pgIndex) {
        for (SJmoPgDetail pg : pgs) {
            if (pg.getIndex() != pgIndex) continue;
            return pg;
        }
        return null;
    }

    public static SJmoPgDetail findPg(List<SJmoPgDetail> pgs, int fb4, int pg) {
        SJmoPgDetail key = new SJmoPgDetail();
        key.setFB4(fb4);
        key.setPG(pg);
        return SJctrParityGroupUtility.findPg(pgs, key.getIndex());
    }

    public static Map<Integer, ScatteredPgInfo> createScatteredPgInfo(CandidatePgInfo info, List<SJmoClprInfo> clprs) {
        TreeMap<Integer, ScatteredPgInfo> ret = new TreeMap<Integer, ScatteredPgInfo>();
        HashSet<Integer> scanned = new HashSet<Integer>();
        for (SJmoPgScatteredInfo elem : info.getScattered()) {
            ArrayList child = elem.getAlPgIndex();
            ScatteredPgInfo current = null;
            for (int i = 0; i < child.size(); ++i) {
                SJmoPgIndex pgIndex = (SJmoPgIndex)child.get(i);
                PgPdevInfo pgPdevInfo = SJctrParityGroupUtility.createPgPdevInfo(info, pgIndex);
                if (i == 0) {
                    current = new ScatteredPgInfo();
                    current.scatteredInfo = elem;
                    current.clpr = SJctrParityGroupUtility.findClpr(clprs, pgPdevInfo.getPg().getCLPR());
                    current.pgs.add(pgPdevInfo);
                    ret.put(pgIndex.getIndex(), current);
                } else {
                    current.pgs.add(pgPdevInfo);
                }
                scanned.add(pgIndex.getIndex());
            }
        }
        for (SJmoPgDetail pg : info.getPgs()) {
            int index = pg.getIndex();
            if (scanned.contains(index)) continue;
            ScatteredPgInfo scatteredPgInfo = new ScatteredPgInfo();
            scatteredPgInfo.clpr = SJctrParityGroupUtility.findClpr(clprs, pg.getCLPR());
            scatteredPgInfo.pgs.add(SJctrParityGroupUtility.createPgPdevInfo(info, pg));
            ret.put(index, scatteredPgInfo);
            scanned.add(index);
        }
        return ret;
    }

    public static List<int[]> findUnusedPg(int number, int initFb4, int initPgid, int maxFb4, int maxPgid, List<SJmoPgDetail> exceptions, SJmoRscUtilInnerPg pgUty, Set<Integer> selectedIds) {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        HashSet<Integer> pgUsedIndexs = new HashSet<Integer>();
        SJmoPgDetail initPg = new SJmoPgDetail();
        initPg.setFB4(initFb4);
        initPg.setPG(initPgid);
        int initialPgIndex = initPg.getIndex();
        for (SJmoPgDetail pg : exceptions) {
            int index = pg.getIndex();
            if (initialPgIndex > index) continue;
            pgUsedIndexs.add(index);
        }
        for (int fb4 = initFb4; fb4 <= maxFb4; ++fb4) {
            for (int pgid = initPgid; pgid <= maxPgid; ++pgid) {
                if (number <= ret.size()) {
                    return ret;
                }
                SJmoPgDetail pg = new SJmoPgDetail();
                pg.setFB4(fb4);
                pg.setPG(pgid);
                int index = pg.getIndex();
                if (pgUsedIndexs.contains(index) || 0 != pgUty.chkPgID(fb4, pgid) && (selectedIds == null || !selectedIds.contains(index))) continue;
                ret.add(new int[]{fb4, pgid});
                pgUsedIndexs.add(index);
            }
        }
        return ret;
    }

    public static SJmoClprInfo findClpr(List<SJmoClprInfo> clprs, short clpr) {
        for (SJmoClprInfo c : clprs) {
            if (c.getSClpr() != clpr) continue;
            return c;
        }
        return null;
    }

    private static PgPdevInfo createPgPdevInfo(CandidatePgInfo info, SJmoPgIndex pgIndex) {
        List<SJmoPgDetail> pgs = info.getPgs();
        List<SJmoPgEncryptionInfo> encs = info.getPgEncs();
        List<List<SJmoPdevDetail>> pdevs = info.getPdevs();
        for (int i = 0; i < pgs.size(); ++i) {
            SJmoPgDetail pg = pgs.get(i);
            if (pg.getIndex() != pgIndex.getIndex()) continue;
            PgPdevInfo ret = new PgPdevInfo();
            ret.pg = pg;
            ret.enc = encs.get(i);
            ret.pdevs = pdevs.get(i);
            return ret;
        }
        return null;
    }

    public static boolean isExternal(SJmoPgIndex pg) {
        boolean isExternal = false;
        if (pg.getFB4() >= 101 && pg.getFB4() <= 16484) {
            isExternal = true;
        }
        return isExternal;
    }

    public static boolean isInternal(SJmoPgIndex pg) {
        boolean isInternal = false;
        if (pg.getFB4() >= 0 && pg.getFB4() <= 64) {
            isInternal = true;
        }
        return isInternal;
    }

    public static Robj_interface_DKCgetSystemOption[] getSystemOptionInfo(SJctrWizardDataController dc) {
        Robj_interface_DKCgetSystemOption[] sysOptList = null;
        List optList = SJctrParityGroupUtility.getCache(dc, SJctrGetSystemOption.class);
        if (optList == null) {
            SJctrLogUty.error("SJctrParityGroupUtility", "getSystemOptionInfo", "System option list is null.");
            SJctrParityGroupUtility.createPgInternalException();
        } else if (optList.isEmpty()) {
            SJctrLogUty.error("SJctrParityGroupUtility", "getSystemOptionInfo", "System option list is empty.");
            SJctrParityGroupUtility.createPgInternalException();
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)optList.get(0);
        sysOptList = (Robj_interface_DKCgetSystemOption[])rmiData.getObjRmi();
        if (sysOptList == null) {
            SJctrLogUty.error("SJctrParityGroupUtility", "getSystemOptionInfo", "System option list from RMI is null.");
            SJctrParityGroupUtility.createPgInternalException();
        } else if (sysOptList.length == 0) {
            SJctrLogUty.error("SJctrParityGroupUtility", "getSystemOptionInfo", "System option list from RMI is empty.");
            SJctrParityGroupUtility.createPgInternalException();
        }
        return sysOptList;
    }

    public static boolean getSupportedRaidLevelOption(SJctrWizardDataController dc) {
        boolean bRetVal = false;
        if (dc == null) {
            SJctrLogUty.error("SJctrParityGroupUtility", "getSupportedRaidLevelOption", "dc parameter is null.");
            SJctrParityGroupUtility.createPgInternalException();
        } else {
            Robj_interface_DKCgetSystemOption[] sysOptList;
            for (Robj_interface_DKCgetSystemOption option : sysOptList = SJctrParityGroupUtility.getSystemOptionInfo(dc)) {
                int clpr = option.getNCLPR();
                if (clpr != -1) continue;
                bRetVal = option.isEnable(1066);
            }
        }
        return bRetVal;
    }

    public static SJctrErrorColumnData checkDetailInfo(List<SJmoPgDetail> PGDetailList, SJctrPGDetail pgDetail) {
        SJctrErrorColumnData errColumn = null;
        int pgIndex = Collections.binarySearch(PGDetailList, (Object)pgDetail);
        if (pgIndex < 0) {
            SJctrError error = SJctrParityGroupUtility.createPgError(205155);
            errColumn = new SJctrErrorColumnData(pgDetail, error);
        }
        return errColumn;
    }

    public static SJmoPgDetail getPgDetail(List<SJmoPgDetail> pgList, SJmoLdevDetail ldevDetail) {
        SJmoPgDetail pgDetail = new SJmoPgDetail();
        if (pgList != null) {
            for (SJmoPgDetail pg : pgList) {
                if (pg.getFB4() != ldevDetail.getIFB4() || pg.getPG() != ldevDetail.getIPG()) continue;
                pgDetail = pg;
                break;
            }
        }
        return pgDetail;
    }

    public static boolean checkVirtMode(List<SJmoPgDetail> pgList) {
        boolean ret = false;
        if (pgList != null) {
            for (SJmoPgDetail pgDetail : pgList) {
                if (!pgDetail.getBVirtMode()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean checkVirtModeInFreeDetailList(List<SJctrFreeDetail> freeList) {
        boolean ret = false;
        if (freeList != null) {
            for (SJctrFreeDetail freeDetail : freeList) {
                if (!freeDetail.getPGDetail().getBVirtMode()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean chkPoolVirtMode(SJmoPoolIndex pool, List<SJmoPoolVolDetail> poolVolDetaillList, List<SJmoLdevDetail> ldevDetailList) {
        boolean ret = false;
        List<SJmoLdevDetail> ldevPVolLdevList = SJctrParityGroupUtility.getLdevDetailFromPoolVol(pool, poolVolDetaillList, ldevDetailList);
        ret = SJctrParityGroupUtility.chkVirtModeFromLdev(ldevPVolLdevList);
        return ret;
    }

    public static boolean chkVirtModeFromLdev(List<SJmoLdevDetail> ldevDetailList) {
        boolean ret = false;
        if (ldevDetailList != null) {
            for (SJmoLdevDetail ldevDetail : ldevDetailList) {
                if (!ldevDetail.getBVirtMode()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static List<SJmoLdevDetail> getLdevDetailFromPoolVol(SJmoPoolIndex pool, List<SJmoPoolVolDetail> poolVolDetaillList, List<SJmoLdevDetail> ldevDetailList) {
        Collections.sort(poolVolDetaillList);
        Collections.sort(ldevDetailList);
        SJmoPoolVolDetail poolVolDtl = SJctrParityGroupUtility.findList(poolVolDetaillList, pool);
        ArrayList poolVolList = poolVolDtl.getAlPoolInfo();
        List<SJmoLdevDetail> retList = SJctrParityGroupUtility.getChangeListType(poolVolList, ldevDetailList);
        return retList;
    }

    public static <T> T findList(List<T> list, Object obj) {
        int idx = Collections.binarySearch(list, (Object)obj);
        if (idx < 0) {
            SJctrParityGroupUtility.createPgInternalException();
        }
        T find = list.get(idx);
        return find;
    }

    public static SJctrRelatedDispDataObject createOkCancelMsgDialog(int errorDetail, SJctrItemSelectListener listener, SJctrWizardDataController dc) {
        SJctrRelatedDispDataObject related = SJctrParityGroupUtility.getMessageDataObject(errorDetail, dc);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)dc.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, listener);
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        return related;
    }

    public static SJctrRelatedDispDataObject getMessageDataObject(int errorDetail, SJctrWizardDataController dc) {
        String strFuncID = Integer.toString(213);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(errorDetail);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
        return related;
    }

    public static <T> List<T> getChangeListType(List<?> searchList, List<T> allList) {
        ArrayList<T> retList = new ArrayList<T>();
        if (searchList != null) {
            for (Object objIndex : searchList) {
                T targetObject = SJctrParityGroupUtility.findList(allList, objIndex);
                retList.add(targetObject);
            }
        }
        return retList;
    }

    static {
        RMI_VALUE_DRIVE_BOX_TYPE.put(2, "DBS(2.5 inch)");
        RMI_VALUE_DRIVE_BOX_TYPE.put(1, "DBL(3.5 inch)");
        RMI_VALUE_DRIVE_BOX_TYPE.put(7, "DB60(3.5 inch)");
        RMI_VALUE_DRIVE_BOX_TYPE.put(4, "DBF");
        RMI_VALUE_DRIVE_BOX_TYPE.put(8, "DBF2");
        RMI_VALUE_DRIVE_BOX_TYPE.put(9, "DBF2");
        RMI_VALUE_DRIVE_BOX_TYPE.put(12, "DB60S(3.5 inch)");
    }

    public static class DriveBoxPdev {
        private SJmoDriveBoxInfo driveBox;
        private List<SJmoPdevDetail> pdevs = new ArrayList<SJmoPdevDetail>();

        public SJmoDriveBoxInfo getDriveBox() {
            return this.driveBox;
        }

        public void setDriveBox(SJmoDriveBoxInfo driveBox) {
            this.driveBox = driveBox;
        }

        public List<SJmoPdevDetail> getPdevs() {
            return this.pdevs;
        }
    }

    public static class CandidatePgInfo {
        private List<SJmoPgScatteredInfo> scattered = new ArrayList<SJmoPgScatteredInfo>();
        private List<SJmoPgDetail> pgs = new ArrayList<SJmoPgDetail>();
        private List<SJmoPgEncryptionInfo> pgEncryptions = new ArrayList<SJmoPgEncryptionInfo>();
        private List<List<SJmoPdevDetail>> pdevs = new ArrayList<List<SJmoPdevDetail>>();

        public List<SJmoPgScatteredInfo> getScattered() {
            return this.scattered;
        }

        public List<SJmoPgDetail> getPgs() {
            return this.pgs;
        }

        public List<SJmoPgEncryptionInfo> getPgEncs() {
            return this.pgEncryptions;
        }

        public List<List<SJmoPdevDetail>> getPdevs() {
            return this.pdevs;
        }
    }

    public static class PgPdevInfo
    implements Serializable {
        private static final long serialVersionUID = 303671556253698584L;
        private SJmoPgDetail pg;
        private SJmoPgEncryptionInfo enc;
        private List<SJmoPdevDetail> pdevs = new ArrayList<SJmoPdevDetail>();

        public SJmoPgDetail getPg() {
            return this.pg;
        }

        public SJmoPgEncryptionInfo getEnc() {
            return this.enc;
        }

        public List<SJmoPdevDetail> getPdevs() {
            return this.pdevs;
        }
    }

    public static class ScatteredPgInfo
    implements Serializable {
        private static final long serialVersionUID = -9155515395510818221L;
        private SJmoPgScatteredInfo scatteredInfo;
        private List<PgPdevInfo> pgs = new ArrayList<PgPdevInfo>();
        private SJmoClprInfo clpr;

        public SJmoPgScatteredInfo getScatteredInfo() {
            return this.scatteredInfo;
        }

        public List<PgPdevInfo> getPgPdevs() {
            return this.pgs;
        }

        public boolean isConcatenatedPg() {
            return this.scatteredInfo != null;
        }

        public PgPdevInfo getRepresentativePg() {
            return this.pgs.get(0);
        }

        public SJmoClprInfo getClpr() {
            return this.clpr;
        }
    }

    public static enum RaidLevel {
        R1_2D2D(8194, "1(2D+2D)", 2, 4, 1, true, true),
        R5_2D1P(8201, "5(2D+1P)", 2, 3, 0, true, false),
        R5_3D1P(8197, "5(3D+1P)", 3, 4, 0, true, true),
        R5_4D1P(8202, "5(4D+1P)", 4, 5, 0, true, true),
        R5_5D1P(8203, "5(5D+1P)", 5, 6, 0, true, false),
        R5_6D1P(8196, "5(6D+1P)", 6, 7, 0, true, true),
        R5_7D1P(8198, "5(7D+1P)", 7, 8, 2, true, true),
        R5_8D1P(8204, "5(8D+1P)", 8, 9, 0, true, false),
        R6_4D2P(8205, "6(4D+2P)", 4, 6, 0, true, false),
        R6_6D2P(8199, "6(6D+2P)", 6, 8, 0, true, true),
        R6_8D2P(8206, "6(8D+2P)", 8, 10, 0, true, false),
        R6_10D2P(8207, "6(10D+2P)", 10, 12, 0, true, false),
        R6_12D2P(8208, "6(12D+2P)", 12, 14, 0, true, true),
        R6_14D2P(8200, "6(14D+2P)", 14, 16, 0, true, true);

        private int rmiValue;
        private String displayName;
        private int dataDriveNumber;
        private int requiredPdevNumber;
        private int supportConcatenate;
        private boolean isSupportedHMHitachiJp;
        private boolean isSupportedHMHitachiEn;

        private RaidLevel(int rmiValue, String displayName, int dataDriveNumber, int requiredPdevNumber, int supportConcatenate, boolean isSupportedHMHitachiJp, boolean isSupportedHMHitachiEn) {
            this.rmiValue = rmiValue;
            this.displayName = displayName;
            this.dataDriveNumber = dataDriveNumber;
            this.requiredPdevNumber = requiredPdevNumber;
            this.supportConcatenate = supportConcatenate;
            this.isSupportedHMHitachiJp = isSupportedHMHitachiJp;
            this.isSupportedHMHitachiEn = isSupportedHMHitachiEn;
        }

        public int getRmiValue() {
            return this.rmiValue;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getDataDriveNumber() {
            return this.dataDriveNumber;
        }

        public int getRequiredPdevNumber() {
            return this.requiredPdevNumber;
        }

        public int getSupportConcatenate() {
            return this.supportConcatenate;
        }

        public static RaidLevel findByRmiValue(int rmiValue) {
            for (RaidLevel lv : RaidLevel.values()) {
                if (lv.rmiValue != rmiValue) continue;
                return lv;
            }
            return null;
        }

        public boolean isSupported(SJctrWizardDataController dc) {
            String venderID = SJcProductUty.getVenderID();
            if ("HIE".equals(venderID) && !SJctrParityGroupUtility.getSupportedRaidLevelOption(dc)) {
                return this.isSupportedHMHitachiEn;
            }
            return this.isSupportedHMHitachiJp;
        }
    }
}

