/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.deletepgs.cntl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.deletepgs.SJctrDeletePGsConfirmData;
import sanproject.sn2.controller.wizard.arraygroup.deletepgs.com.SJctrDeletePGsKeyDef;
import sanproject.sn2.controller.wizard.arraygroup.deletepgs.model.SJctrDeletePGsConfirmTableModel;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevSecurityInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevSecurityInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrDeletePGsConfirmDC
extends SJctrConfirmDataController {
    public static final int DISP_ID = 17871175;
    private static final String CLASS_NAME = SJctrDeletePGsConfirmDC.class.getSimpleName();
    private SJctrRelatedDispDataObject _WarningMsg = null;

    public SJctrDeletePGsConfirmDC() throws SJcException {
        super(17871175);
        this.addDataObjectModel("COM_TABLE", new SJctrDeletePGsConfirmTableModel());
        this.addDataObjectModel("COM_CHILD", new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>();
                if (SJctrDeletePGsConfirmDC.this._WarningMsg != null) {
                    retList.add(SJctrDeletePGsConfirmDC.this._WarningMsg);
                    SJctrDeletePGsConfirmDC.this._WarningMsg = null;
                }
                return retList;
            }
        });
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        return true;
    }

    public void createAndCacheConfirmData() {
        String METHOD_NAME = "createAndCacheConfirmData";
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        List<SJmoPgIndex> selectedPGIdxList = this.getWizardCache("KEY_SELECT_PG_INDEX");
        if (selectedPGIdxList == null) {
            SJctrLogUty.warn(CLASS_NAME, "createAndCacheConfirmData", "selectedPGIdxList is null");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        if (selectedPGIdxList.isEmpty()) {
            SJctrLogUty.warn(CLASS_NAME, "createAndCacheConfirmData", "selectedPGIdxList is empty");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        List<SJctrDeletePGsConfirmData> confirmData = this.createConfirmDataList(selectedPGIdxList);
        wizard.putCache(SJctrDeletePGsKeyDef.DEL_PGS_CONFIRM_DATA_CLASS, confirmData);
    }

    private List<SJctrDeletePGsConfirmData> createConfirmDataList(List<SJmoPgIndex> selectedPGIdxList) {
        String METHOD_NAME = "createConfirmDataList";
        List<SJctrPGDetail> pgDtlList = this.createPgDetail(selectedPGIdxList);
        List pgLdevInfos = this.getWizardCaceh(SJmoGetPgLdevInfo.class);
        List ldevDtls = this.getWizardCaceh(SJmoGetLdevDetail.class);
        List secInfos = this.getWizardCaceh(SJmoGetLdevSecurityInfo.class);
        List pdevDtls = this.getWizardCaceh(SJmoGetPdevDetail.class);
        List rsgs = this.getWizardCaceh(SJmoGetRSGgetAllRsgs.class);
        SJctrUserController userCtrl = this.getOwner();
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(userCtrl, (SJmoRSGgetAllRsgs)rsgs.get(0));
        this.sort(pgLdevInfos);
        this.sort(ldevDtls);
        this.sort(secInfos);
        ArrayList<SJctrErrorColumnData> errExtPgColumnList = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        HashMap<Integer, SJctrPGDetail> pgMap = new HashMap<Integer, SJctrPGDetail>();
        for (SJctrPGDetail pg : pgDtlList) {
            SJmoPgLdevInfo pgLdevInfo;
            if (SJctrParityGroupUtility.isExternal(pg)) {
                errExtPgColumnList.add(this.createErrorData(pg, 205131));
                continue;
            }
            if (!this.checkPgRsg(pg, rsgUtil)) {
                errColumnList.add(this.createErrorData(pg, 206182));
            }
            if (rsgUtil.isSelRscPgInSysRsg(pg)) {
                errColumnList.add(this.createErrorData(pg, 205178));
            }
            if ((pgLdevInfo = (SJmoPgLdevInfo)this.find(pgLdevInfos, pg)) == null) {
                SJctrLogUty.warn(CLASS_NAME, "createConfirmDataList", "pgLdevInfo is null");
                throw SJctrParityGroupUtility.createPgInternalException();
            }
            ArrayList allLdevs = pgLdevInfo.getAlLdevIndex();
            if (allLdevs == null || allLdevs.isEmpty()) {
                pgMap.put(pg.getIndex(), pg);
                continue;
            }
            for (SJmoLdevIndex ldevIdx : allLdevs) {
                SJmoLdevDetail ldev = (SJmoLdevDetail)this.find(ldevDtls, ldevIdx);
                if (ldev == null) {
                    SJctrLogUty.warn(CLASS_NAME, "createConfirmDataList", "ldev is null");
                    throw SJctrParityGroupUtility.createPgInternalException();
                }
                SJmoLdevSecurityInfo secInfo = (SJmoLdevSecurityInfo)this.find(secInfos, ldevIdx);
                if (secInfo == null) {
                    SJctrLogUty.warn(CLASS_NAME, "createConfirmDataList", "secInfo is null");
                    throw SJctrParityGroupUtility.createPgInternalException();
                }
                boolean hasError = false;
                if (ldev.getILUPathNumber() != 0) {
                    errColumnList.add(this.createErrorData(pg, 206183));
                    hasError = true;
                }
                if (ldev.getbPoolVol()) {
                    errColumnList.add(this.createErrorData(pg, 206184));
                    hasError = true;
                }
                if (ldev.getbJNLVolume()) {
                    errColumnList.add(this.createErrorData(pg, 206185));
                    hasError = true;
                }
                if (secInfo.getByLdevSecurity() == 1) {
                    errColumnList.add(this.createErrorData(pg, 206187));
                    hasError = true;
                }
                if (ldev.getbRmtComDev()) {
                    errColumnList.add(this.createErrorData(pg, 206188));
                    hasError = true;
                }
                if (ldev.getbExternalMfVolume()) {
                    errColumnList.add(this.createErrorData(pg, 206189));
                    hasError = true;
                }
                if (ldev.getbOdmVol()) {
                    errColumnList.add(this.createErrorData(pg, 206190));
                    hasError = true;
                }
                if (!this.checkLdevRsg(ldev, rsgUtil)) {
                    errColumnList.add(this.createErrorData(pg, 206191));
                    hasError = true;
                }
                if (hasError) continue;
                pgMap.put(pg.getIndex(), pg);
            }
        }
        if (errExtPgColumnList.size() > 0) {
            throw this.createException(errExtPgColumnList);
        }
        if (errColumnList.isEmpty()) {
            return this.createConfirmData(new ArrayList<SJctrPGDetail>(pgMap.values()));
        }
        throw this.createException(errColumnList);
    }

    private List<SJmoPdevDetail> getMemberPdevs(SJmoPgDetail pg, List<SJmoPdevDetail> pdevDtls) {
        ArrayList<SJmoPdevDetail> ret = new ArrayList<SJmoPdevDetail>();
        for (SJmoPdevDetail pdev : pdevDtls) {
            if (pdev.getFB4() != pg.getFB4() || pdev.getPG() != pg.getPG()) continue;
            ret.add(pdev);
        }
        return ret;
    }

    private boolean checkLdevRsg(SJmoLdevDetail ldev, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoLdevDetail> ldevIndexList = new ArrayList<SJmoLdevDetail>();
        ldevIndexList.add(ldev);
        List<SJmoLdevIndex> invalid = rsgUtil.extractImpossibleLdev(ldevIndexList);
        return invalid.isEmpty();
    }

    private boolean checkPgRsg(SJmoPgDetail pg, SJctrResourceGroupUtility rsgUtil) {
        List<SJmoRSGgetRsg> extractRsg = rsgUtil.extractRsg();
        ArrayList<SJmoPgIndex> pgIndexList = new ArrayList<SJmoPgIndex>();
        for (SJmoRSGgetRsg rsgDetail : extractRsg) {
            ArrayList<SJmoPgIndex> vdevs = rsgDetail.getVdevs();
            pgIndexList.addAll(vdevs);
        }
        this.sort(pgIndexList);
        int idx = this.binarySearch(pgIndexList, pg);
        return idx >= 0;
    }

    private SJcException createException(ArrayList<SJctrErrorColumnData> errColumnList) {
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        SJctrRelatedDispDataObject errDisp = wizard.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = wizard.getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        errDC.setParameter(wizard.getParentDC().getDataObjectModel("COM_TABLE"), errColumnList);
        SJctrErrorColumnData errColumnData = errColumnList.get(0);
        SJctrError error = errColumnData.getError();
        SJctrError errorExp = new SJctrError(error.getFunc(), error.getModule(), error.getError());
        SJcException exp = errorExp.createException();
        exp.setErrDisp(errDisp);
        return exp;
    }

    private SJctrErrorColumnData createErrorData(Comparable<?> keyObj, int errorCode) {
        SJctrError error = SJctrParityGroupUtility.createPgError(errorCode);
        SJctrErrorColumnData errColumn = new SJctrErrorColumnData(keyObj, error);
        return errColumn;
    }

    private List<SJctrPGDetail> createPgDetail(List<SJmoPgIndex> selectedPGIdxList) {
        String METHOD_NAME = "createPgDetail";
        List<SJmoPgDetail> pgDetailList = this.getWizardCaceh(SJmoGetPgDetail.class);
        this.checkNotEmpty(pgDetailList, "createPgDetail", "pgDetailList is empty");
        List<SJmoVdevDetail> vdevList = this.getWizardCaceh(SJmoGetVdevDetail.class);
        this.checkNotNull(vdevList, "createPgDetail", "vdevList is null");
        List<SJmoLdevDetail> ldevList = this.getWizardCaceh(SJmoGetLdevDetail.class);
        this.checkNotNull(ldevList, "createPgDetail", "ldevList is null");
        List<SJmoPgScatteredInfo> scattered = this.getWizardCaceh(SJmoGetPgScatteredInfo.class);
        ArrayList<SJctrPGDetail> selectedPgDtlList = new ArrayList<SJctrPGDetail>();
        ArrayList<SJctrErrorColumnData> errPGList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoPgIndex selectedPgIndex : selectedPGIdxList) {
            int pgIndex = this.binarySearch(pgDetailList, selectedPgIndex);
            if (pgIndex >= 0) {
                SJmoPgDetail pg = (SJmoPgDetail)pgDetailList.get(pgIndex);
                SJctrPGDetail wkPg = new SJctrPGDetail();
                wkPg.setPGDetail(pg);
                wkPg.setPGScatteredList(scattered);
                wkPg.setBasicDataList(pgDetailList, vdevList, ldevList, null);
                selectedPgDtlList.add(wkPg);
                continue;
            }
            SJctrError error = SJctrParityGroupUtility.createPgError(205155);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(selectedPgIndex, error);
            errPGList.add(errColumn);
        }
        if (!errPGList.isEmpty()) {
            throw this.createException(errPGList);
        }
        return selectedPgDtlList;
    }

    private void checkNotNull(List<?> list, String methodName, String message) {
        if (list == null) {
            SJctrLogUty.warn(CLASS_NAME, methodName, message);
            throw SJctrParityGroupUtility.createPgInternalException();
        }
    }

    private void checkNotEmpty(List<?> list, String methodName, String message) {
        if (list == null || list.isEmpty()) {
            SJctrLogUty.warn(CLASS_NAME, methodName, message);
            throw SJctrParityGroupUtility.createPgInternalException();
        }
    }

    private List<SJctrDeletePGsConfirmData> createConfirmData(List<SJctrPGDetail> pgDetails) {
        this.sort(pgDetails);
        SJctrDeletePGsConfirmData confirmData = new SJctrDeletePGsConfirmData();
        confirmData.setPgDetails(pgDetails);
        ArrayList<SJctrDeletePGsConfirmData> confirmDataList = new ArrayList<SJctrDeletePGsConfirmData>();
        confirmDataList.add(confirmData);
        return confirmDataList;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrDeletePGsKeyDef.DEL_PGS_CONFIRM_DATA_CLASS);
        map.put(SJctrDeletePGsKeyDef.DEL_PGS_CONFIRM_DATA_CLASS.getName(), confirmDataList);
        return map;
    }

    private <A extends SJmoGetKind_IF, R> List<R> getWizardCaceh(Class<A> clazz) {
        return this.getWizardWindow().getCache(clazz);
    }

    private <T> T find(List<T> list, Object obj) {
        int idx = this.binarySearch(list, obj);
        if (idx < 0) {
            return null;
        }
        T find = list.get(idx);
        return find;
    }

    private <R> List<R> getWizardCache(String key) {
        return this.getWizardWindow().getCache(key);
    }

    private void sort(List<?> list) {
        Collections.sort(list);
    }

    private int binarySearch(List<?> list, Object obj) {
        return Collections.binarySearch(list, obj);
    }

    public void chkForciblyMsg() {
        List<?> confirmDataList = this.getCache(SJctrDeletePGsKeyDef.DEL_PGS_CONFIRM_DATA_CLASS);
        SJctrDeletePGsConfirmData confirmData = (SJctrDeletePGsConfirmData)confirmDataList.get(0);
        ArrayList pgList = (ArrayList)confirmData.getPgDetailList();
        ArrayList errColumnList = SJctrComCVSUtility.chkPgList(this, pgList, 203);
        if (errColumnList.size() > 0) {
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel("COM_ERRTABLE", errTable);
            errTable.addRowData(errColumnList);
            this._WarningMsg = SJctrCVSUtility.createOkCancelMsgDialogEx(205211, null, this, this.getDataObjectModel("COM_ERRTABLE"), errColumnList);
        }
    }
}

